/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.FileElement;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J,\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00000\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u000eJ\u0006\u0010\u0017\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/codeInsight/completion/OffsetsInFile;", "", "file", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)V", "offsets", "Lcom/intellij/codeInsight/completion/OffsetMap;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInsight/completion/OffsetMap;)V", "getFile", "()Lcom/intellij/psi/PsiFile;", "getOffsets", "()Lcom/intellij/codeInsight/completion/OffsetMap;", "copyWithReplacement", "startOffset", "", "endOffset", "replacement", "", "replaceInCopy", "Ljava/util/function/Supplier;", "fileCopy", "toInjectedIfAny", "offset", "toTopLevelFile", "intellij.platform.analysis.impl"})
public final class OffsetsInFile {
    @NotNull
    private final PsiFile file;
    @NotNull
    private final OffsetMap offsets;

    @NotNull
    public final OffsetsInFile toTopLevelFile() {
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance(this.file.getProject());
        PsiFile hostFile = manager.getTopLevelFile(this.file);
        if (Intrinsics.areEqual((Object)hostFile, (Object)this.file)) {
            return this;
        }
        PsiFile psiFile = hostFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"hostFile");
        FileViewProvider fileViewProvider = hostFile.getViewProvider();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"hostFile.viewProvider");
        Document document = fileViewProvider.getDocument();
        if (document == null) {
            Intrinsics.throwNpe();
        }
        OffsetMap offsetMap = this.offsets.mapOffsets(document, new Function<Integer, Integer>(this, manager){
            final /* synthetic */ OffsetsInFile this$0;
            final /* synthetic */ InjectedLanguageManager $manager;

            public final int apply(Integer it) {
                PsiElement psiElement = this.this$0.getFile();
                Integer n = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"it");
                return this.$manager.injectedToHost(psiElement, n);
            }
            {
                this.this$0 = offsetsInFile;
                this.$manager = injectedLanguageManager;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)offsetMap, (String)"offsets.mapOffsets(hostF\u2026njectedToHost(file, it) }");
        return new OffsetsInFile(psiFile, offsetMap);
    }

    @NotNull
    public final OffsetsInFile toInjectedIfAny(int offset) {
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance(this.file.getProject());
        PsiElement psiElement = manager.findInjectedElementAt(this.file, offset);
        if (psiElement == null || (psiElement = psiElement.getContainingFile()) == null) {
            return this;
        }
        PsiElement injected = psiElement;
        VirtualFile virtualFile2 = injected.getVirtualFile();
        if (virtualFile2 instanceof VirtualFileWindow) {
            DocumentWindow documentWindow = ((VirtualFileWindow)((Object)virtualFile2)).getDocumentWindow();
            Intrinsics.checkExpressionValueIsNotNull((Object)documentWindow, (String)"virtualFile.documentWindow");
            DocumentWindow documentWindow2 = documentWindow;
            OffsetMap offsetMap = this.offsets.mapOffsets(documentWindow2, new Function<Integer, Integer>(documentWindow2){
                final /* synthetic */ DocumentWindow $documentWindow;

                public final int apply(Integer it) {
                    Integer n = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"it");
                    return this.$documentWindow.hostToInjected(n);
                }
                {
                    this.$documentWindow = documentWindow;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)offsetMap, (String)"offsets.mapOffsets(\n    \u2026ndow.hostToInjected(it) }");
            return new OffsetsInFile((PsiFile)injected, offsetMap);
        }
        return this;
    }

    @NotNull
    public final OffsetsInFile copyWithReplacement(int startOffset, int endOffset, @NotNull String replacement) {
        Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
        PsiElement psiElement = this.file.copy();
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiFile");
        }
        OffsetsInFile offsetsInFile = this.replaceInCopy((PsiFile)psiElement, startOffset, endOffset, replacement).get();
        Intrinsics.checkExpressionValueIsNotNull((Object)offsetsInFile, (String)"replaceInCopy(file.copy(\u2026ffset, replacement).get()");
        return offsetsInFile;
    }

    @NotNull
    public final Supplier<OffsetsInFile> replaceInCopy(@NotNull PsiFile fileCopy, int startOffset, int endOffset, @NotNull String replacement) {
        Intrinsics.checkParameterIsNotNull((Object)fileCopy, (String)"fileCopy");
        Intrinsics.checkParameterIsNotNull((Object)replacement, (String)"replacement");
        Document document = this.offsets.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"offsets.document");
        CharSequence charSequence = document.getImmutableCharSequence();
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"offsets.document.immutableCharSequence");
        CharSequence originalText = charSequence;
        DocumentImpl tempDocument = new DocumentImpl(originalText, StringsKt.contains$default((CharSequence)originalText, (char)'\r', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)replacement, (char)'\r', (boolean)false, (int)2, null), true);
        OffsetMap offsetMap = this.offsets.copyOffsets(tempDocument);
        Intrinsics.checkExpressionValueIsNotNull((Object)offsetMap, (String)"offsets.copyOffsets(tempDocument)");
        OffsetMap tempMap = offsetMap;
        tempDocument.replaceString(startOffset, endOffset, replacement);
        FileViewProvider fileViewProvider = fileCopy.getViewProvider();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"fileCopy.viewProvider");
        Document document2 = fileViewProvider.getDocument();
        if (document2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"fileCopy.viewProvider.document!!");
        Document copyDocument = document2;
        PomModel pomModel = PomManager.getModel(this.file.getProject());
        if (pomModel == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.pom.core.impl.PomModelImpl");
        }
        FileASTNode fileASTNode = fileCopy.getNode();
        if (fileASTNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.source.tree.FileElement");
        }
        Runnable applyPsiChange = ((PomModelImpl)pomModel).reparseFile(fileCopy, (FileElement)fileASTNode, tempDocument.getImmutableCharSequence());
        return new Supplier<OffsetsInFile>(applyPsiChange, fileCopy, tempMap, copyDocument){
            final /* synthetic */ Runnable $applyPsiChange;
            final /* synthetic */ PsiFile $fileCopy;
            final /* synthetic */ OffsetMap $tempMap;
            final /* synthetic */ Document $copyDocument;

            @NotNull
            public final OffsetsInFile get() {
                Runnable runnable2 = this.$applyPsiChange;
                if (runnable2 != null) {
                    runnable2.run();
                }
                OffsetMap offsetMap = this.$tempMap.copyOffsets(this.$copyDocument);
                Intrinsics.checkExpressionValueIsNotNull((Object)offsetMap, (String)"tempMap.copyOffsets(copyDocument)");
                return new OffsetsInFile(this.$fileCopy, offsetMap);
            }
            {
                this.$applyPsiChange = runnable2;
                this.$fileCopy = psiFile;
                this.$tempMap = offsetMap;
                this.$copyDocument = document;
            }
        };
    }

    @NotNull
    public final PsiFile getFile() {
        return this.file;
    }

    @NotNull
    public final OffsetMap getOffsets() {
        return this.offsets;
    }

    public OffsetsInFile(@NotNull PsiFile file2, @NotNull OffsetMap offsets2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)offsets2, (String)"offsets");
        this.file = file2;
        this.offsets = offsets2;
    }

    public OffsetsInFile(@NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        FileViewProvider fileViewProvider = file2.getViewProvider();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"file.viewProvider");
        Document document = fileViewProvider.getDocument();
        if (document == null) {
            Intrinsics.throwNpe();
        }
        this(file2, new OffsetMap(document));
    }
}

