/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.util;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.editorActions.TabOutScopesTracker;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ParenthesesInsertHandler<T extends LookupElement>
implements InsertHandler<T> {
    public static final ParenthesesInsertHandler<LookupElement> WITH_PARAMETERS = new ParenthesesInsertHandler<LookupElement>(){

        @Override
        protected boolean placeCaretInsideParentheses(InsertionContext context, LookupElement item) {
            return true;
        }
    };
    public static final ParenthesesInsertHandler<LookupElement> NO_PARAMETERS = new ParenthesesInsertHandler<LookupElement>(){

        @Override
        protected boolean placeCaretInsideParentheses(InsertionContext context, LookupElement item) {
            return false;
        }
    };
    private final boolean mySpaceBeforeParentheses;
    private final boolean mySpaceBetweenParentheses;
    private final boolean myMayInsertRightParenthesis;
    private final boolean myAllowParametersOnNextLine;
    private final char myLeftParenthesis;
    private final char myRightParenthesis;

    public static ParenthesesInsertHandler<LookupElement> getInstance(boolean hasParameters) {
        return hasParameters ? WITH_PARAMETERS : NO_PARAMETERS;
    }

    public static ParenthesesInsertHandler<LookupElement> getInstance(final boolean hasParameters, boolean spaceBeforeParentheses, boolean spaceBetweenParentheses, boolean insertRightParenthesis, boolean allowParametersOnNextLine) {
        return new ParenthesesInsertHandler<LookupElement>(spaceBeforeParentheses, spaceBetweenParentheses, insertRightParenthesis, allowParametersOnNextLine){

            @Override
            protected boolean placeCaretInsideParentheses(InsertionContext context, LookupElement item) {
                return hasParameters;
            }
        };
    }

    protected ParenthesesInsertHandler(boolean spaceBeforeParentheses, boolean spaceBetweenParentheses, boolean mayInsertRightParenthesis) {
        this(spaceBeforeParentheses, spaceBetweenParentheses, mayInsertRightParenthesis, false);
    }

    protected ParenthesesInsertHandler(boolean spaceBeforeParentheses, boolean spaceBetweenParentheses, boolean mayInsertRightParenthesis, boolean allowParametersOnNextLine) {
        this(spaceBeforeParentheses, spaceBetweenParentheses, mayInsertRightParenthesis, allowParametersOnNextLine, '(', ')');
    }

    protected ParenthesesInsertHandler(boolean spaceBeforeParentheses, boolean spaceBetweenParentheses, boolean mayInsertRightParenthesis, boolean allowParametersOnNextLine, char leftParenthesis, char rightParenthesis) {
        this.mySpaceBeforeParentheses = spaceBeforeParentheses;
        this.mySpaceBetweenParentheses = spaceBetweenParentheses;
        this.myMayInsertRightParenthesis = mayInsertRightParenthesis;
        this.myAllowParametersOnNextLine = allowParametersOnNextLine;
        this.myLeftParenthesis = leftParenthesis;
        this.myRightParenthesis = rightParenthesis;
    }

    protected ParenthesesInsertHandler() {
        this(false, false, true);
    }

    private static boolean isToken(@Nullable PsiElement element2, String text2) {
        return element2 != null && text2.equals(element2.getText());
    }

    protected abstract boolean placeCaretInsideParentheses(InsertionContext var1, T var2);

    @Override
    public void handleInsert(@NotNull InsertionContext context, @NotNull T item) {
        int tail;
        boolean putCaretInside;
        if (context == null) {
            ParenthesesInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            ParenthesesInsertHandler.$$$reportNull$$$0(1);
        }
        Editor editor = context.getEditor();
        Document document = editor.getDocument();
        context.commitDocument();
        PsiElement lParen = this.findExistingLeftParenthesis(context);
        char completionChar = context.getCompletionChar();
        boolean bl = putCaretInside = completionChar == this.myLeftParenthesis || this.placeCaretInsideParentheses(context, item);
        if (completionChar == this.myLeftParenthesis) {
            context.setAddCompletionChar(false);
        }
        if (lParen != null) {
            int lparenthOffset = lParen.getTextRange().getStartOffset();
            if (this.mySpaceBeforeParentheses && lparenthOffset == context.getTailOffset()) {
                document.insertString(context.getTailOffset(), " ");
                ++lparenthOffset;
            }
            if (completionChar == this.myLeftParenthesis || completionChar == '\t') {
                editor.getCaretModel().moveToOffset(lparenthOffset + 1);
            } else {
                editor.getCaretModel().moveToOffset(context.getTailOffset());
            }
            context.setTailOffset(lparenthOffset + 1);
            PsiElement list2 = lParen.getParent();
            PsiElement last = list2.getLastChild();
            if (ParenthesesInsertHandler.isToken(last, String.valueOf(this.myRightParenthesis))) {
                int rparenthOffset = last.getTextRange().getStartOffset();
                context.setTailOffset(rparenthOffset + 1);
                if (!putCaretInside) {
                    for (int i = lparenthOffset + 1; i < rparenthOffset; ++i) {
                        if (Character.isWhitespace(document.getCharsSequence().charAt(i))) continue;
                        return;
                    }
                    editor.getCaretModel().moveToOffset(context.getTailOffset());
                } else if (this.mySpaceBetweenParentheses && document.getCharsSequence().charAt(lparenthOffset) == ' ') {
                    editor.getCaretModel().moveToOffset(lparenthOffset + 2);
                } else {
                    editor.getCaretModel().moveToOffset(lparenthOffset + 1);
                }
                return;
            }
        } else {
            document.insertString(context.getTailOffset(), ParenthesesInsertHandler.getSpace(this.mySpaceBeforeParentheses) + this.myLeftParenthesis + ParenthesesInsertHandler.getSpace(this.mySpaceBetweenParentheses));
            editor.getCaretModel().moveToOffset(context.getTailOffset());
        }
        if (!this.myMayInsertRightParenthesis) {
            return;
        }
        if (context.getCompletionChar() == this.myLeftParenthesis && (tail = context.getTailOffset()) < document.getTextLength() && StringUtil.isJavaIdentifierPart(document.getCharsSequence().charAt(tail))) {
            return;
        }
        document.insertString(context.getTailOffset(), ParenthesesInsertHandler.getSpace(this.mySpaceBetweenParentheses) + this.myRightParenthesis);
        if (!putCaretInside) {
            editor.getCaretModel().moveToOffset(context.getTailOffset());
        } else if (!this.mySpaceBetweenParentheses) {
            TabOutScopesTracker.getInstance().registerEmptyScopeAtCaret(editor);
        }
    }

    private static String getSpace(boolean needSpace) {
        return needSpace ? " " : "";
    }

    @Nullable
    protected PsiElement findExistingLeftParenthesis(@NotNull InsertionContext context) {
        PsiElement element2;
        if (context == null) {
            ParenthesesInsertHandler.$$$reportNull$$$0(2);
        }
        return ParenthesesInsertHandler.isToken(element2 = this.findNextToken(context), String.valueOf(this.myLeftParenthesis)) ? element2 : null;
    }

    @Nullable
    protected PsiElement findNextToken(@NotNull InsertionContext context) {
        PsiFile file2;
        PsiElement element2;
        if (context == null) {
            ParenthesesInsertHandler.$$$reportNull$$$0(3);
        }
        if ((element2 = (file2 = context.getFile()).findElementAt(context.getTailOffset())) instanceof PsiWhiteSpace) {
            if (!this.myAllowParametersOnNextLine && element2.getText().contains("\n")) {
                return null;
            }
            element2 = file2.findElementAt(element2.getTextRange().getEndOffset());
        }
        return element2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/util/ParenthesesInsertHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsert";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findExistingLeftParenthesis";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findNextToken";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

