/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.util;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.MethodParenthesesHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import org.jetbrains.annotations.NotNull;

public class SimpleMethodCallLookupElement
extends LookupElement {
    private final PsiMethod myMethod;

    public SimpleMethodCallLookupElement(PsiMethod method2) {
        this.myMethod = method2;
    }

    @Override
    @NotNull
    public String getLookupString() {
        String string = this.myMethod.getName();
        if (string == null) {
            SimpleMethodCallLookupElement.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void handleInsert(@NotNull InsertionContext context) {
        if (context == null) {
            SimpleMethodCallLookupElement.$$$reportNull$$$0(1);
        }
        new MethodParenthesesHandler(this.myMethod, true).handleInsert(context, this);
    }

    public PsiMethod getMethod() {
        return this.myMethod;
    }

    @Override
    public void renderElement(LookupElementPresentation presentation) {
        presentation.setIcon(this.myMethod.getIcon(1));
        presentation.setItemText(this.myMethod.getName());
        presentation.setTailText(PsiFormatUtil.formatMethod(this.myMethod, PsiSubstitutor.EMPTY, 256, 3));
        PsiType returnType = this.myMethod.getReturnType();
        if (returnType != null) {
            presentation.setTypeText(returnType.getCanonicalText());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/util/SimpleMethodCallLookupElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/util/SimpleMethodCallLookupElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

