/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInspection.ex.ApplicationInspectionProfileManager;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.JDOMUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DaemonCodeAnalyzerSettings", storages={@Storage(value="editor.xml"), @Storage(deprecated=true, value="editor.codeinsight.xml")})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0000H\u0016J\n\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/codeInsight/daemon/DaemonCodeAnalyzerSettingsImpl;", "Lcom/intellij/codeInsight/daemon/DaemonCodeAnalyzerSettings;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "", "()V", "clone", "getState", "isCodeHighlightingChanged", "", "oldSettings", "loadState", "", "state", "intellij.platform.lang.impl"})
public class DaemonCodeAnalyzerSettingsImpl
extends DaemonCodeAnalyzerSettings
implements PersistentStateComponent<Element>,
Cloneable {
    @Override
    public boolean isCodeHighlightingChanged(@NotNull DaemonCodeAnalyzerSettings oldSettings) {
        Intrinsics.checkParameterIsNotNull((Object)oldSettings, (String)"oldSettings");
        return !JDOMUtil.areElementsEqual(((DaemonCodeAnalyzerSettingsImpl)oldSettings).getState(), this.getState());
    }

    @NotNull
    public DaemonCodeAnalyzerSettingsImpl clone() {
        DaemonCodeAnalyzerSettingsImpl settings = new DaemonCodeAnalyzerSettingsImpl();
        settings.setAutoReparseDelay(this.getAutoReparseDelay());
        settings.myShowAddImportHints = this.myShowAddImportHints;
        settings.SHOW_METHOD_SEPARATORS = this.SHOW_METHOD_SEPARATORS;
        settings.NO_AUTO_IMPORT_PATTERN = this.NO_AUTO_IMPORT_PATTERN;
        return settings;
    }

    @Override
    @Nullable
    public Element getState() {
        Element element2 = new Element("state");
        XmlSerializer.serializeObjectInto$default(this, element2, null, 4, null);
        String profile = ApplicationInspectionProfileManager.Companion.getInstanceImpl().getRootProfileName();
        if (Intrinsics.areEqual((Object)"Default", (Object)profile) ^ true) {
            element2.setAttribute("profile", profile);
        }
        return element2;
    }

    @Override
    public void loadState(@NotNull Element state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        com.intellij.util.xmlb.XmlSerializer.deserializeInto(this, state);
        ApplicationInspectionProfileManager profileManager = ApplicationInspectionProfileManager.Companion.getInstanceImpl();
        profileManager.getConverter().storeEditorHighlightingProfile(state, new InspectionProfileImpl("EditorHighlightingSettings"));
        String string = state.getAttributeValue("profile");
        if (string == null) {
            string = "Default";
        }
        profileManager.setRootProfile(string);
    }
}

