/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.SelectionAwareListCellRenderer;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MergeableLineMarkerInfo<T extends PsiElement>
extends LineMarkerInfo<T> {
    private static final Logger LOG = Logger.getInstance(MergeableLineMarkerInfo.class);

    @Deprecated
    public MergeableLineMarkerInfo(@NotNull T element2, @NotNull TextRange textRange, Icon icon2, int updatePass, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment) {
        if (element2 == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(0);
        }
        if (textRange == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(1);
        }
        if (alignment == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(2);
        }
        super(element2, textRange, icon2, updatePass, tooltipProvider, navHandler, alignment);
    }

    public MergeableLineMarkerInfo(@NotNull T element2, @NotNull TextRange textRange, Icon icon2, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment) {
        if (element2 == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(3);
        }
        if (textRange == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(4);
        }
        if (alignment == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(5);
        }
        super(element2, textRange, icon2, tooltipProvider, navHandler, alignment);
    }

    public abstract boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> var1);

    public abstract Icon getCommonIcon(@NotNull List<MergeableLineMarkerInfo> var1);

    @NotNull
    public Function<? super PsiElement, String> getCommonTooltip(@NotNull List<MergeableLineMarkerInfo> infos) {
        if (infos == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(6);
        }
        Function<PsiElement, String> function = element2 -> {
            HashSet<String> tooltips = new HashSet<String>(ContainerUtil.mapNotNull(infos, info -> info.getLineMarkerTooltip()));
            StringBuilder tooltip = new StringBuilder();
            for (String info2 : tooltips) {
                if (tooltip.length() > 0) {
                    tooltip.append("<hr size=1 noshade>");
                }
                tooltip.append(UIUtil.getHtmlBody(info2));
            }
            return XmlStringUtil.wrapInHtml(tooltip);
        };
        if (function == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(7);
        }
        return function;
    }

    @NotNull
    public GutterIconRenderer.Alignment getCommonIconAlignment(@NotNull List<MergeableLineMarkerInfo> infos) {
        if (infos == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(8);
        }
        GutterIconRenderer.Alignment alignment = GutterIconRenderer.Alignment.LEFT;
        if (alignment == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(9);
        }
        return alignment;
    }

    @NotNull
    public String getElementPresentation(@NotNull PsiElement element2) {
        if (element2 == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(10);
        }
        String string = element2.getText();
        if (string == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(11);
        }
        return string;
    }

    public int getCommonUpdatePass(@NotNull List<MergeableLineMarkerInfo> infos) {
        if (infos == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(12);
        }
        return this.updatePass;
    }

    @Deprecated
    public boolean configurePopupAndRenderer(@NotNull PopupChooserBuilder builder2, @NotNull JBList list2, @NotNull List<MergeableLineMarkerInfo> markers) {
        if (builder2 == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(13);
        }
        if (list2 == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(14);
        }
        if (markers == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(15);
        }
        return false;
    }

    @NotNull
    public static List<LineMarkerInfo<PsiElement>> merge(@NotNull List<? extends MergeableLineMarkerInfo<PsiElement>> markers) {
        if (markers == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(16);
        }
        SmartList<LineMarkerInfo<PsiElement>> result2 = new SmartList<LineMarkerInfo<PsiElement>>();
        for (int i = 0; i < markers.size(); ++i) {
            MergeableLineMarkerInfo<PsiElement> marker = markers.get(i);
            SmartList<MergeableLineMarkerInfo<PsiElement>> toMerge = new SmartList<MergeableLineMarkerInfo<PsiElement>>();
            for (int k = markers.size() - 1; k > i; --k) {
                MergeableLineMarkerInfo<PsiElement> current2 = markers.get(k);
                boolean canMergeWith = marker.canMergeWith(current2);
                if (ApplicationManager.getApplication().isUnitTestMode() && !canMergeWith && current2.canMergeWith(marker)) {
                    LOG.error(current2.getClass() + "[" + current2.getLineMarkerTooltip() + "] can merge " + marker.getClass() + "[" + marker.getLineMarkerTooltip() + "], but not contrariwise");
                }
                if (!canMergeWith) continue;
                toMerge.add(0, current2);
                markers.remove(k);
            }
            if (toMerge.isEmpty()) {
                result2.add(marker);
                continue;
            }
            toMerge.add(0, marker);
            result2.add(new MyLineMarkerInfo(toMerge));
        }
        SmartList<LineMarkerInfo<PsiElement>> smartList = result2;
        if (smartList == null) {
            MergeableLineMarkerInfo.$$$reportNull$$$0(17);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alignment";
                break;
            }
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonTooltip";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonIconAlignment";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementPresentation";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCommonTooltip";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 17: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCommonIconAlignment";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getElementPresentation";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getCommonUpdatePass";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "configurePopupAndRenderer";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MergedGutterIconNavigationHandler
    implements GutterIconNavigationHandler<PsiElement> {
        private final List<LineMarkerInfo> myInfos;

        MergedGutterIconNavigationHandler(List<? extends MergeableLineMarkerInfo> markers) {
            ArrayList<? extends MergeableLineMarkerInfo> infos = new ArrayList<MergeableLineMarkerInfo>(markers);
            Collections.sort(infos, Comparator.comparingInt(o -> o.startOffset));
            this.myInfos = Collections.unmodifiableList(infos);
        }

        @NotNull
        List<LineMarkerInfo> getMergedLineMarkersInfos() {
            List<LineMarkerInfo> list2 = this.myInfos;
            if (list2 == null) {
                MergedGutterIconNavigationHandler.$$$reportNull$$$0(0);
            }
            return list2;
        }

        @Override
        public void navigate(MouseEvent e, PsiElement elt) {
            IPopupChooserBuilder<LineMarkerInfo> builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(this.myInfos);
            builder2.setRenderer(new SelectionAwareListCellRenderer<Object>(dom -> {
                Object element2;
                Icon icon2 = null;
                GutterIconRenderer renderer = ((LineMarkerInfo)dom).createGutterRenderer();
                if (renderer != null) {
                    icon2 = renderer.getIcon();
                }
                String elementPresentation = (element2 = ((LineMarkerInfo)dom).getElement()) == null ? IdeBundle.message("node.structureview.invalid", new Object[0]) : (dom instanceof MergeableLineMarkerInfo ? ((MergeableLineMarkerInfo)dom).getElementPresentation((PsiElement)element2) : element2.getText());
                String text2 = StringUtil.first(elementPresentation, 100, true).replace('\n', ' ');
                JBLabel label2 = new JBLabel(text2, icon2, 2);
                label2.setBorder(JBUI.Borders.empty(2));
                return label2;
            }));
            builder2.setItemChosenCallback(value2 -> {
                GutterIconNavigationHandler handler2 = value2.getNavigationHandler();
                if (handler2 != null) {
                    handler2.navigate(e, value2.getElement());
                }
            }).createPopup().show(new RelativePoint(e));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo$MergedGutterIconNavigationHandler", "getMergedLineMarkersInfos"));
        }
    }

    private static class MyLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        private MyLineMarkerInfo(@NotNull List<? extends MergeableLineMarkerInfo<PsiElement>> markers) {
            if (markers == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(0);
            }
            this(markers, markers.get(0));
        }

        private MyLineMarkerInfo(@NotNull List<? extends MergeableLineMarkerInfo> markers, @NotNull MergeableLineMarkerInfo template) {
            if (markers == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(1);
            }
            if (template == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(2);
            }
            super(template.getElement(), MyLineMarkerInfo.getCommonTextRange(markers), template.getCommonIcon(markers), template.getCommonUpdatePass(markers), template.getCommonTooltip(markers), MyLineMarkerInfo.getCommonNavigationHandler(markers), template.getCommonIconAlignment(markers));
        }

        @NotNull
        private static TextRange getCommonTextRange(@NotNull List<? extends MergeableLineMarkerInfo> markers) {
            if (markers == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(3);
            }
            int startOffset = Integer.MAX_VALUE;
            int endOffset = Integer.MIN_VALUE;
            for (MergeableLineMarkerInfo mergeableLineMarkerInfo : markers) {
                startOffset = Math.min(startOffset, mergeableLineMarkerInfo.startOffset);
                endOffset = Math.max(endOffset, mergeableLineMarkerInfo.endOffset);
            }
            TextRange textRange = TextRange.create(startOffset, endOffset);
            if (textRange == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(4);
            }
            return textRange;
        }

        @NotNull
        private static GutterIconNavigationHandler<PsiElement> getCommonNavigationHandler(@NotNull List<? extends MergeableLineMarkerInfo> markers) {
            if (markers == null) {
                MyLineMarkerInfo.$$$reportNull$$$0(5);
            }
            return new MergedGutterIconNavigationHandler(markers);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "markers";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo$MyLineMarkerInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/MergeableLineMarkerInfo$MyLineMarkerInfo";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommonTextRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommonTextRange";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommonNavigationHandler";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

