/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.impl.HectorComponent;
import com.intellij.codeInsight.daemon.impl.HectorComponentFactory;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.internal.statistic.service.fus.collectors.UIEventId;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.fileEditor.impl.EditorWindowHolder;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.PopupHandler;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

public class DaemonEditorPopup
extends PopupHandler {
    private final Project myProject;
    private final Editor myEditor;

    DaemonEditorPopup(@NotNull Project project2, @NotNull Editor editor) {
        if (project2 == null) {
            DaemonEditorPopup.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            DaemonEditorPopup.$$$reportNull$$$0(1);
        }
        this.myProject = project2;
        this.myEditor = editor;
    }

    @Override
    public void invokePopup(final Component comp, final int x, final int y) {
        if (ApplicationManager.getApplication() == null) {
            return;
        }
        final PsiFile file2 = PsiDocumentManager.getInstance(this.myProject).getPsiFile(this.myEditor.getDocument());
        if (file2 == null) {
            return;
        }
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        Shortcut shortcut = KeymapUtil.getPrimaryShortcut("GotoNextError");
        String shortcutText = shortcut != null ? " (" + KeymapUtil.getShortcutText(shortcut) + ")" : "";
        DefaultActionGroup gotoGroup = DefaultActionGroup.createPopupGroup(() -> CodeInsightBundle.message("popup.title.next.error.action.0.goes.through", shortcutText));
        gotoGroup.add(new ToggleAction(EditorBundle.message("errors.panel.go.to.errors.first.radio", new Object[0])){

            @Override
            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                return DaemonCodeAnalyzerSettings.getInstance().isNextErrorActionGoesToErrorsFirst();
            }

            @Override
            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                DaemonCodeAnalyzerSettings.getInstance().setNextErrorActionGoesToErrorsFirst(state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonEditorPopup$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        gotoGroup.add(new ToggleAction(EditorBundle.message("errors.panel.go.to.next.error.warning.radio", new Object[0])){

            @Override
            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                return !DaemonCodeAnalyzerSettings.getInstance().isNextErrorActionGoesToErrorsFirst();
            }

            @Override
            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                DaemonCodeAnalyzerSettings.getInstance().setNextErrorActionGoesToErrorsFirst(!state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonEditorPopup$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        actionGroup.add(gotoGroup);
        actionGroup.addSeparator();
        actionGroup.add(new AnAction(EditorBundle.messagePointer("customize.highlighting.level.menu.item", new Object[0])){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                HectorComponent component2 = ServiceManager.getService(DaemonEditorPopup.this.myProject, HectorComponentFactory.class).create(file2);
                component2.showComponent(comp, (Function1<? super Dimension, ? extends Point>)((Function1)d -> new Point(x - d.width, y)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/daemon/impl/DaemonEditorPopup$3", "actionPerformed"));
            }
        });
        if (!UIUtil.uiParents(this.myEditor.getComponent(), false).filter(EditorWindowHolder.class).isEmpty()) {
            actionGroup.addSeparator();
            actionGroup.add(new ToggleAction(IdeBundle.message("checkbox.show.editor.preview.popup", new Object[0])){

                @Override
                public boolean isSelected(@NotNull AnActionEvent e) {
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return UISettings.getInstance().getShowEditorToolTip();
                }

                @Override
                public void setSelected(@NotNull AnActionEvent e, boolean state) {
                    if (e == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    UISettings.getInstance().setShowEditorToolTip(state);
                    UISettings.getInstance().fireUISettingsChanged();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "e";
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonEditorPopup$4";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isSelected";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "setSelected";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        ActionPopupMenu editorPopup = actionManager.createActionPopupMenu("RightEditorGutterPopup", actionGroup);
        if (DaemonCodeAnalyzer.getInstance(this.myProject).isHighlightingAvailable(file2)) {
            UIEventLogger.logUIEvent((UIEventId)UIEventId.DaemonEditorPopupInvoked);
            editorPopup.getComponent().show(comp, x, y);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/daemon/impl/DaemonEditorPopup";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

