/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.DaemonTooltipAction;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.AbstractEmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionActionWithTextCaching;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.TooltipAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.xml.util.XmlStringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a \u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n\u001a\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u000f"}, d2={"extractMostPriorityFixFromHighlightInfo", "Lcom/intellij/codeInsight/intention/IntentionAction;", "highlightInfo", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getFirstAvailableAction", "intentionsInfo", "Lcom/intellij/codeInsight/daemon/impl/ShowIntentionsPass$IntentionsInfo;", "wrapIntentionToTooltipAction", "Lcom/intellij/openapi/editor/ex/TooltipAction;", "intention", "info", "intellij.platform.lang.impl"})
public final class DaemonTooltipActionProviderKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final IntentionAction extractMostPriorityFixFromHighlightInfo(@NotNull HighlightInfo highlightInfo, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        Collection<HighlightInfo.IntentionActionDescriptor> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)highlightInfo, (String)"highlightInfo");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
        ApplicationManager.getApplication().assertReadAccessAllowed();
        boolean bl = false;
        List fixes = new ArrayList();
        List<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>> quickFixActionMarkers = highlightInfo.quickFixActionRanges;
        if (quickFixActionMarkers == null || quickFixActionMarkers.isEmpty()) {
            return null;
        }
        Iterable iterable = quickFixActionMarkers;
        List list2 = fixes;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            HighlightInfo.IntentionActionDescriptor intentionActionDescriptor = (HighlightInfo.IntentionActionDescriptor)it.first;
            collection.add(intentionActionDescriptor);
        }
        collection = (List)destination$iv$iv;
        list2.addAll(CollectionsKt.toList((Iterable)collection));
        ShowIntentionsPass.IntentionsInfo intentionsInfo = new ShowIntentionsPass.IntentionsInfo();
        ShowIntentionsPass.fillIntentionsInfoForHighlightInfo(highlightInfo, intentionsInfo, fixes);
        intentionsInfo.filterActions(psiFile);
        return DaemonTooltipActionProviderKt.getFirstAvailableAction(psiFile, editor, intentionsInfo);
    }

    @Nullable
    public static final IntentionAction getFirstAvailableAction(@NotNull PsiFile psiFile, @NotNull Editor editor, @NotNull ShowIntentionsPass.IntentionsInfo intentionsInfo) {
        Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)intentionsInfo, (String)"intentionsInfo");
        Project project2 = psiFile.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"psiFile.project");
        Project project3 = project2;
        CachedIntentions cachedIntentions = CachedIntentions.createAndUpdateActions(project3, psiFile, editor, intentionsInfo);
        Intrinsics.checkExpressionValueIsNotNull((Object)cachedIntentions, (String)"CachedIntentions.createA\u2026, editor, intentionsInfo)");
        CachedIntentions cachedIntentions2 = cachedIntentions;
        List<IntentionActionWithTextCaching> list2 = cachedIntentions2.getAllActions();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"cachedIntentions.allActions");
        List<IntentionActionWithTextCaching> allActions = list2;
        if (allActions.isEmpty()) {
            return null;
        }
        Iterable $this$forEach$iv = allActions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String text2;
            IntentionAction action2;
            IntentionActionWithTextCaching it = (IntentionActionWithTextCaching)element$iv;
            boolean bl = false;
            IntentionActionWithTextCaching intentionActionWithTextCaching = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)intentionActionWithTextCaching, (String)"it");
            Intrinsics.checkExpressionValueIsNotNull((Object)IntentionActionDelegate.unwrap(intentionActionWithTextCaching.getAction()), (String)"IntentionActionDelegate.unwrap(it.action)");
            if (action2 instanceof AbstractEmptyIntentionAction || !action2.isAvailable(project3, editor, psiFile)) continue;
            Intrinsics.checkExpressionValueIsNotNull((Object)it.getText(), (String)"it.text");
            if (XmlStringUtil.isWrappedInHtml(text2)) continue;
            return action2;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final TooltipAction wrapIntentionToTooltipAction(@NotNull IntentionAction intention, @NotNull HighlightInfo info, @NotNull Editor editor) {
        int n;
        RangeMarker pair;
        RangeMarker rangeMarker;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)intention, (String)"intention");
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        int editorOffset = caretModel.getOffset();
        int n2 = info.getActualStartOffset();
        if (new IntRange(n2, info.getActualEndOffset()).contains(editorOffset)) {
            String string = intention.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"intention.text");
            return new DaemonTooltipAction(string, editorOffset);
        }
        List<Pair<HighlightInfo.IntentionActionDescriptor, RangeMarker>> list2 = info.quickFixActionMarkers;
        if (list2 == null) {
            object = null;
        } else {
            Object v5;
            block6: {
                Iterable iterable = list2;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    Pair it = (Pair)t;
                    boolean bl3 = false;
                    HighlightInfo.IntentionActionDescriptor intentionActionDescriptor = (HighlightInfo.IntentionActionDescriptor)it.first;
                    if (!Intrinsics.areEqual((Object)(intentionActionDescriptor != null ? intentionActionDescriptor.getAction() : null), (Object)intention)) continue;
                    v5 = t;
                    break block6;
                }
                v5 = null;
            }
            object = v5;
        }
        if ((rangeMarker = (pair = object)) != null && (rangeMarker = (RangeMarker)((Pair)((Object)rangeMarker)).second) != null && rangeMarker.isValid()) {
            Object b = ((Pair)((Object)pair)).second;
            Intrinsics.checkExpressionValueIsNotNull(b, (String)"pair.second");
            n = ((RangeMarker)b).getStartOffset();
        } else {
            n = info.getActualStartOffset();
        }
        int offset = n;
        String string = intention.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"intention.text");
        return new DaemonTooltipAction(string, offset);
    }
}

