/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.ErrorQuickFixProvider;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.diagnostic.PluginException;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageAnnotators;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class DefaultHighlightVisitor
implements HighlightVisitor,
DumbAware {
    private AnnotationHolderImpl myAnnotationHolder;
    private final Map<String, List<Annotator>> myAnnotators;
    private static final Logger LOG = Logger.getInstance(DefaultHighlightVisitor.class);
    private final Project myProject;
    private final boolean myHighlightErrorElements;
    private final boolean myRunAnnotators;
    private final DumbService myDumbService;
    private HighlightInfoHolder myHolder;
    private final boolean myBatchMode;
    private boolean myDumb;

    DefaultHighlightVisitor(@NotNull Project project2) {
        if (project2 == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(0);
        }
        this(project2, true, true, false);
    }

    DefaultHighlightVisitor(@NotNull Project project2, boolean highlightErrorElements, boolean runAnnotators, boolean batchMode) {
        if (project2 == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(1);
        }
        this.myAnnotators = FactoryMap.create(key -> DefaultHighlightVisitor.createAnnotators(key));
        this.myProject = project2;
        this.myHighlightErrorElements = highlightErrorElements;
        this.myRunAnnotators = runAnnotators;
        this.myDumbService = DumbService.getInstance(project2);
        this.myBatchMode = batchMode;
    }

    @Override
    public boolean suitableForFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(2);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean analyze(@NotNull PsiFile file2, boolean updateWholeFile, final @NotNull HighlightInfoHolder holder, @NotNull Runnable action2) {
        if (file2 == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(4);
        }
        if (action2 == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(5);
        }
        this.myDumb = this.myDumbService.isDumb();
        this.myHolder = holder;
        this.myAnnotationHolder = new AnnotationHolderImpl(holder.getAnnotationSession(), this.myBatchMode){

            @Override
            void queueToUpdateIncrementally() {
                if (!this.isEmpty()) {
                    for (int i = 0; i < this.size(); ++i) {
                        Annotation annotation = (Annotation)this.get(i);
                        holder.add(HighlightInfo.fromAnnotation(annotation, DefaultHighlightVisitor.this.myBatchMode));
                    }
                    holder.queueToUpdateIncrementally();
                    this.clear();
                }
            }
        };
        try {
            action2.run();
            this.myAnnotationHolder.assertAllAnnotationsCreated();
        }
        finally {
            this.myAnnotators.clear();
            this.myHolder = null;
            this.myAnnotationHolder = null;
        }
        return true;
    }

    @Override
    public void visit(@NotNull PsiElement element2) {
        if (element2 == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(6);
        }
        if (element2 instanceof PsiErrorElement) {
            if (this.myHighlightErrorElements) {
                this.visitErrorElement((PsiErrorElement)element2);
            }
        } else if (this.myRunAnnotators) {
            this.runAnnotators(element2);
        }
    }

    @Override
    @NotNull
    public HighlightVisitor clone() {
        return new DefaultHighlightVisitor(this.myProject, this.myHighlightErrorElements, this.myRunAnnotators, this.myBatchMode);
    }

    private void runAnnotators(@NotNull PsiElement element2) {
        List<Annotator> annotators;
        if (element2 == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(7);
        }
        if (!(annotators = this.myAnnotators.get(element2.getLanguage().getID())).isEmpty()) {
            AnnotationHolderImpl holder = this.myAnnotationHolder;
            holder.myCurrentElement = element2;
            for (Annotator annotator : annotators) {
                if (this.myDumb && !DumbService.isDumbAware(annotator)) continue;
                ProgressManager.checkCanceled();
                annotator.annotate(element2, holder);
                holder.queueToUpdateIncrementally();
            }
        }
    }

    private void visitErrorElement(@NotNull PsiErrorElement element2) {
        if (element2 == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(8);
        }
        if (HighlightErrorFilter.EP_NAME.findFirstSafe(this.myProject, filter2 -> !filter2.shouldHighlightErrorElement(element2)) != null) {
            return;
        }
        this.myHolder.add(DefaultHighlightVisitor.createErrorElementInfo(element2));
    }

    private static HighlightInfo createErrorElementInfo(@NotNull PsiErrorElement element2) {
        HighlightInfo info;
        if (element2 == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(9);
        }
        if ((info = DefaultHighlightVisitor.createInfoWithoutFixes(element2)) != null) {
            for (ErrorQuickFixProvider provider : ErrorQuickFixProvider.EP_NAME.getExtensionList()) {
                provider.registerErrorQuickFix(element2, info);
            }
        }
        return info;
    }

    private static HighlightInfo createInfoWithoutFixes(@NotNull PsiErrorElement element2) {
        int end;
        int start2;
        String text2;
        if (element2 == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(10);
        }
        TextRange range2 = element2.getTextRange();
        String errorDescription = element2.getErrorDescription();
        if (!range2.isEmpty()) {
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range2).descriptionAndTooltip(errorDescription).create();
        }
        int offset = range2.getStartOffset();
        PsiFile containingFile = element2.getContainingFile();
        int fileLength = containingFile.getTextLength();
        FileViewProvider viewProvider = containingFile.getViewProvider();
        PsiElement elementAtOffset = viewProvider.findElementAt(offset, LanguageUtil.getRootLanguage(element2));
        String string = text2 = elementAtOffset == null ? null : elementAtOffset.getText();
        if (offset < fileLength && text2 != null && !StringUtil.startsWithChar(text2, '\n') && !StringUtil.startsWithChar(text2, '\r')) {
            HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(offset, offset + 1);
            builder2.descriptionAndTooltip(errorDescription);
            return builder2.create();
        }
        if (offset > 0) {
            start2 = offset;
            end = offset;
        } else {
            start2 = offset;
            end = offset < fileLength ? offset + 1 : offset;
        }
        HighlightInfo.Builder builder3 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(element2, start2, end);
        builder3.descriptionAndTooltip(errorDescription);
        builder3.endOfLine();
        return builder3.create();
    }

    @NotNull
    private static List<Annotator> cloneTemplates(@NotNull Collection<? extends Annotator> templates) {
        if (templates == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(11);
        }
        ArrayList<Annotator> result2 = new ArrayList<Annotator>(templates.size());
        for (Annotator annotator : templates) {
            Annotator annotator2;
            try {
                annotator2 = (Annotator)ReflectionUtil.newInstance(annotator.getClass());
            }
            catch (Exception e) {
                LOG.error(PluginException.createByClass(e, annotator.getClass()));
                continue;
            }
            result2.add(annotator2);
        }
        ArrayList<Annotator> arrayList = result2;
        if (arrayList == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    private static List<Annotator> createAnnotators(@NotNull String languageId) {
        Language language2;
        if (languageId == null) {
            DefaultHighlightVisitor.$$$reportNull$$$0(13);
        }
        if ((language2 = Language.findLanguageByID(languageId)) == null) {
            List<Annotator> list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                DefaultHighlightVisitor.$$$reportNull$$$0(14);
            }
            return list2;
        }
        return DefaultHighlightVisitor.cloneTemplates(LanguageAnnotators.INSTANCE.allForLanguageOrAny(language2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templates";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DefaultHighlightVisitor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneTemplates";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "suitableForFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "analyze";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runAnnotators";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitErrorElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createErrorElementInfo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createInfoWithoutFixes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "cloneTemplates";
                break;
            }
            case 12: 
            case 14: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotators";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

