/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.util.Processor;
import com.intellij.util.containers.Stack;
import gnu.trove.TIntStack;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Divider {
    private static final int STARTING_TREE_HEIGHT = 10;
    private static final Key<Reference<DividedElements>> DIVIDED_ELEMENTS_KEY = Key.create("DIVIDED_ELEMENTS");
    private static final PsiElement HAVE_TO_GET_CHILDREN = PsiUtilCore.NULL_PSI_ELEMENT;

    public static void divideInsideAndOutsideAllRoots(@NotNull PsiFile file2, @NotNull TextRange restrictRange, @NotNull TextRange priorityRange, @NotNull Condition<? super PsiFile> rootFilter, @NotNull Processor<? super DividedElements> processor2) {
        if (file2 == null) {
            Divider.$$$reportNull$$$0(0);
        }
        if (restrictRange == null) {
            Divider.$$$reportNull$$$0(1);
        }
        if (priorityRange == null) {
            Divider.$$$reportNull$$$0(2);
        }
        if (rootFilter == null) {
            Divider.$$$reportNull$$$0(3);
        }
        if (processor2 == null) {
            Divider.$$$reportNull$$$0(4);
        }
        FileViewProvider viewProvider = file2.getViewProvider();
        for (Language language2 : viewProvider.getLanguages()) {
            PsiFile root = viewProvider.getPsi(language2);
            if (!rootFilter.value(root)) continue;
            Divider.divideInsideAndOutsideInOneRoot(root, restrictRange, priorityRange, processor2);
        }
    }

    static void divideInsideAndOutsideInOneRoot(@NotNull PsiFile root, @NotNull TextRange restrictRange, @NotNull TextRange priorityRange, @NotNull Processor<? super DividedElements> processor2) {
        DividedElements elements2;
        if (root == null) {
            Divider.$$$reportNull$$$0(5);
        }
        if (restrictRange == null) {
            Divider.$$$reportNull$$$0(6);
        }
        if (priorityRange == null) {
            Divider.$$$reportNull$$$0(7);
        }
        if (processor2 == null) {
            Divider.$$$reportNull$$$0(8);
        }
        long modificationStamp = root.getModificationStamp();
        DividedElements cached = SoftReference.dereference(root.getUserData(DIVIDED_ELEMENTS_KEY));
        if (cached == null || cached.modificationStamp != modificationStamp || !cached.restrictRange.equals(restrictRange) || !cached.priorityRange.contains(priorityRange)) {
            elements2 = new DividedElements(modificationStamp, restrictRange, priorityRange);
            Divider.divideInsideAndOutsideInOneRoot(root, restrictRange, priorityRange, elements2.inside, elements2.insideRanges, elements2.outside, elements2.outsideRanges, elements2.parents, elements2.parentRanges, true);
            root.putUserData(DIVIDED_ELEMENTS_KEY, new java.lang.ref.SoftReference<DividedElements>(elements2));
        } else {
            elements2 = cached;
        }
        processor2.process(elements2);
    }

    private static void divideInsideAndOutsideInOneRoot(@NotNull PsiFile root, @NotNull TextRange restrictRange, @NotNull TextRange priorityRange, @NotNull List<PsiElement> inside, @NotNull List<? super ProperTextRange> insideRanges, @NotNull List<PsiElement> outside, @NotNull List<? super ProperTextRange> outsideRanges, @NotNull List<? super PsiElement> outParents, @NotNull List<? super ProperTextRange> outParentRanges, boolean includeParents) {
        if (root == null) {
            Divider.$$$reportNull$$$0(9);
        }
        if (restrictRange == null) {
            Divider.$$$reportNull$$$0(10);
        }
        if (priorityRange == null) {
            Divider.$$$reportNull$$$0(11);
        }
        if (inside == null) {
            Divider.$$$reportNull$$$0(12);
        }
        if (insideRanges == null) {
            Divider.$$$reportNull$$$0(13);
        }
        if (outside == null) {
            Divider.$$$reportNull$$$0(14);
        }
        if (outsideRanges == null) {
            Divider.$$$reportNull$$$0(15);
        }
        if (outParents == null) {
            Divider.$$$reportNull$$$0(16);
        }
        if (outParentRanges == null) {
            Divider.$$$reportNull$$$0(17);
        }
        int startOffset = restrictRange.getStartOffset();
        int endOffset = restrictRange.getEndOffset();
        Condition<PsiElement>[] filters = CollectHighlightsUtil.EP_NAME.getExtensions();
        TIntStack starts = new TIntStack(10);
        starts.push(startOffset);
        Stack<PsiFile> elements2 = new Stack<PsiFile>(10);
        Stack<PsiElement> children2 = new Stack<PsiElement>(10);
        PsiElement element2 = root;
        PsiElement child2 = HAVE_TO_GET_CHILDREN;
        int offset = 0;
        while (true) {
            boolean startChildrenVisiting;
            ProgressManager.checkCanceled();
            for (Condition<PsiElement> filter2 : filters) {
                if (filter2.value(element2)) continue;
                assert (child2 == HAVE_TO_GET_CHILDREN);
                child2 = null;
                break;
            }
            if (child2 == HAVE_TO_GET_CHILDREN) {
                startChildrenVisiting = true;
                child2 = element2.getFirstChild();
            } else {
                startChildrenVisiting = false;
            }
            if (child2 == null) {
                int start2;
                if (startChildrenVisiting) {
                    offset += element2.getTextLength();
                }
                if (startOffset <= (start2 = starts.pop()) && offset <= endOffset) {
                    if (priorityRange.containsRange(start2, offset)) {
                        inside.add(element2);
                        insideRanges.add(new ProperTextRange(start2, offset));
                    } else {
                        outside.add(element2);
                        outsideRanges.add(new ProperTextRange(start2, offset));
                    }
                }
                if (elements2.isEmpty()) break;
                element2 = (PsiElement)elements2.pop();
                child2 = (PsiElement)children2.pop();
                continue;
            }
            if (offset > endOffset) break;
            children2.push(child2.getNextSibling());
            starts.push(offset);
            elements2.push((PsiFile)element2);
            element2 = child2;
            child2 = HAVE_TO_GET_CHILDREN;
        }
        if (includeParents) {
            PsiElement parent;
            PsiElement psiElement = !outside.isEmpty() ? outside.get(outside.size() - 1) : (parent = !inside.isEmpty() ? inside.get(inside.size() - 1) : CollectHighlightsUtil.findCommonParent(root, startOffset, endOffset));
            while (parent != null && !(parent instanceof PsiFile)) {
                if ((parent = parent.getParent()) == null) continue;
                outParents.add(parent);
                TextRange textRange = parent.getTextRange();
                assert (textRange != null) : "Text range for " + parent + " is null. " + parent.getClass() + "; root: " + root + ": " + root.getVirtualFile();
                outParentRanges.add(ProperTextRange.create(textRange));
            }
        }
        assert (inside.size() == insideRanges.size());
        assert (outside.size() == outsideRanges.size());
        assert (outParents.size() == outParentRanges.size());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictRange";
                break;
            }
            case 2: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFilter";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inside";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insideRanges";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outside";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outsideRanges";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outParents";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outParentRanges";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/Divider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "divideInsideAndOutsideAllRoots";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "divideInsideAndOutsideInOneRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class DividedElements {
        private final long modificationStamp;
        @NotNull
        private final TextRange restrictRange;
        @NotNull
        private final TextRange priorityRange;
        public final List<PsiElement> inside;
        final List<ProperTextRange> insideRanges;
        public final List<PsiElement> outside;
        final List<ProperTextRange> outsideRanges;
        public final List<PsiElement> parents;
        final List<ProperTextRange> parentRanges;

        /*
         * WARNING - void declaration
         */
        private DividedElements(long modificationStamp, @NotNull TextRange restrictRange, @NotNull TextRange textRange) {
            void priorityRange;
            if (restrictRange == null) {
                DividedElements.$$$reportNull$$$0(0);
            }
            if (textRange == null) {
                DividedElements.$$$reportNull$$$0(1);
            }
            this.inside = new ArrayList<PsiElement>();
            this.insideRanges = new ArrayList<ProperTextRange>();
            this.outside = new ArrayList<PsiElement>();
            this.outsideRanges = new ArrayList<ProperTextRange>();
            this.parents = new ArrayList<PsiElement>();
            this.parentRanges = new ArrayList<ProperTextRange>();
            this.modificationStamp = modificationStamp;
            this.restrictRange = restrictRange;
            this.priorityRange = priorityRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "restrictRange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "priorityRange";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/Divider$DividedElements";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

