/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.impl.DaemonEditorPopup;
import com.intellij.codeInsight.daemon.impl.DaemonTooltipRendererProvider;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.codeInsight.daemon.impl.TrafficLightRendererContributor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.ErrorStripTooltipRendererProvider;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorStripeUpdateManager {
    private final Project myProject;
    private final PsiDocumentManager myPsiDocumentManager;

    public static ErrorStripeUpdateManager getInstance(Project project2) {
        return ServiceManager.getService(project2, ErrorStripeUpdateManager.class);
    }

    public ErrorStripeUpdateManager(Project project2) {
        this.myProject = project2;
        this.myPsiDocumentManager = PsiDocumentManager.getInstance(this.myProject);
    }

    public void repaintErrorStripePanel(@NotNull Editor editor) {
        if (editor == null) {
            ErrorStripeUpdateManager.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.myProject.isInitialized()) {
            return;
        }
        PsiFile file2 = this.myPsiDocumentManager.getPsiFile(editor.getDocument());
        EditorMarkupModel markup = (EditorMarkupModel)editor.getMarkupModel();
        markup.setErrorPanelPopupHandler(new DaemonEditorPopup(this.myProject, editor));
        markup.setErrorStripTooltipRendererProvider(this.createTooltipRenderer(editor));
        markup.setMinMarkHeight(DaemonCodeAnalyzerSettings.getInstance().getErrorStripeMarkMinHeight());
        this.setOrRefreshErrorStripeRenderer(markup, file2);
    }

    protected void setOrRefreshErrorStripeRenderer(@NotNull EditorMarkupModel editorMarkupModel, @Nullable PsiFile file2) {
        Editor editor;
        if (editorMarkupModel == null) {
            ErrorStripeUpdateManager.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!editorMarkupModel.isErrorStripeVisible() || !DaemonCodeAnalyzer.getInstance(this.myProject).isHighlightingAvailable(file2)) {
            return;
        }
        ErrorStripeRenderer renderer = editorMarkupModel.getErrorStripeRenderer();
        if (renderer instanceof TrafficLightRenderer) {
            TrafficLightRenderer tlr = (TrafficLightRenderer)renderer;
            EditorMarkupModelImpl markupModelImpl = (EditorMarkupModelImpl)editorMarkupModel;
            tlr.refresh(markupModelImpl);
            markupModelImpl.repaintTrafficLightIcon();
            if (tlr.isValid()) {
                return;
            }
        }
        if ((editor = editorMarkupModel.getEditor()).isDisposed()) {
            return;
        }
        editorMarkupModel.setErrorStripeRenderer(this.createRenderer(editor, file2));
    }

    @NotNull
    private ErrorStripTooltipRendererProvider createTooltipRenderer(Editor editor) {
        return new DaemonTooltipRendererProvider(this.myProject, editor);
    }

    @Nullable
    protected TrafficLightRenderer createRenderer(@NotNull Editor editor, @Nullable PsiFile file2) {
        if (editor == null) {
            ErrorStripeUpdateManager.$$$reportNull$$$0(2);
        }
        for (TrafficLightRendererContributor contributor : TrafficLightRendererContributor.EP_NAME.getExtensionList()) {
            TrafficLightRenderer renderer = contributor.createRenderer(editor, file2);
            if (renderer == null) continue;
            return renderer;
        }
        return new TrafficLightRenderer(this.myProject, editor.getDocument());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorMarkupModel";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ErrorStripeUpdateManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "repaintErrorStripePanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setOrRefreshErrorStripeRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createRenderer";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

