/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.ExternalToolPassFactory;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.diagnostic.PluginException;
import com.intellij.lang.ExternalLanguageAnnotators;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalToolPass
extends ProgressableTextEditorHighlightingPass {
    private static final Logger LOG = Logger.getInstance(ExternalToolPass.class);
    private final Document myDocument;
    private final AnnotationHolderImpl myAnnotationHolder;
    private final ExternalToolPassFactory myExternalToolPassFactory;
    private final boolean myMainHighlightingPass;
    private final List<MyData> myAnnotationData;

    ExternalToolPass(@NotNull ExternalToolPassFactory factory, @NotNull PsiFile file2, @NotNull Editor editor, int startOffset, int endOffset) {
        if (factory == null) {
            ExternalToolPass.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ExternalToolPass.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            ExternalToolPass.$$$reportNull$$$0(2);
        }
        this(factory, file2, editor.getDocument(), editor, startOffset, endOffset, new DefaultHighlightInfoProcessor(), false);
    }

    ExternalToolPass(@NotNull ExternalToolPassFactory factory, @NotNull PsiFile file2, @NotNull Document document, @Nullable Editor editor, int startOffset, int endOffset, @NotNull HighlightInfoProcessor processor2, boolean mainHighlightingPass) {
        if (factory == null) {
            ExternalToolPass.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            ExternalToolPass.$$$reportNull$$$0(4);
        }
        if (document == null) {
            ExternalToolPass.$$$reportNull$$$0(5);
        }
        if (processor2 == null) {
            ExternalToolPass.$$$reportNull$$$0(6);
        }
        super(file2.getProject(), document, "External annotators", file2, editor, new TextRange(startOffset, endOffset), false, processor2);
        this.myAnnotationData = new ArrayList<MyData>();
        this.myDocument = document;
        this.myAnnotationHolder = new AnnotationHolderImpl(new AnnotationSession(file2));
        this.myExternalToolPassFactory = factory;
        this.myMainHighlightingPass = mainHighlightingPass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void collectInformationWithProgress(@NotNull ProgressIndicator progress2) {
        if (progress2 == null) {
            ExternalToolPass.$$$reportNull$$$0(7);
        }
        FileViewProvider viewProvider = this.myFile.getViewProvider();
        HighlightingLevelManager highlightingManager = HighlightingLevelManager.getInstance(this.myProject);
        HashMap<PsiFile, List<ExternalAnnotator>> allAnnotators = new HashMap<PsiFile, List<ExternalAnnotator>>();
        int externalAnnotatorsInRoots = 0;
        for (Language language2 : viewProvider.getLanguages()) {
            List<ExternalAnnotator> annotators;
            PsiFile psiRoot = viewProvider.getPsi(language2);
            if (!highlightingManager.shouldInspect(psiRoot) || (annotators = ExternalLanguageAnnotators.allForFile(language2, psiRoot)).isEmpty()) continue;
            externalAnnotatorsInRoots += annotators.size();
            allAnnotators.put(psiRoot, annotators);
        }
        this.setProgressLimit(externalAnnotatorsInRoots);
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance(this.myProject).getCurrentProfile();
        boolean errorFound = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject).getFileStatusMap().wasErrorFound(this.myDocument);
        Editor editor = this.getEditor();
        DumbService dumbService = DumbService.getInstance(this.myProject);
        for (PsiFile psiRoot : allAnnotators.keySet()) {
            for (ExternalAnnotator annotator : (List)allAnnotators.get(psiRoot)) {
                progress2.checkCanceled();
                try {
                    if (dumbService.isDumb() && !DumbService.isDumbAware(annotator)) continue;
                    String shortName = annotator.getPairedBatchInspectionShortName();
                    if (shortName != null) {
                        HighlightDisplayKey key = HighlightDisplayKey.find(shortName);
                        if (key == null) {
                            if (ApplicationManager.getApplication().isUnitTestMode()) continue;
                            ExternalToolPass.process(new Exception("Paired tool '" + shortName + "' not found"), annotator, psiRoot);
                            continue;
                        }
                        if (!profile.isToolEnabled(key, this.myFile)) continue;
                    }
                    Object collectedInfo = null;
                    try {
                        collectedInfo = (editor != null ? annotator.collectInformation(psiRoot, editor, errorFound) : annotator.collectInformation(psiRoot));
                    }
                    catch (Throwable t) {
                        ExternalToolPass.process(t, annotator, psiRoot);
                    }
                    if (collectedInfo == null) continue;
                    this.myAnnotationData.add(new MyData(annotator, psiRoot, collectedInfo));
                }
                finally {
                    this.advanceProgress(1L);
                }
            }
        }
    }

    @Override
    @NotNull
    public List<HighlightInfo> getInfos() {
        if (this.myProject.isDisposed()) {
            List<HighlightInfo> list2 = Collections.emptyList();
            if (list2 == null) {
                ExternalToolPass.$$$reportNull$$$0(8);
            }
            return list2;
        }
        if (this.myMainHighlightingPass) {
            this.doAnnotate();
            this.doApply();
            List<HighlightInfo> list3 = this.getHighlights();
            if (list3 == null) {
                ExternalToolPass.$$$reportNull$$$0(9);
            }
            return list3;
        }
        List<HighlightInfo> list4 = super.getInfos();
        if (list4 == null) {
            ExternalToolPass.$$$reportNull$$$0(10);
        }
        return list4;
    }

    @Override
    protected void applyInformationWithProgress() {
        final long modificationStampBefore = this.myDocument.getModificationStamp();
        Update update2 = new Update((Object)this.myFile){

            @Override
            public void setRejected() {
                super.setRejected();
                ExternalToolPass.this.doFinish(ExternalToolPass.this.getHighlights(), modificationStampBefore);
            }

            @Override
            public void run() {
                if (!ExternalToolPass.this.documentChanged(modificationStampBefore) && !ExternalToolPass.this.myProject.isDisposed()) {
                    BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)ExternalToolPass.this.myProject, () -> {
                        ExternalToolPass.runChangeAware(ExternalToolPass.this.myDocument, () -> ExternalToolPass.this.doAnnotate());
                        ReadAction.run(() -> {
                            ProgressManager.checkCanceled();
                            if (!ExternalToolPass.this.documentChanged(modificationStampBefore)) {
                                ExternalToolPass.this.doApply();
                                ExternalToolPass.this.doFinish(ExternalToolPass.this.getHighlights(), modificationStampBefore);
                            }
                        });
                    });
                }
            }
        };
        this.myExternalToolPassFactory.scheduleExternalActivity(update2);
    }

    private boolean documentChanged(long modificationStampBefore) {
        return this.myDocument.getModificationStamp() != modificationStampBefore;
    }

    private void doAnnotate() {
        for (MyData data2 : this.myAnnotationData) {
            try {
                data2.annotationResult = data2.annotator.doAnnotate(data2.collectedInfo);
            }
            catch (Throwable t) {
                ExternalToolPass.process(t, data2.annotator, data2.psiRoot);
            }
        }
    }

    private void doApply() {
        for (MyData data2 : this.myAnnotationData) {
            if (data2.annotationResult == null || data2.psiRoot == null || !data2.psiRoot.isValid()) continue;
            try {
                this.myAnnotationHolder.applyExternalAnnotatorWithContext(data2.psiRoot, data2.annotator, data2.annotationResult);
            }
            catch (Throwable t) {
                ExternalToolPass.process(t, data2.annotator, data2.psiRoot);
            }
        }
        this.myAnnotationHolder.assertAllAnnotationsCreated();
    }

    private List<HighlightInfo> getHighlights() {
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>(this.myAnnotationHolder.size());
        for (Annotation annotation : this.myAnnotationHolder) {
            infos.add(HighlightInfo.fromAnnotation(annotation));
        }
        return infos;
    }

    private void doFinish(List<? extends HighlightInfo> highlights, long modificationStampBefore) {
        Editor editor = this.getEditor();
        assert (editor != null);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!this.documentChanged(modificationStampBefore) && !this.myProject.isDisposed()) {
                int start2 = this.myRestrictRange.getStartOffset();
                int end = this.myRestrictRange.getEndOffset();
                UpdateHighlightersUtil.setHighlightersToEditor(this.myProject, this.myDocument, start2, end, highlights, this.getColorsScheme(), this.getId());
                DaemonCodeAnalyzerEx.getInstanceEx(this.myProject).getFileStatusMap().markFileUpToDate(this.myDocument, this.getId());
            }
        }, ModalityState.stateForComponent(editor.getComponent()));
    }

    private static void process(Throwable t, ExternalAnnotator annotator, PsiFile root) {
        if (t instanceof ProcessCanceledException) {
            throw (ProcessCanceledException)t;
        }
        VirtualFile file2 = root.getVirtualFile();
        String path2 = file2 != null ? file2.getPath() : root.getName();
        String message = "annotator: " + annotator + " (" + annotator.getClass() + ")";
        PluginException pe = PluginException.createByClass(message, t, annotator.getClass());
        LOG.error("ExternalToolPass: ", (Throwable)pe, new Attachment("root_path.txt", path2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runChangeAware(@NotNull Document document, @NotNull Runnable runnable2) {
        if (document == null) {
            ExternalToolPass.$$$reportNull$$$0(11);
        }
        if (runnable2 == null) {
            ExternalToolPass.$$$reportNull$$$0(12);
        }
        final ProgressIndicator currentIndicator = ProgressManager.getInstance().getProgressIndicator();
        assert (currentIndicator != null);
        DocumentListener cancellingListener = new DocumentListener(){

            @Override
            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                currentIndicator.cancel();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/daemon/impl/ExternalToolPass$2", "documentChanged"));
            }
        };
        document.addDocumentListener(cancellingListener);
        try {
            runnable2.run();
        }
        finally {
            document.removeDocumentListener(cancellingListener);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/ExternalToolPass";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ExternalToolPass";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectInformationWithProgress";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "runChangeAware";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyData {
        final ExternalAnnotator annotator;
        final PsiFile psiRoot;
        final Object collectedInfo;
        volatile Object annotationResult;

        MyData(ExternalAnnotator annotator, PsiFile psiRoot, Object collectedInfo) {
            this.annotator = annotator;
            this.psiRoot = psiRoot;
            this.collectedInfo = collectedInfo;
        }
    }
}

