/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.GutterIntentionAction;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.IntentionMenuContributor;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.execution.lineMarker.LineMarkerActionWrapper;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GutterIntentionMenuContributor
implements IntentionMenuContributor {
    @Override
    public void collectActions(@NotNull Editor hostEditor, @NotNull PsiFile hostFile, @NotNull ShowIntentionsPass.IntentionsInfo intentions, int passIdToShowIntentionsFor, int offset) {
        if (hostEditor == null) {
            GutterIntentionMenuContributor.$$$reportNull$$$0(0);
        }
        if (hostFile == null) {
            GutterIntentionMenuContributor.$$$reportNull$$$0(1);
        }
        if (intentions == null) {
            GutterIntentionMenuContributor.$$$reportNull$$$0(2);
        }
        Project project2 = hostFile.getProject();
        Document hostDocument = hostEditor.getDocument();
        int line = hostDocument.getLineNumber(offset);
        MarkupModelEx model = (MarkupModelEx)DocumentMarkupModel.forDocument(hostDocument, project2, true);
        ArrayList result2 = new ArrayList();
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        model.processRangeHighlightersOverlappingWith(hostDocument.getLineStartOffset(line), hostDocument.getLineEndOffset(line), processor2);
        for (RangeHighlighterEx highlighter : result2) {
            GutterIntentionMenuContributor.addActions(project2, highlighter, intentions.guttersToShow, ((EditorEx)hostEditor).getDataContext());
        }
    }

    private static void addActions(@NotNull Project project2, @NotNull RangeHighlighterEx info, @NotNull List<? super HighlightInfo.IntentionActionDescriptor> descriptors, @NotNull DataContext dataContext) {
        GutterIconRenderer r;
        if (project2 == null) {
            GutterIntentionMenuContributor.$$$reportNull$$$0(3);
        }
        if (info == null) {
            GutterIntentionMenuContributor.$$$reportNull$$$0(4);
        }
        if (descriptors == null) {
            GutterIntentionMenuContributor.$$$reportNull$$$0(5);
        }
        if (dataContext == null) {
            GutterIntentionMenuContributor.$$$reportNull$$$0(6);
        }
        if ((r = info.getGutterIconRenderer()) == null || DumbService.isDumb(project2) && !DumbService.isDumbAware(r)) {
            return;
        }
        ArrayList list2 = new ArrayList();
        AtomicInteger order = new AtomicInteger();
        AnAction[] actions = new AnAction[]{r.getClickAction(), r.getMiddleButtonClickAction(), r.getRightButtonClickAction()};
        if (r.getPopupMenuActions() != null) {
            actions = ArrayUtil.mergeArrays(actions, r.getPopupMenuActions().getChildren(null));
        }
        for (AnAction action2 : actions) {
            if (action2 == null) continue;
            GutterIntentionMenuContributor.addActions(action2, list2, r, order, dataContext);
        }
        descriptors.addAll(list2);
    }

    private static void addActions(@NotNull AnAction action2, @NotNull List<? super HighlightInfo.IntentionActionDescriptor> descriptors, @NotNull GutterIconRenderer renderer, AtomicInteger order, @NotNull DataContext dataContext) {
        GutterIntentionAction gutterAction;
        Icon icon2;
        AnAction[] children2;
        if (action2 == null) {
            GutterIntentionMenuContributor.$$$reportNull$$$0(7);
        }
        if (descriptors == null) {
            GutterIntentionMenuContributor.$$$reportNull$$$0(8);
        }
        if (renderer == null) {
            GutterIntentionMenuContributor.$$$reportNull$$$0(9);
        }
        if (dataContext == null) {
            GutterIntentionMenuContributor.$$$reportNull$$$0(10);
        }
        if (action2 instanceof LineMarkerActionWrapper && (children2 = Arrays.asList(((LineMarkerActionWrapper)action2).getChildren(null))).size() > 0 && ContainerUtil.all(children2, o -> o instanceof LineMarkerActionWrapper)) {
            for (AnAction child2 : children2) {
                GutterIntentionMenuContributor.addActions(child2, descriptors, renderer, order, dataContext);
            }
            return;
        }
        if (action2 instanceof ActionGroup) {
            for (AnAction child3 : ((ActionGroup)action2).getChildren(null)) {
                GutterIntentionMenuContributor.addActions(child3, descriptors, renderer, order, dataContext);
            }
        }
        if ((icon2 = action2.getTemplatePresentation().getIcon()) == null) {
            icon2 = EmptyIcon.ICON_16;
        }
        if (!(gutterAction = new GutterIntentionAction(action2, order.getAndIncrement(), icon2)).isAvailable(dataContext)) {
            return;
        }
        descriptors.add(new HighlightInfo.IntentionActionDescriptor(gutterAction, Collections.emptyList(), null, icon2){

            @Override
            @NotNull
            public String getDisplayName() {
                String string = gutterAction.getText();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/GutterIntentionMenuContributor$1", "getDisplayName"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/GutterIntentionMenuContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectActions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addActions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

