/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.HectorComponentPanel;
import com.intellij.openapi.editor.HectorComponentPanelsProvider;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.DialogUtil;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ImportPopupHectorComponentProvider
implements HectorComponentPanelsProvider {
    @Override
    public HectorComponentPanel createConfigurable(final @NotNull PsiFile file2) {
        if (file2 == null) {
            ImportPopupHectorComponentProvider.$$$reportNull$$$0(0);
        }
        Project project2 = file2.getProject();
        final DaemonCodeAnalyzer analyzer = DaemonCodeAnalyzer.getInstance(project2);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project2).getFileIndex();
        VirtualFile virtualFile2 = file2.getVirtualFile();
        assert (virtualFile2 != null);
        final boolean notInLibrary = !fileIndex.isInLibrary(virtualFile2) || fileIndex.isInContent(virtualFile2);
        return new HectorComponentPanel(){
            private JCheckBox myImportPopupCheckBox = new JCheckBox(EditorBundle.message("hector.import.popup.checkbox", new Object[0]));

            @Override
            public JComponent createComponent() {
                DialogUtil.registerMnemonic(this.myImportPopupCheckBox);
                return this.myImportPopupCheckBox;
            }

            @Override
            public boolean isModified() {
                return this.myImportPopupCheckBox.isSelected() != analyzer.isImportHintsEnabled(file2);
            }

            @Override
            public void apply() throws ConfigurationException {
                analyzer.setImportHintsEnabled(file2, this.myImportPopupCheckBox.isSelected());
            }

            @Override
            public void reset() {
                this.myImportPopupCheckBox.setSelected(analyzer.isImportHintsEnabled(file2));
                this.myImportPopupCheckBox.setEnabled(analyzer.isAutohintsAvailable(file2));
                this.myImportPopupCheckBox.setVisible(notInLibrary);
            }

            @Override
            public void disposeUIResources() {
                this.myImportPopupCheckBox = null;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/ImportPopupHectorComponentProvider", "createConfigurable"));
    }
}

