/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.navigation.BackgroundUpdaterTask;
import com.intellij.codeInsight.navigation.ListBackgroundUpdaterTask;
import com.intellij.find.FindUtil;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ListComponentUpdater;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiElementListNavigator {
    private PsiElementListNavigator() {
    }

    public static void openTargets(MouseEvent e, NavigatablePsiElement[] targets2, String title, String findUsagesTitle, ListCellRenderer listRenderer) {
        PsiElementListNavigator.openTargets(e, targets2, title, findUsagesTitle, listRenderer, (BackgroundUpdaterTask)null);
    }

    public static void openTargets(MouseEvent e, NavigatablePsiElement[] targets2, String title, String findUsagesTitle, ListCellRenderer listRenderer, @Nullable BackgroundUpdaterTask listUpdaterTask) {
        JBPopup popup2 = PsiElementListNavigator.navigateOrCreatePopup(targets2, title, findUsagesTitle, listRenderer, listUpdaterTask);
        if (popup2 != null) {
            RelativePoint point = new RelativePoint(e);
            if (listUpdaterTask != null) {
                PsiElementListNavigator.runActionAndListUpdaterTask(() -> popup2.show(point), listUpdaterTask);
            } else {
                popup2.show(point);
            }
        }
    }

    public static void openTargets(Editor e, NavigatablePsiElement[] targets2, String title, String findUsagesTitle, ListCellRenderer listRenderer) {
        PsiElementListNavigator.openTargets(e, targets2, title, findUsagesTitle, listRenderer, null);
    }

    public static void openTargets(Editor e, NavigatablePsiElement[] targets2, String title, String findUsagesTitle, ListCellRenderer listRenderer, @Nullable BackgroundUpdaterTask listUpdaterTask) {
        JBPopup popup2 = PsiElementListNavigator.navigateOrCreatePopup(targets2, title, findUsagesTitle, listRenderer, listUpdaterTask);
        if (popup2 != null) {
            if (listUpdaterTask != null) {
                PsiElementListNavigator.runActionAndListUpdaterTask(() -> popup2.showInBestPositionFor(e), listUpdaterTask);
            } else {
                popup2.showInBestPositionFor(e);
            }
        }
    }

    private static void runActionAndListUpdaterTask(@NotNull Runnable action2, @NotNull BackgroundUpdaterTask listUpdaterTask) {
        if (action2 == null) {
            PsiElementListNavigator.$$$reportNull$$$0(0);
        }
        if (listUpdaterTask == null) {
            PsiElementListNavigator.$$$reportNull$$$0(1);
        }
        action2.run();
        ProgressManager.getInstance().run(listUpdaterTask);
    }

    @Nullable
    public static JBPopup navigateOrCreatePopup(NavigatablePsiElement[] targets2, String title, String findUsagesTitle, ListCellRenderer listRenderer, @Nullable BackgroundUpdaterTask listUpdaterTask) {
        return PsiElementListNavigator.navigateOrCreatePopup(targets2, title, findUsagesTitle, listRenderer, listUpdaterTask, selectedElements -> {
            for (Object element2 : selectedElements) {
                PsiElement selected2 = (PsiElement)element2;
                if (!selected2.isValid()) continue;
                ((NavigatablePsiElement)selected2).navigate(true);
            }
        });
    }

    @Nullable
    public static JBPopup navigateOrCreatePopup(NavigatablePsiElement @NotNull [] targets2, String title, String findUsagesTitle, ListCellRenderer listRenderer, @Nullable BackgroundUpdaterTask listUpdaterTask, @NotNull Consumer<Object[]> consumer) {
        if (consumer == null) {
            PsiElementListNavigator.$$$reportNull$$$0(2);
        }
        if (targets2 == null) {
            PsiElementListNavigator.$$$reportNull$$$0(3);
        }
        return new NavigateOrPopupHelper(targets2, title).setFindUsagesTitle(findUsagesTitle).setListRenderer(listRenderer).setListUpdaterTask(listUpdaterTask).setTargetsConsumer(consumer).navigateOrCreatePopup();
    }

    @Deprecated
    public static void openTargets(MouseEvent e, NavigatablePsiElement[] targets2, String title, String findUsagesTitle, ListCellRenderer listRenderer, @Nullable ListBackgroundUpdaterTask listUpdaterTask) {
        PsiElementListNavigator.openTargets(e, targets2, title, findUsagesTitle, listRenderer, (BackgroundUpdaterTask)listUpdaterTask);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listUpdaterTask";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/PsiElementListNavigator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActionAndListUpdaterTask";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "navigateOrCreatePopup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class NavigateOrPopupHelper {
        private final NavigatablePsiElement @NotNull [] myTargets;
        private final String myTitle;
        @NotNull
        private Consumer<Object[]> myTargetsConsumer;
        @Nullable
        private String myFindUsagesTitle;
        @Nullable
        private ListCellRenderer myListRenderer;
        @Nullable
        private BackgroundUpdaterTask myListUpdaterTask;
        @Nullable
        private Project myProject;

        public NavigateOrPopupHelper(NavigatablePsiElement @NotNull [] targets2, String title) {
            if (targets2 == null) {
                NavigateOrPopupHelper.$$$reportNull$$$0(0);
            }
            this.myTargets = targets2;
            this.myTitle = title;
            this.myTargetsConsumer = selectedElements -> {
                for (Object element2 : selectedElements) {
                    PsiElement selected2 = (PsiElement)element2;
                    if (!selected2.isValid()) continue;
                    ((NavigatablePsiElement)selected2).navigate(true);
                }
            };
        }

        @NotNull
        public NavigateOrPopupHelper setFindUsagesTitle(@Nullable String findUsagesTitle) {
            this.myFindUsagesTitle = findUsagesTitle;
            NavigateOrPopupHelper navigateOrPopupHelper = this;
            if (navigateOrPopupHelper == null) {
                NavigateOrPopupHelper.$$$reportNull$$$0(1);
            }
            return navigateOrPopupHelper;
        }

        @NotNull
        public NavigateOrPopupHelper setListRenderer(@Nullable ListCellRenderer listRenderer) {
            this.myListRenderer = listRenderer;
            NavigateOrPopupHelper navigateOrPopupHelper = this;
            if (navigateOrPopupHelper == null) {
                NavigateOrPopupHelper.$$$reportNull$$$0(2);
            }
            return navigateOrPopupHelper;
        }

        @NotNull
        public NavigateOrPopupHelper setListUpdaterTask(@Nullable BackgroundUpdaterTask listUpdaterTask) {
            this.myListUpdaterTask = listUpdaterTask;
            NavigateOrPopupHelper navigateOrPopupHelper = this;
            if (navigateOrPopupHelper == null) {
                NavigateOrPopupHelper.$$$reportNull$$$0(3);
            }
            return navigateOrPopupHelper;
        }

        @NotNull
        public NavigateOrPopupHelper setTargetsConsumer(@NotNull Consumer<Object[]> targetsConsumer) {
            if (targetsConsumer == null) {
                NavigateOrPopupHelper.$$$reportNull$$$0(4);
            }
            this.myTargetsConsumer = targetsConsumer;
            NavigateOrPopupHelper navigateOrPopupHelper = this;
            if (navigateOrPopupHelper == null) {
                NavigateOrPopupHelper.$$$reportNull$$$0(5);
            }
            return navigateOrPopupHelper;
        }

        @NotNull
        public NavigateOrPopupHelper setProject(@Nullable Project project2) {
            this.myProject = project2;
            NavigateOrPopupHelper navigateOrPopupHelper = this;
            if (navigateOrPopupHelper == null) {
                NavigateOrPopupHelper.$$$reportNull$$$0(6);
            }
            return navigateOrPopupHelper;
        }

        @Nullable
        public final JBPopup navigateOrCreatePopup() {
            if (this.myTargets.length == 0) {
                if (!this.allowEmptyTargets()) {
                    return null;
                }
                if (this.myListUpdaterTask == null || this.myListUpdaterTask.isFinished()) {
                    return null;
                }
            }
            if (this.myTargets.length == 1 && (this.myListUpdaterTask == null || this.myListUpdaterTask.isFinished())) {
                this.myTargetsConsumer.consume(this.myTargets);
                return null;
            }
            List<NavigatablePsiElement> initialTargetsList = Arrays.asList(this.myTargets);
            final Ref<NavigatablePsiElement[]> updatedTargetsList = Ref.create(this.myTargets);
            IPopupChooserBuilder<NavigatablePsiElement> builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(initialTargetsList);
            this.afterPopupBuilderCreated(builder2);
            if (this.myListRenderer instanceof PsiElementListCellRenderer) {
                ((PsiElementListCellRenderer)this.myListRenderer).installSpeedSearch(builder2);
            }
            IPopupChooserBuilder<NavigatablePsiElement> popupChooserBuilder = builder2.setTitle(this.myTitle).setMovable(true).setFont(EditorUtil.getEditorFont()).setRenderer(this.myListRenderer).withHintUpdateSupply().setResizable(true).setItemsChosenCallback(selectedValues -> this.myTargetsConsumer.consume(ArrayUtil.toObjectArray(selectedValues))).setCancelCallback(() -> {
                if (this.myListUpdaterTask != null) {
                    this.myListUpdaterTask.cancelTask();
                }
                return true;
            });
            Ref usageView = new Ref();
            if (this.myFindUsagesTitle != null) {
                popupChooserBuilder = popupChooserBuilder.setCouldPin(popup2 -> {
                    usageView.set(FindUtil.showInUsageView(null, (PsiElement[])updatedTargetsList.get(), this.myFindUsagesTitle, this.getProject()));
                    popup2.cancel();
                    return false;
                });
            }
            JBPopup popup3 = popupChooserBuilder.createPopup();
            if (builder2 instanceof PopupChooserBuilder) {
                final JBList list2 = (JBList)((PopupChooserBuilder)builder2).getChooserComponent();
                list2.setTransferHandler(new TransferHandler(){

                    @Override
                    protected Transferable createTransferable(JComponent c) {
                        Object[] selectedValues = list2.getSelectedValues();
                        PsiElement[] copy2 = new PsiElement[selectedValues.length];
                        for (int i = 0; i < selectedValues.length; ++i) {
                            copy2[i] = (PsiElement)selectedValues[i];
                        }
                        return new PsiCopyPasteManager.MyTransferable(copy2);
                    }

                    @Override
                    public int getSourceActions(JComponent c) {
                        return 1;
                    }
                });
                JScrollPane pane2 = ((PopupChooserBuilder)builder2).getScrollPane();
                pane2.setBorder(null);
                pane2.setViewportBorder(null);
            }
            if (this.myListUpdaterTask != null) {
                final ListComponentUpdater popupUpdater = builder2.getBackgroundUpdater();
                this.myListUpdaterTask.init(popup3, new ListComponentUpdater(){

                    @Override
                    public void replaceModel(@NotNull List<? extends PsiElement> data2) {
                        if (data2 == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        updatedTargetsList.set(data2.toArray(NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY));
                        popupUpdater.replaceModel(data2);
                    }

                    @Override
                    public void paintBusy(boolean paintBusy) {
                        popupUpdater.paintBusy(paintBusy);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/codeInsight/daemon/impl/PsiElementListNavigator$NavigateOrPopupHelper$2", "replaceModel"));
                    }
                }, usageView);
            }
            return popup3;
        }

        @NotNull
        private Project getProject() {
            if (this.myProject != null) {
                Project project2 = this.myProject;
                if (project2 == null) {
                    NavigateOrPopupHelper.$$$reportNull$$$0(7);
                }
                return project2;
            }
            assert (!this.allowEmptyTargets()) : "Project was not set and cannot be taken from targets";
            Project project3 = this.myTargets[0].getProject();
            if (project3 == null) {
                NavigateOrPopupHelper.$$$reportNull$$$0(8);
            }
            return project3;
        }

        protected boolean allowEmptyTargets() {
            return false;
        }

        protected void afterPopupBuilderCreated(@NotNull IPopupChooserBuilder<NavigatablePsiElement> builder2) {
            if (builder2 == null) {
                NavigateOrPopupHelper.$$$reportNull$$$0(9);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targets";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/PsiElementListNavigator$NavigateOrPopupHelper";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetsConsumer";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/PsiElementListNavigator$NavigateOrPopupHelper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setFindUsagesTitle";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setListRenderer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setListUpdaterTask";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setTargetsConsumer";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setProject";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setTargetsConsumer";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "afterPopupBuilderCreated";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

