/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import gnu.trove.TIntFunction;
import gnu.trove.TObjectIntHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeverityRegistrar
implements Comparator<HighlightSeverity>,
ModificationTracker {
    static final int SHOWN_SEVERITIES_OFFSET = 1;
    private static final Logger LOG = Logger.getInstance(SeverityRegistrar.class);
    @NonNls
    private static final String INFO_TAG = "info";
    @NonNls
    private static final String COLOR_ATTRIBUTE = "color";
    private final Map<String, SeverityBasedTextAttributes> myMap;
    private final Map<String, Color> myRendererColors;
    static final Topic<Runnable> SEVERITIES_CHANGED_TOPIC = Topic.create("SEVERITIES_CHANGED_TOPIC", Runnable.class, Topic.BroadcastDirection.TO_PARENT);
    private static final Topic<Runnable> STANDARD_SEVERITIES_CHANGED_TOPIC = Topic.create("STANDARD_SEVERITIES_CHANGED_TOPIC", Runnable.class, Topic.BroadcastDirection.TO_CHILDREN);
    @NotNull
    private final MessageBus myMessageBus;
    private volatile OrderMap myOrderMap;
    private JDOMExternalizableStringList myReadOrder;
    private static final Map<String, HighlightInfoType> STANDARD_SEVERITIES = ContainerUtil.newConcurrentMap();
    private final SimpleModificationTracker myModificationTracker;
    private static final AtomicFieldUpdater<SeverityRegistrar, OrderMap> ORDER_MAP_UPDATER;

    public SeverityRegistrar(@NotNull MessageBus messageBus) {
        if (messageBus == null) {
            SeverityRegistrar.$$$reportNull$$$0(0);
        }
        this.myMap = ContainerUtil.newConcurrentMap();
        this.myRendererColors = ContainerUtil.newConcurrentMap();
        this.myModificationTracker = new SimpleModificationTracker();
        this.myMessageBus = messageBus;
        messageBus.connect().subscribe(STANDARD_SEVERITIES_CHANGED_TOPIC, () -> {
            this.myOrderMap = null;
        });
    }

    public static void registerStandard(@NotNull HighlightInfoType highlightInfoType, @NotNull HighlightSeverity highlightSeverity) {
        if (highlightInfoType == null) {
            SeverityRegistrar.$$$reportNull$$$0(1);
        }
        if (highlightSeverity == null) {
            SeverityRegistrar.$$$reportNull$$$0(2);
        }
        STANDARD_SEVERITIES.put(highlightSeverity.getName(), highlightInfoType);
        ApplicationManager.getApplication().getMessageBus().syncPublisher(STANDARD_SEVERITIES_CHANGED_TOPIC).run();
    }

    @NotNull
    public static SeverityRegistrar getSeverityRegistrar(@Nullable Project project2) {
        SeverityRegistrar severityRegistrar = project2 == null ? InspectionProfileManager.getInstance().getSeverityRegistrar() : InspectionProfileManager.getInstance(project2).getCurrentProfile().getProfileManager().getSeverityRegistrar();
        if (severityRegistrar == null) {
            SeverityRegistrar.$$$reportNull$$$0(3);
        }
        return severityRegistrar;
    }

    @Override
    public long getModificationCount() {
        return this.myModificationTracker.getModificationCount();
    }

    public void registerSeverity(@NotNull SeverityBasedTextAttributes info, Color renderColor) {
        if (info == null) {
            SeverityRegistrar.$$$reportNull$$$0(4);
        }
        HighlightSeverity severity = info.getType().getSeverity(null);
        this.myMap.put(severity.getName(), info);
        if (renderColor != null) {
            this.myRendererColors.put(severity.getName(), renderColor);
        }
        this.myOrderMap = null;
        HighlightDisplayLevel.registerSeverity(severity, this.getHighlightInfoTypeBySeverity(severity).getAttributesKey(), null);
        this.severitiesChanged();
    }

    private void severitiesChanged() {
        this.myModificationTracker.incModificationCount();
        this.myMessageBus.syncPublisher(SEVERITIES_CHANGED_TOPIC).run();
    }

    public SeverityBasedTextAttributes unregisterSeverity(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            SeverityRegistrar.$$$reportNull$$$0(5);
        }
        this.severitiesChanged();
        return this.myMap.remove(severity.getName());
    }

    @NotNull
    public HighlightInfoType.HighlightInfoTypeImpl getHighlightInfoTypeBySeverity(@NotNull HighlightSeverity severity) {
        HighlightInfoType infoType;
        if (severity == null) {
            SeverityRegistrar.$$$reportNull$$$0(6);
        }
        if ((infoType = STANDARD_SEVERITIES.get(severity.getName())) != null) {
            HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = (HighlightInfoType.HighlightInfoTypeImpl)infoType;
            if (highlightInfoTypeImpl == null) {
                SeverityRegistrar.$$$reportNull$$$0(7);
            }
            return highlightInfoTypeImpl;
        }
        if (severity == HighlightSeverity.INFORMATION) {
            HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = (HighlightInfoType.HighlightInfoTypeImpl)HighlightInfoType.INFORMATION;
            if (highlightInfoTypeImpl == null) {
                SeverityRegistrar.$$$reportNull$$$0(8);
            }
            return highlightInfoTypeImpl;
        }
        SeverityBasedTextAttributes type = this.getAttributesBySeverity(severity);
        HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = (HighlightInfoType.HighlightInfoTypeImpl)(type == null ? HighlightInfoType.WARNING : type.getType());
        if (highlightInfoTypeImpl == null) {
            SeverityRegistrar.$$$reportNull$$$0(9);
        }
        return highlightInfoTypeImpl;
    }

    private SeverityBasedTextAttributes getAttributesBySeverity(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            SeverityRegistrar.$$$reportNull$$$0(10);
        }
        return this.myMap.get(severity.getName());
    }

    @Nullable
    public TextAttributes getTextAttributesBySeverity(@NotNull HighlightSeverity severity) {
        SeverityBasedTextAttributes infoType;
        if (severity == null) {
            SeverityRegistrar.$$$reportNull$$$0(11);
        }
        if ((infoType = this.getAttributesBySeverity(severity)) != null) {
            return infoType.getAttributes();
        }
        return null;
    }

    public void readExternal(@NotNull Element element2) {
        if (element2 == null) {
            SeverityRegistrar.$$$reportNull$$$0(12);
        }
        this.myMap.clear();
        this.myRendererColors.clear();
        for (Element infoElement : element2.getChildren(INFO_TAG)) {
            SeverityBasedTextAttributes highlightInfo = new SeverityBasedTextAttributes(infoElement);
            String colorStr = infoElement.getAttributeValue(COLOR_ATTRIBUTE);
            Color color = colorStr == null ? null : new Color(Integer.parseInt(colorStr, 16));
            this.registerSeverity(highlightInfo, color);
        }
        this.myReadOrder = new JDOMExternalizableStringList();
        this.myReadOrder.readExternal(element2);
        ArrayList<HighlightSeverity> read2 = new ArrayList<HighlightSeverity>(this.myReadOrder.size());
        List<HighlightSeverity> knownSeverities = this.getDefaultOrder();
        for (String name : this.myReadOrder) {
            HighlightSeverity severity = this.getSeverity(name);
            if (severity == null || !knownSeverities.contains(severity)) continue;
            read2.add(severity);
        }
        this.myOrderMap = this.ensureAllStandardIncluded(read2, knownSeverities);
        this.severitiesChanged();
    }

    private OrderMap ensureAllStandardIncluded(List<? extends HighlightSeverity> read2, List<? extends HighlightSeverity> knownSeverities) {
        OrderMap orderMap = SeverityRegistrar.fromList(read2);
        if (orderMap.isEmpty()) {
            orderMap = SeverityRegistrar.fromList(knownSeverities);
        } else {
            List<HighlightSeverity> list2 = SeverityRegistrar.getSortedSeverities(orderMap);
            block0: for (HighlightSeverity highlightSeverity : knownSeverities) {
                if (list2.contains(highlightSeverity)) continue;
                for (int oIdx = 0; oIdx < list2.size(); ++oIdx) {
                    HighlightSeverity orderSeverity = list2.get(oIdx);
                    if (orderSeverity.myVal <= highlightSeverity.myVal) continue;
                    list2.add(oIdx, highlightSeverity);
                    this.myReadOrder = null;
                    continue block0;
                }
            }
            orderMap = SeverityRegistrar.fromList(list2);
        }
        return orderMap;
    }

    public void writeExternal(Element element2) {
        List<HighlightSeverity> list2 = this.getAllSeverities();
        for (HighlightSeverity severity : list2) {
            Element info = new Element(INFO_TAG);
            String severityName = severity.getName();
            SeverityBasedTextAttributes infoType = this.getAttributesBySeverity(severity);
            if (infoType == null) continue;
            infoType.writeExternal(info);
            Color color = this.myRendererColors.get(severityName);
            if (color != null) {
                info.setAttribute(COLOR_ATTRIBUTE, Integer.toString(color.getRGB() & 0xFFFFFF, 16));
            }
            element2.addContent(info);
        }
        if (this.myReadOrder != null && !this.myReadOrder.isEmpty()) {
            this.myReadOrder.writeExternal(element2);
        } else if (!this.getDefaultOrder().equals(list2)) {
            JDOMExternalizableStringList ext = new JDOMExternalizableStringList((Collection<String>)Collections.nCopies(this.getOrderMap().size(), ""));
            this.getOrderMap().forEachEntry((orderSeverity, oIdx) -> {
                ext.set(oIdx, orderSeverity.getName());
                return true;
            });
            ext.writeExternal(element2);
        }
    }

    @NotNull
    public List<HighlightSeverity> getAllSeverities() {
        return SeverityRegistrar.getSortedSeverities(this.getOrderMap());
    }

    @NotNull
    private static List<HighlightSeverity> getSortedSeverities(OrderMap map2) {
        List<HighlightSeverity> list2 = Arrays.stream(map2.keys()).map(o -> (HighlightSeverity)o).sorted((o1, o2) -> SeverityRegistrar.compare(o1, o2, map2)).collect(Collectors.toList());
        if (list2 == null) {
            SeverityRegistrar.$$$reportNull$$$0(13);
        }
        return list2;
    }

    int getSeveritiesCount() {
        return STANDARD_SEVERITIES.size() + this.myMap.size();
    }

    public HighlightSeverity getSeverityByIndex(int i) {
        HighlightSeverity[] found2 = new HighlightSeverity[1];
        this.getOrderMap().forEachEntry((severity, order) -> {
            if (order == i) {
                found2[0] = severity;
                return false;
            }
            return true;
        });
        return found2[0];
    }

    int getSeverityMaxIndex() {
        return ArrayUtil.max(this.getOrderMap().getValues());
    }

    @Nullable
    public HighlightSeverity getSeverity(@NotNull String name) {
        HighlightInfoType type;
        if (name == null) {
            SeverityRegistrar.$$$reportNull$$$0(14);
        }
        if ((type = STANDARD_SEVERITIES.get(name)) != null) {
            return type.getSeverity(null);
        }
        SeverityBasedTextAttributes attributes = this.myMap.get(name);
        if (attributes != null) {
            return attributes.getSeverity();
        }
        return null;
    }

    Icon getRendererIconByIndex(int i) {
        HighlightSeverity severity = this.getSeverityByIndex(i);
        HighlightDisplayLevel level = HighlightDisplayLevel.find(severity);
        if (level != null) {
            return level.getIcon();
        }
        return HighlightDisplayLevel.createIconByMask(this.myRendererColors.get(severity.getName()));
    }

    public boolean isSeverityValid(@NotNull String severityName) {
        if (severityName == null) {
            SeverityRegistrar.$$$reportNull$$$0(15);
        }
        return STANDARD_SEVERITIES.containsKey(severityName) || this.myMap.containsKey(severityName);
    }

    @Override
    public int compare(@NotNull HighlightSeverity s1, @NotNull HighlightSeverity s2) {
        if (s1 == null) {
            SeverityRegistrar.$$$reportNull$$$0(16);
        }
        if (s2 == null) {
            SeverityRegistrar.$$$reportNull$$$0(17);
        }
        return SeverityRegistrar.compare(s1, s2, this.getOrderMap());
    }

    private static int compare(@NotNull HighlightSeverity s1, @NotNull HighlightSeverity s2, @NotNull OrderMap orderMap) {
        if (s1 == null) {
            SeverityRegistrar.$$$reportNull$$$0(18);
        }
        if (s2 == null) {
            SeverityRegistrar.$$$reportNull$$$0(19);
        }
        if (orderMap == null) {
            SeverityRegistrar.$$$reportNull$$$0(20);
        }
        int o1 = orderMap.getOrder(s1);
        int o2 = orderMap.getOrder(s2);
        return o1 - o2;
    }

    @NotNull
    private OrderMap getOrderMap() {
        OrderMap orderMap;
        OrderMap defaultOrder = null;
        while ((orderMap = this.myOrderMap) == null) {
            boolean replaced;
            if (defaultOrder == null) {
                defaultOrder = SeverityRegistrar.fromList(this.getDefaultOrder());
            }
            if (!(replaced = ORDER_MAP_UPDATER.compareAndSet(this, null, defaultOrder))) continue;
            orderMap = defaultOrder;
            break;
        }
        OrderMap orderMap2 = orderMap;
        if (orderMap2 == null) {
            SeverityRegistrar.$$$reportNull$$$0(21);
        }
        return orderMap2;
    }

    @NotNull
    private static OrderMap fromList(@NotNull List<? extends HighlightSeverity> orderList) {
        if (orderList == null) {
            SeverityRegistrar.$$$reportNull$$$0(22);
        }
        if (orderList.size() != new HashSet<HighlightSeverity>(orderList).size()) {
            LOG.error("Severities order list MUST contain only unique severities: " + orderList);
        }
        TObjectIntHashMap<HighlightSeverity> map2 = new TObjectIntHashMap<HighlightSeverity>();
        for (int i = 0; i < orderList.size(); ++i) {
            HighlightSeverity severity = orderList.get(i);
            map2.put(severity, i);
        }
        return new OrderMap(map2);
    }

    @NotNull
    private List<HighlightSeverity> getDefaultOrder() {
        Collection<SeverityBasedTextAttributes> values2 = this.myMap.values();
        ArrayList<HighlightSeverity> order = new ArrayList<HighlightSeverity>(STANDARD_SEVERITIES.size() + values2.size());
        for (HighlightInfoType type : STANDARD_SEVERITIES.values()) {
            order.add(type.getSeverity(null));
        }
        for (SeverityBasedTextAttributes attributes : values2) {
            order.add(attributes.getSeverity());
        }
        ContainerUtil.sort(order);
        ArrayList<HighlightSeverity> arrayList = order;
        if (arrayList == null) {
            SeverityRegistrar.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    public void setOrder(@NotNull List<? extends HighlightSeverity> orderList) {
        if (orderList == null) {
            SeverityRegistrar.$$$reportNull$$$0(24);
        }
        this.myOrderMap = this.ensureAllStandardIncluded(orderList, this.getDefaultOrder());
        this.myReadOrder = null;
        this.severitiesChanged();
    }

    int getSeverityIdx(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            SeverityRegistrar.$$$reportNull$$$0(25);
        }
        return this.getOrderMap().getOrder(severity);
    }

    public static boolean isDefaultSeverity(@NotNull HighlightSeverity severity) {
        if (severity == null) {
            SeverityRegistrar.$$$reportNull$$$0(26);
        }
        return STANDARD_SEVERITIES.containsKey(severity.myName);
    }

    static boolean isGotoBySeverityEnabled(@NotNull HighlightSeverity minSeverity) {
        if (minSeverity == null) {
            SeverityRegistrar.$$$reportNull$$$0(27);
        }
        for (SeveritiesProvider provider : SeveritiesProvider.EP_NAME.getExtensionList()) {
            if (!provider.isGotoBySeverityEnabled(minSeverity)) continue;
            return true;
        }
        return minSeverity != HighlightSeverity.INFORMATION;
    }

    @NotNull
    Collection<SeverityBasedTextAttributes> allRegisteredAttributes() {
        Collection<SeverityBasedTextAttributes> collection = Collections.unmodifiableCollection(this.myMap.values());
        if (collection == null) {
            SeverityRegistrar.$$$reportNull$$$0(28);
        }
        return collection;
    }

    @NotNull
    Collection<HighlightInfoType> standardSeverities() {
        Collection<HighlightInfoType> collection = STANDARD_SEVERITIES.values();
        if (collection == null) {
            SeverityRegistrar.$$$reportNull$$$0(29);
        }
        return collection;
    }

    static {
        SeverityRegistrar.registerStandard(HighlightInfoType.ERROR, HighlightSeverity.ERROR);
        SeverityRegistrar.registerStandard(HighlightInfoType.WARNING, HighlightSeverity.WARNING);
        SeverityRegistrar.registerStandard(HighlightInfoType.INFO, HighlightSeverity.INFO);
        SeverityRegistrar.registerStandard(HighlightInfoType.WEAK_WARNING, HighlightSeverity.WEAK_WARNING);
        SeverityRegistrar.registerStandard(HighlightInfoType.GENERIC_WARNINGS_OR_ERRORS_FROM_SERVER, HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING);
        STANDARD_SEVERITIES.put(HighlightDisplayLevel.DO_NOT_SHOW.getName(), HighlightInfoType.INFORMATION);
        ORDER_MAP_UPDATER = AtomicFieldUpdater.forFieldOfType(SeverityRegistrar.class, OrderMap.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 21: 
            case 23: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 21: 
            case 23: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageBus";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightSeverity";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 21: 
            case 23: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/SeverityRegistrar";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = INFO_TAG;
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityName";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderMap";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderList";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minSeverity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/SeverityRegistrar";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverityRegistrar";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightInfoTypeBySeverity";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedSeverities";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderMap";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultOrder";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "allRegisteredAttributes";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "standardSeverities";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerStandard";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 21: 
            case 23: 
            case 28: 
            case 29: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerSeverity";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unregisterSeverity";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightInfoTypeBySeverity";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAttributesBySeverity";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTextAttributesBySeverity";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSeverity";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isSeverityValid";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "fromList";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setOrder";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSeverityIdx";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultSeverity";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isGotoBySeverityEnabled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 21: 
            case 23: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SeverityBasedTextAttributes {
        private final TextAttributes myAttributes;
        private final HighlightInfoType.HighlightInfoTypeImpl myType;

        SeverityBasedTextAttributes(@NotNull Element element2) {
            if (element2 == null) {
                SeverityBasedTextAttributes.$$$reportNull$$$0(0);
            }
            this(new TextAttributes(element2), new HighlightInfoType.HighlightInfoTypeImpl(element2));
        }

        public SeverityBasedTextAttributes(@NotNull TextAttributes attributes, @NotNull HighlightInfoType.HighlightInfoTypeImpl type) {
            if (attributes == null) {
                SeverityBasedTextAttributes.$$$reportNull$$$0(1);
            }
            if (type == null) {
                SeverityBasedTextAttributes.$$$reportNull$$$0(2);
            }
            this.myAttributes = attributes;
            this.myType = type;
        }

        @NotNull
        public TextAttributes getAttributes() {
            TextAttributes textAttributes = this.myAttributes;
            if (textAttributes == null) {
                SeverityBasedTextAttributes.$$$reportNull$$$0(3);
            }
            return textAttributes;
        }

        @NotNull
        public HighlightInfoType.HighlightInfoTypeImpl getType() {
            HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = this.myType;
            if (highlightInfoTypeImpl == null) {
                SeverityBasedTextAttributes.$$$reportNull$$$0(4);
            }
            return highlightInfoTypeImpl;
        }

        private void writeExternal(@NotNull Element element2) {
            if (element2 == null) {
                SeverityBasedTextAttributes.$$$reportNull$$$0(5);
            }
            this.myAttributes.writeExternal(element2);
            this.myType.writeExternal(element2);
        }

        @NotNull
        public HighlightSeverity getSeverity() {
            HighlightSeverity highlightSeverity = this.myType.getSeverity(null);
            if (highlightSeverity == null) {
                SeverityBasedTextAttributes.$$$reportNull$$$0(6);
            }
            return highlightSeverity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SeverityBasedTextAttributes that = (SeverityBasedTextAttributes)o;
            if (!this.myAttributes.equals(that.myAttributes)) {
                return false;
            }
            return this.myType.equals(that.myType);
        }

        public int hashCode() {
            int result2 = this.myAttributes.hashCode();
            result2 = 31 * result2 + this.myType.hashCode();
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/SeverityRegistrar$SeverityBasedTextAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/SeverityRegistrar$SeverityBasedTextAttributes";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributes";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSeverity";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "writeExternal";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class OrderMap
    extends TObjectIntHashMap<HighlightSeverity> {
        private OrderMap(@NotNull TObjectIntHashMap<? extends HighlightSeverity> map2) {
            if (map2 == null) {
                OrderMap.$$$reportNull$$$0(0);
            }
            super(map2.size());
            map2.forEachEntry((key, value2) -> {
                super.put(key, value2);
                return true;
            });
            this.trimToSize();
        }

        private int getOrder(@NotNull HighlightSeverity severity) {
            int index;
            if (severity == null) {
                OrderMap.$$$reportNull$$$0(1);
            }
            return (index = this.index(severity)) < 0 ? -1 : this._values[index];
        }

        @Override
        public void clear() {
            throw new IncorrectOperationException("readonly");
        }

        @Override
        protected void removeAt(int index) {
            throw new IncorrectOperationException("readonly");
        }

        @Override
        public void transformValues(TIntFunction function) {
            throw new IncorrectOperationException("readonly");
        }

        @Override
        public boolean adjustValue(HighlightSeverity key, int amount) {
            throw new IncorrectOperationException("readonly");
        }

        @Override
        public int put(HighlightSeverity key, int value2) {
            throw new IncorrectOperationException("readonly");
        }

        @Override
        public int remove(HighlightSeverity key) {
            throw new IncorrectOperationException("readonly");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "map";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "severity";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/SeverityRegistrar$OrderMap";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getOrder";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

