/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.MainHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorHighlightingPassRegistrarImpl
extends TextEditorHighlightingPassRegistrarEx
implements Disposable {
    public static final ExtensionPointName<TextEditorHighlightingPassFactoryRegistrar> EP_NAME = new ExtensionPointName("com.intellij.highlightingPassFactory");
    private final TIntObjectHashMap<PassConfig> myRegisteredPassFactories;
    private final List<DirtyScopeTrackingHighlightingPassFactory> myDirtyScopeTrackingFactories;
    private final AtomicInteger nextAvailableId;
    private boolean checkedForCycles;
    private final Project myProject;
    private boolean runInspectionsAfterCompletionOfGeneralHighlightPass;

    public TextEditorHighlightingPassRegistrarImpl(final @NotNull Project project2) {
        if (project2 == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(0);
        }
        this.myRegisteredPassFactories = new TIntObjectHashMap();
        this.myDirtyScopeTrackingFactories = new ArrayList<DirtyScopeTrackingHighlightingPassFactory>();
        this.nextAvailableId = new AtomicInteger();
        this.myProject = project2;
        this.reregisterFactories();
        EP_NAME.addExtensionPointListener(new ExtensionPointListener<TextEditorHighlightingPassFactoryRegistrar>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void extensionAdded(@NotNull TextEditorHighlightingPassFactoryRegistrar factoryRegistrar, @NotNull PluginDescriptor pluginDescriptor) {
                if (factoryRegistrar == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                TextEditorHighlightingPassRegistrarImpl textEditorHighlightingPassRegistrarImpl = TextEditorHighlightingPassRegistrarImpl.this;
                synchronized (textEditorHighlightingPassRegistrarImpl) {
                    TextEditorHighlightingPassRegistrarImpl.this.checkedForCycles = false;
                }
                factoryRegistrar.registerHighlightingPassFactory(TextEditorHighlightingPassRegistrarImpl.this, project2);
            }

            @Override
            public void extensionRemoved(@NotNull TextEditorHighlightingPassFactoryRegistrar factoryRegistrar, @NotNull PluginDescriptor pluginDescriptor) {
                if (factoryRegistrar == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                TextEditorHighlightingPassRegistrarImpl.this.reregisterFactories();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "factoryRegistrar";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reregisterFactories() {
        TextEditorHighlightingPassRegistrarImpl textEditorHighlightingPassRegistrarImpl = this;
        synchronized (textEditorHighlightingPassRegistrarImpl) {
            this.checkedForCycles = false;
            this.myRegisteredPassFactories.clear();
            this.nextAvailableId.set(13);
            this.myDirtyScopeTrackingFactories.clear();
        }
        for (TextEditorHighlightingPassFactoryRegistrar factoryRegistrar : EP_NAME.getExtensionList()) {
            factoryRegistrar.registerHighlightingPassFactory(this, this.myProject);
        }
    }

    @Override
    public void dispose() {
    }

    @ApiStatus.Internal
    void runInspectionsAfterCompletionOfGeneralHighlightPass(boolean flag) {
        this.runInspectionsAfterCompletionOfGeneralHighlightPass = flag;
        this.reregisterFactories();
    }

    @ApiStatus.Internal
    boolean isRunInspectionsAfterCompletionOfGeneralHighlightPass() {
        return this.runInspectionsAfterCompletionOfGeneralHighlightPass;
    }

    @Override
    public synchronized int registerTextEditorHighlightingPass(@NotNull TextEditorHighlightingPassFactory factory, int @Nullable [] runAfterCompletionOf, int @Nullable [] runAfterOfStartingOf, boolean runIntentionsPassAfter, int forcedPassId) {
        if (factory == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(1);
        }
        assert (!this.checkedForCycles);
        PassConfig info = new PassConfig(factory, runAfterCompletionOf == null || runAfterCompletionOf.length == 0 ? ArrayUtilRt.EMPTY_INT_ARRAY : runAfterCompletionOf, runAfterOfStartingOf == null || runAfterOfStartingOf.length == 0 ? ArrayUtilRt.EMPTY_INT_ARRAY : runAfterOfStartingOf);
        int passId = forcedPassId == -1 ? this.nextAvailableId.incrementAndGet() : forcedPassId;
        PassConfig registered = this.myRegisteredPassFactories.get(passId);
        assert (registered == null) : "Pass id " + passId + " has already been registered in: " + PassConfig.access$300(registered);
        this.myRegisteredPassFactories.put(passId, info);
        if (factory instanceof DirtyScopeTrackingHighlightingPassFactory) {
            this.myDirtyScopeTrackingFactories.add((DirtyScopeTrackingHighlightingPassFactory)factory);
        }
        return passId;
    }

    @NotNull
    AtomicInteger getNextAvailableId() {
        AtomicInteger atomicInteger = this.nextAvailableId;
        if (atomicInteger == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(2);
        }
        return atomicInteger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<TextEditorHighlightingPass> instantiatePasses(@NotNull PsiFile psiFile, @NotNull Editor editor, int @NotNull [] passesToIgnore) {
        if (psiFile == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(4);
        }
        if (passesToIgnore == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(5);
        }
        TextEditorHighlightingPassRegistrarImpl textEditorHighlightingPassRegistrarImpl = this;
        synchronized (textEditorHighlightingPassRegistrarImpl) {
            if (!this.checkedForCycles) {
                this.checkedForCycles = true;
                this.checkForCycles();
            }
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(this.myProject);
        Document document = editor.getDocument();
        PsiFile fileFromDoc = documentManager.getPsiFile(document);
        if (!(fileFromDoc instanceof PsiCompiledElement)) {
            assert (fileFromDoc == psiFile) : "Files are different: " + psiFile + ";" + fileFromDoc;
            Document documentFromFile = documentManager.getDocument(psiFile);
            assert (documentFromFile == document) : "Documents are different. Doc: " + document + "; Doc from file: " + documentFromFile + "; File: " + psiFile + "; Virtual file: " + PsiUtilCore.getVirtualFile(psiFile);
        }
        TIntObjectHashMap id2Pass = new TIntObjectHashMap();
        TIntArrayList passesRefusedToCreate = new TIntArrayList();
        boolean isDumb = DumbService.getInstance(this.myProject).isDumb();
        this.myRegisteredPassFactories.forEachKey(passId -> {
            TextEditorHighlightingPass pass;
            if (ArrayUtil.find(passesToIgnore, passId) != -1) {
                return true;
            }
            PassConfig passConfig = this.myRegisteredPassFactories.get(passId);
            TextEditorHighlightingPassFactory factory = passConfig.passFactory;
            TextEditorHighlightingPass textEditorHighlightingPass = pass = isDumb && !DumbService.isDumbAware(factory) ? null : factory.createHighlightingPass(psiFile, editor);
            if (pass == null || isDumb && !DumbService.isDumbAware(pass)) {
                passesRefusedToCreate.add(passId);
            } else {
                pass.setColorsScheme(editor.getColorsScheme());
                TIntArrayList ids = new TIntArrayList(passConfig.completionPredecessorIds.length);
                for (int id2 : passConfig.completionPredecessorIds) {
                    if (!this.myRegisteredPassFactories.containsKey(id2)) continue;
                    ids.add(id2);
                }
                pass.setCompletionPredecessorIds(ids.isEmpty() ? ArrayUtilRt.EMPTY_INT_ARRAY : ids.toNativeArray());
                ids = new TIntArrayList(passConfig.startingPredecessorIds.length);
                for (int id2 : passConfig.startingPredecessorIds) {
                    if (!this.myRegisteredPassFactories.containsKey(id2)) continue;
                    ids.add(id2);
                }
                pass.setStartingPredecessorIds(ids.isEmpty() ? ArrayUtilRt.EMPTY_INT_ARRAY : ids.toNativeArray());
                pass.setId(passId);
                id2Pass.put(passId, pass);
            }
            return true;
        });
        DaemonCodeAnalyzerEx daemonCodeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(this.myProject);
        FileStatusMap statusMap = daemonCodeAnalyzer.getFileStatusMap();
        passesRefusedToCreate.forEach(passId -> {
            statusMap.markFileUpToDate(document, passId);
            return true;
        });
        List<Object> list2 = Arrays.asList(id2Pass.getValues());
        if (list2 == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<TextEditorHighlightingPass> instantiateMainPasses(@NotNull PsiFile psiFile, @NotNull Document document, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        if (psiFile == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(7);
        }
        if (document == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(8);
        }
        if (highlightInfoProcessor == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(9);
        }
        THashSet ids = new THashSet();
        this.myRegisteredPassFactories.forEachKey(passId -> {
            TextEditorHighlightingPass pass;
            PassConfig passConfig = this.myRegisteredPassFactories.get(passId);
            TextEditorHighlightingPassFactory factory = passConfig.passFactory;
            if (factory instanceof MainHighlightingPassFactory && (pass = ((MainHighlightingPassFactory)factory).createMainHighlightingPass(psiFile, document, highlightInfoProcessor)) != null) {
                ids.add(pass);
                pass.setId(passId);
            }
            return true;
        });
        return new ArrayList<TextEditorHighlightingPass>(ids);
    }

    private void checkForCycles() {
        TIntObjectHashMap transitivePredecessors = new TIntObjectHashMap();
        this.myRegisteredPassFactories.forEachEntry((passId, config2) -> {
            TIntHashSet allPredecessors = new TIntHashSet(((PassConfig)config2).completionPredecessorIds);
            allPredecessors.addAll(((PassConfig)config2).startingPredecessorIds);
            transitivePredecessors.put(passId, allPredecessors);
            allPredecessors.forEach(predecessorId -> {
                PassConfig predecessor = this.myRegisteredPassFactories.get(predecessorId);
                if (predecessor == null) {
                    return true;
                }
                TIntHashSet transitives = (TIntHashSet)transitivePredecessors.get(predecessorId);
                if (transitives == null) {
                    transitives = new TIntHashSet();
                    transitivePredecessors.put(predecessorId, transitives);
                }
                transitives.addAll(predecessor.completionPredecessorIds);
                transitives.addAll(predecessor.startingPredecessorIds);
                return true;
            });
            return true;
        });
        transitivePredecessors.forEachKey(passId -> {
            if (((TIntHashSet)transitivePredecessors.get(passId)).contains(passId)) {
                throw new IllegalArgumentException("There is a cycle introduced involving pass " + this.myRegisteredPassFactories.get(passId).passFactory);
            }
            return true;
        });
    }

    @Override
    @NotNull
    public List<DirtyScopeTrackingHighlightingPassFactory> getDirtyScopeTrackingFactories() {
        List<DirtyScopeTrackingHighlightingPassFactory> list2 = this.myDirtyScopeTrackingFactories;
        if (list2 == null) {
            TextEditorHighlightingPassRegistrarImpl.$$$reportNull$$$0(10);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "passesToIgnore";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextAvailableId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiatePasses";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirtyScopeTrackingFactories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerTextEditorHighlightingPass";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "instantiatePasses";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "instantiateMainPasses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PassConfig {
        private final TextEditorHighlightingPassFactory passFactory;
        private final int[] startingPredecessorIds;
        private final int[] completionPredecessorIds;

        private PassConfig(@NotNull TextEditorHighlightingPassFactory passFactory, int @NotNull [] completionPredecessorIds, int @NotNull [] startingPredecessorIds) {
            if (passFactory == null) {
                PassConfig.$$$reportNull$$$0(0);
            }
            if (completionPredecessorIds == null) {
                PassConfig.$$$reportNull$$$0(1);
            }
            if (startingPredecessorIds == null) {
                PassConfig.$$$reportNull$$$0(2);
            }
            this.completionPredecessorIds = completionPredecessorIds;
            this.startingPredecessorIds = startingPredecessorIds;
            this.passFactory = passFactory;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "passFactory";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "completionPredecessorIds";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "startingPredecessorIds";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/TextEditorHighlightingPassRegistrarImpl$PassConfig";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

