/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoPostFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightersRecycler;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.RedBlackTree;
import com.intellij.openapi.editor.impl.SweepProcessor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateHighlightersUtil {
    private static final ExtensionPointName<HighlightInfoPostFilter> EP_NAME = ExtensionPointName.create("com.intellij.highlightInfoPostFilter");
    private static final Comparator<HighlightInfo> BY_START_OFFSET_NODUPS = (o1, o2) -> {
        int d = o1.getActualStartOffset() - o2.getActualStartOffset();
        if (d != 0) {
            return d;
        }
        d = o1.getActualEndOffset() - o2.getActualEndOffset();
        if (d != 0) {
            return d;
        }
        d = Comparing.compare(o1.getSeverity(), o2.getSeverity());
        if (d != 0) {
            return -d;
        }
        if (!Comparing.equal(o1.type, o2.type)) {
            return String.valueOf(o1.type).compareTo(String.valueOf(o2.type));
        }
        if (!Comparing.equal(o1.getGutterIconRenderer(), o2.getGutterIconRenderer())) {
            return String.valueOf(o1.getGutterIconRenderer()).compareTo(String.valueOf(o2.getGutterIconRenderer()));
        }
        if (!Comparing.equal(o1.forcedTextAttributes, o2.forcedTextAttributes)) {
            return String.valueOf(o1.getGutterIconRenderer()).compareTo(String.valueOf(o2.getGutterIconRenderer()));
        }
        if (!Comparing.equal(o1.forcedTextAttributesKey, o2.forcedTextAttributesKey)) {
            return String.valueOf(o1.getGutterIconRenderer()).compareTo(String.valueOf(o2.getGutterIconRenderer()));
        }
        return Comparing.compare(o1.getDescription(), o2.getDescription());
    };
    private static final Key<Boolean> TYPING_INSIDE_HIGHLIGHTER_OCCURRED = Key.create("TYPING_INSIDE_HIGHLIGHTER_OCCURRED");

    private static boolean isCoveredByOffsets(HighlightInfo info, HighlightInfo coveredBy) {
        return coveredBy.startOffset <= info.startOffset && info.endOffset <= coveredBy.endOffset && info.getGutterIconRenderer() == null;
    }

    static void addHighlighterToEditorIncrementally(@NotNull Project project2, @NotNull Document document, @NotNull PsiFile file2, int startOffset, int endOffset, @NotNull HighlightInfo info, @Nullable EditorColorsScheme colorsScheme, int group, @NotNull Map<TextRange, RangeMarker> ranges2markersCache) {
        if (project2 == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(0);
        }
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(2);
        }
        if (info == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(3);
        }
        if (ranges2markersCache == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!UpdateHighlightersUtil.accept(project2, info)) {
            return;
        }
        if (UpdateHighlightersUtil.isFileLevelOrGutterAnnotation(info)) {
            return;
        }
        if (info.getStartOffset() < startOffset || info.getEndOffset() > endOffset) {
            return;
        }
        MarkupModel markup = DocumentMarkupModel.forDocument(document, project2, true);
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project2);
        boolean myInfoIsError = UpdateHighlightersUtil.isSevere(info, severityRegistrar);
        Processor<HighlightInfo> otherHighlightInTheWayProcessor = oldInfo -> {
            if (!myInfoIsError && UpdateHighlightersUtil.isCovered(info, severityRegistrar, oldInfo)) {
                return false;
            }
            return oldInfo.getGroup() != group || !oldInfo.equalsByActualOffset(info);
        };
        boolean allIsClear = DaemonCodeAnalyzerEx.processHighlights(document, project2, null, info.getActualStartOffset(), info.getActualEndOffset(), otherHighlightInTheWayProcessor);
        if (allIsClear) {
            UpdateHighlightersUtil.createOrReuseHighlighterFor(info, colorsScheme, document, group, file2, (MarkupModelEx)markup, null, ranges2markersCache, severityRegistrar);
            UpdateHighlightersUtil.clearWhiteSpaceOptimizationFlag(document);
            UpdateHighlightersUtil.assertMarkupConsistent(markup, project2);
        }
    }

    private static boolean accept(@NotNull Project project2, HighlightInfo info) {
        if (project2 == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(5);
        }
        for (HighlightInfoPostFilter filter2 : EP_NAME.getExtensions(project2)) {
            if (filter2.accept(info)) continue;
            return false;
        }
        return true;
    }

    public static boolean isFileLevelOrGutterAnnotation(HighlightInfo info) {
        return info.isFileLevelAnnotation() || info.getGutterIconRenderer() != null;
    }

    public static void setHighlightersToSingleEditor(@NotNull Project project2, @NotNull Editor editor, int startOffset, int endOffset, @NotNull Collection<? extends HighlightInfo> highlights, @Nullable EditorColorsScheme colorsScheme, int group) {
        if (project2 == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(7);
        }
        if (highlights == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(8);
        }
        Document document = editor.getDocument();
        MarkupModelEx markup = (MarkupModelEx)editor.getMarkupModel();
        UpdateHighlightersUtil.setHighlightersToEditor(project2, document, startOffset, endOffset, highlights, colorsScheme, group, markup);
    }

    public static void setHighlightersToEditor(@NotNull Project project2, @NotNull Document document, int startOffset, int endOffset, @NotNull Collection<? extends HighlightInfo> highlights, @Nullable EditorColorsScheme colorsScheme, int group) {
        if (project2 == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(9);
        }
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(10);
        }
        if (highlights == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(11);
        }
        MarkupModelEx markup = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project2, true);
        UpdateHighlightersUtil.setHighlightersToEditor(project2, document, startOffset, endOffset, highlights, colorsScheme, group, markup);
    }

    private static void setHighlightersToEditor(@NotNull Project project2, @NotNull Document document, int startOffset, int endOffset, @NotNull Collection<? extends HighlightInfo> highlights, @Nullable EditorColorsScheme colorsScheme, int group, @NotNull MarkupModelEx markup) {
        if (project2 == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(12);
        }
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(13);
        }
        if (highlights == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(14);
        }
        if (markup == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(15);
        }
        TextRange range2 = new TextRange(startOffset, endOffset);
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiFile psiFile = PsiDocumentManager.getInstance(project2).getPsiFile(document);
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(project2);
        codeAnalyzer.cleanFileLevelHighlights(project2, group, psiFile);
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project2);
        UpdateHighlightersUtil.setHighlightersInRange(project2, document, range2, colorsScheme, new ArrayList<HighlightInfo>(highlights), markup, group);
    }

    @NotNull
    private static List<HighlightInfo> applyPostFilter(@NotNull Project project2, @NotNull List<? extends HighlightInfo> highlightInfos) {
        if (project2 == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(16);
        }
        if (highlightInfos == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(17);
        }
        ArrayList<HighlightInfo> result2 = new ArrayList<HighlightInfo>(highlightInfos.size());
        for (HighlightInfo highlightInfo : highlightInfos) {
            if (!UpdateHighlightersUtil.accept(project2, highlightInfo)) continue;
            result2.add(highlightInfo);
        }
        ArrayList<HighlightInfo> arrayList = result2;
        if (arrayList == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    static void setHighlightersOutsideRange(@NotNull Project project2, @NotNull Document document, @NotNull PsiFile psiFile, @NotNull List<? extends HighlightInfo> infos, @Nullable EditorColorsScheme colorsScheme, int startOffset, int endOffset, @NotNull ProperTextRange priorityRange, int group) {
        if (project2 == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(19);
        }
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(20);
        }
        if (psiFile == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(21);
        }
        if (infos == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(22);
        }
        if (priorityRange == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(23);
        }
        List<HighlightInfo> filteredInfos = UpdateHighlightersUtil.applyPostFilter(project2, infos);
        ApplicationManager.getApplication().assertIsDispatchThread();
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(project2);
        if (startOffset == 0 && endOffset == document.getTextLength()) {
            codeAnalyzer.cleanFileLevelHighlights(project2, group, psiFile);
        }
        MarkupModel markup = DocumentMarkupModel.forDocument(document, project2, true);
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project2);
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project2);
        HighlightersRecycler infosToRemove = new HighlightersRecycler();
        ContainerUtil.quickSort(filteredInfos, BY_START_OFFSET_NODUPS);
        THashSet<HighlightInfo> infoSet = new THashSet<HighlightInfo>(filteredInfos);
        Processor<HighlightInfo> processor2 = info -> {
            if (info.getGroup() == group) {
                boolean toRemove2;
                RangeHighlighterEx highlighter = info.getHighlighter();
                int hiStart = highlighter.getStartOffset();
                int hiEnd = highlighter.getEndOffset();
                if (!info.isFromInjection() && hiEnd < document.getTextLength() && (hiEnd != 0 && hiEnd <= startOffset || hiStart >= endOffset)) {
                    return true;
                }
                boolean bl = toRemove2 = infoSet.contains(info) || !priorityRange.containsRange(hiStart, hiEnd) && (hiEnd != document.getTextLength() || priorityRange.getEndOffset() != document.getTextLength());
                if (toRemove2) {
                    infosToRemove.recycleHighlighter(highlighter);
                    info.setHighlighter(null);
                }
            }
            return true;
        };
        DaemonCodeAnalyzerEx.processHighlightsOverlappingOutside(document, project2, null, priorityRange.getStartOffset(), priorityRange.getEndOffset(), processor2);
        THashMap ranges2markersCache = new THashMap(10);
        boolean[] changed2 = new boolean[]{false};
        SweepProcessor.Generator generator = proc -> ContainerUtil.process(filteredInfos, proc);
        SweepProcessor.sweep(generator, (offset, info, atStart, overlappingIntervals) -> {
            if (!atStart) {
                return true;
            }
            if (!(info.isFromInjection() || info.getEndOffset() >= document.getTextLength() || info.getEndOffset() > startOffset && info.getStartOffset() < endOffset)) {
                return true;
            }
            if (info.isFileLevelAnnotation()) {
                codeAnalyzer.addFileLevelHighlight(project2, group, (HighlightInfo)info, psiFile);
                changed2[0] = true;
                return true;
            }
            if (UpdateHighlightersUtil.isWarningCoveredByError(info, overlappingIntervals, severityRegistrar)) {
                return true;
            }
            if (info.getStartOffset() < priorityRange.getStartOffset() || info.getEndOffset() > priorityRange.getEndOffset()) {
                UpdateHighlightersUtil.createOrReuseHighlighterFor(info, colorsScheme, document, group, psiFile, (MarkupModelEx)markup, infosToRemove, ranges2markersCache, severityRegistrar);
                changed2[0] = true;
            }
            return true;
        });
        for (RangeHighlighter rangeHighlighter : infosToRemove.forAllInGarbageBin()) {
            rangeHighlighter.dispose();
            changed2[0] = true;
        }
        if (changed2[0]) {
            UpdateHighlightersUtil.clearWhiteSpaceOptimizationFlag(document);
        }
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project2);
    }

    static void setHighlightersInRange(@NotNull Project project2, @NotNull Document document, @NotNull TextRange range2, @Nullable EditorColorsScheme colorsScheme, @NotNull List<? extends HighlightInfo> infos, @NotNull MarkupModelEx markup, int group) {
        if (project2 == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(24);
        }
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(25);
        }
        if (range2 == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(26);
        }
        if (infos == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(27);
        }
        if (markup == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(28);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project2);
        HighlightersRecycler infosToRemove = new HighlightersRecycler();
        DaemonCodeAnalyzerEx.processHighlights(markup, project2, null, range2.getStartOffset(), range2.getEndOffset(), info -> {
            if (info.getGroup() == group) {
                boolean willBeRemoved;
                RangeHighlighterEx highlighter = info.getHighlighter();
                int hiStart = highlighter.getStartOffset();
                int hiEnd = highlighter.getEndOffset();
                boolean bl = willBeRemoved = hiEnd == document.getTextLength() && range2.getEndOffset() == document.getTextLength() || range2.containsRange(hiStart, hiEnd);
                if (willBeRemoved) {
                    infosToRemove.recycleHighlighter(highlighter);
                    info.setHighlighter(null);
                }
            }
            return true;
        });
        List<HighlightInfo> filteredInfos = UpdateHighlightersUtil.applyPostFilter(project2, infos);
        ContainerUtil.quickSort(filteredInfos, BY_START_OFFSET_NODUPS);
        THashMap ranges2markersCache = new THashMap(10);
        PsiFile psiFile = PsiDocumentManager.getInstance(project2).getPsiFile(document);
        DaemonCodeAnalyzerEx codeAnalyzer = DaemonCodeAnalyzerEx.getInstanceEx(project2);
        boolean[] changed2 = new boolean[]{false};
        SweepProcessor.Generator generator = processor2 -> ContainerUtil.process(filteredInfos, processor2);
        SweepProcessor.sweep(generator, (offset, info, atStart, overlappingIntervals) -> {
            if (!atStart) {
                return true;
            }
            if (info.isFileLevelAnnotation() && psiFile != null) {
                codeAnalyzer.addFileLevelHighlight(project2, group, (HighlightInfo)info, psiFile);
                changed2[0] = true;
                return true;
            }
            if (UpdateHighlightersUtil.isWarningCoveredByError(info, overlappingIntervals, severityRegistrar)) {
                return true;
            }
            if (info.getStartOffset() >= range2.getStartOffset() && info.getEndOffset() <= range2.getEndOffset() && psiFile != null) {
                UpdateHighlightersUtil.createOrReuseHighlighterFor(info, colorsScheme, document, group, psiFile, markup, infosToRemove, ranges2markersCache, severityRegistrar);
                changed2[0] = true;
            }
            return true;
        });
        for (RangeHighlighter rangeHighlighter : infosToRemove.forAllInGarbageBin()) {
            rangeHighlighter.dispose();
            changed2[0] = true;
        }
        if (changed2[0]) {
            UpdateHighlightersUtil.clearWhiteSpaceOptimizationFlag(document);
        }
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project2);
    }

    private static boolean isWarningCoveredByError(@NotNull HighlightInfo info, @NotNull Collection<? extends HighlightInfo> overlappingIntervals, @NotNull SeverityRegistrar severityRegistrar) {
        if (info == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(29);
        }
        if (overlappingIntervals == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(30);
        }
        if (severityRegistrar == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(31);
        }
        if (!UpdateHighlightersUtil.isSevere(info, severityRegistrar)) {
            for (HighlightInfo highlightInfo : overlappingIntervals) {
                if (!UpdateHighlightersUtil.isCovered(info, severityRegistrar, highlightInfo)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isCovered(@NotNull HighlightInfo warning, @NotNull SeverityRegistrar severityRegistrar, @NotNull HighlightInfo candidate) {
        if (warning == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(32);
        }
        if (severityRegistrar == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(33);
        }
        if (candidate == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(34);
        }
        if (!UpdateHighlightersUtil.isCoveredByOffsets(warning, candidate)) {
            return false;
        }
        HighlightSeverity severity = candidate.getSeverity();
        if (severity == HighlightInfoType.SYMBOL_TYPE_SEVERITY) {
            return false;
        }
        return UpdateHighlightersUtil.isSevere(candidate, severityRegistrar);
    }

    private static boolean isSevere(@NotNull HighlightInfo info, @NotNull SeverityRegistrar severityRegistrar) {
        HighlightSeverity severity;
        if (info == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(35);
        }
        if (severityRegistrar == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(36);
        }
        return severityRegistrar.compare(HighlightSeverity.ERROR, severity = info.getSeverity()) <= 0 || severity == HighlightInfoType.SYMBOL_TYPE_SEVERITY;
    }

    private static void createOrReuseHighlighterFor(@NotNull HighlightInfo info, @Nullable EditorColorsScheme colorsScheme, @NotNull Document document, int group, @NotNull PsiFile psiFile, @NotNull MarkupModelEx markup, @Nullable HighlightersRecycler infosToRemove, @NotNull Map<TextRange, RangeMarker> ranges2markersCache, @NotNull SeverityRegistrar severityRegistrar) {
        if (info == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(37);
        }
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(38);
        }
        if (psiFile == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(39);
        }
        if (markup == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(40);
        }
        if (ranges2markersCache == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(41);
        }
        if (severityRegistrar == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(42);
        }
        int infoStartOffset = info.startOffset;
        int infoEndOffset = info.endOffset;
        int docLength = document.getTextLength();
        if (infoEndOffset > docLength) {
            infoEndOffset = docLength;
            infoStartOffset = Math.min(infoStartOffset, infoEndOffset);
        }
        if (infoEndOffset == infoStartOffset && !info.isAfterEndOfLine()) {
            if (infoEndOffset == docLength) {
                return;
            }
            ++infoEndOffset;
        }
        info.setGroup(group);
        int layer = UpdateHighlightersUtil.getLayer(info, severityRegistrar);
        RangeHighlighterEx highlighter = infosToRemove == null ? null : (RangeHighlighterEx)infosToRemove.pickupHighlighterFromGarbageBin(infoStartOffset, infoEndOffset, layer);
        TextRange finalInfoRange = new TextRange(infoStartOffset, infoEndOffset);
        TextAttributes infoAttributes = info.getTextAttributes(psiFile, colorsScheme);
        Consumer<RangeHighlighterEx> changeAttributes = finalHighlighter -> {
            ProperTextRange fixRange;
            if (infoAttributes != null) {
                finalHighlighter.setTextAttributes(infoAttributes);
            }
            info.setHighlighter((RangeHighlighterEx)finalHighlighter);
            finalHighlighter.setAfterEndOfLine(info.isAfterEndOfLine());
            Color color = info.getErrorStripeMarkColor(psiFile, colorsScheme);
            finalHighlighter.setErrorStripeMarkColor(color);
            if (info != finalHighlighter.getErrorStripeTooltip()) {
                finalHighlighter.setErrorStripeTooltip(info);
            }
            GutterMark renderer = info.getGutterIconRenderer();
            finalHighlighter.setGutterIconRenderer((GutterIconRenderer)renderer);
            ranges2markersCache.put(finalInfoRange, info.getHighlighter());
            if (info.quickFixActionRanges != null) {
                ArrayList list2 = new ArrayList(info.quickFixActionRanges.size());
                for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : info.quickFixActionRanges) {
                    TextRange textRange = (TextRange)pair.second;
                    RangeMarker marker = UpdateHighlightersUtil.getOrCreate(document, ranges2markersCache, textRange);
                    list2.add(Pair.create(pair.first, marker));
                }
                info.quickFixActionMarkers = ContainerUtil.createLockFreeCopyOnWriteList(list2);
            }
            info.fixMarker = finalInfoRange.equals(fixRange = info.getFixTextRange()) ? null : UpdateHighlightersUtil.getOrCreate(document, ranges2markersCache, fixRange);
        };
        if (highlighter == null) {
            highlighter = markup.addRangeHighlighterAndChangeAttributes(infoStartOffset, infoEndOffset, layer, null, HighlighterTargetArea.EXACT_RANGE, false, changeAttributes);
            if (HighlightInfoType.VISIBLE_IF_FOLDED.contains(info.type)) {
                highlighter.setVisibleIfFolded(true);
            }
        } else {
            markup.changeAttributesInBatch(highlighter, changeAttributes);
        }
        if (infoAttributes != null) {
            boolean attributesSet = Comparing.equal(infoAttributes, highlighter.getTextAttributes());
            assert (attributesSet) : "Info: " + infoAttributes + "; colorsScheme: " + (colorsScheme == null ? "[global]" : colorsScheme.getName()) + "; highlighter:" + highlighter.getTextAttributes();
        }
    }

    private static int getLayer(@NotNull HighlightInfo info, @NotNull SeverityRegistrar severityRegistrar) {
        HighlightSeverity severity;
        if (info == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(43);
        }
        if (severityRegistrar == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(44);
        }
        int layer = (severity = info.getSeverity()) == HighlightSeverity.WARNING ? 4000 : (severity == HighlightSeverity.WEAK_WARNING ? 3750 : (severityRegistrar.compare(severity, HighlightSeverity.ERROR) >= 0 ? 5000 : (severity == HighlightInfoType.INJECTED_FRAGMENT_SEVERITY ? 1999 : (severity == HighlightInfoType.INJECTED_FRAGMENT_SYNTAX_SEVERITY ? 1998 : (severity == HighlightInfoType.ELEMENT_UNDER_CARET_SEVERITY ? 5500 : 3000)))));
        return layer;
    }

    @NotNull
    private static RangeMarker getOrCreate(@NotNull Document document, @NotNull Map<TextRange, RangeMarker> ranges2markersCache, @NotNull TextRange textRange) {
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(45);
        }
        if (ranges2markersCache == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(46);
        }
        if (textRange == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(47);
        }
        RangeMarker rangeMarker = ranges2markersCache.computeIfAbsent(textRange, __ -> document.createRangeMarker(textRange));
        if (rangeMarker == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(48);
        }
        return rangeMarker;
    }

    static boolean isWhitespaceOptimizationAllowed(@NotNull Document document) {
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(49);
        }
        return document.getUserData(TYPING_INSIDE_HIGHLIGHTER_OCCURRED) == null;
    }

    private static void disableWhiteSpaceOptimization(@NotNull Document document) {
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(50);
        }
        document.putUserData(TYPING_INSIDE_HIGHLIGHTER_OCCURRED, Boolean.TRUE);
    }

    private static void clearWhiteSpaceOptimizationFlag(@NotNull Document document) {
        if (document == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(51);
        }
        document.putUserData(TYPING_INSIDE_HIGHLIGHTER_OCCURRED, null);
    }

    static void updateHighlightersByTyping(@NotNull Project project2, @NotNull DocumentEvent e) {
        if (project2 == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(52);
        }
        if (e == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(53);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Document document = e.getDocument();
        if (document.isInBulkUpdate()) {
            return;
        }
        MarkupModel markup = DocumentMarkupModel.forDocument(document, project2, true);
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project2);
        int start2 = e.getOffset() - 1;
        int end = start2 + e.getOldLength();
        ArrayList toRemove2 = new ArrayList();
        DaemonCodeAnalyzerEx.processHighlights(document, project2, null, start2, end, info -> {
            if (!info.needUpdateOnTyping()) {
                return true;
            }
            RangeHighlighterEx highlighter = info.getHighlighter();
            int highlighterStart = highlighter.getStartOffset();
            int highlighterEnd = highlighter.getEndOffset();
            if (info.isAfterEndOfLine()) {
                if (highlighterStart < document.getTextLength()) {
                    ++highlighterStart;
                }
                if (highlighterEnd < document.getTextLength()) {
                    ++highlighterEnd;
                }
            }
            if (!highlighter.isValid() || start2 < highlighterEnd && highlighterStart <= end) {
                toRemove2.add(info);
            }
            return true;
        });
        for (HighlightInfo info2 : toRemove2) {
            if (info2.getHighlighter().isValid() && !info2.type.equals(HighlightInfoType.WRONG_REF)) continue;
            info2.getHighlighter().dispose();
        }
        UpdateHighlightersUtil.assertMarkupConsistent(markup, project2);
        if (!toRemove2.isEmpty()) {
            UpdateHighlightersUtil.disableWhiteSpaceOptimization(document);
        }
    }

    private static void assertMarkupConsistent(@NotNull MarkupModel markup, @NotNull Project project2) {
        RangeHighlighter[] allHighlighters;
        if (markup == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(54);
        }
        if (project2 == null) {
            UpdateHighlightersUtil.$$$reportNull$$$0(55);
        }
        if (!RedBlackTree.VERIFY) {
            return;
        }
        Document document = markup.getDocument();
        DaemonCodeAnalyzerEx.processHighlights(document, project2, null, 0, document.getTextLength(), info -> {
            assert (((MarkupModelEx)markup).containsHighlighter(info.getHighlighter()));
            return true;
        });
        for (RangeHighlighter highlighter : allHighlighters = markup.getAllHighlighters()) {
            boolean contains;
            HighlightInfo info2;
            if (!highlighter.isValid() || (info2 = HighlightInfo.fromRangeHighlighter(highlighter)) == null) continue;
            boolean bl = contains = !DaemonCodeAnalyzerEx.processHighlights(document, project2, null, info2.getActualStartOffset(), info2.getActualEndOffset(), highlightInfo -> BY_START_OFFSET_NODUPS.compare((HighlightInfo)highlightInfo, info2) != 0);
            assert (contains) : info2;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: 
            case 13: 
            case 20: 
            case 25: 
            case 38: 
            case 45: 
            case 49: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 29: 
            case 35: 
            case 37: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: 
            case 41: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges2markersCache";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlights";
                break;
            }
            case 15: 
            case 28: 
            case 40: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markup";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfos";
                break;
            }
            case 18: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil";
                break;
            }
            case 21: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overlappingIntervals";
                break;
            }
            case 31: 
            case 33: 
            case 36: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityRegistrar";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warning";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/UpdateHighlightersUtil";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "applyPostFilter";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addHighlighterToEditorIncrementally";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightersToSingleEditor";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightersToEditor";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "applyPostFilter";
                break;
            }
            case 18: 
            case 48: {
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightersOutsideRange";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightersInRange";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isWarningCoveredByError";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isCovered";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isSevere";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "createOrReuseHighlighterFor";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getLayer";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isWhitespaceOptimizationAllowed";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "disableWhiteSpaceOptimization";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "clearWhiteSpaceOptimizationFlag";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "updateHighlightersByTyping";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "assertMarkupConsistent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

