/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

abstract class GotoElementUnderCaretUsageBase
extends BaseCodeInsightAction
implements CodeInsightActionHandler {
    @NotNull
    private final Direction myDirection;

    GotoElementUnderCaretUsageBase(@NotNull Direction direction) {
        if (direction == null) {
            GotoElementUnderCaretUsageBase.$$$reportNull$$$0(0);
        }
        this.myDirection = direction;
    }

    @Override
    @NotNull
    protected CodeInsightActionHandler getHandler() {
        GotoElementUnderCaretUsageBase gotoElementUnderCaretUsageBase = this;
        if (gotoElementUnderCaretUsageBase == null) {
            GotoElementUnderCaretUsageBase.$$$reportNull$$$0(1);
        }
        return gotoElementUnderCaretUsageBase;
    }

    @Override
    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            GotoElementUnderCaretUsageBase.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            GotoElementUnderCaretUsageBase.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            GotoElementUnderCaretUsageBase.$$$reportNull$$$0(4);
        }
        Comparator<Integer> ordering = this.myDirection.ordering;
        int caretOffset = editor.getCaretModel().getOffset();
        int startOffset = file2.getTextRange().getStartOffset();
        int endOffset = file2.getTextRange().getEndOffset();
        Ref first = new Ref();
        Ref next = new Ref();
        DaemonCodeAnalyzerEx.processHighlights((MarkupModelEx)editor.getMarkupModel(), project2, null, startOffset, endOffset, info -> {
            if (HighlightInfoType.ELEMENT_UNDER_CARET_READ.equals(info.type) || HighlightInfoType.ELEMENT_UNDER_CARET_WRITE.equals(info.type)) {
                if (ordering.compare(info.startOffset, caretOffset) > 0 && ordering.compare(info.endOffset, caretOffset) > 0 && (next.isNull() || ordering.compare((Integer)next.get(), info.startOffset) > 0)) {
                    next.set(info.startOffset);
                }
                if (first.isNull() || ordering.compare((Integer)first.get(), info.startOffset) > 0) {
                    first.set(info.startOffset);
                }
            }
            return true;
        });
        if (!next.isNull()) {
            GotoElementUnderCaretUsageBase.moveCaret(editor, (Integer)next.get());
        } else if (!first.isNull()) {
            GotoElementUnderCaretUsageBase.moveCaret(editor, (Integer)first.get());
        }
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    private static void moveCaret(Editor editor, int toOffset) {
        Caret caret = editor.getCaretModel().getCurrentCaret();
        caret.removeSelection();
        caret.moveToOffset(toOffset);
        FoldingModel foldingModel = editor.getFoldingModel();
        FoldRegion region = foldingModel.getCollapsedRegionAtOffset(toOffset);
        if (region != null) {
            foldingModel.runBatchFoldingOperation(() -> region.setExpanded(true));
        }
        if (caret == editor.getCaretModel().getPrimaryCaret()) {
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/actions/GotoElementUnderCaretUsageBase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/actions/GotoElementUnderCaretUsageBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static enum Direction {
        FORWARD(Comparator.naturalOrder()),
        BACKWARD(Comparator.reverseOrder());

        public final Comparator<Integer> ordering;

        private Direction(Comparator<Integer> ordering) {
            this.ordering = ordering;
        }
    }
}

