/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.analysis.DefaultHighlightingSettingProvider;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSetting;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSettingListener;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.lang.Language;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.messages.MessageBus;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@State(name="HighlightingSettingsPerFile", storages={@Storage(value="$WORKSPACE_FILE$")})
public class HighlightingSettingsPerFile
extends HighlightingLevelManager
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String SETTING_TAG = "setting";
    @NonNls
    private static final String ROOT_ATT_PREFIX = "root";
    @NonNls
    private static final String FILE_ATT = "file";
    private final MessageBus myBus;
    private final Set<String> vcsIgnoreFileNames;
    private final Map<VirtualFile, FileHighlightingSetting[]> myHighlightSettings;

    public HighlightingSettingsPerFile(@NotNull Project project2, @NotNull MessageBus bus) {
        if (project2 == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(0);
        }
        if (bus == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(1);
        }
        this.myHighlightSettings = new HashMap<VirtualFile, FileHighlightingSetting[]>();
        this.myBus = bus;
        this.vcsIgnoreFileNames = VcsUtil.getVcsIgnoreFileNames(project2);
    }

    public static HighlightingSettingsPerFile getInstance(Project project2) {
        return (HighlightingSettingsPerFile)ServiceManager.getService(project2, HighlightingLevelManager.class);
    }

    private static int getRootIndex(PsiFile file2) {
        FileViewProvider provider = file2.getViewProvider();
        Set<Language> languages = provider.getLanguages();
        if (languages.size() == 1) {
            return 0;
        }
        ArrayList<Language> array = new ArrayList<Language>(languages);
        Collections.sort(array, PsiUtilBase.LANGUAGE_COMPARATOR);
        for (int i = 0; i < array.size(); ++i) {
            Language language2 = (Language)array.get(i);
            if (provider.getPsi(language2) != file2) continue;
            return i;
        }
        throw new RuntimeException("Cannot find root for: " + file2);
    }

    @NotNull
    public FileHighlightingSetting getHighlightingSettingForRoot(@NotNull PsiElement root) {
        if (root == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(2);
        }
        PsiFile containingFile = root.getContainingFile();
        VirtualFile virtualFile2 = containingFile.getVirtualFile();
        FileHighlightingSetting[] fileHighlightingSettings = this.myHighlightSettings.get(virtualFile2);
        int index = HighlightingSettingsPerFile.getRootIndex(containingFile);
        if (fileHighlightingSettings == null || fileHighlightingSettings.length <= index) {
            return HighlightingSettingsPerFile.getDefaultHighlightingSetting(root.getProject(), virtualFile2);
        }
        FileHighlightingSetting fileHighlightingSetting = fileHighlightingSettings[index];
        if (fileHighlightingSetting == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(3);
        }
        return fileHighlightingSetting;
    }

    @NotNull
    private static FileHighlightingSetting getDefaultHighlightingSetting(@NotNull Project project2, VirtualFile virtualFile2) {
        if (project2 == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(4);
        }
        if (virtualFile2 != null) {
            DefaultHighlightingSettingProvider[] providers = DefaultHighlightingSettingProvider.EP_NAME.getExtensions();
            List<DefaultHighlightingSettingProvider> filtered2 = DumbService.getInstance(project2).filterByDumbAwareness(providers);
            for (DefaultHighlightingSettingProvider p : filtered2) {
                FileHighlightingSetting setting = p.getDefaultSetting(project2, virtualFile2);
                if (setting == null) continue;
                FileHighlightingSetting fileHighlightingSetting = setting;
                if (fileHighlightingSetting == null) {
                    HighlightingSettingsPerFile.$$$reportNull$$$0(5);
                }
                return fileHighlightingSetting;
            }
        }
        FileHighlightingSetting fileHighlightingSetting = FileHighlightingSetting.FORCE_HIGHLIGHTING;
        if (fileHighlightingSetting == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(6);
        }
        return fileHighlightingSetting;
    }

    private static FileHighlightingSetting @NotNull [] getDefaults(@NotNull PsiFile file2) {
        if (file2 == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(7);
        }
        int rootsCount = file2.getViewProvider().getLanguages().size();
        FileHighlightingSetting[] fileHighlightingSettings = new FileHighlightingSetting[rootsCount];
        for (int i = 0; i < fileHighlightingSettings.length; ++i) {
            fileHighlightingSettings[i] = FileHighlightingSetting.FORCE_HIGHLIGHTING;
        }
        if (fileHighlightingSettings == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(8);
        }
        return fileHighlightingSettings;
    }

    public void setHighlightingSettingForRoot(@NotNull PsiElement root, @NotNull FileHighlightingSetting setting) {
        PsiFile containingFile;
        VirtualFile virtualFile2;
        if (root == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(9);
        }
        if (setting == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(10);
        }
        if ((virtualFile2 = (containingFile = root.getContainingFile()).getVirtualFile()) == null) {
            return;
        }
        FileHighlightingSetting[] defaults = this.myHighlightSettings.get(virtualFile2);
        int rootIndex = HighlightingSettingsPerFile.getRootIndex(containingFile);
        if (defaults != null && rootIndex >= defaults.length) {
            defaults = null;
        }
        if (defaults == null) {
            defaults = HighlightingSettingsPerFile.getDefaults(containingFile);
        }
        defaults[rootIndex] = setting;
        boolean toRemove2 = true;
        for (FileHighlightingSetting aDefault : defaults) {
            if (aDefault == FileHighlightingSetting.NONE) continue;
            toRemove2 = false;
            break;
        }
        if (toRemove2) {
            this.myHighlightSettings.remove(virtualFile2);
        } else {
            this.myHighlightSettings.put(virtualFile2, defaults);
        }
        this.myBus.syncPublisher(FileHighlightingSettingListener.SETTING_CHANGE).settingChanged(root, setting);
    }

    @Override
    public void loadState(@NotNull Element element2) {
        if (element2 == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(11);
        }
        List<Element> children2 = element2.getChildren(SETTING_TAG);
        for (Element aChildren : children2) {
            VirtualFile fileByUrl;
            Element child2 = aChildren;
            String url = child2.getAttributeValue(FILE_ATT);
            if (url == null || (fileByUrl = VirtualFileManager.getInstance().findFileByUrl(url)) == null) continue;
            ArrayList<FileHighlightingSetting> settings = new ArrayList<FileHighlightingSetting>();
            int index = 0;
            while (child2.getAttributeValue(ROOT_ATT_PREFIX + index) != null) {
                String attributeValue = child2.getAttributeValue(ROOT_ATT_PREFIX + index++);
                settings.add(Enum.valueOf(FileHighlightingSetting.class, attributeValue));
            }
            this.myHighlightSettings.put(fileByUrl, settings.toArray(new FileHighlightingSetting[0]));
        }
    }

    @Override
    public Element getState() {
        Element element2 = new Element("state");
        for (Map.Entry<VirtualFile, FileHighlightingSetting[]> entry : this.myHighlightSettings.entrySet()) {
            Element child2 = new Element(SETTING_TAG);
            VirtualFile vFile = entry.getKey();
            if (!vFile.isValid()) continue;
            child2.setAttribute(FILE_ATT, vFile.getUrl());
            for (int i = 0; i < entry.getValue().length; ++i) {
                FileHighlightingSetting fileHighlightingSetting = entry.getValue()[i];
                child2.setAttribute(ROOT_ATT_PREFIX + i, fileHighlightingSetting.toString());
            }
            element2.addContent(child2);
        }
        return element2;
    }

    @Override
    public boolean shouldHighlight(@NotNull PsiElement psiRoot) {
        FileHighlightingSetting settingForRoot;
        if (psiRoot == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(12);
        }
        return (settingForRoot = this.getHighlightingSettingForRoot(psiRoot)) != FileHighlightingSetting.SKIP_HIGHLIGHTING;
    }

    @Override
    public boolean shouldInspect(@NotNull PsiElement psiRoot) {
        FileHighlightingSetting settingForRoot;
        if (psiRoot == null) {
            HighlightingSettingsPerFile.$$$reportNull$$$0(13);
        }
        if ((settingForRoot = this.getHighlightingSettingForRoot(psiRoot)) == FileHighlightingSetting.SKIP_HIGHLIGHTING || settingForRoot == FileHighlightingSetting.SKIP_INSPECTION) {
            return false;
        }
        Project project2 = psiRoot.getProject();
        VirtualFile virtualFile2 = psiRoot.getContainingFile().getVirtualFile();
        if (virtualFile2 == null || !virtualFile2.isValid()) {
            return false;
        }
        if (ProjectUtil.isProjectOrWorkspaceFile(virtualFile2) && !this.vcsIgnoreFileNames.contains(virtualFile2.getName())) {
            return false;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project2).getFileIndex();
        if (ProjectScope.getLibrariesScope(project2).contains(virtualFile2) && !fileIndex.isInContent(virtualFile2)) {
            return false;
        }
        return !SingleRootFileViewProvider.isTooLargeForIntelligence(virtualFile2);
    }

    public int countRoots(FileHighlightingSetting setting) {
        int count = 0;
        for (FileHighlightingSetting[] settingsForRoots : this.myHighlightSettings.values()) {
            for (FileHighlightingSetting settingForRoot : settingsForRoots) {
                if (settingForRoot != setting) continue;
                ++count;
            }
        }
        return count;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = ROOT_ATT_PREFIX;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightingSettingsPerFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = FILE_ATT;
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = SETTING_TAG;
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightingSettingsPerFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightingSettingForRoot";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultHighlightingSetting";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightingSettingForRoot";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultHighlightingSetting";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaults";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setHighlightingSettingForRoot";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "shouldHighlight";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "shouldInspect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

