/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class ActionHint {
    @NotNull
    private final String myExpectedText;
    private final boolean myShouldPresent;
    private final ProblemHighlightType myHighlightType;
    private final boolean myExactMatch;

    private ActionHint(@NotNull String expectedText, boolean shouldPresent, ProblemHighlightType severity, boolean exactMatch) {
        if (expectedText == null) {
            ActionHint.$$$reportNull$$$0(0);
        }
        this.myExpectedText = expectedText;
        this.myShouldPresent = shouldPresent;
        this.myHighlightType = severity;
        this.myExactMatch = exactMatch;
    }

    @NotNull
    public String getExpectedText() {
        String string = this.myExpectedText;
        if (string == null) {
            ActionHint.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean shouldPresent() {
        return this.myShouldPresent;
    }

    @Nullable
    public IntentionAction findAndCheck(@NotNull Collection<? extends IntentionAction> actions, @NotNull Supplier<String> infoSupplier) {
        if (actions == null) {
            ActionHint.$$$reportNull$$$0(2);
        }
        if (infoSupplier == null) {
            ActionHint.$$$reportNull$$$0(3);
        }
        IntentionAction result2 = actions.stream().filter(t -> {
            String text2 = t.getText();
            return this.myExactMatch ? text2.equals(this.myExpectedText) : text2.startsWith(this.myExpectedText);
        }).findFirst().orElse(null);
        if (this.myShouldPresent) {
            if (result2 == null) {
                Assert.fail((String)(this.exceptionHeader() + " not found\nAvailable actions: " + actions.stream().map(IntentionAction::getText).collect(Collectors.joining(", ", "[", "]\n")) + infoSupplier.get()));
            } else if (this.myHighlightType != null) {
                ProblemHighlightType actualType;
                if (!((result2 = IntentionActionDelegate.unwrap(result2)) instanceof QuickFixWrapper)) {
                    Assert.fail((String)(this.exceptionHeader() + " is not a LocalQuickFix, but " + result2.getClass().getName() + "\nExpected LocalQuickFix with ProblemHighlightType=" + (Object)((Object)this.myHighlightType) + "\n" + infoSupplier.get()));
                }
                if ((actualType = ((QuickFixWrapper)result2).getHighlightType()) != this.myHighlightType) {
                    Assert.fail((String)(this.exceptionHeader() + " has wrong ProblemHighlightType.\nExpected: " + (Object)((Object)this.myHighlightType) + "\nActual: " + (Object)((Object)actualType) + "\n" + infoSupplier.get()));
                }
            }
        } else if (result2 != null) {
            Assert.fail((String)(this.exceptionHeader() + " is present, but should not\n" + infoSupplier.get()));
        }
        return result2;
    }

    @NotNull
    private String exceptionHeader() {
        String string = "Action with " + (this.myExactMatch ? "text" : "prefix") + " '" + this.myExpectedText + "'";
        if (string == null) {
            ActionHint.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static ActionHint parse(@NotNull PsiFile file2, @NotNull String contents) {
        if (file2 == null) {
            ActionHint.$$$reportNull$$$0(5);
        }
        if (contents == null) {
            ActionHint.$$$reportNull$$$0(6);
        }
        return ActionHint.parse(file2, contents, true);
    }

    @NotNull
    public static ActionHint parse(@NotNull PsiFile file2, @NotNull String contents, boolean exactMatch) {
        PsiFile hostFile;
        Commenter commenter;
        String comment;
        if (file2 == null) {
            ActionHint.$$$reportNull$$$0(7);
        }
        if (contents == null) {
            ActionHint.$$$reportNull$$$0(8);
        }
        if ((comment = (commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage((hostFile = InjectedLanguageManager.getInstance(file2.getProject()).getTopLevelFile(file2)).getLanguage())).getLineCommentPrefix()) == null) {
            comment = commenter.getBlockCommentPrefix();
        }
        assert (comment != null) : commenter;
        Pattern pattern = Pattern.compile("^" + Pattern.quote(comment) + " \"(.*)\" \"(\\w+)\".*", 32);
        Matcher matcher = pattern.matcher(contents);
        TestCase.assertTrue((String)("No comment found in " + file2.getVirtualFile()), (boolean)matcher.matches());
        String text2 = matcher.group(1);
        String state = matcher.group(2);
        if (state.equals("true") || state.equals("false")) {
            return new ActionHint(text2, Boolean.parseBoolean(state), null, exactMatch);
        }
        return new ActionHint(text2, true, ProblemHighlightType.valueOf(state), exactMatch);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedText";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/quickFix/ActionHint";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoSupplier";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/quickFix/ActionHint";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "exceptionHeader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findAndCheck";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

