/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.daemon.impl.quickfix.RenameFileFix;
import com.intellij.codeInsight.daemon.quickFix.CreateDirectoryPathFix;
import com.intellij.codeInsight.daemon.quickFix.CreateFilePathFix;
import com.intellij.codeInsight.daemon.quickFix.NewFileLocation;
import com.intellij.codeInsight.daemon.quickFix.RenameFileReferenceIntentionAction;
import com.intellij.codeInsight.daemon.quickFix.TargetDirectory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileTargetContext;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileReferenceQuickFixProvider {
    private FileReferenceQuickFixProvider() {
    }

    @NotNull
    public static List<? extends LocalQuickFix> registerQuickFix(@NotNull FileReference reference2) {
        NewFileLocation location2;
        if (reference2 == null) {
            FileReferenceQuickFixProvider.$$$reportNull$$$0(0);
        }
        FileReferenceSet fileReferenceSet = reference2.getFileReferenceSet();
        int index = reference2.getIndex();
        if (index < 0) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                FileReferenceQuickFixProvider.$$$reportNull$$$0(1);
            }
            return list2;
        }
        String newFileName = reference2.getFileNameToCreate();
        if (newFileName.isEmpty() || newFileName.indexOf(92) != -1 || newFileName.indexOf(42) != -1 || newFileName.indexOf(63) != -1 || SystemInfo.isWindows && newFileName.indexOf(58) != -1) {
            List list3 = Collections.emptyList();
            if (list3 == null) {
                FileReferenceQuickFixProvider.$$$reportNull$$$0(2);
            }
            return list3;
        }
        PsiElement element2 = reference2.getElement();
        PsiFile containingFile = element2.getContainingFile();
        if (fileReferenceSet.isCaseSensitive()) {
            PsiFileSystemItem psiElement;
            PsiFileSystemItem psiFileSystemItem = psiElement = containingFile == null ? null : reference2.innerSingleResolve(false, containingFile);
            if (psiElement != null) {
                String existingElementName = ((PsiNamedElement)psiElement).getName();
                RenameFileReferenceIntentionAction renameRefAction = new RenameFileReferenceIntentionAction(existingElementName, reference2);
                RenameFileFix renameFileFix = new RenameFileFix(newFileName);
                List<LocalQuickFix> list4 = Arrays.asList(renameRefAction, renameFileFix);
                if (list4 == null) {
                    FileReferenceQuickFixProvider.$$$reportNull$$$0(3);
                }
                return list4;
            }
        }
        if (reference2.isLast()) {
            location2 = FileReferenceQuickFixProvider.getNewFileLocation(reference2, newFileName, containingFile, false);
            if (location2 == null) {
                List list5 = Collections.emptyList();
                if (list5 == null) {
                    FileReferenceQuickFixProvider.$$$reportNull$$$0(4);
                }
                return list5;
            }
            List<MyCreateFileFix> list6 = Collections.singletonList(new MyCreateFileFix(element2, location2, reference2.getNewFileTemplateName()));
            if (list6 == null) {
                FileReferenceQuickFixProvider.$$$reportNull$$$0(5);
            }
            return list6;
        }
        location2 = FileReferenceQuickFixProvider.getNewFileLocation(reference2, newFileName, containingFile, true);
        if (location2 == null) {
            List list7 = Collections.emptyList();
            if (list7 == null) {
                FileReferenceQuickFixProvider.$$$reportNull$$$0(6);
            }
            return list7;
        }
        List<CreateDirectoryPathFix> list8 = Collections.singletonList(new CreateDirectoryPathFix(element2, location2));
        if (list8 == null) {
            FileReferenceQuickFixProvider.$$$reportNull$$$0(7);
        }
        return list8;
    }

    @Nullable
    public static NewFileLocation getNewFileLocation(@NotNull FileReference reference2, String newFileName, boolean isDirectory) {
        if (reference2 == null) {
            FileReferenceQuickFixProvider.$$$reportNull$$$0(8);
        }
        return FileReferenceQuickFixProvider.getNewFileLocation(reference2, newFileName, reference2.getElement().getContainingFile(), isDirectory);
    }

    @Nullable
    private static NewFileLocation getNewFileLocation(@NotNull FileReference reference2, String newFileName, PsiFile containingFile, boolean isDirectory) {
        Module module2;
        List<TargetDirectory> targetDirectories;
        if (reference2 == null) {
            FileReferenceQuickFixProvider.$$$reportNull$$$0(9);
        }
        if ((targetDirectories = FileReferenceQuickFixProvider.getTargets(reference2, module2 = ModuleUtilCore.findModuleForPsiElement(containingFile), newFileName, isDirectory)).isEmpty()) {
            return null;
        }
        return new NewFileLocation(targetDirectories, FileReferenceQuickFixProvider.getPathToReferencePart(reference2), newFileName);
    }

    @NotNull
    private static List<TargetDirectory> getTargets(@NotNull FileReference reference2, @Nullable Module module2, String newFileName, boolean isDirectory) {
        if (reference2 == null) {
            FileReferenceQuickFixProvider.$$$reportNull$$$0(10);
        }
        List<FileTargetContext> contexts = FileReferenceQuickFixProvider.getSuitableContexts(reference2, module2);
        SmartList<TargetDirectory> targetDirectories = new SmartList<TargetDirectory>();
        for (FileTargetContext targetContext : contexts) {
            PsiDirectory directory;
            FileType ft;
            PsiFileSystemItem context = targetContext.getFileSystemItem();
            VirtualFile virtualFile2 = context.getVirtualFile();
            if (virtualFile2 == null || !virtualFile2.isValid() || !isDirectory && (ft = FileTypeManager.getInstance().getFileTypeByFileName(newFileName)) instanceof UnknownFileType || (directory = context.getManager().findDirectory(virtualFile2)) == null || !FileReferenceQuickFixProvider.checkFileWriteAccess(reference2, directory, targetContext.getPathToCreate(), newFileName, isDirectory)) continue;
            if (module2 != null) {
                targetDirectories.add(new TargetDirectory(directory, targetContext.getPathToCreate()));
                continue;
            }
            targetDirectories.add(new TargetDirectory(directory));
        }
        SmartList<TargetDirectory> smartList = targetDirectories;
        if (smartList == null) {
            FileReferenceQuickFixProvider.$$$reportNull$$$0(11);
        }
        return smartList;
    }

    private static boolean checkFileWriteAccess(FileReference reference2, PsiDirectory targetRoot, String[] pathToCreate, String newFileName, boolean isDirectory) {
        PsiDirectory currentDirectory = targetRoot;
        for (String part : pathToCreate) {
            PsiDirectory subDirectory = currentDirectory.findSubdirectory(part);
            if (subDirectory == null) {
                return FileReferenceQuickFixProvider.checkCreateSubdirectory(currentDirectory, part);
            }
            currentDirectory = subDirectory;
        }
        if (reference2.getIndex() > 0) {
            FileReference[] references2 = reference2.getFileReferenceSet().getAllReferences();
            for (int i = 0; i < references2.length - 1; ++i) {
                String part = references2[i].getFileNameToCreate();
                PsiDirectory subDirectory = currentDirectory.findSubdirectory(part);
                if (subDirectory == null) {
                    return FileReferenceQuickFixProvider.checkCreateSubdirectory(currentDirectory, part);
                }
                currentDirectory = subDirectory;
            }
        }
        if (isDirectory) {
            return FileReferenceQuickFixProvider.checkCreateSubdirectory(currentDirectory, newFileName);
        }
        return FileReferenceQuickFixProvider.checkCreateFile(currentDirectory, newFileName);
    }

    private static boolean checkCreateFile(PsiDirectory directory, String newFileName) {
        try {
            directory.checkCreateFile(newFileName);
        }
        catch (IncorrectOperationException ex) {
            return false;
        }
        return true;
    }

    private static boolean checkCreateSubdirectory(PsiDirectory directory, String part) {
        try {
            directory.checkCreateSubdirectory(part);
        }
        catch (IncorrectOperationException ex) {
            return false;
        }
        return true;
    }

    private static String @NotNull [] getPathToReferencePart(FileReference reference2) {
        if (reference2.getIndex() == 0) {
            if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
                FileReferenceQuickFixProvider.$$$reportNull$$$0(12);
            }
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        FileReference[] references2 = reference2.getFileReferenceSet().getAllReferences();
        String[] path2 = new String[reference2.getIndex()];
        for (int i = 0; i < reference2.getIndex(); ++i) {
            path2[i] = references2[i].getFileNameToCreate();
        }
        if (path2 == null) {
            FileReferenceQuickFixProvider.$$$reportNull$$$0(13);
        }
        return path2;
    }

    @NotNull
    private static List<FileTargetContext> getSuitableContexts(@NotNull FileReference reference2, @Nullable Module module2) {
        FileReferenceSet fileReferenceSet;
        Collection<FileTargetContext> targetContexts;
        if (reference2 == null) {
            FileReferenceQuickFixProvider.$$$reportNull$$$0(14);
        }
        if ((targetContexts = (fileReferenceSet = reference2.getFileReferenceSet()).getTargetContexts()).isEmpty()) {
            List<FileTargetContext> list2 = Collections.emptyList();
            if (list2 == null) {
                FileReferenceQuickFixProvider.$$$reportNull$$$0(15);
            }
            return list2;
        }
        SmartList<FileTargetContext> contexts = new SmartList<FileTargetContext>();
        for (FileTargetContext targetContext : targetContexts) {
            PsiFileSystemItem fsContext = targetContext.getFileSystemItem();
            if (module2 != null) {
                if (module2 != FileReferenceQuickFixProvider.getModuleForContext(fsContext)) continue;
                contexts.add(targetContext);
                continue;
            }
            contexts.add(targetContext);
        }
        if (contexts.isEmpty() && ApplicationManager.getApplication().isUnitTestMode()) {
            List<FileTargetContext> list3 = Collections.singletonList(targetContexts.iterator().next());
            if (list3 == null) {
                FileReferenceQuickFixProvider.$$$reportNull$$$0(16);
            }
            return list3;
        }
        SmartList<FileTargetContext> smartList = contexts;
        if (smartList == null) {
            FileReferenceQuickFixProvider.$$$reportNull$$$0(17);
        }
        return smartList;
    }

    @Nullable
    private static Module getModuleForContext(@NotNull PsiFileSystemItem context) {
        VirtualFile file2;
        if (context == null) {
            FileReferenceQuickFixProvider.$$$reportNull$$$0(18);
        }
        return (file2 = context.getVirtualFile()) != null ? ModuleUtilCore.findModuleForFile(file2, context.getProject()) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "registerQuickFix";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToReferencePart";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerQuickFix";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNewFileLocation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTargets";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSuitableContexts";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getModuleForContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyCreateFileFix
    extends CreateFilePathFix {
        private final String myNewFileTemplateName;

        private MyCreateFileFix(@NotNull PsiElement psiElement, @NotNull NewFileLocation newFileLocation, @Nullable String newFileTemplateName) {
            if (psiElement == null) {
                MyCreateFileFix.$$$reportNull$$$0(0);
            }
            if (newFileLocation == null) {
                MyCreateFileFix.$$$reportNull$$$0(1);
            }
            super(psiElement, newFileLocation);
            this.myNewFileTemplateName = newFileTemplateName;
        }

        @Override
        protected String getFileText() {
            Project project2;
            FileTemplateManager fileTemplateManager;
            FileTemplate template;
            if (this.myNewFileTemplateName != null && (template = this.findTemplate(fileTemplateManager = FileTemplateManager.getInstance(project2 = this.getStartElement().getProject()))) != null) {
                try {
                    return template.getText(fileTemplateManager.getDefaultProperties());
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return super.getFileText();
        }

        private FileTemplate findTemplate(FileTemplateManager fileTemplateManager) {
            FileTemplate template = fileTemplateManager.getTemplate(this.myNewFileTemplateName);
            if (template == null) {
                template = fileTemplateManager.findInternalTemplate(this.myNewFileTemplateName);
            }
            if (template == null) {
                for (FileTemplate fileTemplate : fileTemplateManager.getAllJ2eeTemplates()) {
                    String fileTemplateWithExtension = fileTemplate.getName() + '.' + fileTemplate.getExtension();
                    if (!fileTemplateWithExtension.equals(this.myNewFileTemplateName)) continue;
                    return fileTemplate;
                }
            }
            return template;
        }

        @Override
        protected void openFile(@NotNull Project project2, PsiDirectory directory, PsiFile newFile, String text2) {
            FileTemplateManager fileTemplateManager;
            FileTemplate template;
            if (project2 == null) {
                MyCreateFileFix.$$$reportNull$$$0(2);
            }
            super.openFile(project2, directory, newFile, text2);
            if (this.myNewFileTemplateName != null && (template = this.findTemplate(fileTemplateManager = FileTemplateManager.getInstance(project2))) != null && template.isLiveTemplateEnabled()) {
                CreateFromTemplateActionBase.startLiveTemplate(newFile);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newFileLocation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/quickFix/FileReferenceQuickFixProvider$MyCreateFileFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "openFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

