/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.impl.EditorMouseHoverPopupControl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainText;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.reference.SoftReference;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QuickDocOnMouseOverManager {
    private static final Logger LOG = Logger.getInstance(QuickDocOnMouseOverManager.class);
    @NotNull
    private final MyEditorMouseListener myMouseListener = new MyEditorMouseListener();
    @NotNull
    private final VisibleAreaListener myVisibleAreaListener = new MyVisibleAreaListener();
    @NotNull
    private final CaretListener myCaretListener = new MyCaretListener();
    @NotNull
    private final DocumentListener myDocumentListener = new MyDocumentListener();
    @NotNull
    private final Alarm myAlarm;
    @NotNull
    private final Map<Document, Boolean> myMonitoredDocuments = ContainerUtil.createWeakMap();
    private final Map<Editor, Reference<PsiElement>> myActiveElements = ContainerUtil.createWeakMap();
    @Nullable
    private WeakReference<DocumentationManager> myDocumentationManager;
    private boolean myEnabled;
    private boolean myApplicationActive;
    private MyShowQuickDocRequest myCurrentRequest;

    public QuickDocOnMouseOverManager() {
        Application app = ApplicationManager.getApplication();
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, app);
        EditorFactory factory = EditorFactory.getInstance();
        if (factory != null) {
            factory.addEditorFactoryListener(new MyEditorFactoryListener(), app);
        }
        app.getMessageBus().connect().subscribe(ApplicationActivationListener.TOPIC, new ApplicationActivationListener(){

            @Override
            public void applicationActivated(@NotNull IdeFrame ideFrame) {
                if (ideFrame == null) {
                    1.$$$reportNull$$$0(0);
                }
                QuickDocOnMouseOverManager.this.myApplicationActive = true;
            }

            @Override
            public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
                if (ideFrame == null) {
                    1.$$$reportNull$$$0(1);
                }
                QuickDocOnMouseOverManager.this.myApplicationActive = false;
                QuickDocOnMouseOverManager.this.closeQuickDocIfPossible();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "ideFrame";
                objectArray2[1] = "com/intellij/codeInsight/documentation/QuickDocOnMouseOverManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "applicationActivated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "applicationDeactivated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void setEnabled(boolean enabled) {
        EditorFactory factory;
        if (this.myEnabled == enabled) {
            return;
        }
        this.myEnabled = enabled;
        if (!enabled) {
            this.closeQuickDocIfPossible();
            this.myAlarm.cancelAllRequests();
        }
        if ((factory = EditorFactory.getInstance()) == null) {
            return;
        }
        for (Editor editor : factory.getAllEditors()) {
            if (enabled) {
                this.registerListeners(editor);
                continue;
            }
            this.unRegisterListeners(editor);
        }
    }

    private void registerListeners(@NotNull Editor editor) {
        if (editor == null) {
            QuickDocOnMouseOverManager.$$$reportNull$$$0(0);
        }
        editor.addEditorMouseListener(this.myMouseListener);
        editor.addEditorMouseMotionListener(this.myMouseListener);
        editor.getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener);
        editor.getCaretModel().addCaretListener(this.myCaretListener);
        Document document = editor.getDocument();
        if (this.myMonitoredDocuments.put(document, Boolean.TRUE) == null) {
            document.addDocumentListener(this.myDocumentListener);
        }
    }

    private void unRegisterListeners(@NotNull Editor editor) {
        if (editor == null) {
            QuickDocOnMouseOverManager.$$$reportNull$$$0(1);
        }
        editor.removeEditorMouseListener(this.myMouseListener);
        editor.removeEditorMouseMotionListener(this.myMouseListener);
        editor.getScrollingModel().removeVisibleAreaListener(this.myVisibleAreaListener);
        editor.getCaretModel().removeCaretListener(this.myCaretListener);
        Document document = editor.getDocument();
        if (this.myMonitoredDocuments.remove(document) != null) {
            document.removeDocumentListener(this.myDocumentListener);
        }
    }

    private void processMouseExited() {
        this.myActiveElements.clear();
        this.myAlarm.cancelAllRequests();
    }

    private void processMouseMove(@NotNull EditorMouseEvent e) {
        PsiFile psiFile;
        if (e == null) {
            QuickDocOnMouseOverManager.$$$reportNull$$$0(2);
        }
        if (!this.myApplicationActive || !this.myEnabled || e.getArea() != EditorMouseEventArea.EDITING_AREA) {
            this.closeQuickDocIfPossible();
            return;
        }
        if (e.getMouseEvent().getModifiers() != 0) {
            return;
        }
        Editor editor = e.getEditor();
        if (EditorMouseHoverPopupControl.arePopupsDisabled(editor)) {
            return;
        }
        if (editor.isOneLineMode()) {
            return;
        }
        Project project2 = editor.getProject();
        if (project2 == null) {
            return;
        }
        DocumentationManager documentationManager = DocumentationManager.getInstance(project2);
        JBPopup hint = documentationManager.getDocInfoHint();
        if (hint != null) {
            DocumentationManager manager = this.getDocManager();
            if (manager == null || !manager.isCloseOnSneeze()) {
                return;
            }
            Point hintLocation = hint.getLocationOnScreen();
            Dimension hintSize = hint.getSize();
            int mouseX = e.getMouseEvent().getXOnScreen();
            int mouseY = e.getMouseEvent().getYOnScreen();
            int resizeZoneWidth = editor.getLineHeight();
            if (mouseX >= hintLocation.x - resizeZoneWidth && mouseX <= hintLocation.x + hintSize.width + resizeZoneWidth && mouseY >= hintLocation.y - resizeZoneWidth && mouseY <= hintLocation.y + hintSize.height + resizeZoneWidth) {
                return;
            }
        }
        if ((psiFile = PsiDocumentManager.getInstance(project2).getPsiFile(editor.getDocument())) == null) {
            this.closeQuickDocIfPossible();
            return;
        }
        Point point = e.getMouseEvent().getPoint();
        if (editor instanceof EditorEx && ((EditorEx)editor).getFoldingModel().getFoldingPlaceholderAt(point) != null) {
            this.closeQuickDocIfPossible();
            return;
        }
        VisualPosition visualPosition = editor.xyToVisualPosition(point);
        if (editor.getSoftWrapModel().isInsideOrBeforeSoftWrap(visualPosition)) {
            this.closeQuickDocIfPossible();
            return;
        }
        int mouseOffset = editor.logicalPositionToOffset(editor.visualToLogicalPosition(visualPosition));
        PsiElement elementUnderMouse = psiFile.findElementAt(mouseOffset);
        if (elementUnderMouse == null || elementUnderMouse instanceof PsiWhiteSpace || elementUnderMouse instanceof PsiPlainText) {
            this.closeQuickDocIfPossible();
            return;
        }
        if (elementUnderMouse.equals(SoftReference.dereference(this.myActiveElements.get(editor))) && (!this.myAlarm.isEmpty() || hint != null)) {
            return;
        }
        this.allowUpdateFromContext(project2, false);
        this.closeQuickDocIfPossible();
        this.myActiveElements.put(editor, new WeakReference<PsiElement>(elementUnderMouse));
        this.myAlarm.cancelAllRequests();
        if (this.myCurrentRequest != null) {
            this.myCurrentRequest.cancel();
        }
        this.myCurrentRequest = new MyShowQuickDocRequest(documentationManager, editor, mouseOffset, elementUnderMouse);
        this.myAlarm.addRequest((Runnable)this.myCurrentRequest, EditorSettingsExternalizable.getInstance().getTooltipsDelay());
    }

    private void closeQuickDocIfPossible() {
        JBPopup hint;
        this.myAlarm.cancelAllRequests();
        DocumentationManager docManager = this.getDocManager();
        if (docManager != null && (hint = docManager.getDocInfoHint()) != null) {
            hint.cancel();
        }
    }

    private void allowUpdateFromContext(Project project2, boolean allow) {
        DocumentationManager documentationManager = this.getDocManager();
        if (documentationManager != null && documentationManager.getProject(null) == project2) {
            documentationManager.setAllowContentUpdateFromContext(allow);
        }
    }

    @Nullable
    private DocumentationManager getDocManager() {
        return SoftReference.dereference(this.myDocumentationManager);
    }

    @Nullable
    private Editor getEditor() {
        DocumentationManager manager = this.getDocManager();
        return manager == null ? null : manager.getEditor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/documentation/QuickDocOnMouseOverManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerListeners";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "unRegisterListeners";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processMouseMove";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        @Override
        public void documentChanged(@NotNull DocumentEvent e) {
            if (e == null) {
                MyDocumentListener.$$$reportNull$$$0(0);
            }
            if (Registry.is("editor.new.mouse.hover.popups")) {
                return;
            }
            Editor editor = QuickDocOnMouseOverManager.this.getEditor();
            if (editor == null || editor.getDocument() == e.getDocument()) {
                QuickDocOnMouseOverManager.this.closeQuickDocIfPossible();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/QuickDocOnMouseOverManager$MyDocumentListener", "documentChanged"));
        }
    }

    private class MyCaretListener
    implements CaretListener {
        private MyCaretListener() {
        }

        @Override
        public void caretPositionChanged(@NotNull CaretEvent e) {
            if (e == null) {
                MyCaretListener.$$$reportNull$$$0(0);
            }
            if (Registry.is("editor.new.mouse.hover.popups")) {
                return;
            }
            Editor editor = QuickDocOnMouseOverManager.this.getEditor();
            if (editor == null || editor == e.getEditor()) {
                QuickDocOnMouseOverManager.this.allowUpdateFromContext(e.getEditor().getProject(), true);
                QuickDocOnMouseOverManager.this.closeQuickDocIfPossible();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/QuickDocOnMouseOverManager$MyCaretListener", "caretPositionChanged"));
        }
    }

    private class MyVisibleAreaListener
    implements VisibleAreaListener {
        private MyVisibleAreaListener() {
        }

        @Override
        public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
            if (e == null) {
                MyVisibleAreaListener.$$$reportNull$$$0(0);
            }
            if (Registry.is("editor.new.mouse.hover.popups")) {
                return;
            }
            Editor editor = QuickDocOnMouseOverManager.this.getEditor();
            if (editor == null || editor == e.getEditor()) {
                QuickDocOnMouseOverManager.this.closeQuickDocIfPossible();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/QuickDocOnMouseOverManager$MyVisibleAreaListener", "visibleAreaChanged"));
        }
    }

    private class MyEditorMouseListener
    implements EditorMouseMotionListener,
    EditorMouseListener {
        private MyEditorMouseListener() {
        }

        @Override
        public void mouseExited(@NotNull EditorMouseEvent e) {
            if (e == null) {
                MyEditorMouseListener.$$$reportNull$$$0(0);
            }
            if (Registry.is("editor.new.mouse.hover.popups")) {
                return;
            }
            QuickDocOnMouseOverManager.this.processMouseExited();
        }

        @Override
        public void mouseMoved(@NotNull EditorMouseEvent e) {
            if (e == null) {
                MyEditorMouseListener.$$$reportNull$$$0(1);
            }
            if (Registry.is("editor.new.mouse.hover.popups")) {
                return;
            }
            QuickDocOnMouseOverManager.this.processMouseMove(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/codeInsight/documentation/QuickDocOnMouseOverManager$MyEditorMouseListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseExited";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseMoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyEditorFactoryListener
    implements EditorFactoryListener {
        private MyEditorFactoryListener() {
        }

        @Override
        public void editorCreated(@NotNull EditorFactoryEvent event) {
            if (event == null) {
                MyEditorFactoryListener.$$$reportNull$$$0(0);
            }
            if (QuickDocOnMouseOverManager.this.myEnabled) {
                QuickDocOnMouseOverManager.this.registerListeners(event.getEditor());
            }
        }

        @Override
        public void editorReleased(@NotNull EditorFactoryEvent event) {
            if (event == null) {
                MyEditorFactoryListener.$$$reportNull$$$0(1);
            }
            if (QuickDocOnMouseOverManager.this.myEnabled) {
                QuickDocOnMouseOverManager.this.unRegisterListeners(event.getEditor());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/codeInsight/documentation/QuickDocOnMouseOverManager$MyEditorFactoryListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editorCreated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editorReleased";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyCloseDocCallback
    implements Runnable {
        @NotNull
        private final Editor myEditor;

        private MyCloseDocCallback(Editor editor) {
            if (editor == null) {
                MyCloseDocCallback.$$$reportNull$$$0(0);
            }
            this.myEditor = editor;
        }

        @Override
        public void run() {
            QuickDocOnMouseOverManager.this.myActiveElements.clear();
            this.myEditor.putUserData(PopupFactoryImpl.ANCHOR_POPUP_POSITION, null);
            QuickDocOnMouseOverManager.this.myDocumentationManager = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/documentation/QuickDocOnMouseOverManager$MyCloseDocCallback", "<init>"));
        }
    }

    private class MyShowQuickDocRequest
    implements Runnable {
        @NotNull
        private final DocumentationManager docManager;
        @NotNull
        private final Editor editor;
        private final int offset;
        @NotNull
        private final PsiElement originalElement;
        @NotNull
        private final ProgressIndicator myProgressIndicator;

        private MyShowQuickDocRequest(@NotNull DocumentationManager docManager, Editor editor, @NotNull int offset, PsiElement originalElement) {
            if (docManager == null) {
                MyShowQuickDocRequest.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                MyShowQuickDocRequest.$$$reportNull$$$0(1);
            }
            if (originalElement == null) {
                MyShowQuickDocRequest.$$$reportNull$$$0(2);
            }
            this.myProgressIndicator = new ProgressIndicatorBase();
            this.docManager = docManager;
            this.editor = editor;
            this.offset = offset;
            this.originalElement = originalElement;
        }

        private void cancel() {
            this.myProgressIndicator.cancel();
        }

        @Override
        public void run() {
            PsiElement targetElement;
            try {
                targetElement = ReadAction.nonBlocking(() -> this.originalElement.isValid() ? this.docManager.findTargetElement(this.editor, this.offset, this.originalElement.getContainingFile(), this.originalElement) : null).wrapProgress(this.myProgressIndicator).executeSynchronously();
            }
            catch (ProcessCanceledException e) {
                return;
            }
            Ref<String> documentationRef = new Ref<String>();
            if (targetElement != null) {
                try {
                    documentationRef.set(this.docManager.generateDocumentation(targetElement, this.originalElement, true));
                }
                catch (Exception e) {
                    LOG.info(e);
                }
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                QuickDocOnMouseOverManager.this.myCurrentRequest = null;
                if (this.editor.isDisposed() || (IdeTooltipManager.getInstance().hasCurrent() || IdeTooltipManager.getInstance().hasScheduled()) && !this.docManager.hasActiveDockedDocWindow()) {
                    return;
                }
                String documentation = (String)documentationRef.get();
                if (targetElement == null || StringUtil.isEmpty(documentation)) {
                    QuickDocOnMouseOverManager.this.closeQuickDocIfPossible();
                    return;
                }
                QuickDocOnMouseOverManager.this.myAlarm.cancelAllRequests();
                if (!this.originalElement.equals(SoftReference.dereference((Reference)QuickDocOnMouseOverManager.this.myActiveElements.get(this.editor)))) {
                    return;
                }
                if (this.docManager.getDocInfoHint() != null && !this.docManager.isCloseOnSneeze()) {
                    return;
                }
                this.editor.putUserData(PopupFactoryImpl.ANCHOR_POPUP_POSITION, this.editor.offsetToVisualPosition(this.originalElement.getTextRange().getStartOffset()));
                this.docManager.showJavaDocInfo(this.editor, targetElement, this.originalElement, new MyCloseDocCallback(this.editor), documentation, true, false);
                QuickDocOnMouseOverManager.this.myDocumentationManager = new WeakReference<DocumentationManager>(this.docManager);
            }, ApplicationManager.getApplication().getNoneModalityState());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "docManager";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "originalElement";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/documentation/QuickDocOnMouseOverManager$MyShowQuickDocRequest";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

