/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeInsight.documentation.render.DocRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

@Service
public final class DocRenderItemUpdater
implements Runnable {
    private static final long MAX_UPDATE_DURATION_MS = 50L;
    private final List<Inlay<DocRenderer>> myQueue = new ArrayList<Inlay<DocRenderer>>();

    static DocRenderItemUpdater getInstance() {
        return ApplicationManager.getApplication().getService(DocRenderItemUpdater.class);
    }

    boolean updateInlays(@NotNull Collection<Inlay<DocRenderer>> inlays) {
        if (inlays == null) {
            DocRenderItemUpdater.$$$reportNull$$$0(0);
        }
        if (inlays.isEmpty()) {
            return false;
        }
        boolean wasEmpty = this.myQueue.isEmpty();
        this.myQueue.addAll(0, inlays);
        return wasEmpty && this.processChunk();
    }

    @Override
    public void run() {
        this.processChunk();
    }

    private boolean processChunk() {
        long deadline = System.currentTimeMillis() + 50L;
        HashMap<Editor, EditorScrollingPositionKeeper> keepers = new HashMap<Editor, EditorScrollingPositionKeeper>();
        this.myQueue.sort(Comparator.comparingInt(i -> -Math.abs(i.getOffset() - i.getEditor().getCaretModel().getOffset())));
        do {
            Inlay<DocRenderer> inlay;
            if (!(inlay = this.myQueue.remove(this.myQueue.size() - 1)).isValid()) continue;
            Editor editor = inlay.getEditor();
            keepers.computeIfAbsent(editor, e -> {
                EditorScrollingPositionKeeper keeper = new EditorScrollingPositionKeeper(editor);
                keeper.savePosition();
                return keeper;
            });
            inlay.getRenderer().updateContent();
        } while (!this.myQueue.isEmpty() && System.currentTimeMillis() < deadline);
        keepers.values().forEach(k -> k.restorePosition(false));
        if (!this.myQueue.isEmpty()) {
            SwingUtilities.invokeLater(this);
        }
        return !keepers.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlays", "com/intellij/codeInsight/documentation/render/DocRenderItemUpdater", "updateInlays"));
    }
}

