/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class CutHandler
extends EditorWriteActionHandler {
    private final EditorActionHandler myOriginalHandler;

    public CutHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    @Override
    public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
        assert (caret == null) : "Invocation of 'cut' operation for specific caret is not supported";
        Project project2 = CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(editor.getContentComponent()));
        if (project2 == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, null, dataContext);
            }
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getPsiFile(editor.getDocument());
        if (file2 == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, null, dataContext);
            }
            return;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection(true)) {
            if (Registry.is("editor.skip.copy.and.cut.for.empty.selection")) {
                return;
            }
            editor.getCaretModel().runForEachCaret(__ -> selectionModel.selectLineAtCaret());
            if (!selectionModel.hasSelection(true)) {
                return;
            }
        }
        int start2 = selectionModel.getSelectionStart();
        int end = selectionModel.getSelectionEnd();
        ArrayList selections = new ArrayList();
        if (editor.getCaretModel().supportsMultipleCarets()) {
            editor.getCaretModel().runForEachCaret(__ -> selections.add(new TextRange(selectionModel.getSelectionStart(), selectionModel.getSelectionEnd())));
        }
        EditorActionManager.getInstance().getActionHandler("EditorCopy").execute(editor, null, dataContext);
        if (editor.getCaretModel().supportsMultipleCarets()) {
            Collections.reverse(selections);
            Iterator it = selections.iterator();
            editor.getCaretModel().runForEachCaret(__ -> {
                TextRange range2 = (TextRange)it.next();
                editor.getCaretModel().moveToOffset(range2.getStartOffset());
                selectionModel.removeSelection();
                editor.getDocument().deleteString(range2.getStartOffset(), range2.getEndOffset());
            });
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        } else if (start2 != end) {
            editor.getDocument().deleteString(start2, end);
        } else {
            EditorModificationUtil.deleteSelectedText(editor);
        }
    }
}

