/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.editorActions.emacs.EmacsProcessingHandler;
import com.intellij.codeInsight.editorActions.emacs.LanguageEmacsExtension;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class EmacsStyleIndentAction
extends BaseCodeInsightAction
implements DumbAware {
    @Override
    @NotNull
    protected CodeInsightActionHandler getHandler() {
        return new Handler();
    }

    @Override
    protected boolean isValidForFile(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement context;
        if (project2 == null) {
            EmacsStyleIndentAction.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            EmacsStyleIndentAction.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            EmacsStyleIndentAction.$$$reportNull$$$0(2);
        }
        return LanguageFormatting.INSTANCE.forContext(context = (PsiElement)ObjectUtils.notNull(file2.findElementAt(editor.getCaretModel().getOffset()), file2)) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/editorActions/EmacsStyleIndentAction";
        objectArray[2] = "isValidForFile";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Handler
    implements CodeInsightActionHandler {
        private Handler() {
        }

        @Override
        public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
            EmacsProcessingHandler.Result result2;
            EmacsProcessingHandler emacsProcessingHandler;
            if (project2 == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                Handler.$$$reportNull$$$0(1);
            }
            if (file2 == null) {
                Handler.$$$reportNull$$$0(2);
            }
            if ((emacsProcessingHandler = (EmacsProcessingHandler)LanguageEmacsExtension.INSTANCE.forLanguage(file2.getLanguage())) != null && (result2 = emacsProcessingHandler.changeIndent(project2, editor, file2)) == EmacsProcessingHandler.Result.STOP) {
                return;
            }
            Document document = editor.getDocument();
            int startLine = document.getLineNumber(editor.getSelectionModel().getSelectionStart());
            int endLine = document.getLineNumber(editor.getSelectionModel().getSelectionEnd());
            for (int line = startLine; line <= endLine; ++line) {
                int lineStart = document.getLineStartOffset(line);
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance(project2);
                int newPos = codeStyleManager.adjustLineIndent(file2, lineStart);
                if (startLine != endLine || editor.getCaretModel().getOffset() >= newPos) continue;
                editor.getCaretModel().moveToOffset(newPos);
                editor.getSelectionModel().removeSelection();
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/editorActions/EmacsStyleIndentAction$Handler";
            objectArray[2] = "invoke";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

