/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.AutoHardWrapHandler;
import com.intellij.codeInsight.editorActions.BaseEnterHandler;
import com.intellij.codeInsight.editorActions.CodeDocumentationUtil;
import com.intellij.codeInsight.editorActions.CommentCompleteHandler;
import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.ide.DataManager;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.LanguageDocumentation;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.documentation.CodeDocumentationProvider;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataContextWrapper;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnterHandler
extends BaseEnterHandler {
    private static final Logger LOG = Logger.getInstance(EnterHandler.class);
    private final EditorActionHandler myOriginalHandler;
    private static final Key<Language> CONTEXT_LANGUAGE = Key.create("EnterHandler.Language");

    public EnterHandler(EditorActionHandler originalHandler) {
        super(true);
        this.myOriginalHandler = originalHandler;
    }

    @Override
    public boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor == null) {
            EnterHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            EnterHandler.$$$reportNull$$$0(1);
        }
        return this.myOriginalHandler.isEnabled(editor, caret, dataContext);
    }

    @Override
    public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
        Project project2 = CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 != null && !project2.isDefault()) {
            PostprocessReformattingAspect.getInstance(project2).disablePostprocessFormattingInside(() -> this.executeWriteActionInner(editor, caret, EnterHandler.getExtendedContext(dataContext, project2, caret), project2));
        } else {
            this.executeWriteActionInner(editor, caret, dataContext, project2);
        }
    }

    private void executeWriteActionInner(Editor editor, Caret caret, DataContext dataContext, Project project2) {
        int offset1;
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        if (project2 == null) {
            this.myOriginalHandler.execute(editor, caret, dataContext);
            return;
        }
        Document document = editor.getDocument();
        PsiFile file2 = PsiUtilBase.getPsiFileInEditor(editor, project2);
        if (file2 == null) {
            this.myOriginalHandler.execute(editor, caret, dataContext);
            return;
        }
        CommandProcessor.getInstance().setCurrentCommandName(CodeInsightBundle.message("command.name.typing", new Object[0]));
        EditorModificationUtil.deleteSelectedText(editor);
        int caretOffset = editor.getCaretModel().getOffset();
        CharSequence text2 = document.getCharsSequence();
        int length = document.getTextLength();
        if (caretOffset < length && text2.charAt(caretOffset) != '\n' && ((offset1 = CharArrayUtil.shiftBackward(text2, caretOffset, " \t")) < 0 || text2.charAt(offset1) == '\n')) {
            boolean isEmptyLine;
            int offset2 = CharArrayUtil.shiftForward(text2, offset1 + 1, " \t");
            boolean bl = isEmptyLine = offset2 >= length || text2.charAt(offset2) == '\n';
            if (!isEmptyLine) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
                return;
            }
        }
        boolean forceIndent = false;
        boolean forceSkipIndent = false;
        Ref<Integer> caretOffsetRef = new Ref<Integer>(caretOffset);
        Ref<Integer> caretAdvanceRef = new Ref<Integer>(0);
        for (EnterHandlerDelegate delegate : EnterHandlerDelegate.EP_NAME.getExtensionList()) {
            EnterHandlerDelegate.Result result2 = delegate.preprocessEnter(file2, editor, caretOffsetRef, caretAdvanceRef, dataContext, this.myOriginalHandler);
            if (caretOffsetRef.get() > document.getTextLength()) {
                throw new AssertionError((Object)("Wrong caret offset change by " + delegate));
            }
            if (result2 == EnterHandlerDelegate.Result.Stop) {
                return;
            }
            if (result2 == EnterHandlerDelegate.Result.Continue) continue;
            if (result2 == EnterHandlerDelegate.Result.DefaultForceIndent) {
                forceIndent = true;
                break;
            }
            if (result2 != EnterHandlerDelegate.Result.DefaultSkipIndent) break;
            forceSkipIndent = true;
            break;
        }
        text2 = document.getCharsSequence();
        caretOffset = caretOffsetRef.get();
        boolean isFirstColumn = caretOffset == 0 || text2.charAt(caretOffset - 1) == '\n';
        boolean insertSpace = !isFirstColumn && caretOffset < text2.length() && text2.charAt(caretOffset) != ' ' && text2.charAt(caretOffset) != '\t';
        editor.getCaretModel().moveToOffset(caretOffset);
        this.myOriginalHandler.execute(editor, caret, dataContext);
        if (!editor.isInsertMode() || forceSkipIndent) {
            return;
        }
        if (settings.SMART_INDENT_ON_ENTER || forceIndent) {
            ++caretOffset;
            caretOffset = CharArrayUtil.shiftForward(editor.getDocument().getCharsSequence(), caretOffset, " \t");
            if (DocumentUtil.isAtLineEnd(caretOffset, document)) {
                caretOffset = editor.getCaretModel().getOffset();
            }
        } else {
            caretOffset = editor.getCaretModel().getOffset();
        }
        DoEnterAction action2 = new DoEnterAction(file2, editor, document, dataContext, caretOffset, !insertSpace, caretAdvanceRef.get(), project2);
        action2.setForceIndent(forceIndent);
        action2.run();
        for (EnterHandlerDelegate delegate : EnterHandlerDelegate.EP_NAME.getExtensionList()) {
            if (delegate.postProcessEnter(file2, editor, dataContext) == EnterHandlerDelegate.Result.Stop) break;
        }
        if (settings.SMART_INDENT_ON_ENTER && action2.isIndentAdjustmentNeeded()) {
            CodeStyleManager.getInstance(project2).scheduleIndentAdjustment(document, editor.getCaretModel().getOffset());
        }
    }

    @NotNull
    private static DataContext getExtendedContext(@NotNull DataContext originalContext, @NotNull Project project2, @NotNull Caret caret) {
        if (originalContext == null) {
            EnterHandler.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            EnterHandler.$$$reportNull$$$0(3);
        }
        if (caret == null) {
            EnterHandler.$$$reportNull$$$0(4);
        }
        DataContext context = originalContext instanceof UserDataHolder ? originalContext : new DataContextWrapper(originalContext);
        ((UserDataHolder)((Object)context)).putUserData(CONTEXT_LANGUAGE, PsiUtilBase.getLanguageInEditor(caret, project2));
        DataContext dataContext = context;
        if (dataContext == null) {
            EnterHandler.$$$reportNull$$$0(5);
        }
        return dataContext;
    }

    public static boolean isCommentComplete(PsiComment comment, CodeDocumentationAwareCommenter commenter, Editor editor) {
        JavaLikeQuoteHandler javaLikeQuoteHandler;
        String expectedCommentEnd;
        for (CommentCompleteHandler handler2 : CommentCompleteHandler.EP_NAME.getExtensionList()) {
            if (!handler2.isApplicable(comment, commenter)) continue;
            return handler2.isCommentComplete(comment, commenter, editor);
        }
        String commentText = comment.getText();
        boolean docComment = EnterHandler.isDocComment(comment, commenter);
        String string = expectedCommentEnd = docComment ? commenter.getDocumentationCommentSuffix() : commenter.getBlockCommentSuffix();
        if (!commentText.endsWith(expectedCommentEnd)) {
            return false;
        }
        PsiFile containingFile = comment.getContainingFile();
        Language language2 = containingFile.getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language2);
        if (parserDefinition == null) {
            return true;
        }
        Lexer lexer = parserDefinition.createLexer(containingFile.getProject());
        String commentPrefix = docComment ? commenter.getDocumentationCommentPrefix() : commenter.getBlockCommentPrefix();
        lexer.start(commentText, commentPrefix == null ? 0 : commentPrefix.length(), commentText.length());
        QuoteHandler fileTypeHandler = TypedHandler.getQuoteHandler(containingFile, editor);
        JavaLikeQuoteHandler javaLikeQuoteHandler2 = javaLikeQuoteHandler = fileTypeHandler instanceof JavaLikeQuoteHandler ? (JavaLikeQuoteHandler)fileTypeHandler : null;
        IElementType tokenType;
        while ((tokenType = lexer.getTokenType()) != null) {
            if (javaLikeQuoteHandler != null && javaLikeQuoteHandler.getStringTokenTypes() != null && javaLikeQuoteHandler.getStringTokenTypes().contains(tokenType)) {
                String text2 = commentText.substring(lexer.getTokenStart(), lexer.getTokenEnd());
                int endOffset = comment.getTextRange().getEndOffset();
                if (text2.endsWith(expectedCommentEnd) && endOffset < containingFile.getTextLength() && containingFile.getText().charAt(endOffset) == '\n') {
                    return true;
                }
            }
            if (tokenType == commenter.getDocumentationCommentTokenType() || tokenType == commenter.getBlockCommentTokenType()) {
                return false;
            }
            if (tokenType == commenter.getLineCommentTokenType() && lexer.getTokenText().contains(commentPrefix)) {
                return false;
            }
            if (lexer.getTokenEnd() == commentText.length()) {
                if (tokenType == commenter.getLineCommentTokenType()) {
                    String prefix = commenter.getLineCommentPrefix();
                    lexer.start(commentText, lexer.getTokenStart() + (prefix == null ? 0 : prefix.length()), commentText.length());
                    lexer.advance();
                    continue;
                }
                return !EnterHandler.isInvalidPsi(comment);
            }
            lexer.advance();
        }
        return false;
    }

    private static boolean isInvalidPsi(@NotNull PsiElement base) {
        if (base == null) {
            EnterHandler.$$$reportNull$$$0(6);
        }
        for (PsiElement current2 = base.getNextSibling(); current2 != null; current2 = current2.getNextSibling()) {
            if (!(current2 instanceof PsiErrorElement)) continue;
            return true;
        }
        return base.getPrevSibling() instanceof PsiErrorElement;
    }

    private static boolean isDocComment(PsiElement element2, CodeDocumentationAwareCommenter commenter) {
        if (!(element2 instanceof PsiComment)) {
            return false;
        }
        PsiComment comment = (PsiComment)element2;
        return commenter.isDocumentationComment(comment);
    }

    public static int adjustLineIndentNoCommit(Language language2, @NotNull Document document, @NotNull Editor editor, int offset) {
        if (document == null) {
            EnterHandler.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            EnterHandler.$$$reportNull$$$0(8);
        }
        CharSequence docChars = document.getCharsSequence();
        int indentStart = CharArrayUtil.shiftBackwardUntil(docChars, offset - 1, "\n") + 1;
        int indentEnd = CharArrayUtil.shiftForward(docChars, indentStart, " \t");
        String newIndent = CodeStyleFacade.getInstance(editor.getProject()).getLineIndent(editor, language2, offset, false);
        if (newIndent == null) {
            return -1;
        }
        if (newIndent == LineIndentProvider.DO_NOT_ADJUST) {
            return offset;
        }
        int delta = newIndent.length() - (indentEnd - indentStart);
        document.replaceString(indentStart, indentEnd, newIndent);
        return offset <= indentEnd ? indentStart + newIndent.length() : offset + delta;
    }

    @Nullable
    public static Language getLanguage(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            EnterHandler.$$$reportNull$$$0(9);
        }
        if (dataContext instanceof UserDataHolder) {
            return CONTEXT_LANGUAGE.get((UserDataHolder)((Object)dataContext));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/EnterHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/EnterHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendedContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledForCaret";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getExtendedContext";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInvalidPsi";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "adjustLineIndentNoCommit";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DoEnterAction
    implements Runnable {
        private final DataContext myDataContext;
        private final PsiFile myFile;
        private int myOffset;
        private final Document myDocument;
        private final boolean myInsertSpace;
        private final Editor myEditor;
        private final Project myProject;
        private int myCaretAdvance;
        private boolean myForceIndent = false;
        private static final String LINE_SEPARATOR = "\n";
        private boolean myIsIndentAdjustmentNeeded = true;

        DoEnterAction(PsiFile file2, Editor view, Document document, DataContext dataContext, int offset, boolean insertSpace, int caretAdvance, Project project2) {
            this.myEditor = view;
            this.myFile = file2;
            this.myDataContext = dataContext;
            this.myOffset = offset;
            this.myDocument = document;
            this.myInsertSpace = insertSpace;
            this.myCaretAdvance = caretAdvance;
            this.myProject = project2;
        }

        public void setForceIndent(boolean forceIndent) {
            this.myForceIndent = forceIndent;
        }

        @Override
        public void run() {
            CaretModel caretModel = this.myEditor.getCaretModel();
            try {
                int line;
                PsiElement element2;
                CharSequence chars = this.myDocument.getCharsSequence();
                int i = CharArrayUtil.shiftBackwardUntil(chars, this.myOffset - 1, LINE_SEPARATOR) - 1;
                i = CharArrayUtil.shiftBackwardUntil(chars, i, LINE_SEPARATOR) + 1;
                if (i < 0) {
                    i = 0;
                }
                int lineStart = CharArrayUtil.shiftForward(chars, i, " \t");
                Language language2 = this.myDataContext instanceof UserDataHolder ? (Language)CONTEXT_LANGUAGE.get((UserDataHolder)((Object)this.myDataContext)) : null;
                Commenter langCommenter = language2 != null ? (Commenter)LanguageCommenters.INSTANCE.forLanguage(language2) : null;
                CodeDocumentationUtil.CommentContext commentContext = CodeDocumentationUtil.tryParseCommentContext(langCommenter, chars, lineStart);
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance(this.getProject());
                if (commentContext.docStart) {
                    psiDocumentManager.commitDocument(this.myDocument);
                    element2 = this.myFile.findElementAt(commentContext.lineStart);
                    String text2 = element2.getText();
                    PsiElement parent = element2.getParent();
                    if (text2.equals(commentContext.commenter.getDocumentationCommentPrefix()) && EnterHandler.isDocComment(parent, commentContext.commenter) || text2.startsWith(commentContext.commenter.getDocumentationCommentPrefix()) && element2 instanceof PsiComment) {
                        PsiComment comment = EnterHandler.isDocComment(parent, commentContext.commenter) ? (PsiComment)parent : (PsiComment)element2;
                        int commentEnd = comment.getTextRange().getEndOffset();
                        if (this.myOffset >= commentEnd) {
                            commentContext.docStart = false;
                        } else if (EnterHandler.isCommentComplete(comment, commentContext.commenter, this.myEditor)) {
                            commentContext.docAsterisk = this.myOffset >= commentEnd ? false : CodeStyleManager.getInstance(this.getProject()).getDocCommentSettings(this.myFile).isLeadingAsteriskEnabled();
                            commentContext.docStart = false;
                        } else {
                            this.generateJavadoc(commentContext.commenter);
                        }
                    } else {
                        commentContext.docStart = false;
                    }
                } else if (commentContext.docAsterisk) {
                    psiDocumentManager.commitDocument(this.myDocument);
                    element2 = this.myFile.findElementAt(commentContext.lineStart);
                    PsiComment comment = PsiTreeUtil.getParentOfType(element2, PsiComment.class, false);
                    if (comment == null || !EnterHandler.isDocComment(comment, commentContext.commenter)) {
                        commentContext.docAsterisk = false;
                    }
                }
                String indentInsideJavadoc = null;
                if (this.myOffset < this.myDocument.getTextLength() && (line = this.myDocument.getLineNumber(this.myOffset)) > 0 && (commentContext.docAsterisk || commentContext.docStart)) {
                    indentInsideJavadoc = CodeDocumentationUtil.getIndentInsideJavadoc(this.myDocument, this.myDocument.getLineStartOffset(line - 1));
                }
                if (commentContext.docAsterisk) {
                    commentContext.docAsterisk = this.insertDocAsterisk(commentContext.lineStart, commentContext.docAsterisk, !StringUtil.isEmpty(indentInsideJavadoc), commentContext.commenter);
                }
                boolean docIndentApplied = false;
                CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
                if (codeInsightSettings.SMART_INDENT_ON_ENTER || this.myForceIndent || commentContext.docStart || commentContext.docAsterisk) {
                    int offset = EnterHandler.adjustLineIndentNoCommit(EnterHandler.getLanguage(this.myDataContext), this.myDocument, this.myEditor, this.myOffset);
                    if (offset >= 0) {
                        this.myOffset = offset;
                        this.myIsIndentAdjustmentNeeded = false;
                    }
                    if (commentContext.docAsterisk && !StringUtil.isEmpty(indentInsideJavadoc) && this.myOffset < this.myDocument.getTextLength()) {
                        this.myDocument.insertString(this.myOffset + 1, indentInsideJavadoc);
                        this.myOffset += indentInsideJavadoc.length();
                        docIndentApplied = true;
                    }
                    if (this.myForceIndent && indentInsideJavadoc != null) {
                        int indentSize = CodeStyle.getSettings(this.myFile).getIndentSize(this.myFile.getFileType());
                        this.myDocument.insertString(this.myOffset + 1, StringUtil.repeatSymbol(' ', indentSize));
                        this.myCaretAdvance += indentSize;
                    }
                }
                if ((commentContext.docAsterisk || commentContext.docStart) && !docIndentApplied) {
                    char c;
                    if (this.myInsertSpace) {
                        if (this.myOffset == this.myDocument.getTextLength()) {
                            this.myDocument.insertString(this.myOffset, " ");
                        }
                        this.myDocument.insertString(this.myOffset + 1, " ");
                    }
                    if ((c = this.myDocument.getCharsSequence().charAt(this.myOffset)) != '\n') {
                        ++this.myOffset;
                    }
                }
                if (commentContext.docAsterisk && !commentContext.docStart) {
                    ++this.myCaretAdvance;
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error(e);
            }
            this.myOffset = Math.min(this.myOffset, this.myDocument.getTextLength());
            caretModel.moveToOffset(this.myOffset);
            EditorModificationUtil.scrollToCaret(this.myEditor);
            this.myEditor.getSelectionModel().removeSelection();
            if (this.myCaretAdvance != 0) {
                LogicalPosition caretPosition = caretModel.getLogicalPosition();
                LogicalPosition pos = new LogicalPosition(caretPosition.line, caretPosition.column + this.myCaretAdvance);
                caretModel.moveToLogicalPosition(pos);
            }
        }

        private void generateJavadoc(CodeDocumentationAwareCommenter commenter) throws IncorrectOperationException {
            CodeInsightSettings settings = CodeInsightSettings.getInstance();
            StringBuilder buffer = new StringBuilder();
            String docCommentLinePrefix = commenter.getDocumentationCommentLinePrefix();
            if (docCommentLinePrefix == null) {
                return;
            }
            buffer.append(docCommentLinePrefix);
            if (DataManager.getInstance().loadFromDataContext(this.myDataContext, AutoHardWrapHandler.AUTO_WRAP_LINE_IN_PROGRESS_KEY) == Boolean.TRUE) {
                this.myDocument.insertString(this.myOffset, buffer);
                buffer = new StringBuilder(LINE_SEPARATOR).append(commenter.getDocumentationCommentSuffix());
                int line = this.myDocument.getLineNumber(this.myOffset);
                this.myOffset = this.myDocument.getLineEndOffset(line);
            } else {
                buffer.append(LINE_SEPARATOR);
                buffer.append(commenter.getDocumentationCommentSuffix());
            }
            PsiComment comment = this.createComment(buffer, settings);
            if (comment == null) {
                return;
            }
            this.myOffset = comment.getTextRange().getStartOffset();
            CharSequence text2 = this.myDocument.getCharsSequence();
            this.myOffset = CharArrayUtil.shiftForwardUntil(text2, this.myOffset, LINE_SEPARATOR);
            this.myOffset = CharArrayUtil.shiftForward(text2, this.myOffset, LINE_SEPARATOR);
            this.myOffset = CharArrayUtil.shiftForwardUntil(text2, this.myOffset, docCommentLinePrefix) + 1;
            DoEnterAction.removeTrailingSpaces(this.myDocument, this.myOffset);
            if (!CodeStyleManager.getInstance(this.getProject()).getDocCommentSettings(this.myFile).isLeadingAsteriskEnabled()) {
                LOG.assertTrue(CharArrayUtil.regionMatches(this.myDocument.getCharsSequence(), this.myOffset - docCommentLinePrefix.length(), docCommentLinePrefix));
                this.myDocument.deleteString(this.myOffset - docCommentLinePrefix.length(), this.myOffset);
                --this.myOffset;
            } else {
                this.myDocument.insertString(this.myOffset, " ");
                ++this.myOffset;
            }
            PsiDocumentManager.getInstance(this.getProject()).commitAllDocuments();
        }

        @Nullable
        private PsiComment createComment(CharSequence buffer, CodeInsightSettings settings) throws IncorrectOperationException {
            this.myDocument.insertString(this.myOffset, buffer);
            PsiDocumentManager.getInstance(this.getProject()).commitAllDocuments();
            CodeStyleManager.getInstance(this.getProject()).adjustLineIndent(this.myFile, this.myOffset + buffer.length() - 2);
            PsiComment comment = (PsiComment)PsiTreeUtil.getNonStrictParentOfType(this.myFile.findElementAt(this.myOffset), PsiComment.class);
            comment = this.createJavaDocStub(settings, comment, this.getProject());
            if (comment == null) {
                return null;
            }
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance(this.getProject());
            Ref<PsiComment> commentRef = Ref.create(comment);
            codeStyleManager.runWithDocCommentFormattingDisabled(this.myFile, () -> this.formatComment(commentRef, codeStyleManager));
            comment = commentRef.get();
            PsiElement next = comment.getNextSibling();
            if (next == null && comment.getParent().getClass() == comment.getClass()) {
                next = comment.getParent().getNextSibling();
            }
            if (next != null) {
                next = this.myFile.findElementAt(next.getTextRange().getStartOffset());
            }
            if (!(next == null || FormatterUtil.containsWhiteSpacesOnly(next.getNode()) && next.getText().contains(LINE_SEPARATOR))) {
                int lineBreakOffset = comment.getTextRange().getEndOffset();
                this.myDocument.insertString(lineBreakOffset, LINE_SEPARATOR);
                PsiDocumentManager.getInstance(this.getProject()).commitAllDocuments();
                codeStyleManager.adjustLineIndent(this.myFile, lineBreakOffset + 1);
                comment = (PsiComment)PsiTreeUtil.getNonStrictParentOfType(this.myFile.findElementAt(this.myOffset), PsiComment.class);
            }
            return comment;
        }

        private void formatComment(Ref<PsiComment> commentRef, CodeStyleManager codeStyleManager) {
            PsiComment comment = commentRef.get();
            RangeMarker commentMarker = this.myDocument.createRangeMarker(comment.getTextRange().getStartOffset(), comment.getTextRange().getEndOffset());
            codeStyleManager.reformatNewlyAddedElement(comment.getNode().getTreeParent(), comment.getNode());
            commentRef.set((PsiComment)PsiTreeUtil.getNonStrictParentOfType(this.myFile.findElementAt(commentMarker.getStartOffset()), PsiComment.class));
            commentMarker.dispose();
        }

        @Nullable
        private PsiComment createJavaDocStub(CodeInsightSettings settings, PsiComment comment, Project project2) {
            if (settings.JAVADOC_STUB_ON_ENTER) {
                CodeDocumentationProvider docProvider;
                DocumentationProvider langDocumentationProvider = LanguageDocumentation.INSTANCE.forLanguage(comment.getParent().getLanguage());
                if (langDocumentationProvider instanceof CompositeDocumentationProvider) {
                    docProvider = ((CompositeDocumentationProvider)langDocumentationProvider).getFirstCodeDocumentationProvider();
                } else {
                    CodeDocumentationProvider codeDocumentationProvider = docProvider = langDocumentationProvider instanceof CodeDocumentationProvider ? (CodeDocumentationProvider)langDocumentationProvider : null;
                }
                if (docProvider != null) {
                    if (docProvider.findExistingDocComment(comment) != comment) {
                        return comment;
                    }
                    String docStub = DumbService.getInstance(project2).computeWithAlternativeResolveEnabled(() -> docProvider.generateDocumentationContentStub(comment));
                    if (docStub != null && docStub.length() != 0) {
                        this.myOffset = CharArrayUtil.shiftForwardUntil(this.myDocument.getCharsSequence(), this.myOffset, LINE_SEPARATOR);
                        this.myOffset = CharArrayUtil.shiftForward(this.myDocument.getCharsSequence(), this.myOffset, LINE_SEPARATOR);
                        this.myDocument.insertString(this.myOffset, docStub);
                    }
                }
                PsiDocumentManager.getInstance(project2).commitAllDocuments();
                return (PsiComment)PsiTreeUtil.getNonStrictParentOfType(this.myFile.findElementAt(this.myOffset), PsiComment.class);
            }
            return comment;
        }

        private Project getProject() {
            return this.myFile.getProject();
        }

        private static void removeTrailingSpaces(Document document, int startOffset) {
            int endOffset = startOffset;
            CharSequence charsSequence = document.getCharsSequence();
            for (int i = startOffset; i < charsSequence.length(); ++i) {
                char c = charsSequence.charAt(i);
                endOffset = i;
                if (c == '\n') break;
                if (c == ' ' || c == '\t') continue;
                return;
            }
            document.deleteString(startOffset, endOffset);
        }

        private boolean insertDocAsterisk(int lineStart, boolean docAsterisk, boolean previousLineIndentUsed, CodeDocumentationAwareCommenter commenter) {
            PsiDocumentManager.getInstance(this.myProject).commitDocument(this.myDocument);
            PsiElement atLineStart = this.myFile.findElementAt(lineStart);
            if (atLineStart == null) {
                return false;
            }
            String linePrefix = commenter.getDocumentationCommentLinePrefix();
            String docPrefix = commenter.getDocumentationCommentPrefix();
            String text2 = atLineStart.getText();
            TextRange textRange = atLineStart.getTextRange();
            if (text2.equals(linePrefix) || text2.equals(docPrefix) || docPrefix != null && text2.regionMatches(lineStart - textRange.getStartOffset(), docPrefix, 0, docPrefix.length()) || linePrefix != null && text2.regionMatches(lineStart - textRange.getStartOffset(), linePrefix, 0, linePrefix.length())) {
                PsiComment comment;
                PsiElement element2 = this.myFile.findElementAt(this.myOffset);
                if (element2 == null) {
                    return false;
                }
                PsiComment psiComment = comment = element2 instanceof PsiComment ? (PsiComment)element2 : PsiTreeUtil.getParentOfType(element2, PsiComment.class, false);
                if (comment != null) {
                    int commentEnd = comment.getTextRange().getEndOffset();
                    if (this.myOffset >= commentEnd || lineStart < comment.getTextOffset()) {
                        docAsterisk = false;
                    } else {
                        DoEnterAction.removeTrailingSpaces(this.myDocument, this.myOffset);
                        String toInsert = previousLineIndentUsed ? "*" : CodeDocumentationUtil.createDocCommentLine("", this.myFile, commenter);
                        this.myDocument.insertString(this.myOffset, toInsert);
                        PsiDocumentManager.getInstance(this.getProject()).commitAllDocuments();
                    }
                } else {
                    docAsterisk = false;
                }
            } else {
                docAsterisk = false;
            }
            return docAsterisk;
        }

        public boolean isIndentAdjustmentNeeded() {
            return this.myIsIndentAdjustmentNeeded;
        }
    }
}

