/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.documentation.DocCommentFixer;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.LanguageDocumentation;
import com.intellij.lang.documentation.CodeDocumentationProvider;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.DocCommentSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FixDocCommentAction
extends EditorAction {
    @NotNull
    @NonNls
    public static final String ACTION_ID = "FixDocComment";

    public FixDocCommentAction() {
        super(new MyHandler());
    }

    private static void process(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Project project2, int offset) {
        PsiElement elementAtOffset;
        if (file2 == null) {
            FixDocCommentAction.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            FixDocCommentAction.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            FixDocCommentAction.$$$reportNull$$$0(2);
        }
        if ((elementAtOffset = file2.findElementAt(offset)) == null || !FileModificationService.getInstance().preparePsiElementForWrite(elementAtOffset)) {
            return;
        }
        FixDocCommentAction.generateOrFixComment(elementAtOffset, project2, editor);
    }

    public static void generateOrFixComment(@NotNull PsiElement element2, @NotNull Project project2, @NotNull Editor editor) {
        Runnable task2;
        Language language2;
        DocumentationProvider langDocumentationProvider;
        CodeDocumentationProvider docProvider;
        if (element2 == null) {
            FixDocCommentAction.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            FixDocCommentAction.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            FixDocCommentAction.$$$reportNull$$$0(5);
        }
        if ((docProvider = (langDocumentationProvider = LanguageDocumentation.INSTANCE.forLanguage(language2 = element2.getLanguage())) instanceof CompositeDocumentationProvider ? ((CompositeDocumentationProvider)langDocumentationProvider).getFirstCodeDocumentationProvider() : (langDocumentationProvider instanceof CodeDocumentationProvider ? (CodeDocumentationProvider)langDocumentationProvider : null)) == null) {
            return;
        }
        Pair<PsiElement, PsiComment> pair = docProvider.parseContext(element2);
        if (pair == null) {
            return;
        }
        Commenter c = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language2);
        if (!(c instanceof CodeDocumentationAwareCommenter)) {
            return;
        }
        CodeDocumentationAwareCommenter commenter = (CodeDocumentationAwareCommenter)c;
        if (pair.second == null || ((PsiComment)pair.second).getTextRange().isEmpty()) {
            task2 = () -> FixDocCommentAction.generateComment((PsiElement)pair.first, editor, docProvider, commenter, project2);
        } else {
            DocCommentFixer fixer = DocCommentFixer.EXTENSION.forLanguage(language2);
            if (fixer == null) {
                return;
            }
            task2 = () -> fixer.fixComment(project2, editor, (PsiComment)pair.second);
        }
        Runnable command = () -> ApplicationManager.getApplication().runWriteAction(task2);
        CommandProcessor.getInstance().executeCommand(project2, command, CodeInsightBundle.message("command.fix.documentation", new Object[0]), null);
    }

    private static void generateComment(@NotNull PsiElement anchor2, @NotNull Editor editor, @NotNull CodeDocumentationProvider documentationProvider, @NotNull CodeDocumentationAwareCommenter commenter, @NotNull Project project2) {
        char c;
        String linePrefix;
        int commentStartOffset;
        Document document;
        int lineStartOffset;
        if (anchor2 == null) {
            FixDocCommentAction.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            FixDocCommentAction.$$$reportNull$$$0(7);
        }
        if (documentationProvider == null) {
            FixDocCommentAction.$$$reportNull$$$0(8);
        }
        if (commenter == null) {
            FixDocCommentAction.$$$reportNull$$$0(9);
        }
        if (project2 == null) {
            FixDocCommentAction.$$$reportNull$$$0(10);
        }
        if ((lineStartOffset = (document = editor.getDocument()).getLineStartOffset(document.getLineNumber(commentStartOffset = anchor2.getTextRange().getStartOffset()))) > 0 && lineStartOffset < commentStartOffset) {
            int nonWhiteSpaceOffset = CharArrayUtil.shiftBackward(document.getCharsSequence(), commentStartOffset - 1, " \t");
            commentStartOffset = Math.max(nonWhiteSpaceOffset, lineStartOffset);
        }
        int commentBodyRelativeOffset = 0;
        int caretOffsetToSet = -1;
        StringBuilder buffer = new StringBuilder();
        String commentPrefix = commenter.getDocumentationCommentPrefix();
        if (commentPrefix != null) {
            buffer.append(commentPrefix).append("\n");
            commentBodyRelativeOffset += commentPrefix.length() + 1;
        }
        if ((linePrefix = commenter.getDocumentationCommentLinePrefix()) != null) {
            buffer.append(linePrefix);
            caretOffsetToSet = commentStartOffset + (commentBodyRelativeOffset += linePrefix.length());
        }
        buffer.append("\n");
        ++commentBodyRelativeOffset;
        String commentSuffix = commenter.getDocumentationCommentSuffix();
        if (commentSuffix != null) {
            buffer.append(commentSuffix).append("\n");
        }
        if (buffer.length() <= 0) {
            return;
        }
        document.insertString(commentStartOffset, buffer);
        PsiDocumentManager docManager = PsiDocumentManager.getInstance(project2);
        docManager.commitDocument(document);
        Pair<PsiElement, PsiComment> pair = documentationProvider.parseContext(anchor2);
        if (pair == null || pair.second == null) {
            return;
        }
        String stub = documentationProvider.generateDocumentationContentStub((PsiComment)pair.second);
        CaretModel caretModel = editor.getCaretModel();
        if (stub != null) {
            int insertionOffset = commentStartOffset + commentBodyRelativeOffset;
            document.insertString(insertionOffset, stub);
            docManager.commitDocument(document);
            pair = documentationProvider.parseContext(anchor2);
        }
        if (caretOffsetToSet >= 0) {
            caretModel.moveToOffset(caretOffsetToSet);
            editor.getSelectionModel().removeSelection();
        }
        if (pair == null || pair.second == null) {
            return;
        }
        int start2 = Math.min(FixDocCommentAction.calcStartReformatOffset((PsiElement)pair.first), FixDocCommentAction.calcStartReformatOffset((PsiElement)pair.second));
        int end = ((PsiComment)pair.second).getTextRange().getEndOffset();
        FixDocCommentAction.reformatCommentKeepingEmptyTags(anchor2.getContainingFile(), project2, start2, end);
        editor.getCaretModel().moveToOffset(document.getLineEndOffset(document.getLineNumber(editor.getCaretModel().getOffset())));
        int caretOffset = caretModel.getOffset();
        if (caretOffset > 0 && caretOffset <= document.getTextLength() && !StringUtil.isWhiteSpace(c = document.getCharsSequence().charAt(caretOffset - 1))) {
            document.insertString(caretOffset, " ");
            caretModel.moveToOffset(caretOffset + 1);
        }
    }

    private static void reformatCommentKeepingEmptyTags(@NotNull PsiFile file2, @NotNull Project project2, int start2, int end) {
        if (file2 == null) {
            FixDocCommentAction.$$$reportNull$$$0(11);
        }
        if (project2 == null) {
            FixDocCommentAction.$$$reportNull$$$0(12);
        }
        CodeStyleSettings tempSettings = CodeStyle.getSettings(file2).clone();
        LanguageCodeStyleSettingsProvider langProvider = LanguageCodeStyleSettingsProvider.forLanguage(file2.getLanguage());
        if (langProvider != null) {
            DocCommentSettings docCommentSettings = langProvider.getDocCommentSettings(tempSettings);
            docCommentSettings.setRemoveEmptyTags(false);
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance(project2);
        CodeStyle.doWithTemporarySettings(project2, tempSettings, () -> codeStyleManager.reformatText(file2, start2, end));
    }

    private static int calcStartReformatOffset(@NotNull PsiElement element2) {
        if (element2 == null) {
            FixDocCommentAction.$$$reportNull$$$0(13);
        }
        int result2 = element2.getTextRange().getStartOffset();
        for (PsiElement e = element2.getPrevSibling(); e != null && e instanceof PsiWhiteSpace; e = e.getPrevSibling()) {
            result2 = e.getTextRange().getStartOffset();
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentationProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commenter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/FixDocCommentAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "generateOrFixComment";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "generateComment";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "reformatCommentKeepingEmptyTags";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "calcStartReformatOffset";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyHandler
    extends EditorActionHandler {
        private MyHandler() {
        }

        @Override
        public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            Project project2;
            if (editor == null) {
                MyHandler.$$$reportNull$$$0(0);
            }
            if ((project2 = CommonDataKeys.PROJECT.getData(dataContext)) == null) {
                return;
            }
            PsiFile psiFile = CommonDataKeys.PSI_FILE.getData(dataContext);
            if (psiFile == null) {
                return;
            }
            FixDocCommentAction.process(psiFile, editor, project2, editor.getCaretModel().getOffset());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/FixDocCommentAction$MyHandler", "doExecute"));
        }
    }
}

