/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.editorActions.JoinLinesHandlerDelegate;
import com.intellij.codeInsight.editorActions.JoinRawLinesHandlerDelegate;
import com.intellij.formatting.FormatterEx;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.ide.DataManager;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JoinLinesHandler
extends EditorActionHandler {
    private static final Logger LOG = Logger.getInstance(JoinLinesHandler.class);
    private final EditorActionHandler myOriginalHandler;

    public JoinLinesHandler(EditorActionHandler originalHandler) {
        super(true);
        this.myOriginalHandler = originalHandler;
    }

    @Override
    public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        if (editor == null) {
            JoinLinesHandler.$$$reportNull$$$0(0);
        }
        assert (caret != null);
        if (editor.isViewer() || !EditorModificationUtil.requestWriting(editor)) {
            return;
        }
        if (!(editor.getDocument() instanceof DocumentEx)) {
            this.myOriginalHandler.execute(editor, caret, dataContext);
            return;
        }
        DocumentEx doc = (DocumentEx)editor.getDocument();
        Project project2 = CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(editor.getContentComponent()));
        if (project2 == null) {
            return;
        }
        PsiDocumentManager docManager = PsiDocumentManager.getInstance(project2);
        PsiFile psiFile = docManager.getPsiFile(doc);
        if (psiFile == null) {
            this.myOriginalHandler.execute(editor, caret, dataContext);
            return;
        }
        LogicalPosition caretPosition = caret.getLogicalPosition();
        int startLine = caretPosition.line;
        int endLine = startLine + 1;
        if (caret.hasSelection()) {
            startLine = doc.getLineNumber(caret.getSelectionStart());
            endLine = doc.getLineNumber(caret.getSelectionEnd());
            if (doc.getLineStartOffset(endLine) == caret.getSelectionEnd()) {
                --endLine;
            }
        }
        if (endLine >= doc.getLineCount()) {
            return;
        }
        int lineCount = endLine - startLine;
        int line = startLine;
        ((ApplicationImpl)ApplicationManager.getApplication()).runWriteActionWithCancellableProgressInDispatchThread("Join Lines", project2, null, indicator -> {
            indicator.setIndeterminate(false);
            JoinLineProcessor processor2 = new JoinLineProcessor(doc, psiFile, line, (ProgressIndicator)indicator);
            processor2.process(editor, caret, lineCount);
        });
    }

    @Contract(pure=true)
    private static int checkOffset(int offset, JoinLinesHandlerDelegate delegate, DocumentEx doc) {
        if (offset == -1) {
            return offset;
        }
        if (offset < 0) {
            LOG.error("Handler returned negative offset: handler class=" + delegate.getClass() + "; offset=" + offset);
            return 0;
        }
        if (offset > doc.getTextLength()) {
            LOG.error("Handler returned an offset which exceeds the document length: handler class=" + delegate.getClass() + "; offset=" + offset + "; length=" + doc.getTextLength());
            return doc.getTextLength();
        }
        return offset;
    }

    private static boolean tryConvertEndOfLineComment(PsiElement commentElement) {
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(commentElement.getLanguage());
        if (commenter instanceof CodeDocumentationAwareCommenter) {
            CodeDocumentationAwareCommenter docCommenter = (CodeDocumentationAwareCommenter)commenter;
            String lineCommentPrefix = commenter.getLineCommentPrefix();
            String blockCommentPrefix = commenter.getBlockCommentPrefix();
            String blockCommentSuffix = commenter.getBlockCommentSuffix();
            if (commentElement.getNode().getElementType() == docCommenter.getLineCommentTokenType() && blockCommentPrefix != null && blockCommentSuffix != null && lineCommentPrefix != null) {
                String commentText = StringUtil.trimStart(commentElement.getText(), lineCommentPrefix);
                String suffix = docCommenter.getBlockCommentSuffix();
                if (suffix != null && suffix.length() > 1) {
                    String fixedSuffix = suffix.charAt(0) + " " + suffix.substring(1);
                    commentText = commentText.replace(suffix, fixedSuffix);
                }
                try {
                    Project project2 = commentElement.getProject();
                    PsiParserFacade parserFacade = PsiParserFacade.SERVICE.getInstance(project2);
                    PsiComment newComment = parserFacade.createBlockCommentFromText(commentElement.getLanguage(), commentText);
                    commentElement.replace(newComment);
                    return true;
                }
                catch (IncorrectOperationException e) {
                    LOG.info("Failed to replace line comment with block comment", e);
                }
            }
        }
        return false;
    }

    private static PsiComment getCommentElement(@Nullable PsiElement element2) {
        return PsiTreeUtil.getParentOfType(element2, PsiComment.class, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/JoinLinesHandler", "doExecute"));
    }

    private static class JoinLinesOffsets {
        final int lineEndOffset;
        final int lastNonSpaceOffsetInStartLine;
        final int firstNonSpaceOffsetInNextLine;

        JoinLinesOffsets(Document doc, int startLine) {
            CharSequence text2 = doc.getCharsSequence();
            this.lineEndOffset = doc.getLineEndOffset(startLine);
            this.firstNonSpaceOffsetInNextLine = StringUtil.skipWhitespaceForward(text2, doc.getLineStartOffset(startLine + 1));
            this.lastNonSpaceOffsetInStartLine = StringUtil.skipWhitespaceBackward(text2, this.lineEndOffset);
        }
    }

    private static class JoinLineProcessor {
        @NotNull
        private final DocumentEx myDoc;
        @NotNull
        private final PsiFile myFile;
        private int myLine;
        @NotNull
        private final PsiDocumentManager myManager;
        @NotNull
        private final CodeStyleManager myStyleManager;
        @NotNull
        private final ProgressIndicator myIndicator;
        int myCaretRestoreOffset;

        JoinLineProcessor(@NotNull DocumentEx doc, @NotNull PsiFile file2, int line, @NotNull ProgressIndicator indicator) {
            if (doc == null) {
                JoinLineProcessor.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                JoinLineProcessor.$$$reportNull$$$0(1);
            }
            if (indicator == null) {
                JoinLineProcessor.$$$reportNull$$$0(2);
            }
            this.myCaretRestoreOffset = -1;
            this.myDoc = doc;
            this.myFile = file2;
            this.myLine = line;
            this.myIndicator = indicator;
            Project project2 = file2.getProject();
            this.myManager = PsiDocumentManager.getInstance(project2);
            this.myStyleManager = CodeStyleManager.getInstance(project2);
        }

        void process(@NotNull Editor editor, @NotNull Caret caret, int lineCount) {
            if (editor == null) {
                JoinLineProcessor.$$$reportNull$$$0(3);
            }
            if (caret == null) {
                JoinLineProcessor.$$$reportNull$$$0(4);
            }
            this.myStyleManager.performActionWithFormatterDisabled(() -> this.doProcess(lineCount));
            this.positionCaret(editor, caret);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doProcess(int lineCount) {
            ArrayList<RangeMarker> markers = new ArrayList<RangeMarker>();
            try {
                this.myIndicator.setText2(CodeInsightBundle.message("progress.text.converting.end.of.line.comments", new Object[0]));
                this.convertEndComments(lineCount);
                this.myIndicator.setText2(CodeInsightBundle.message("progress.text.removing.line.breaks", new Object[0]));
                int newCount = this.processRawJoiners(lineCount);
                DocumentUtil.executeInBulk(this.myDoc, newCount > 100, () -> this.removeLineBreaks(newCount, markers));
                this.myIndicator.setText2(CodeInsightBundle.message("progress.text.postprocessing", new Object[0]));
                List<RangeMarker> unprocessed = this.processNonRawJoiners(markers);
                this.myIndicator.setText2(CodeInsightBundle.message("progress.text.adjusting.white.space", new Object[0]));
                this.adjustWhiteSpace(unprocessed);
            }
            finally {
                markers.forEach(RangeMarker::dispose);
            }
        }

        private void convertEndComments(int lineCount) {
            ArrayList<PsiComment> endComments = new ArrayList<PsiComment>();
            CharSequence text2 = this.myDoc.getCharsSequence();
            for (int i = 0; i < lineCount; ++i) {
                int nextStart;
                PsiComment comment;
                this.myIndicator.checkCanceled();
                this.myIndicator.setFraction(0.05 * (double)i / (double)lineCount);
                int line = this.myLine + i;
                int lineEnd = this.myDoc.getLineEndOffset(line);
                int lastNonSpaceOffset = StringUtil.skipWhitespaceBackward(text2, lineEnd);
                if (lastNonSpaceOffset <= this.myDoc.getLineStartOffset(line) || (comment = JoinLinesHandler.getCommentElement(this.myFile.findElementAt(lastNonSpaceOffset - 1))) == null || (nextStart = CharArrayUtil.shiftForward(text2, this.myDoc.getLineStartOffset(line + 1), " \t\n")) >= text2.length() || this.myDoc.getLineNumber(nextStart) > this.myLine + lineCount || JoinLinesHandler.getCommentElement(this.myFile.findElementAt(nextStart)) != null) continue;
                endComments.add(comment);
            }
            boolean changed2 = false;
            for (int i = 0; i < endComments.size(); ++i) {
                this.myIndicator.checkCanceled();
                this.myIndicator.setFraction(0.05 + 0.05 * (double)i / (double)endComments.size());
                PsiComment comment = (PsiComment)endComments.get(i);
                changed2 |= JoinLinesHandler.tryConvertEndOfLineComment(comment);
            }
            if (changed2) {
                this.myManager.doPostponedOperationsAndUnblockDocument(this.myDoc);
            }
        }

        private int processRawJoiners(int lineCount) {
            int startLine = this.myLine;
            List<JoinLinesHandlerDelegate> list2 = JoinLinesHandlerDelegate.EP_NAME.getExtensionList();
            int beforeLines = this.myDoc.getLineCount();
            CharSequence text2 = this.myDoc.getCharsSequence();
            int finalLine = this.myLine + lineCount;
            int finalOffset = this.myDoc.getLineEndOffset(this.myLine + lineCount);
            while (startLine < finalLine) {
                this.myIndicator.checkCanceled();
                this.myIndicator.setFraction(0.1 + 0.2 * (double)(startLine - this.myLine) / (double)Math.max(1, finalLine - this.myLine));
                int rc = -1;
                int lineEndOffset = this.myDoc.getLineEndOffset(startLine);
                int start2 = StringUtil.skipWhitespaceBackward(text2, lineEndOffset);
                int end = CharArrayUtil.shiftForward(text2, lineEndOffset, finalOffset, " \t\n");
                int linesToJoin = this.myDoc.getLineNumber(end) - startLine;
                JoinRawLinesHandlerDelegate rawJoiner = null;
                if (end < finalOffset && start2 > 0 && text2.charAt(start2 - 1) != '\n') {
                    for (JoinLinesHandlerDelegate delegate : list2) {
                        if (!(delegate instanceof JoinRawLinesHandlerDelegate) || (rc = (rawJoiner = (JoinRawLinesHandlerDelegate)delegate).tryJoinRawLines(this.myDoc, this.myFile, start2, end)) == -1) continue;
                        this.myCaretRestoreOffset = JoinLinesHandler.checkOffset(rc, delegate, this.myDoc);
                        break;
                    }
                }
                if (rc == -1) {
                    startLine += linesToJoin;
                    continue;
                }
                this.myManager.doPostponedOperationsAndUnblockDocument(this.myDoc);
                this.myManager.commitDocument(this.myDoc);
                int afterLines = this.myDoc.getLineCount();
                if (afterLines > beforeLines) {
                    LOG.error("Raw joiner increased number of lines: " + rawJoiner + " (" + rawJoiner.getClass() + ")");
                }
                if (afterLines >= beforeLines && this.myLine == startLine) {
                    ++this.myLine;
                    ++startLine;
                } else {
                    finalLine -= Math.max(beforeLines - afterLines, 1);
                }
                beforeLines = afterLines;
                text2 = this.myDoc.getCharsSequence();
                if (finalLine < startLine) continue;
                finalOffset = this.myDoc.getLineEndOffset(finalLine);
            }
            return startLine - this.myLine;
        }

        private void removeLineBreaks(int lineCount, List<RangeMarker> markers) {
            for (int i = 0; i < lineCount; ++i) {
                this.myIndicator.checkCanceled();
                this.myIndicator.setFraction(0.3 + 0.2 * (double)i / (double)lineCount);
                JoinLinesOffsets offsets2 = new JoinLinesOffsets(this.myDoc, this.myLine);
                if (offsets2.lastNonSpaceOffsetInStartLine == this.myDoc.getLineStartOffset(this.myLine)) {
                    this.myDoc.deleteString(this.myDoc.getLineStartOffset(this.myLine), offsets2.firstNonSpaceOffsetInNextLine);
                    this.myManager.commitDocument(this.myDoc);
                    int indent = this.myStyleManager.adjustLineIndent(this.myFile, this.myLine == 0 ? 0 : this.myDoc.getLineStartOffset(this.myLine));
                    if (this.myCaretRestoreOffset != -1) continue;
                    this.myCaretRestoreOffset = indent;
                    continue;
                }
                this.myDoc.deleteString(offsets2.lineEndOffset, offsets2.lineEndOffset + this.myDoc.getLineSeparatorLength(this.myLine));
                RangeMarker marker = this.myDoc.createRangeMarker(offsets2.lineEndOffset, offsets2.lineEndOffset);
                marker.setGreedyToLeft(true);
                marker.setGreedyToRight(true);
                markers.add(marker);
            }
            Collections.reverse(markers);
            this.myManager.commitDocument(this.myDoc);
        }

        private List<RangeMarker> processNonRawJoiners(List<RangeMarker> markers) {
            ArrayList<RangeMarker> unprocessed = new ArrayList<RangeMarker>();
            for (int i = 0; i < markers.size(); ++i) {
                this.myIndicator.checkCanceled();
                this.myIndicator.setFraction(0.5 + 0.2 * (double)i / (double)markers.size());
                RangeMarker marker = markers.get(i);
                if (!marker.isValid()) continue;
                Runnable doProcess = () -> {
                    if (!this.joinNonRaw(marker)) {
                        unprocessed.add(marker);
                    }
                };
                ProgressManager.getInstance().executeNonCancelableSection(doProcess);
            }
            return unprocessed;
        }

        private boolean joinNonRaw(RangeMarker marker) {
            JoinLinesHandlerDelegate delegate;
            CharSequence text2 = this.myDoc.getCharsSequence();
            int lineEndOffset = marker.getStartOffset();
            int start2 = StringUtil.skipWhitespaceBackward(text2, lineEndOffset) - 1;
            int end = StringUtil.skipWhitespaceForward(text2, lineEndOffset);
            int rc = -1;
            Iterator<JoinLinesHandlerDelegate> iterator2 = JoinLinesHandlerDelegate.EP_NAME.getExtensionList().iterator();
            while (iterator2.hasNext() && (rc = JoinLinesHandler.checkOffset((delegate = iterator2.next()).tryJoinLines(this.myDoc, this.myFile, start2, end), delegate, this.myDoc)) == -1) {
            }
            if (rc != -1) {
                RangeMarker posMarker = this.myDoc.createRangeMarker(rc, rc);
                this.myManager.doPostponedOperationsAndUnblockDocument(this.myDoc);
                if (this.myCaretRestoreOffset == -1 && posMarker.isValid()) {
                    this.myCaretRestoreOffset = posMarker.getStartOffset();
                }
                return true;
            }
            return false;
        }

        private void adjustWhiteSpace(List<RangeMarker> markers) {
            int size = markers.size();
            if (size == 0) {
                return;
            }
            int[] spacesToAdd = this.getSpacesToAdd(markers);
            DocumentUtil.executeInBulk(this.myDoc, size > 100, () -> {
                for (int i = 0; i < size; ++i) {
                    int replaceStart;
                    this.myIndicator.checkCanceled();
                    this.myIndicator.setFraction(0.95 + 0.05 * (double)i / (double)size);
                    RangeMarker marker = (RangeMarker)markers.get(i);
                    if (!marker.isValid()) continue;
                    CharSequence docText = this.myDoc.getCharsSequence();
                    int lineEndOffset = marker.getStartOffset();
                    int start2 = StringUtil.skipWhitespaceBackward(docText, lineEndOffset) - 1;
                    int end = StringUtil.skipWhitespaceForward(docText, lineEndOffset);
                    int n = replaceStart = start2 == lineEndOffset ? start2 : start2 + 1;
                    if (this.myCaretRestoreOffset == -1) {
                        this.myCaretRestoreOffset = replaceStart;
                    }
                    int spacesToCreate = spacesToAdd[i];
                    String spacing = StringUtil.repeatSymbol(' ', spacesToCreate);
                    this.myDoc.replaceString(replaceStart, end, spacing);
                }
            });
            this.myManager.commitDocument(this.myDoc);
        }

        private int[] getSpacesToAdd(List<RangeMarker> markers) {
            int size = markers.size();
            int[] spacesToAdd = new int[size];
            Arrays.fill(spacesToAdd, -1);
            CharSequence text2 = this.myDoc.getCharsSequence();
            FormattingModelBuilder builder2 = LanguageFormatting.INSTANCE.forContext(this.myFile);
            CodeStyleSettings settings = CodeStyle.getSettings(this.myFile);
            FormattingModel model = builder2 == null ? null : builder2.createModel(this.myFile, settings);
            FormatterEx formatter = FormatterEx.getInstance();
            for (int i = 0; i < size; ++i) {
                this.myIndicator.checkCanceled();
                this.myIndicator.setFraction(0.7 + 0.25 * (double)i / (double)size);
                RangeMarker marker = markers.get(i);
                if (!marker.isValid()) continue;
                int end = StringUtil.skipWhitespaceForward(text2, marker.getStartOffset());
                int spacesToCreate = end >= text2.length() || text2.charAt(end) == '\n' ? 0 : (model == null ? 1 : formatter.getSpacingForBlockAtOffset(model, end));
                spacesToAdd[i] = spacesToCreate < 0 ? 1 : spacesToCreate;
            }
            return spacesToAdd;
        }

        private void positionCaret(Editor editor, Caret caret) {
            if (caret.hasSelection()) {
                caret.moveToOffset(caret.getSelectionEnd());
            } else if (this.myCaretRestoreOffset != -1) {
                caret.moveToOffset(this.myCaretRestoreOffset);
                if (caret == editor.getCaretModel().getPrimaryCaret()) {
                    editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                }
                caret.removeSelection();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "doc";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/editorActions/JoinLinesHandler$JoinLineProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

