/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.CodeDocumentationUtil;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.text.CharArrayUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnterAfterJavadocTagHandler
extends EnterHandlerDelegateAdapter {
    private static final Context NOT_MATCHED_CONTEXT = new Context();

    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file2 == null) {
            EnterAfterJavadocTagHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            EnterAfterJavadocTagHandler.$$$reportNull$$$0(1);
        }
        if (caretOffset == null) {
            EnterAfterJavadocTagHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            EnterAfterJavadocTagHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            EnterAfterJavadocTagHandler.$$$reportNull$$$0(4);
        }
        if (!CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor.getDocument();
        CharSequence text2 = document.getCharsSequence();
        int line = document.getLineNumber(caretOffset.get());
        int start2 = document.getLineStartOffset(line);
        int end = document.getLineEndOffset(line);
        CodeDocumentationUtil.CommentContext commentContext = CodeDocumentationUtil.tryParseCommentContext(file2, text2, caretOffset.get(), start2);
        if (!commentContext.docAsterisk) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Context context = EnterAfterJavadocTagHandler.parse(text2, start2, end, caretOffset.get());
        if (!context.shouldGenerateLine()) {
            return context.shouldIndent() ? EnterHandlerDelegate.Result.DefaultForceIndent : EnterHandlerDelegate.Result.Continue;
        }
        String indentInsideJavadoc = CodeDocumentationUtil.getIndentInsideJavadoc(document, caretOffset.get());
        boolean restoreCaret = false;
        if (caretOffset.get() != context.endTagStartOffset) {
            editor.getCaretModel().moveToOffset(context.endTagStartOffset);
            restoreCaret = true;
        }
        originalHandler.execute(editor, editor.getCaretModel().getCurrentCaret(), dataContext);
        Project project2 = editor.getProject();
        if (indentInsideJavadoc != null && project2 != null && CodeStyleManager.getInstance(project2).getDocCommentSettings(file2).isLeadingAsteriskEnabled()) {
            document.insertString(editor.getCaretModel().getOffset(), "*" + indentInsideJavadoc);
        }
        if (restoreCaret) {
            editor.getCaretModel().moveToOffset(caretOffset.get());
        }
        return EnterHandlerDelegate.Result.DefaultForceIndent;
    }

    @NotNull
    static Context parse(@NotNull CharSequence text2, int startOffset, int endOffset, int offset) {
        int asteriskOffset;
        if (text2 == null) {
            EnterAfterJavadocTagHandler.$$$reportNull$$$0(5);
        }
        if ((asteriskOffset = StringUtil.indexOf(text2, '*', startOffset, endOffset)) < 0) {
            Context context = NOT_MATCHED_CONTEXT;
            if (context == null) {
                EnterAfterJavadocTagHandler.$$$reportNull$$$0(6);
            }
            return context;
        }
        startOffset = asteriskOffset + 1;
        int startTagStartOffset = -1;
        int startTagEndOffset = -1;
        HashSet<CharSequence> closedTags = new HashSet<CharSequence>();
        CharSequence startTag = null;
        for (int i = offset - 1; i >= startOffset; --i) {
            CharSequence tag2;
            char c = text2.charAt(i);
            if (c == ' ' || c == '\t') continue;
            if (c == '>' && startTagEndOffset < 0) {
                if (i > startOffset && text2.charAt(i - 1) == '/') break;
                startTagEndOffset = i;
                continue;
            }
            if (c != '<') continue;
            if (startTagEndOffset < 0 || i >= endOffset) break;
            if (text2.charAt(i + 1) == '/') {
                tag2 = text2.subSequence(i + 2, startTagEndOffset);
                closedTags.add(tag2);
                startTagEndOffset = -1;
                continue;
            }
            tag2 = text2.subSequence(i + 1, startTagEndOffset);
            if (closedTags.remove(tag2)) {
                startTagEndOffset = -1;
                continue;
            }
            startTagStartOffset = i;
            startTag = text2.subSequence(i + 1, startTagEndOffset + 1);
            break;
        }
        if (startTagStartOffset < 0 || startTagEndOffset < 0) {
            Context context = NOT_MATCHED_CONTEXT;
            if (context == null) {
                EnterAfterJavadocTagHandler.$$$reportNull$$$0(7);
            }
            return context;
        }
        int endTagStartOffset = -1;
        for (int i = offset; i < endOffset; ++i) {
            char c = text2.charAt(i);
            if (c != '<' || i >= endOffset - 2 || text2.charAt(i + 1) != '/' || startTag == null || !CharArrayUtil.regionMatches(text2, i + 2, endOffset, startTag)) continue;
            endTagStartOffset = i;
            break;
        }
        return new Context(text2, startTagEndOffset, endTagStartOffset, offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/enter/EnterAfterJavadocTagHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/enter/EnterAfterJavadocTagHandler";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "preprocessEnter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Context {
        public final int startTagEndOffset;
        public final int endTagStartOffset;
        @Nullable
        private final CharSequence myText;
        private final int myOffset;

        Context() {
            this(null, -1, -1, -1);
        }

        Context(@Nullable CharSequence text2, int startTagEndOffset, int endTagStartOffset, int offset) {
            this.myText = text2;
            this.startTagEndOffset = startTagEndOffset;
            this.endTagStartOffset = endTagStartOffset;
            this.myOffset = offset;
        }

        public boolean shouldGenerateLine() {
            return this.endTagStartOffset >= 0 && this.shouldIndent();
        }

        public boolean shouldIndent() {
            if (this.startTagEndOffset < 0 || this.myText == null) {
                return false;
            }
            for (int i = this.startTagEndOffset + 1; i < this.myOffset; ++i) {
                char c = this.myText.charAt(i);
                if (c == ' ' || c == '\t') continue;
                return false;
            }
            return true;
        }
    }
}

