/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.completion.SkipAutopopupInStrings;
import com.intellij.codeInsight.editorActions.wordSelection.AbstractWordSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralValue;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.IntStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class InjectedFileReferenceSelectioner
extends AbstractWordSelectioner {
    @Override
    public boolean canSelect(@NotNull PsiElement e) {
        if (e == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(0);
        }
        return PsiTreeUtil.getParentOfType(e, PsiLanguageInjectionHost.class) != null;
    }

    @Override
    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        BitSet compositeIndexes;
        BitSet charEscapeLocations;
        PsiLanguageInjectionHost host;
        if (e == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(3);
        }
        if ((host = PsiTreeUtil.getParentOfType(e, PsiLanguageInjectionHost.class)) == null) {
            return Collections.emptyList();
        }
        TextRange realRange = ElementManipulators.getValueTextRange(host).shiftRight(host.getTextRange().getStartOffset());
        PsiElement valueElement = InjectedFileReferenceSelectioner.findValueElement(host, realRange);
        List<TextRange> segments2 = InjectedFileReferenceSelectioner.buildSegments(editorText, cursorOffset, realRange = InjectedFileReferenceSelectioner.limitToCurrentLineAndStripWhiteSpace(editorText, cursorOffset, realRange), charEscapeLocations = InjectedFileReferenceSelectioner.isWithinLiteral(e, host) ? InjectedFileReferenceSelectioner.findCharEscapeLocations(editor, editorText, host.getTextRange(), realRange.getStartOffset()) : new BitSet(0), compositeIndexes = InjectedFileReferenceSelectioner.createCompositeIndexesSet(valueElement, realRange.getStartOffset()));
        if (!segments2.isEmpty()) {
            int endOffsetAlignment = segments2.get(segments2.size() - 1).getEndOffset();
            ListIterator<TextRange> it = segments2.listIterator();
            while (it.hasNext()) {
                TextRange r = it.next();
                if (r.getEndOffset() > cursorOffset) continue;
                it.set(TextRange.create(r.getStartOffset(), endOffsetAlignment));
            }
            segments2.add(realRange);
        }
        return segments2;
    }

    @NotNull
    private static PsiElement findValueElement(@NotNull PsiElement host, @NotNull TextRange valueRange) {
        if (host == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(4);
        }
        if (valueRange == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(5);
        }
        PsiElement psiElement = ObjectUtils.notNull(PsiTreeUtil.findFirstParent(host.getContainingFile().findElementAt(valueRange.getStartOffset()), false, parent -> parent == host || parent.getTextRange().contains(valueRange)), host);
        if (psiElement == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    @NotNull
    private static List<TextRange> buildSegments(@NotNull CharSequence editorText, int cursorOffset, @NotNull TextRange range2, @NotNull BitSet charEscapeLocations, @NotNull BitSet compositeIndexes) {
        if (editorText == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(7);
        }
        if (range2 == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(8);
        }
        if (charEscapeLocations == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(9);
        }
        if (compositeIndexes == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(10);
        }
        if (range2.getLength() == 0) {
            List<TextRange> list2 = Collections.emptyList();
            if (list2 == null) {
                InjectedFileReferenceSelectioner.$$$reportNull$$$0(11);
            }
            return list2;
        }
        int hostTextOffset = range2.getStartOffset();
        int hostTextEndOffset = range2.getEndOffset();
        ArrayList<TextRange> segments2 = new ArrayList<TextRange>();
        int rangeStart = hostTextOffset;
        boolean segmentsFinished = false;
        int hardSegmentCount = 0;
        for (int i = hostTextOffset; i < hostTextEndOffset; ++i) {
            if (compositeIndexes.get(i - hostTextOffset)) continue;
            char ch = editorText.charAt(i);
            if (!segmentsFinished) {
                if (ch == '/' || ch == '\\' && !charEscapeLocations.get(i - hostTextOffset) || ch == ' ' && i <= cursorOffset) {
                    if (rangeStart < i) {
                        if (editorText.charAt(i - 1) == ':') {
                            segments2.add(new TextRange(rangeStart, i - 1));
                        } else {
                            segments2.add(new TextRange(rangeStart, i));
                        }
                        if (i > cursorOffset) {
                            segmentsFinished = true;
                        }
                    }
                    rangeStart = i + 1;
                    if (ch != ' ') {
                        ++hardSegmentCount;
                    }
                } else if (ch == '?') {
                    segments2.add(new TextRange(rangeStart, i));
                    if (i + 1 < hostTextEndOffset) {
                        segments2.add(new TextRange(i + 1, hostTextEndOffset));
                    }
                    segments2.add(new TextRange(rangeStart, hostTextEndOffset));
                    segmentsFinished = true;
                }
            }
            if ((ch != '>' || i <= hostTextOffset || editorText.charAt(i - 1) != '/') && (ch != '<' || i + 1 >= hostTextEndOffset || editorText.charAt(i + 1) != '/')) continue;
            List<TextRange> list3 = Collections.emptyList();
            if (list3 == null) {
                InjectedFileReferenceSelectioner.$$$reportNull$$$0(12);
            }
            return list3;
        }
        if (hardSegmentCount <= 0) {
            List<TextRange> list4 = Collections.emptyList();
            if (list4 == null) {
                InjectedFileReferenceSelectioner.$$$reportNull$$$0(13);
            }
            return list4;
        }
        if (!segmentsFinished && rangeStart < hostTextEndOffset) {
            segments2.add(new TextRange(rangeStart, hostTextEndOffset));
        }
        ArrayList<TextRange> arrayList = segments2;
        if (arrayList == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    private static BitSet createCompositeIndexesSet(@NotNull PsiElement valueElement, int indexesOffset) {
        if (valueElement == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(15);
        }
        BitSet bitSet = ((StreamEx)StreamEx.of((Object[])valueElement.getChildren()).filter(child2 -> !(child2 instanceof LeafPsiElement))).map(PsiElement::getTextRange).flatMapToInt(range2 -> IntStream.range(range2.getStartOffset(), range2.getEndOffset())).map(index -> index - indexesOffset).atLeast(0).toBitSet();
        if (bitSet == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(16);
        }
        return bitSet;
    }

    @NotNull
    private static TextRange limitToCurrentLineAndStripWhiteSpace(@NotNull CharSequence text2, int cursor, @NotNull TextRange range2) {
        if (text2 == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(17);
        }
        if (range2 == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(18);
        }
        int subsequenceOffset = range2.getStartOffset();
        CharSequenceSubSequence rangeText = new CharSequenceSubSequence(text2, subsequenceOffset, range2.getEndOffset());
        int start2 = CharArrayUtil.shiftBackwardUntil(rangeText, cursor - subsequenceOffset, "\n\r") + 1;
        int end = CharArrayUtil.shiftForwardUntil(rangeText, cursor - subsequenceOffset, "\n\r");
        start2 = CharArrayUtil.shiftForward(rangeText, start2, cursor - subsequenceOffset, " \t");
        end = CharArrayUtil.shiftBackward(rangeText, cursor - subsequenceOffset, end - 1, " \t") + 1;
        return new TextRange(subsequenceOffset + start2, subsequenceOffset + end);
    }

    private static boolean isWithinLiteral(@NotNull PsiElement e, PsiElement host) {
        if (e == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(19);
        }
        return host instanceof PsiLiteralValue || SkipAutopopupInStrings.isInStringLiteral(e);
    }

    private static BitSet findCharEscapeLocations(@NotNull Editor editor, @NotNull CharSequence text2, @NotNull TextRange range2, int indexesOffset) {
        int pos;
        if (editor == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(20);
        }
        if (text2 == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(21);
        }
        if (range2 == null) {
            InjectedFileReferenceSelectioner.$$$reportNull$$$0(22);
        }
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(range2.getStartOffset());
        int rangeEnd = range2.getEndOffset();
        BitSet locations = new BitSet(range2.getLength());
        while (!iterator2.atEnd() && (pos = iterator2.getStart()) < rangeEnd) {
            if (text2.charAt(pos) == '\\' && (pos + 1 >= rangeEnd || text2.charAt(pos + 1) != '\\') && pos >= indexesOffset) {
                locations.set(pos - indexesOffset);
            }
            iterator2.advance();
        }
        return locations;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueRange";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/wordSelection/InjectedFileReferenceSelectioner";
                break;
            }
            case 8: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charEscapeLocations";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compositeIndexes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueElement";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/wordSelection/InjectedFileReferenceSelectioner";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findValueElement";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSegments";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompositeIndexesSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findValueElement";
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildSegments";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createCompositeIndexesSet";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "limitToCurrentLineAndStripWhiteSpace";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isWithinLiteral";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findCharEscapeLocations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

