/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.DocumentFoldingInfo;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingUpdate;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.folding.impl.UpdateFoldRegionsOperation;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.extensions.ExtensionPointChangeListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.LanguageInjector;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.containers.WeakList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeFoldingManagerImpl
extends CodeFoldingManager
implements Disposable {
    private final Project myProject;
    private final Collection<Document> myDocumentsWithFoldingInfo = new WeakList<Document>();
    private final Key<DocumentFoldingInfo> myFoldingInfoInDocumentKey = Key.create("FOLDING_INFO_IN_DOCUMENT_KEY");
    private static final Key<Boolean> FOLDING_STATE_KEY = Key.create("FOLDING_STATE_KEY");

    public CodeFoldingManagerImpl(final Project project2) {
        this.myProject = project2;
        LanguageFolding.EP_NAME.addExtensionPointListener(new ExtensionPointListener<KeyedLazyInstance<FoldingBuilder>>(){

            @Override
            public void extensionAdded(@NotNull KeyedLazyInstance<FoldingBuilder> extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (FileEditor fileEditor : FileEditorManager.getInstance(project2).getAllEditors()) {
                    if (!(fileEditor instanceof TextEditor)) continue;
                    CodeFoldingManagerImpl.this.scheduleAsyncFoldingUpdate(((TextEditor)fileEditor).getEditor());
                }
            }

            @Override
            public void extensionRemoved(@NotNull KeyedLazyInstance<FoldingBuilder> extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                for (FileEditor fileEditor : FileEditorManager.getInstance(project2).getAllEditors()) {
                    if (!(fileEditor instanceof TextEditor)) continue;
                    CodeFoldingManagerImpl.this.updateFoldRegions(((TextEditor)fileEditor).getEditor());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        ExtensionPointChangeListener listener2 = () -> {
            for (FileEditor fileEditor : FileEditorManager.getInstance(project2).getAllEditors()) {
                if (!(fileEditor instanceof TextEditor)) continue;
                FoldingUpdate.clearFoldingCache(((TextEditor)fileEditor).getEditor());
            }
        };
        MultiHostInjector.MULTIHOST_INJECTOR_EP_NAME.getPoint(project2).addExtensionPointListener(listener2, false, (Disposable)this);
        LanguageInjector.EXTENSION_POINT_NAME.addExtensionPointListener(listener2, (Disposable)this);
    }

    @Override
    public void dispose() {
        for (Document document : this.myDocumentsWithFoldingInfo) {
            if (document == null) continue;
            document.putUserData(this.myFoldingInfoInDocumentKey, null);
        }
    }

    @Override
    public void releaseFoldings(@NotNull Editor editor) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Project project2 = editor.getProject();
        if (!(project2 == null || project2.equals(this.myProject) && project2.isOpen())) {
            return;
        }
        Document document = editor.getDocument();
        PsiFile file2 = PsiDocumentManager.getInstance(this.myProject).getPsiFile(document);
        if (file2 == null || !file2.getViewProvider().isPhysical() || !file2.isValid()) {
            return;
        }
        EditorFoldingInfo.get(editor).dispose();
    }

    @Override
    public void buildInitialFoldings(@NotNull Editor editor) {
        Project project2;
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(1);
        }
        if ((project2 = editor.getProject()) == null || !project2.equals(this.myProject) || editor.isDisposed()) {
            return;
        }
        if (!((FoldingModelEx)editor.getFoldingModel()).isFoldingEnabled()) {
            return;
        }
        if (!FoldingUpdate.supportsDumbModeFolding(editor)) {
            return;
        }
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance(this.myProject).commitDocument(document);
        CodeFoldingState foldingState = this.buildInitialFoldings(document);
        if (foldingState != null) {
            foldingState.setToEditor(editor);
        }
    }

    @Override
    @Nullable
    public CodeFoldingState buildInitialFoldings(@NotNull Document document) {
        if (document == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(2);
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance(this.myProject);
        if (psiDocumentManager.isUncommited(document)) {
            return null;
        }
        PsiFile file2 = psiDocumentManager.getPsiFile(document);
        if (file2 == null || !file2.isValid() || !file2.getViewProvider().isPhysical() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        List<FoldingUpdate.RegionInfo> regionInfos = FoldingUpdate.getFoldingsFor(file2, document, true);
        return editor -> {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (this.myProject.isDisposed() || editor.isDisposed()) {
                return;
            }
            FoldingModelEx foldingModel = (FoldingModelEx)editor.getFoldingModel();
            if (!foldingModel.isFoldingEnabled()) {
                return;
            }
            if (CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor)) {
                return;
            }
            if (DumbService.isDumb(this.myProject) && !FoldingUpdate.supportsDumbModeFolding(editor)) {
                return;
            }
            foldingModel.runBatchFoldingOperationDoNotCollapseCaret(new UpdateFoldRegionsOperation(this.myProject, editor, file2, regionInfos, UpdateFoldRegionsOperation.ApplyDefaultStateMode.YES, false, false));
            this.initFolding(editor);
        };
    }

    @Override
    @Nullable
    public Boolean isCollapsedByDefault(@NotNull FoldRegion region) {
        if (region == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(3);
        }
        return region.getUserData(UpdateFoldRegionsOperation.COLLAPSED_BY_DEFAULT);
    }

    @Override
    public void scheduleAsyncFoldingUpdate(@NotNull Editor editor) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(4);
        }
        FoldingUpdate.clearFoldingCache(editor);
        DaemonCodeAnalyzer.getInstance(this.myProject).restart();
    }

    private void initFolding(@NotNull Editor editor) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(5);
        }
        Document document = editor.getDocument();
        editor.getFoldingModel().runBatchFoldingOperation(() -> {
            Editor[] editors;
            DocumentFoldingInfo documentFoldingInfo = this.getDocumentFoldingInfo(document);
            for (Editor otherEditor : editors = EditorFactory.getInstance().getEditors(document, this.myProject)) {
                if (otherEditor == editor || !CodeFoldingManagerImpl.isFoldingsInitializedInEditor(otherEditor)) continue;
                documentFoldingInfo.loadFromEditor(otherEditor);
                break;
            }
            documentFoldingInfo.setToEditor(editor);
            documentFoldingInfo.clear();
            editor.putUserData(FOLDING_STATE_KEY, Boolean.TRUE);
        });
    }

    @Override
    @Nullable
    public FoldRegion findFoldRegion(@NotNull Editor editor, int startOffset, int endOffset) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(6);
        }
        return FoldingUtil.findFoldRegion(editor, startOffset, endOffset);
    }

    @Override
    public FoldRegion[] getFoldRegionsAtOffset(@NotNull Editor editor, int offset) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(7);
        }
        return FoldingUtil.getFoldRegionsAtOffset(editor, offset);
    }

    @Override
    public void updateFoldRegions(@NotNull Editor editor) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(8);
        }
        this.updateFoldRegions(editor, false);
    }

    public void updateFoldRegions(Editor editor, boolean quick) {
        if (!editor.getSettings().isAutoCodeFoldingEnabled()) {
            return;
        }
        PsiDocumentManager.getInstance(this.myProject).commitDocument(editor.getDocument());
        Runnable runnable2 = this.updateFoldRegions(editor, false, quick);
        if (runnable2 != null) {
            runnable2.run();
        }
    }

    @Override
    @Nullable
    public Runnable updateFoldRegionsAsync(@NotNull Editor editor, boolean firstTime) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(9);
        }
        if (!editor.getSettings().isAutoCodeFoldingEnabled()) {
            return null;
        }
        Runnable runnable2 = this.updateFoldRegions(editor, firstTime, false);
        return () -> {
            if (runnable2 != null) {
                runnable2.run();
            }
            if (firstTime && !CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor)) {
                this.initFolding(editor);
            }
        };
    }

    @Nullable
    private Runnable updateFoldRegions(@NotNull Editor editor, boolean applyDefaultState, boolean quick) {
        PsiFile file2;
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(10);
        }
        return (file2 = PsiDocumentManager.getInstance(this.myProject).getPsiFile(editor.getDocument())) == null ? null : FoldingUpdate.updateFoldRegions(editor, file2, applyDefaultState, quick);
    }

    @Override
    public CodeFoldingState saveFoldingState(@NotNull Editor editor) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        DocumentFoldingInfo info = this.getDocumentFoldingInfo(editor.getDocument());
        if (CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor)) {
            info.loadFromEditor(editor);
        }
        return info;
    }

    @Override
    public void restoreFoldingState(@NotNull Editor editor, @NotNull CodeFoldingState state) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(12);
        }
        if (state == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor)) {
            state.setToEditor(editor);
        }
    }

    @Override
    public void writeFoldingState(@NotNull CodeFoldingState state, @NotNull Element element2) {
        if (state == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(14);
        }
        if (element2 == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(15);
        }
        if (state instanceof DocumentFoldingInfo) {
            ((DocumentFoldingInfo)state).writeExternal(element2);
        }
    }

    @Override
    public CodeFoldingState readFoldingState(@NotNull Element element2, @NotNull Document document) {
        if (element2 == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(16);
        }
        if (document == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(17);
        }
        DocumentFoldingInfo info = this.getDocumentFoldingInfo(document);
        info.readExternal(element2);
        return info;
    }

    @NotNull
    private DocumentFoldingInfo getDocumentFoldingInfo(@NotNull Document document) {
        DocumentFoldingInfo info;
        if (document == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(18);
        }
        if ((info = document.getUserData(this.myFoldingInfoInDocumentKey)) == null) {
            info = new DocumentFoldingInfo(this.myProject, document);
            DocumentFoldingInfo written = ((UserDataHolderEx)((Object)document)).putUserDataIfAbsent(this.myFoldingInfoInDocumentKey, info);
            if (written == info) {
                this.myDocumentsWithFoldingInfo.add(document);
            } else {
                info = written;
            }
        }
        DocumentFoldingInfo documentFoldingInfo = info;
        if (documentFoldingInfo == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(19);
        }
        return documentFoldingInfo;
    }

    private static boolean isFoldingsInitializedInEditor(@NotNull Editor editor) {
        if (editor == null) {
            CodeFoldingManagerImpl.$$$reportNull$$$0(20);
        }
        return Boolean.TRUE.equals(editor.getUserData(FOLDING_STATE_KEY));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "region";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentFoldingInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "releaseFoldings";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildInitialFoldings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "scheduleAsyncFoldingUpdate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initFolding";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFoldRegion";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFoldRegionsAtOffset";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateFoldRegions";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateFoldRegionsAsync";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "saveFoldingState";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "restoreFoldingState";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "writeFoldingState";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "readFoldingState";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentFoldingInfo";
                break;
            }
            case 19: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isFoldingsInitializedInEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

