/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class CollapseSelectionHandler
implements CodeInsightActionHandler {
    private static final String ourPlaceHolderText = "...";
    private static final Logger LOG = Logger.getInstance(CollapseSelectionHandler.class);

    @Override
    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            CollapseSelectionHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            CollapseSelectionHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            CollapseSelectionHandler.$$$reportNull$$$0(2);
        }
        editor.getFoldingModel().runBatchFoldingOperation(() -> {
            int end;
            EditorFoldingInfo info = EditorFoldingInfo.get(editor);
            FoldingModelEx foldingModel = (FoldingModelEx)editor.getFoldingModel();
            int start2 = editor.getSelectionModel().getSelectionStart();
            if (start2 < (end = editor.getSelectionModel().getSelectionEnd())) {
                FoldRegion region;
                Document doc = editor.getDocument();
                if (start2 < end && doc.getCharsSequence().charAt(end - 1) == '\n') {
                    --end;
                }
                if ((region = FoldingUtil.findFoldRegion(editor, start2, end)) != null) {
                    if (info.getPsiElement(region) == null) {
                        editor.getFoldingModel().removeFoldRegion(region);
                        info.removeRegion(region);
                    } else {
                        HintManager.getInstance().showInformationHint(editor, CodeInsightBundle.message("collapse.selection.existing.autogenerated.region", new Object[0]));
                    }
                } else {
                    if (foldingModel.intersectsRegion(start2, end)) {
                        if (Messages.showDialog(project2, CodeInsightBundle.message("collapse.selection.overlapping.warning.text", new Object[0]), CodeInsightBundle.message("collapse.selection.overlapping.warning.title", new Object[0]), new String[]{CodeInsightBundle.message("collapse.selection.overlapping.warning.ok", new Object[0]), CodeInsightBundle.message("collapse.selection.overlapping.warning.cancel", new Object[0])}, 1, Messages.getWarningIcon()) != 0) {
                            return;
                        }
                        for (FoldRegion r : foldingModel.getAllFoldRegions()) {
                            if ((r.getStartOffset() >= start2 || r.getEndOffset() <= start2 || r.getEndOffset() >= end) && (r.getStartOffset() <= start2 || r.getStartOffset() >= end || r.getEndOffset() <= end)) continue;
                            foldingModel.removeFoldRegion(r);
                        }
                    }
                    LOG.assertTrue((region = foldingModel.addFoldRegion(start2, end, ourPlaceHolderText)) != null, "Fold region is not created. Folding model: " + foldingModel);
                    region.setExpanded(false);
                    int offset = Math.min(start2 + ourPlaceHolderText.length(), doc.getTextLength());
                    editor.getCaretModel().moveToOffset(offset);
                }
            } else {
                FoldRegion[] regions = FoldingUtil.getFoldRegionsAtOffset(editor, editor.getCaretModel().getOffset());
                if (regions.length > 0) {
                    FoldRegion region = regions[0];
                    if (info.getPsiElement(region) == null) {
                        editor.getFoldingModel().removeFoldRegion(region);
                        info.removeRegion(region);
                    } else {
                        region.setExpanded(!region.isExpanded());
                    }
                }
            }
        });
    }

    public static boolean isEnabled(@NotNull Editor editor) {
        if (editor == null) {
            CollapseSelectionHandler.$$$reportNull$$$0(3);
        }
        return editor.getSelectionModel().getSelectionStart() < editor.getSelectionModel().getSelectionEnd() || FoldingUtil.getFoldRegionsAtOffset(editor, editor.getCaretModel().getOffset()).length > 0;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/folding/impl/CollapseSelectionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabled";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

