/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class AutoIndentLinesHandler
implements CodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance(AutoIndentLinesHandler.class);

    @Override
    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        int endOffset;
        int startOffset;
        if (project2 == null) {
            AutoIndentLinesHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            AutoIndentLinesHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            AutoIndentLinesHandler.$$$reportNull$$$0(2);
        }
        Document document = editor.getDocument();
        boolean hasSelection = editor.getSelectionModel().hasSelection();
        if (hasSelection) {
            startOffset = editor.getSelectionModel().getSelectionStart();
            endOffset = editor.getSelectionModel().getSelectionEnd() - 1;
        } else {
            startOffset = endOffset = editor.getCaretModel().getOffset();
        }
        int line1 = editor.offsetToLogicalPosition((int)startOffset).line;
        int col = editor.getCaretModel().getLogicalPosition().column;
        try {
            AutoIndentLinesHandler.adjustLineIndent(file2, document, startOffset, endOffset, line1, project2);
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
        if (!hasSelection && line1 < document.getLineCount() - 1) {
            if (document.getLineStartOffset(line1 + 1) + col >= document.getTextLength()) {
                col = document.getLineEndOffset(line1 + 1) - document.getLineStartOffset(line1 + 1);
            }
            LogicalPosition pos = new LogicalPosition(line1 + 1, col);
            editor.getCaretModel().moveToLogicalPosition(pos);
            editor.getSelectionModel().removeSelection();
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    private static void adjustLineIndent(PsiFile file2, Document document, int startOffset, int endOffset, int line, Project project2) {
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance(project2);
        if (startOffset == endOffset) {
            int lineStart = document.getLineStartOffset(line);
            if (codeStyleManager.isLineToBeIndented(file2, lineStart)) {
                codeStyleManager.adjustLineIndent(file2, lineStart);
            }
        } else {
            codeStyleManager.adjustLineIndent(file2, new TextRange(DocumentUtil.getLineStartOffset(startOffset, document), endOffset));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/generation/AutoIndentLinesHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

