/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CommentUtil;
import com.intellij.codeInsight.actions.MultiCaretCodeInsightActionHandler;
import com.intellij.codeInsight.generation.CommentByBlockCommentHandler;
import com.intellij.codeInsight.generation.CommenterDataHolder;
import com.intellij.codeInsight.generation.CommenterWithLineSuffix;
import com.intellij.codeInsight.generation.IndentedCommenter;
import com.intellij.codeInsight.generation.SelfManagingCommenter;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.formatting.IndentData;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.tree.injected.InjectedCaret;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommentByLineCommentHandler
extends MultiCaretCodeInsightActionHandler {
    private static final Key<Boolean> INJECTION_FORBIDS_LINE_COMMENTS = Key.create("INJECTION_FORBIDS_LINE_COMMENTS");
    private final List<Block> myBlocks = new ArrayList<Block>();

    public static void markInjectedFileUnsuitableForLineComment(@NotNull PsiFile file2) {
        if (file2 == null) {
            CommentByLineCommentHandler.$$$reportNull$$$0(0);
        }
        if (!InjectedLanguageManager.getInstance(file2.getProject()).isInjectedFragment(file2)) {
            throw new IllegalArgumentException("This method should be called only on injected files");
        }
        file2.putUserData(INJECTION_FORBIDS_LINE_COMMENTS, true);
    }

    @Override
    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull Caret caret, @NotNull PsiFile file2) {
        boolean startingNewLineComment;
        Block currentBlock;
        Block lastBlock;
        FoldRegion collapsedAt;
        PsiLanguageInjectionHost context;
        if (project2 == null) {
            CommentByLineCommentHandler.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            CommentByLineCommentHandler.$$$reportNull$$$0(2);
        }
        if (caret == null) {
            CommentByLineCommentHandler.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            CommentByLineCommentHandler.$$$reportNull$$$0(4);
        }
        if ((context = InjectedLanguageManager.getInstance((file2 = file2.getViewProvider().getPsi(file2.getViewProvider().getBaseLanguage())).getProject()).getInjectionHost(file2)) != null && CommentByLineCommentHandler.shouldCommentInHostFile(file2, context)) {
            file2 = context.getContainingFile();
            editor = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
            caret = caret instanceof InjectedCaret ? ((InjectedCaret)caret).getDelegate() : caret;
        }
        Document document = editor.getDocument();
        boolean hasSelection = caret.hasSelection();
        int startOffset = caret.getSelectionStart();
        int endOffset = caret.getSelectionEnd();
        FoldRegion fold = editor.getFoldingModel().getCollapsedRegionAtOffset(startOffset);
        if (fold != null && fold.shouldNeverExpand() && fold.getStartOffset() == startOffset && fold.getEndOffset() == endOffset) {
            hasSelection = false;
        }
        if (document.getTextLength() == 0) {
            return;
        }
        while (true) {
            int regionStartOffset;
            int firstLineStart = DocumentUtil.getLineStartOffset(startOffset, document);
            collapsedAt = editor.getFoldingModel().getCollapsedRegionAtOffset(firstLineStart - 1);
            if (collapsedAt == null || (regionStartOffset = collapsedAt.getStartOffset()) >= startOffset) break;
            startOffset = regionStartOffset;
        }
        if (!hasSelection || !DocumentUtil.isAtLineStart(endOffset, document)) {
            while (true) {
                int regionEndOffset;
                int lastLineEnd = DocumentUtil.getLineEndOffset(endOffset, document);
                collapsedAt = editor.getFoldingModel().getCollapsedRegionAtOffset(lastLineEnd);
                if (collapsedAt == null || (regionEndOffset = collapsedAt.getEndOffset()) <= endOffset) break;
                endOffset = regionEndOffset;
            }
        }
        int startLine = document.getLineNumber(startOffset);
        int endLine = document.getLineNumber(endOffset);
        if (endLine > startLine && document.getLineStartOffset(endLine) == endOffset) {
            --endLine;
        }
        Block block = lastBlock = this.myBlocks.isEmpty() ? null : this.myBlocks.get(this.myBlocks.size() - 1);
        if (lastBlock == null || lastBlock.editor != editor || lastBlock.psiFile != file2 || startLine > lastBlock.endLine + 1) {
            currentBlock = new Block();
            currentBlock.editor = editor;
            currentBlock.psiFile = file2;
            currentBlock.startLine = startLine;
            this.myBlocks.add(currentBlock);
        } else {
            currentBlock = lastBlock;
        }
        currentBlock.carets.add(caret);
        currentBlock.endLine = endLine;
        boolean wholeLinesSelected = !hasSelection || startOffset == document.getLineStartOffset(document.getLineNumber(startOffset)) && endOffset == document.getLineEndOffset(document.getLineNumber(endOffset - 1)) + 1;
        boolean bl = startingNewLineComment = !hasSelection && DocumentUtil.isLineEmpty(document, document.getLineNumber(startOffset)) && !Comparing.equal("CommentByLineComment", ActionManagerEx.getInstanceEx().getPrevPreformedActionId());
        currentBlock.caretUpdate = startingNewLineComment ? CaretUpdate.PUT_AT_COMMENT_START : (!hasSelection ? CaretUpdate.SHIFT_DOWN : (wholeLinesSelected ? CaretUpdate.RESTORE_SELECTION : null));
    }

    private static boolean shouldCommentInHostFile(@NotNull PsiFile file2, @NotNull PsiElement context) {
        if (file2 == null) {
            CommentByLineCommentHandler.$$$reportNull$$$0(5);
        }
        if (context == null) {
            CommentByLineCommentHandler.$$$reportNull$$$0(6);
        }
        if (file2.getUserData(INJECTION_FORBIDS_LINE_COMMENTS) != null) {
            return true;
        }
        if (context.textContains('\'') || context.textContains('\"') || context.textContains('/')) {
            String s = context.getText();
            return StringUtil.startsWith(s, "\"") || StringUtil.startsWith(s, "'") || StringUtil.startsWith(s, "/");
        }
        return false;
    }

    @Override
    public void postInvoke() {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.comment.line");
        boolean allLinesCommented = true;
        block5: for (Block block : this.myBlocks) {
            int startLine = block.startLine;
            int endLine = block.endLine;
            Document document = block.editor.getDocument();
            PsiFile psiFile = block.psiFile;
            Block.access$702(block, new int[endLine - startLine + 1]);
            Block.access$802(block, new int[endLine - startLine + 1]);
            Block.access$902(block, new Commenter[endLine - startLine + 1]);
            block.commenterStateMap = new THashMap();
            CharSequence chars = document.getCharsSequence();
            boolean singleline = startLine == endLine;
            int offset = document.getLineStartOffset(startLine);
            offset = CharArrayUtil.shiftForward(chars, offset, " \t");
            int endOffset = CharArrayUtil.shiftBackward(chars, document.getLineEndOffset(endLine), " \t\n");
            block.blockSuitableCommenter = CommentByLineCommentHandler.getBlockSuitableCommenter(psiFile, offset, endOffset);
            Language lineStartLanguage = CommentByLineCommentHandler.getLineStartLanguage(block.editor, psiFile, startLine);
            CommonCodeStyleSettings languageSettings = CodeStyle.getLanguageSettings(psiFile, lineStartLanguage);
            block.commentWithIndent = !languageSettings.LINE_COMMENT_AT_FIRST_COLUMN;
            block.addSpace = languageSettings.LINE_COMMENT_ADD_SPACE;
            for (int line = startLine; line <= endLine; ++line) {
                Boolean value2;
                Commenter commenter;
                Commenter commenter2 = commenter = block.blockSuitableCommenter != null ? block.blockSuitableCommenter : CommentByLineCommentHandler.findCommenter(block.editor, psiFile, line);
                if (commenter == null || commenter.getLineCommentPrefix() == null && (commenter.getBlockCommentPrefix() == null || commenter.getBlockCommentSuffix() == null)) {
                    block.skip = true;
                    continue block5;
                }
                if (commenter instanceof SelfManagingCommenter && block.commenterStateMap.get(commenter) == null) {
                    SelfManagingCommenter selfManagingCommenter = (SelfManagingCommenter)((Object)commenter);
                    Object state = selfManagingCommenter.createLineCommentingState(startLine, endLine, document, psiFile);
                    if (state == null) {
                        state = SelfManagingCommenter.EMPTY_STATE;
                    }
                    block.commenterStateMap.put(selfManagingCommenter, state);
                }
                ((Block)block).commenters[line - startLine] = commenter;
                if (CommentByLineCommentHandler.isLineCommented(block, line, commenter) || !singleline && DocumentUtil.isLineEmpty(document, line)) continue;
                allLinesCommented = false;
                if (!(commenter instanceof IndentedCommenter) || (value2 = ((IndentedCommenter)commenter).forceIndentedLineComment()) == null) continue block5;
                block.commentWithIndent = value2;
                continue block5;
            }
        }
        boolean moveCarets = true;
        for (Block block : this.myBlocks) {
            if (block.carets.size() <= 1 || block.startLine == block.endLine) continue;
            moveCarets = false;
            break;
        }
        Collections.reverse(this.myBlocks);
        for (Block block : this.myBlocks) {
            if (!block.skip) {
                if (!allLinesCommented) {
                    if (!block.commentWithIndent) {
                        this.doDefaultCommenting(block);
                    } else {
                        CommentByLineCommentHandler.doIndentCommenting(block);
                    }
                } else {
                    CommentByLineCommentHandler.doUncommenting(block);
                }
            }
            if (!moveCarets || block.caretUpdate == null) continue;
            Document document = block.editor.getDocument();
            for (Caret caret : block.carets) {
                switch (block.caretUpdate) {
                    case PUT_AT_COMMENT_START: {
                        String prefix;
                        Commenter commenter = block.commenters[0];
                        if (commenter == null) break;
                        if (commenter instanceof SelfManagingCommenter) {
                            prefix = ((SelfManagingCommenter)((Object)commenter)).getCommentPrefix(block.startLine, document, (CommenterDataHolder)block.commenterStateMap.get((SelfManagingCommenter)((Object)commenter)));
                            if (prefix == null) {
                                prefix = "";
                            }
                        } else {
                            prefix = commenter.getLineCommentPrefix();
                            if (prefix == null) {
                                prefix = commenter.getBlockCommentPrefix();
                            }
                        }
                        int lineStart = document.getLineStartOffset(block.startLine);
                        lineStart = CharArrayUtil.shiftForward(document.getCharsSequence(), lineStart, " \t");
                        lineStart += prefix.length();
                        lineStart = CharArrayUtil.shiftForward(document.getCharsSequence(), lineStart, " \t");
                        if (lineStart > document.getTextLength()) {
                            lineStart = document.getTextLength();
                        }
                        caret.moveToOffset(lineStart);
                        break;
                    }
                    case SHIFT_DOWN: {
                        LogicalPosition position = caret.getLogicalPosition();
                        if (position.line >= document.getLineCount() - 1) break;
                        int verticalShift = 1 + block.editor.getSoftWrapModel().getSoftWrapsForLine(position.line).size() - EditorUtil.getSoftWrapCountAfterLineStart(block.editor, position);
                        caret.moveCaretRelatively(0, verticalShift, false, true);
                        break;
                    }
                    case RESTORE_SELECTION: {
                        caret.setSelection(document.getLineStartOffset(document.getLineNumber(caret.getSelectionStart())), caret.getSelectionEnd());
                    }
                }
            }
        }
    }

    private static void doUncommenting(Block block) {
        DocumentUtil.executeInBulk(block.editor.getDocument(), block.endLine - block.startLine >= Registry.intValue("comment.by.line.bulk.lines.trigger"), () -> {
            for (int line = block.endLine; line >= block.startLine; --line) {
                CommentByLineCommentHandler.uncommentLine(block, line, block.addSpace);
            }
        });
    }

    private static Commenter getBlockSuitableCommenter(final PsiFile file2, int offset, int endOffset) {
        Commenter blockSuitableCommenter;
        PsiElement element2;
        Language languageSuitableForCompleteFragment = offset >= endOffset ? ((element2 = file2.findElementAt(offset)) != null ? element2.getParent().getLanguage() : null) : PsiUtilBase.reallyEvaluateLanguageInRange(offset, endOffset, file2);
        Commenter commenter = blockSuitableCommenter = languageSuitableForCompleteFragment == null ? (Commenter)LanguageCommenters.INSTANCE.forLanguage(file2.getLanguage()) : null;
        if (blockSuitableCommenter == null && file2.getFileType() instanceof CustomSyntaxTableFileType) {
            blockSuitableCommenter = new Commenter(){
                final SyntaxTable mySyntaxTable;
                {
                    this.mySyntaxTable = ((CustomSyntaxTableFileType)file2.getFileType()).getSyntaxTable();
                }

                @Override
                @Nullable
                public String getLineCommentPrefix() {
                    return this.mySyntaxTable.getLineComment();
                }

                @Override
                @Nullable
                public String getBlockCommentPrefix() {
                    return this.mySyntaxTable.getStartComment();
                }

                @Override
                @Nullable
                public String getBlockCommentSuffix() {
                    return this.mySyntaxTable.getEndComment();
                }

                @Override
                public String getCommentedBlockCommentPrefix() {
                    return null;
                }

                @Override
                public String getCommentedBlockCommentSuffix() {
                    return null;
                }
            };
        }
        return blockSuitableCommenter;
    }

    private static boolean isLineCommented(Block block, int line, Commenter commenter) {
        boolean commented;
        int lineEndForBlockCommenting = -1;
        Document document = block.editor.getDocument();
        int lineStart = document.getLineStartOffset(line);
        CharSequence chars = document.getCharsSequence();
        lineStart = CharArrayUtil.shiftForward(chars, lineStart, " \t");
        if (commenter instanceof SelfManagingCommenter) {
            SelfManagingCommenter selfManagingCommenter = (SelfManagingCommenter)((Object)commenter);
            commented = selfManagingCommenter.isLineCommented(line, lineStart, document, (CommenterDataHolder)block.commenterStateMap.get(selfManagingCommenter));
        } else {
            String prefix = commenter.getLineCommentPrefix();
            if (prefix != null) {
                commented = CharArrayUtil.regionMatches(chars, lineStart, StringUtil.trimTrailing(prefix));
            } else {
                prefix = commenter.getBlockCommentPrefix();
                String suffix = commenter.getBlockCommentSuffix();
                int textLength = document.getTextLength();
                lineEndForBlockCommenting = document.getLineEndOffset(line);
                if (lineEndForBlockCommenting == textLength) {
                    int shifted = CharArrayUtil.shiftBackward(chars, textLength - 1, " \t");
                    if (shifted < textLength - 1) {
                        lineEndForBlockCommenting = shifted;
                    }
                } else {
                    lineEndForBlockCommenting = CharArrayUtil.shiftBackward(chars, lineEndForBlockCommenting, " \t");
                }
                boolean bl = commented = lineStart == lineEndForBlockCommenting && block.startLine != block.endLine || CharArrayUtil.regionMatches(chars, lineStart, prefix) && CharArrayUtil.regionMatches(chars, lineEndForBlockCommenting - suffix.length(), suffix);
            }
        }
        if (commented) {
            ((Block)block).startOffsets[line - ((Block)block).startLine] = lineStart;
            ((Block)block).endOffsets[line - ((Block)block).startLine] = lineEndForBlockCommenting;
        }
        return commented;
    }

    @Nullable
    private static Commenter findCommenter(@NotNull Editor editor, @NotNull PsiFile file2, int line) {
        FileType fileType;
        if (editor == null) {
            CommentByLineCommentHandler.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            CommentByLineCommentHandler.$$$reportNull$$$0(8);
        }
        if ((fileType = file2.getFileType()) instanceof AbstractFileType) {
            return ((AbstractFileType)fileType).getCommenter();
        }
        Language lineStartLanguage = CommentByLineCommentHandler.getLineStartLanguage(editor, file2, line);
        Language lineEndLanguage = CommentByLineCommentHandler.getLineEndLanguage(file2, editor, line);
        return CommentByBlockCommentHandler.getCommenter(file2, editor, lineStartLanguage, lineEndLanguage);
    }

    @NotNull
    private static Language getLineStartLanguage(@NotNull Editor editor, @NotNull PsiFile file2, int line) {
        if (editor == null) {
            CommentByLineCommentHandler.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            CommentByLineCommentHandler.$$$reportNull$$$0(10);
        }
        Document document = editor.getDocument();
        int lineStartOffset = document.getLineStartOffset(line);
        lineStartOffset = Math.max(0, CharArrayUtil.shiftForward(document.getCharsSequence(), lineStartOffset, " \t"));
        Language language2 = PsiUtilCore.getLanguageAtOffset(file2, lineStartOffset);
        if (language2 == null) {
            CommentByLineCommentHandler.$$$reportNull$$$0(11);
        }
        return language2;
    }

    @NotNull
    private static Language getLineEndLanguage(@NotNull PsiFile file2, @NotNull Editor editor, int line) {
        if (file2 == null) {
            CommentByLineCommentHandler.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            CommentByLineCommentHandler.$$$reportNull$$$0(13);
        }
        Document document = editor.getDocument();
        int lineEndOffset = document.getLineEndOffset(line) - 1;
        lineEndOffset = Math.max(0, CharArrayUtil.shiftBackward(document.getCharsSequence(), lineEndOffset < 0 ? 0 : lineEndOffset, " \t"));
        Language language2 = PsiUtilCore.getLanguageAtOffset(file2, lineEndOffset);
        if (language2 == null) {
            CommentByLineCommentHandler.$$$reportNull$$$0(14);
        }
        return language2;
    }

    private static IndentData computeMinIndent(Editor editor, PsiFile psiFile, int line1, int line2) {
        int commentOffset;
        Document document = editor.getDocument();
        IndentData minIndent = CommentUtil.getMinLineIndent(document, line1, line2, psiFile);
        if (line1 > 0 && (commentOffset = CommentByLineCommentHandler.getCommentStart(editor, psiFile, line1 - 1)) >= 0) {
            int lineStart = document.getLineStartOffset(line1 - 1);
            IndentData indent = IndentData.createFrom(document.getCharsSequence(), lineStart, commentOffset, CodeStyle.getIndentOptions((PsiFile)psiFile).TAB_SIZE);
            minIndent = IndentData.min(minIndent, indent);
        }
        if (minIndent == null) {
            minIndent = new IndentData(0);
        }
        return minIndent;
    }

    private static int getCommentStart(Editor editor, PsiFile psiFile, int line) {
        int offset = editor.getDocument().getLineStartOffset(line);
        CharSequence chars = editor.getDocument().getCharsSequence();
        offset = CharArrayUtil.shiftForward(chars, offset, " \t");
        Commenter commenter = CommentByLineCommentHandler.findCommenter(editor, psiFile, line);
        if (commenter == null) {
            return -1;
        }
        String prefix = commenter.getLineCommentPrefix();
        if (prefix == null) {
            prefix = commenter.getBlockCommentPrefix();
        }
        if (prefix == null) {
            return -1;
        }
        return CharArrayUtil.regionMatches(chars, offset, prefix) ? offset : -1;
    }

    public void doDefaultCommenting(Block block) {
        Document document = block.editor.getDocument();
        DocumentUtil.executeInBulk(document, block.endLine - block.startLine >= Registry.intValue("comment.by.line.bulk.lines.trigger"), () -> {
            for (int line = block.endLine; line >= block.startLine; --line) {
                int offset = document.getLineStartOffset(line);
                CommentByLineCommentHandler.commentLine(block, line, offset);
            }
        });
    }

    private static void doIndentCommenting(Block block) {
        Document document = block.editor.getDocument();
        CharSequence chars = document.getCharsSequence();
        IndentData minIndent = CommentByLineCommentHandler.computeMinIndent(block.editor, block.psiFile, block.startLine, block.endLine);
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getIndentOptions(block.psiFile);
        DocumentUtil.executeInBulk(document, block.endLine - block.startLine > Registry.intValue("comment.by.line.bulk.lines.trigger"), () -> {
            for (int line = block.endLine; line >= block.startLine; --line) {
                IndentData indent;
                int lineStart;
                int offset = lineStart = document.getLineStartOffset(line);
                StringBuilder buffer = new StringBuilder();
                while ((indent = IndentData.createFrom(buffer, 0, buffer.length(), indentOptions.TAB_SIZE)).getTotalSpaces() < minIndent.getTotalSpaces()) {
                    char c = chars.charAt(offset);
                    if (c != ' ' && c != '\t') {
                        String newSpace = minIndent.createIndentInfo().generateNewWhiteSpace(indentOptions);
                        document.replaceString(lineStart, offset, newSpace);
                        offset = lineStart + newSpace.length();
                        break;
                    }
                    buffer.append(c);
                    ++offset;
                }
                CommentByLineCommentHandler.commentLine(block, line, offset);
            }
        });
    }

    private static void uncommentRange(Document document, int startOffset, int endOffset, @NotNull Commenter commenter) {
        if (commenter == null) {
            CommentByLineCommentHandler.$$$reportNull$$$0(15);
        }
        String commentedSuffix = commenter.getCommentedBlockCommentSuffix();
        String commentedPrefix = commenter.getCommentedBlockCommentPrefix();
        String prefix = commenter.getBlockCommentPrefix();
        String suffix = commenter.getBlockCommentSuffix();
        if (prefix == null || suffix == null) {
            return;
        }
        if (endOffset >= suffix.length() && CharArrayUtil.regionMatches(document.getCharsSequence(), endOffset - suffix.length(), suffix)) {
            document.deleteString(endOffset - suffix.length(), endOffset);
            endOffset -= suffix.length();
        }
        if (commentedPrefix != null && commentedSuffix != null) {
            CommentByBlockCommentHandler.commentNestedComments(document, new TextRange(startOffset, endOffset), commenter);
        }
        document.deleteString(startOffset, startOffset + prefix.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void uncommentLine(Block block, int line, boolean removeSpace) {
        int endOffset;
        Document document = block.editor.getDocument();
        Commenter commenter = block.commenters[line - block.startLine];
        if (commenter == null) {
            commenter = CommentByLineCommentHandler.findCommenter(block.editor, block.psiFile, line);
        }
        if (commenter == null) {
            return;
        }
        int startOffset = block.startOffsets[line - block.startLine];
        if (startOffset == (endOffset = block.endOffsets[line - block.startLine])) {
            return;
        }
        if (commenter instanceof SelfManagingCommenter) {
            SelfManagingCommenter selfManagingCommenter = (SelfManagingCommenter)((Object)commenter);
            selfManagingCommenter.uncommentLine(line, startOffset, document, (CommenterDataHolder)block.commenterStateMap.get(selfManagingCommenter));
            return;
        }
        RangeMarker marker = endOffset > startOffset ? block.editor.getDocument().createRangeMarker(startOffset, endOffset) : null;
        try {
            if (CommentByLineCommentHandler.doUncommentLine(line, document, commenter, startOffset, endOffset, removeSpace)) {
                return;
            }
            if (marker != null) {
                CommentByBlockCommentHandler.processDocument(document, marker, commenter, false);
            }
        }
        finally {
            if (marker != null) {
                marker.dispose();
            }
        }
    }

    private static boolean doUncommentLine(int line, Document document, Commenter commenter, int startOffset, int endOffset, boolean removeSpace) {
        int prefixPos;
        String prefix = commenter.getLineCommentPrefix();
        if (prefix != null) {
            boolean commented;
            int originalPrefixLength = prefix.length();
            if (removeSpace) {
                prefix = prefix + ' ';
            }
            CharSequence chars = document.getCharsSequence();
            if (commenter instanceof CommenterWithLineSuffix) {
                int theEnd;
                CommenterWithLineSuffix commenterWithLineSuffix = (CommenterWithLineSuffix)commenter;
                String suffix = commenterWithLineSuffix.getLineCommentSuffix();
                int n = theEnd = endOffset > 0 ? endOffset : document.getLineEndOffset(line);
                while (theEnd > startOffset && Character.isWhitespace(chars.charAt(theEnd - 1))) {
                    --theEnd;
                }
                int suffixPos = CharArrayUtil.indexOf(chars, suffix, startOffset + originalPrefixLength, theEnd);
                if (suffixPos != -1) {
                    document.deleteString(suffixPos, suffixPos + suffix.length());
                }
            }
            boolean matchesTrimmed = false;
            boolean bl = CharArrayUtil.regionMatches(chars, startOffset, prefix) || (matchesTrimmed = prefix.endsWith(" ") && CharArrayUtil.regionMatches(chars, startOffset, prefix.trim())) ? true : (commented = false);
            assert (commented) : "Commenter: " + commenter;
            int charsToDelete = matchesTrimmed ? prefix.trim().length() : prefix.length();
            document.deleteString(startOffset, startOffset + charsToDelete);
            int lineStartOffset = document.getLineStartOffset(line);
            int lineEndOffset = document.getLineEndOffset(line);
            if (CharArrayUtil.isEmptyOrSpaces(chars, lineStartOffset, lineEndOffset)) {
                document.deleteString(lineStartOffset, lineEndOffset);
            }
            return true;
        }
        String text2 = document.getCharsSequence().subSequence(startOffset, endOffset).toString();
        prefix = commenter.getBlockCommentPrefix();
        String suffix = commenter.getBlockCommentSuffix();
        if (prefix == null || suffix == null) {
            return true;
        }
        IntArrayList prefixes = new IntArrayList();
        IntArrayList suffixes = new IntArrayList();
        int position = 0;
        while (position < text2.length() && (prefixPos = text2.indexOf(prefix, position)) != -1) {
            prefixes.add(prefixPos);
            position = prefixPos + prefix.length();
            int suffixPos = text2.indexOf(suffix, position);
            if (suffixPos == -1) {
                suffixPos = text2.length() - suffix.length();
            }
            suffixes.add(suffixPos);
            position = suffixPos + suffix.length();
        }
        assert (prefixes.size() == suffixes.size());
        for (int i = prefixes.size() - 1; i >= 0; --i) {
            CommentByLineCommentHandler.uncommentRange(document, startOffset + prefixes.get(i), Math.min(startOffset + suffixes.get(i) + suffix.length(), endOffset), commenter);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void commentLine(Block block, int line, int offset) {
        Commenter commenter = block.blockSuitableCommenter;
        Document document = block.editor.getDocument();
        if (commenter == null) {
            commenter = CommentByLineCommentHandler.findCommenter(block.editor, block.psiFile, line);
        }
        if (commenter == null) {
            return;
        }
        if (commenter instanceof SelfManagingCommenter) {
            SelfManagingCommenter selfManagingCommenter = (SelfManagingCommenter)((Object)commenter);
            selfManagingCommenter.commentLine(line, offset, document, (CommenterDataHolder)block.commenterStateMap.get(selfManagingCommenter));
            return;
        }
        int endOffset = document.getLineEndOffset(line);
        RangeMarker marker = document.createRangeMarker(offset, endOffset);
        marker.setGreedyToLeft(true);
        marker.setGreedyToRight(true);
        try {
            if (CommentByLineCommentHandler.doCommentLine(block, line, offset, endOffset, commenter, document)) {
                return;
            }
            CommentByBlockCommentHandler.processDocument(document, marker, commenter, true);
        }
        finally {
            marker.dispose();
        }
    }

    private static boolean doCommentLine(Block block, int line, int offset, int endOffset, Commenter commenter, Document document) {
        String prefix = commenter.getLineCommentPrefix();
        int shiftedStartOffset = CharArrayUtil.shiftForward(document.getCharsSequence(), offset, " \t");
        if (prefix != null) {
            if (commenter instanceof CommenterWithLineSuffix) {
                endOffset = CharArrayUtil.shiftBackward(document.getCharsSequence(), endOffset, " \t");
                String lineSuffix = ((CommenterWithLineSuffix)commenter).getLineCommentSuffix();
                if (!CharArrayUtil.regionMatches(document.getCharsSequence(), shiftedStartOffset, prefix)) {
                    if (!CharArrayUtil.regionMatches(document.getCharsSequence(), endOffset - lineSuffix.length(), lineSuffix)) {
                        document.insertString(endOffset, lineSuffix);
                    }
                    document.insertString(offset, prefix);
                }
            } else {
                if (block.addSpace && shiftedStartOffset < document.getTextLength() && document.getCharsSequence().charAt(shiftedStartOffset) != '\n') {
                    prefix = prefix + ' ';
                }
                document.insertString(offset, prefix);
            }
        } else {
            prefix = commenter.getBlockCommentPrefix();
            String suffix = commenter.getBlockCommentSuffix();
            if (prefix == null || suffix == null) {
                return true;
            }
            if (endOffset == offset && block.startLine != block.endLine) {
                return true;
            }
            int textLength = document.getTextLength();
            CharSequence chars = document.getCharsSequence();
            if (endOffset == textLength) {
                int shifted = CharArrayUtil.shiftBackward(chars, textLength - 1, " \t") + 1;
                if (shifted < textLength) {
                    endOffset = shifted;
                }
            } else {
                endOffset = CharArrayUtil.shiftBackward(chars, endOffset, " \t");
            }
            if (endOffset < offset || offset == textLength - 1 && line != document.getLineCount() - 1) {
                return true;
            }
            String text2 = chars.subSequence(offset, endOffset).toString();
            IntArrayList prefixes = new IntArrayList();
            IntArrayList suffixes = new IntArrayList();
            String commentedSuffix = commenter.getCommentedBlockCommentSuffix();
            String commentedPrefix = commenter.getCommentedBlockCommentPrefix();
            int position = 0;
            while (position < text2.length()) {
                int nearestSuffix;
                int nearestPrefix = text2.indexOf(prefix, position);
                if (nearestPrefix == -1) {
                    nearestPrefix = text2.length();
                }
                if ((nearestSuffix = text2.indexOf(suffix, position)) == -1) {
                    nearestSuffix = text2.length();
                }
                if (Math.min(nearestPrefix, nearestSuffix) == text2.length()) break;
                if (nearestPrefix < nearestSuffix) {
                    prefixes.add(nearestPrefix);
                    position = nearestPrefix + prefix.length();
                    continue;
                }
                suffixes.add(nearestSuffix);
                position = nearestSuffix + suffix.length();
            }
            if (commentedSuffix != null || suffixes.isEmpty() || offset + suffixes.get(suffixes.size() - 1) + suffix.length() < endOffset) {
                document.insertString(endOffset, suffix);
            }
            int nearestPrefix = prefixes.size() - 1;
            int nearestSuffix = suffixes.size() - 1;
            while (nearestPrefix >= 0 || nearestSuffix >= 0) {
                int position2;
                if (nearestSuffix == -1 || nearestPrefix != -1 && prefixes.get(nearestPrefix) > suffixes.get(nearestSuffix)) {
                    position2 = prefixes.get(nearestPrefix);
                    --nearestPrefix;
                    if (commentedPrefix != null) {
                        document.replaceString(offset + position2, offset + position2 + prefix.length(), commentedPrefix);
                        continue;
                    }
                    if (position2 == 0) continue;
                    document.insertString(offset + position2, suffix);
                    continue;
                }
                position2 = suffixes.get(nearestSuffix);
                --nearestSuffix;
                if (commentedSuffix != null) {
                    document.replaceString(offset + position2, offset + position2 + suffix.length(), commentedSuffix);
                    continue;
                }
                if (offset + position2 + suffix.length() >= endOffset) continue;
                document.insertString(offset + position2 + suffix.length(), prefix);
            }
            if (commentedPrefix != null || prefixes.isEmpty() || prefixes.get(0) != 0) {
                document.insertString(offset, prefix);
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/generation/CommentByLineCommentHandler";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commenter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/generation/CommentByLineCommentHandler";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineStartLanguage";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineEndLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "markInjectedFileUnsuitableForLineComment";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shouldCommentInHostFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findCommenter";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLineStartLanguage";
                break;
            }
            case 11: 
            case 14: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getLineEndLanguage";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "uncommentRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum CaretUpdate {
        PUT_AT_COMMENT_START,
        SHIFT_DOWN,
        RESTORE_SELECTION;

    }

    private static class Block {
        private Editor editor;
        private PsiFile psiFile;
        private final List<Caret> carets = new ArrayList<Caret>();
        private int startLine;
        private int endLine;
        private int[] startOffsets;
        private int[] endOffsets;
        private Commenter blockSuitableCommenter;
        private Commenter[] commenters;
        private Map<SelfManagingCommenter, CommenterDataHolder> commenterStateMap;
        private boolean commentWithIndent;
        private CaretUpdate caretUpdate;
        private boolean skip;
        private boolean addSpace;

        private Block() {
        }

        static /* synthetic */ int[] access$702(Block x0, int[] x1) {
            x0.startOffsets = x1;
            return x1;
        }

        static /* synthetic */ int[] access$802(Block x0, int[] x1) {
            x0.endOffsets = x1;
            return x1;
        }

        static /* synthetic */ Commenter[] access$902(Block x0, Commenter[] x1) {
            x0.commenters = x1;
            return x1;
        }
    }
}

