/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.HighlighterIteratorWrapper;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Alarm;
import com.intellij.util.IntIntFunction;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BraceHighlightingHandler {
    private static final Key<List<RangeHighlighter>> BRACE_HIGHLIGHTERS_IN_EDITOR_VIEW_KEY = Key.create("BraceHighlighter.BRACE_HIGHLIGHTERS_IN_EDITOR_VIEW_KEY");
    private static final Key<RangeHighlighter> LINE_MARKER_IN_EDITOR_KEY = Key.create("BraceHighlighter.LINE_MARKER_IN_EDITOR_KEY");
    private static final Key<LightweightHint> HINT_IN_EDITOR_KEY = Key.create("BraceHighlighter.HINT_IN_EDITOR_KEY");
    static final int LAYER = 6001;
    @NotNull
    private final Project myProject;
    @NotNull
    private final EditorEx myEditor;
    private final Alarm myAlarm;
    private final DocumentEx myDocument;
    private final PsiFile myPsiFile;
    private final CodeInsightSettings myCodeInsightSettings;

    BraceHighlightingHandler(@NotNull Project project2, @NotNull EditorEx editor, @NotNull Alarm alarm2, PsiFile psiFile) {
        if (project2 == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(1);
        }
        if (alarm2 == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(2);
        }
        this.myProject = project2;
        this.myEditor = editor;
        this.myAlarm = alarm2;
        this.myDocument = this.myEditor.getDocument();
        this.myPsiFile = psiFile;
        this.myCodeInsightSettings = CodeInsightSettings.getInstance();
    }

    static void lookForInjectedAndMatchBracesInOtherThread(@NotNull Editor editor, @NotNull Alarm alarm2, @NotNull Processor<? super BraceHighlightingHandler> processor2) {
        if (editor == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(3);
        }
        if (alarm2 == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(4);
        }
        if (processor2 == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!BraceHighlightingHandler.isValidEditor(editor)) {
            return;
        }
        Project project2 = Objects.requireNonNull(editor.getProject());
        int offset = editor.getCaretModel().getOffset();
        ReadAction.nonBlocking(() -> {
            PsiFile psiFile = PsiUtilBase.getPsiFileInEditor(editor, project2);
            return psiFile == null || psiFile instanceof PsiBinaryFile ? null : BraceHighlightingHandler.getInjectedFileIfAny(offset, psiFile);
        }).withDocumentsCommitted(project2).expireWhen(() -> !BraceHighlightingHandler.isValidEditor(editor)).coalesceBy(BraceHighlightingHandler.class, editor).finishOnUiThread(ModalityState.stateForComponent(editor.getComponent()), foundFile -> {
            if (foundFile == null) {
                return;
            }
            if (foundFile.isValid() && offset == editor.getCaretModel().getOffset()) {
                EditorEx newEditor = (EditorEx)InjectedLanguageUtil.getInjectedEditorForInjectedFile(editor, foundFile);
                BraceHighlightingHandler handler2 = new BraceHighlightingHandler(project2, newEditor, alarm2, (PsiFile)foundFile);
                processor2.process(handler2);
            } else {
                BraceHighlightingHandler.lookForInjectedAndMatchBracesInOtherThread(editor, alarm2, processor2);
            }
        }).submit(AppExecutorUtil.getAppExecutorService());
    }

    private static boolean isValidEditor(@NotNull Editor editor) {
        Project editorProject;
        if (editor == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(6);
        }
        return (editorProject = editor.getProject()) != null && !editorProject.isDisposed() && !editor.isDisposed() && editor.getComponent().isShowing();
    }

    @NotNull
    private static PsiFile getInjectedFileIfAny(int offset, @NotNull PsiFile psiFile) {
        PsiFile injected;
        PsiElement injectedElement;
        if (psiFile == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(7);
        }
        if ((injectedElement = InjectedLanguageManager.getInstance(psiFile.getProject()).findInjectedElementAt(psiFile, offset)) != null && (injected = injectedElement.getContainingFile()) != null) {
            PsiFile psiFile2 = injected;
            if (psiFile2 == null) {
                BraceHighlightingHandler.$$$reportNull$$$0(8);
            }
            return psiFile2;
        }
        PsiFile psiFile3 = psiFile;
        if (psiFile3 == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(9);
        }
        return psiFile3;
    }

    @NotNull
    public static EditorHighlighter getLazyParsableHighlighterIfAny(Project project2, Editor editor, PsiFile psiFile) {
        if (!PsiDocumentManager.getInstance(project2).isCommitted(editor.getDocument())) {
            EditorHighlighter editorHighlighter = ((EditorEx)editor).getHighlighter();
            if (editorHighlighter == null) {
                BraceHighlightingHandler.$$$reportNull$$$0(10);
            }
            return editorHighlighter;
        }
        PsiElement elementAt = psiFile.findElementAt(editor.getCaretModel().getOffset());
        for (PsiElement e : SyntaxTraverser.psiApi().parents(elementAt).takeWhile(Conditions.notEqualTo(psiFile))) {
            Language language2;
            if (!(PsiUtilCore.getElementType(e) instanceof ILazyParseableElementType) || (language2 = ILazyParseableElementType.LANGUAGE_KEY.get(e.getNode())) == null) continue;
            TextRange range2 = e.getTextRange();
            final int offset = range2.getStartOffset();
            SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter(language2, project2, psiFile.getVirtualFile());
            LexerEditorHighlighter highlighter = new LexerEditorHighlighter(syntaxHighlighter, editor.getColorsScheme()){

                @Override
                @NotNull
                public HighlighterIterator createIterator(int startOffset) {
                    return new HighlighterIteratorWrapper(super.createIterator(Math.max(startOffset - offset, 0))){

                        @Override
                        public int getStart() {
                            return super.getStart() + offset;
                        }

                        @Override
                        public int getEnd() {
                            return super.getEnd() + offset;
                        }
                    };
                }
            };
            highlighter.setText(editor.getDocument().getText(range2));
            LexerEditorHighlighter lexerEditorHighlighter = highlighter;
            if (lexerEditorHighlighter == null) {
                BraceHighlightingHandler.$$$reportNull$$$0(11);
            }
            return lexerEditorHighlighter;
        }
        EditorHighlighter editorHighlighter = ((EditorEx)editor).getHighlighter();
        if (editorHighlighter == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(12);
        }
        return editorHighlighter;
    }

    void updateBraces() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.clearBraceHighlighters();
        if (this.myPsiFile == null || !this.myPsiFile.isValid()) {
            return;
        }
        if (!this.myCodeInsightSettings.HIGHLIGHT_BRACES) {
            return;
        }
        if (this.myEditor.getSelectionModel().hasSelection()) {
            return;
        }
        if (this.myEditor.getSoftWrapModel().isInsideOrBeforeSoftWrap(this.myEditor.getCaretModel().getVisualPosition())) {
            return;
        }
        int offset = this.myEditor.getCaretModel().getOffset();
        CharSequence chars = this.myEditor.getDocument().getCharsSequence();
        this.myAlarm.cancelAllRequests();
        BraceMatchingUtil.BraceHighlightingAndNavigationContext context = BraceMatchingUtil.computeHighlightingAndNavigationContext(this.myEditor, this.myPsiFile);
        if (context != null) {
            this.doHighlight(context.currentBraceOffset);
            offset = context.currentBraceOffset;
        } else if (offset > 0 && offset < chars.length()) {
            int nextNonSpaceCharOffset;
            char c = chars.charAt(offset);
            boolean searchForward = c != '\n';
            int backwardNonSpaceEndOffset = CharArrayUtil.shiftBackward(chars, offset - 1, "\t ") + 1;
            if (backwardNonSpaceEndOffset > 0 && backwardNonSpaceEndOffset < offset && (context = BraceMatchingUtil.computeHighlightingAndNavigationContext(this.myEditor, this.myPsiFile, backwardNonSpaceEndOffset)) != null) {
                this.doHighlight(context.currentBraceOffset);
                offset = context.currentBraceOffset;
                searchForward = false;
            }
            if (searchForward && (nextNonSpaceCharOffset = CharArrayUtil.shiftForward(chars, offset, "\t ")) > offset && (context = BraceMatchingUtil.computeHighlightingAndNavigationContext(this.myEditor, this.myPsiFile, nextNonSpaceCharOffset)) != null) {
                this.doHighlight(context.currentBraceOffset);
                offset = context.currentBraceOffset;
            }
        }
        if (this.myCodeInsightSettings.HIGHLIGHT_SCOPE) {
            this.highlightScope(offset);
        }
    }

    @NotNull
    private FileType getFileTypeByOffset(int offset) {
        FileType fileType = PsiUtilBase.getPsiFileAtOffset(this.myPsiFile, offset).getFileType();
        if (fileType == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(13);
        }
        return fileType;
    }

    @NotNull
    private EditorHighlighter getEditorHighlighter() {
        return BraceHighlightingHandler.getLazyParsableHighlighterIfAny(this.myProject, this.myEditor, this.myPsiFile);
    }

    private void highlightScope(int offset) {
        if (!this.myPsiFile.isValid()) {
            return;
        }
        if (this.myEditor.getFoldingModel().isOffsetCollapsed(offset)) {
            return;
        }
        if (this.myEditor.getDocument().getTextLength() <= offset) {
            return;
        }
        HighlighterIterator iterator2 = this.getEditorHighlighter().createIterator(offset);
        CharSequence chars = this.myDocument.getCharsSequence();
        FileType fileType = this.getFileTypeByOffset(offset);
        if ((!BraceMatchingUtil.isStructuralBraceToken(fileType, iterator2, chars) || !BraceMatchingUtil.isRBraceToken(iterator2, chars, fileType) && !BraceMatchingUtil.isLBraceToken(iterator2, chars, fileType)) && BraceMatchingUtil.findStructuralLeftBrace(fileType, iterator2, chars)) {
            this.highlightLeftBrace(iterator2, true, fileType);
        }
    }

    private void doHighlight(int offset) {
        FileType fileType;
        CharSequence chars;
        if (this.myEditor.getFoldingModel().isOffsetCollapsed(offset)) {
            return;
        }
        HighlighterIterator iterator2 = this.getEditorHighlighter().createIterator(offset);
        if (BraceMatchingUtil.isLBraceToken(iterator2, chars = this.myDocument.getCharsSequence(), fileType = this.getFileTypeByOffset(offset))) {
            this.highlightLeftBrace(iterator2, false, fileType);
            if (offset > 0 && BraceMatchingUtil.isRBraceToken(iterator2 = this.getEditorHighlighter().createIterator(offset - 1), chars, fileType)) {
                this.highlightRightBrace(iterator2, fileType);
            }
        } else if (BraceMatchingUtil.isRBraceToken(iterator2, chars, fileType)) {
            this.highlightRightBrace(iterator2, fileType);
        }
    }

    private void highlightRightBrace(@NotNull HighlighterIterator iterator2, @NotNull FileType fileType) {
        if (iterator2 == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(14);
        }
        if (fileType == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(15);
        }
        TextRange brace1 = TextRange.create(iterator2.getStart(), iterator2.getEnd());
        boolean matched = BraceMatchingUtil.matchBrace(this.myDocument.getCharsSequence(), fileType, iterator2, false);
        TextRange brace2 = iterator2.atEnd() ? null : TextRange.create(iterator2.getStart(), iterator2.getEnd());
        this.highlightBraces(brace2, brace1, matched, false, fileType);
    }

    private void highlightLeftBrace(@NotNull HighlighterIterator iterator2, boolean scopeHighlighting, @NotNull FileType fileType) {
        if (iterator2 == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(16);
        }
        if (fileType == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(17);
        }
        TextRange brace1Start = TextRange.create(iterator2.getStart(), iterator2.getEnd());
        boolean matched = BraceMatchingUtil.matchBrace(this.myDocument.getCharsSequence(), fileType, iterator2, true);
        TextRange brace2End = iterator2.atEnd() ? null : TextRange.create(iterator2.getStart(), iterator2.getEnd());
        this.highlightBraces(brace1Start, brace2End, matched, scopeHighlighting, fileType);
    }

    private void highlightBraces(@Nullable TextRange lBrace, @Nullable TextRange rBrace, boolean matched, boolean scopeHighlighting, @NotNull FileType fileType) {
        FileEditorManager fileEditorManager;
        if (fileType == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(18);
        }
        if (!matched && fileType == FileTypes.PLAIN_TEXT) {
            return;
        }
        if (rBrace != null && !scopeHighlighting) {
            this.highlightBrace(rBrace, matched);
        }
        if (lBrace != null && !scopeHighlighting) {
            this.highlightBrace(lBrace, matched);
        }
        if ((fileEditorManager = FileEditorManager.getInstance(this.myProject)) == null || !this.myEditor.equals(fileEditorManager.getSelectedTextEditor())) {
            return;
        }
        if (lBrace != null && rBrace != null) {
            int endLine = this.myEditor.offsetToLogicalPosition((int)rBrace.getEndOffset()).line;
            int startLine = this.myEditor.offsetToLogicalPosition((int)lBrace.getStartOffset()).line;
            if (endLine - startLine > 0) {
                BraceHighlightingHandler.lineMarkFragment(this.myEditor, this.myDocument, startLine, endLine, matched);
            }
            if (!scopeHighlighting) {
                this.showScopeHint(lBrace.getStartOffset(), lBrace.getEndOffset());
            }
        }
    }

    private void highlightBrace(@NotNull TextRange braceRange, boolean matched) {
        if (braceRange == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(19);
        }
        EditorColorsScheme scheme = this.myEditor.getColorsScheme();
        TextAttributes attributes = matched ? scheme.getAttributes(CodeInsightColors.MATCHED_BRACE_ATTRIBUTES) : scheme.getAttributes(CodeInsightColors.UNMATCHED_BRACE_ATTRIBUTES);
        RangeHighlighter rbraceHighlighter = this.myEditor.getMarkupModel().addRangeHighlighter(braceRange.getStartOffset(), braceRange.getEndOffset(), 6001, attributes, HighlighterTargetArea.EXACT_RANGE);
        rbraceHighlighter.setGreedyToLeft(false);
        rbraceHighlighter.setGreedyToRight(false);
        this.registerHighlighter(rbraceHighlighter);
    }

    private void registerHighlighter(@NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(20);
        }
        this.getHighlightersList().add(highlighter);
    }

    @NotNull
    private List<RangeHighlighter> getHighlightersList() {
        Editor editor = this.myEditor instanceof EditorWindow ? ((EditorWindow)((Object)this.myEditor)).getDelegate() : this.myEditor;
        List<RangeHighlighter> highlighters = editor.getUserData(BRACE_HIGHLIGHTERS_IN_EDITOR_VIEW_KEY);
        if (highlighters == null) {
            highlighters = new ArrayList<RangeHighlighter>();
            editor.putUserData(BRACE_HIGHLIGHTERS_IN_EDITOR_VIEW_KEY, highlighters);
        }
        List<RangeHighlighter> list2 = highlighters;
        if (list2 == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(21);
        }
        return list2;
    }

    private void showScopeHint(int lbraceStart, int lbraceEnd) {
        BraceHighlightingHandler.showScopeHint(this.myEditor, this.myAlarm, lbraceStart, lbraceEnd, it -> {
            if (!(this.myPsiFile instanceof PsiPlainTextFile) && this.myPsiFile.isValid()) {
                return BraceMatchingUtil.getBraceMatcher(this.getFileTypeByOffset(it), PsiUtilCore.getLanguageAtOffset(this.myPsiFile, it)).getCodeConstructStart(this.myPsiFile, it);
            }
            return it;
        });
    }

    public static void showScopeHint(@NotNull Editor editor, @NotNull Alarm alarm2, int leftBraceStart, int leftBraceEnd, @Nullable IntIntFunction startComputation) {
        Project project2;
        if (editor == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(22);
        }
        if (alarm2 == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(23);
        }
        if ((project2 = editor.getProject()) == null) {
            return;
        }
        LogicalPosition bracePosition = editor.offsetToLogicalPosition(leftBraceStart);
        Point braceLocation = editor.logicalPositionToXY(bracePosition);
        int y = braceLocation.y;
        alarm2.addRequest(() -> ReadAction.run(() -> {
            if (project2.isDisposed()) {
                return;
            }
            PsiDocumentManager.getInstance(project2).performLaterWhenAllCommitted(() -> {
                if (editor.isDisposed() || !editor.getComponent().isShowing()) {
                    return;
                }
                Rectangle viewRect = editor.getScrollingModel().getVisibleArea();
                if (y >= viewRect.y) {
                    return;
                }
                TextRange range2 = new TextRange(startComputation == null ? leftBraceStart : startComputation.fun(leftBraceStart), leftBraceEnd);
                Document document = editor.getDocument();
                int line1 = document.getLineNumber(range2.getStartOffset());
                int line2 = document.getLineNumber(range2.getEndOffset());
                line1 = Math.max(line1, line2 - EditorFragmentComponent.getAvailableVisualLinesAboveEditor(editor) + 1);
                range2 = new TextRange(document.getLineStartOffset(line1), range2.getEndOffset());
                LightweightHint hint = EditorFragmentComponent.showEditorFragmentHint(editor, range2, true, true);
                editor.putUserData(HINT_IN_EDITOR_KEY, hint);
            });
        }), 300, ModalityState.stateForComponent(editor.getComponent()));
    }

    void clearBraceHighlighters() {
        List<RangeHighlighter> highlighters = this.getHighlightersList();
        for (RangeHighlighter highlighter : highlighters) {
            highlighter.dispose();
        }
        highlighters.clear();
        LightweightHint hint = this.myEditor.getUserData(HINT_IN_EDITOR_KEY);
        if (hint != null) {
            hint.hide();
            this.myEditor.putUserData(HINT_IN_EDITOR_KEY, null);
        }
        BraceHighlightingHandler.removeLineMarkers(this.myEditor);
    }

    public static void lineMarkFragment(@NotNull EditorEx editor, @NotNull Document document, int startLine, int endLine, boolean matched) {
        if (editor == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(24);
        }
        if (document == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(25);
        }
        BraceHighlightingHandler.removeLineMarkers(editor);
        if (startLine >= endLine || endLine >= document.getLineCount()) {
            return;
        }
        int startOffset = document.getLineStartOffset(startLine);
        int endOffset = document.getLineEndOffset(endLine);
        LineMarkerRenderer renderer = BraceHighlightingHandler.createLineMarkerRenderer(matched);
        if (renderer == null) {
            return;
        }
        RangeHighlighterEx highlighter = editor.getMarkupModel().addRangeHighlighterAndChangeAttributes(startOffset, endOffset, 0, null, HighlighterTargetArea.LINES_IN_RANGE, false, h -> h.setLineMarkerRenderer(renderer));
        editor.putUserData(LINE_MARKER_IN_EDITOR_KEY, highlighter);
    }

    private static void removeLineMarkers(@NotNull EditorEx editor) {
        if (editor == null) {
            BraceHighlightingHandler.$$$reportNull$$$0(26);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        RangeHighlighter marker = editor.getUserData(LINE_MARKER_IN_EDITOR_KEY);
        if (marker != null && editor.getMarkupModel().containsHighlighter(marker)) {
            marker.dispose();
        }
        editor.putUserData(LINE_MARKER_IN_EDITOR_KEY, null);
    }

    @Nullable
    public static LineMarkerRenderer createLineMarkerRenderer(boolean matched) {
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes attributes = matched ? scheme.getAttributes(CodeInsightColors.MATCHED_BRACE_ATTRIBUTES) : scheme.getAttributes(CodeInsightColors.UNMATCHED_BRACE_ATTRIBUTES);
        Color color = attributes.getBackgroundColor();
        if (color == null) {
            return null;
        }
        color = ColorUtil.isDark(scheme.getDefaultBackground()) ? ColorUtil.shift(color, 1.5) : color.darker();
        return new MyLineMarkerRenderer(color);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 4: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alarm";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/BraceHighlightingHandler";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "braceRange";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/BraceHighlightingHandler";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedFileIfAny";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLazyParsableHighlighterIfAny";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypeByOffset";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightersList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lookForInjectedAndMatchBracesInOtherThread";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isValidEditor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedFileIfAny";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 21: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "highlightRightBrace";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "highlightLeftBrace";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "highlightBraces";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "highlightBrace";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "registerHighlighter";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "showScopeHint";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lineMarkFragment";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "removeLineMarkers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyLineMarkerRenderer
    implements LineMarkerRenderer {
        private static final int DEEPNESS = 0;
        private static final int THICKNESS = 1;
        private final Color myColor;

        private MyLineMarkerRenderer(@NotNull Color color) {
            if (color == null) {
                MyLineMarkerRenderer.$$$reportNull$$$0(0);
            }
            this.myColor = color;
        }

        @Override
        public void paint(Editor editor, Graphics g, Rectangle r) {
            g.setColor(this.myColor);
            g.fillRect(r.x, r.y, 1, r.height);
            g.fillRect(r.x + 1, r.y, 0, 1);
            g.fillRect(r.x + 1, r.y + r.height - 1, 0, 1);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/codeInsight/highlighting/BraceHighlightingHandler$MyLineMarkerRenderer", "<init>"));
        }
    }
}

