/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.BraceHighlightingHandler;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.FileTypeBraceMather;
import com.intellij.codeInsight.highlighting.PairedBraceMatcherAdapter;
import com.intellij.codeInsight.highlighting.XmlAwareBraceMatcher;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.ide.highlighter.custom.impl.CustomFileTypeBraceMatcher;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageBraceMatching;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.containers.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BraceMatchingUtil {
    public static final int UNDEFINED_TOKEN_GROUP = -1;

    private BraceMatchingUtil() {
    }

    public static boolean isPairedBracesAllowedBeforeTypeInFileType(@NotNull IElementType lbraceType, IElementType tokenType, @NotNull FileType fileType) {
        if (lbraceType == null) {
            BraceMatchingUtil.$$$reportNull$$$0(0);
        }
        if (fileType == null) {
            BraceMatchingUtil.$$$reportNull$$$0(1);
        }
        try {
            return BraceMatchingUtil.getBraceMatcher(fileType, lbraceType).isPairedBracesAllowedBeforeType(lbraceType, tokenType);
        }
        catch (AbstractMethodError abstractMethodError) {
            return true;
        }
    }

    public static int getMatchedBraceOffset(@NotNull Editor editor, boolean forward, @NotNull PsiFile file2) {
        if (editor == null) {
            BraceMatchingUtil.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            BraceMatchingUtil.$$$reportNull$$$0(3);
        }
        Document document = editor.getDocument();
        int offset = editor.getCaretModel().getOffset();
        EditorHighlighter editorHighlighter = BraceHighlightingHandler.getLazyParsableHighlighterIfAny(file2.getProject(), editor, file2);
        HighlighterIterator iterator2 = editorHighlighter.createIterator(offset);
        boolean matched = BraceMatchingUtil.matchBrace(document.getCharsSequence(), file2.getFileType(), iterator2, forward);
        if (!matched) {
            throw new AssertionError();
        }
        return iterator2.getStart();
    }

    @Nullable
    public static BraceHighlightingAndNavigationContext computeHighlightingAndNavigationContext(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            BraceMatchingUtil.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            BraceMatchingUtil.$$$reportNull$$$0(5);
        }
        return BraceMatchingUtil.computeHighlightingAndNavigationContext(editor, file2, editor.getCaretModel().getOffset());
    }

    @Nullable
    public static BraceHighlightingAndNavigationContext computeHighlightingAndNavigationContext(@NotNull Editor editor, @NotNull PsiFile file2, int offset) {
        int preOffsetTokenStart;
        if (editor == null) {
            BraceMatchingUtil.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            BraceMatchingUtil.$$$reportNull$$$0(7);
        }
        EditorHighlighter highlighter = BraceHighlightingHandler.getLazyParsableHighlighterIfAny(file2.getProject(), editor, file2);
        CharSequence text2 = editor.getDocument().getCharsSequence();
        HighlighterIterator iterator2 = highlighter.createIterator(offset);
        FileType fileType = iterator2.atEnd() ? null : BraceMatchingUtil.getFileType(file2, iterator2.getStart());
        HighlighterIterator preOffsetIterator = offset > 0 ? highlighter.createIterator(offset - 1) : null;
        FileType preOffsetFileType = preOffsetIterator != null ? BraceMatchingUtil.getFileType(file2, preOffsetIterator.getStart()) : null;
        boolean isAfterLeftBrace = preOffsetIterator != null && BraceMatchingUtil.isLBraceToken(preOffsetIterator, text2, preOffsetFileType);
        boolean isAfterRightBrace = !isAfterLeftBrace && preOffsetIterator != null && BraceMatchingUtil.isRBraceToken(preOffsetIterator, text2, preOffsetFileType);
        boolean isBeforeLeftBrace = fileType != null && BraceMatchingUtil.isLBraceToken(iterator2, text2, fileType);
        boolean isBeforeRightBrace = !isBeforeLeftBrace && fileType != null && BraceMatchingUtil.isRBraceToken(iterator2, text2, fileType);
        int offsetTokenStart = iterator2.atEnd() ? -1 : iterator2.getStart();
        int n = preOffsetTokenStart = preOffsetIterator == null || preOffsetIterator.atEnd() ? -1 : preOffsetIterator.getStart();
        if (editor.getSettings().isBlockCursor()) {
            if (isBeforeLeftBrace && BraceMatchingUtil.matchBrace(text2, fileType, iterator2, true)) {
                return new BraceHighlightingAndNavigationContext(offsetTokenStart, iterator2.getStart());
            }
            if (isBeforeRightBrace && BraceMatchingUtil.matchBrace(text2, fileType, iterator2, false)) {
                return new BraceHighlightingAndNavigationContext(offsetTokenStart, iterator2.getStart());
            }
            if (isAfterRightBrace && BraceMatchingUtil.matchBrace(text2, preOffsetFileType, preOffsetIterator, false)) {
                return new BraceHighlightingAndNavigationContext(preOffsetTokenStart, preOffsetIterator.getStart());
            }
            if (isAfterLeftBrace && BraceMatchingUtil.matchBrace(text2, preOffsetFileType, preOffsetIterator, true)) {
                return new BraceHighlightingAndNavigationContext(preOffsetTokenStart, preOffsetIterator.getStart());
            }
        } else {
            if (isAfterRightBrace && BraceMatchingUtil.matchBrace(text2, preOffsetFileType, preOffsetIterator, false)) {
                return new BraceHighlightingAndNavigationContext(preOffsetTokenStart, preOffsetIterator.getStart());
            }
            if (isBeforeLeftBrace && BraceMatchingUtil.matchBrace(text2, fileType, iterator2, true)) {
                return new BraceHighlightingAndNavigationContext(offsetTokenStart, iterator2.getEnd());
            }
            if (isAfterLeftBrace && BraceMatchingUtil.matchBrace(text2, preOffsetFileType, preOffsetIterator, true)) {
                return new BraceHighlightingAndNavigationContext(preOffsetTokenStart, preOffsetIterator.getEnd());
            }
            if (isBeforeRightBrace && BraceMatchingUtil.matchBrace(text2, fileType, iterator2, false)) {
                return new BraceHighlightingAndNavigationContext(offsetTokenStart, iterator2.getStart());
            }
        }
        return null;
    }

    @NotNull
    public static FileType getFileType(PsiFile file2, int offset) {
        FileType fileType = PsiUtilBase.getPsiFileAtOffset(file2, offset).getFileType();
        if (fileType == null) {
            BraceMatchingUtil.$$$reportNull$$$0(8);
        }
        return fileType;
    }

    public static synchronized boolean matchBrace(@NotNull CharSequence fileText, @NotNull FileType fileType, @NotNull HighlighterIterator iterator2, boolean forward) {
        if (fileText == null) {
            BraceMatchingUtil.$$$reportNull$$$0(9);
        }
        if (fileType == null) {
            BraceMatchingUtil.$$$reportNull$$$0(10);
        }
        if (iterator2 == null) {
            BraceMatchingUtil.$$$reportNull$$$0(11);
        }
        return new MatchBraceContext(fileText, fileType, iterator2, forward).doBraceMatch();
    }

    public static synchronized boolean matchBrace(@NotNull CharSequence fileText, @NotNull FileType fileType, @NotNull HighlighterIterator iterator2, boolean forward, boolean isStrict) {
        if (fileText == null) {
            BraceMatchingUtil.$$$reportNull$$$0(12);
        }
        if (fileType == null) {
            BraceMatchingUtil.$$$reportNull$$$0(13);
        }
        if (iterator2 == null) {
            BraceMatchingUtil.$$$reportNull$$$0(14);
        }
        return new MatchBraceContext(fileText, fileType, iterator2, forward, isStrict).doBraceMatch();
    }

    public static boolean findStructuralLeftBrace(@NotNull FileType fileType, @NotNull HighlighterIterator iterator2, @NotNull CharSequence fileText) {
        if (fileType == null) {
            BraceMatchingUtil.$$$reportNull$$$0(15);
        }
        if (iterator2 == null) {
            BraceMatchingUtil.$$$reportNull$$$0(16);
        }
        if (fileText == null) {
            BraceMatchingUtil.$$$reportNull$$$0(17);
        }
        Stack<IElementType> braceStack = new Stack<IElementType>();
        Stack<String> tagNameStack = new Stack<String>();
        BraceMatcher matcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator2);
        while (!iterator2.atEnd()) {
            if (BraceMatchingUtil.isStructuralBraceToken(fileType, iterator2, fileText)) {
                if (BraceMatchingUtil.isRBraceToken(iterator2, fileText, fileType)) {
                    braceStack.push(iterator2.getTokenType());
                    tagNameStack.push(BraceMatchingUtil.getTagName(matcher, fileText, iterator2));
                }
                if (BraceMatchingUtil.isLBraceToken(iterator2, fileText, fileType)) {
                    if (braceStack.isEmpty()) {
                        return true;
                    }
                    int group = matcher.getBraceTokenGroupId(iterator2.getTokenType());
                    IElementType topTokenType = (IElementType)braceStack.pop();
                    IElementType tokenType = iterator2.getTokenType();
                    boolean isStrict = BraceMatchingUtil.isStrictTagMatching(matcher, fileType, group);
                    boolean isCaseSensitive = BraceMatchingUtil.areTagsCaseSensitive(matcher, fileType, group);
                    String topTagName = null;
                    String tagName = null;
                    if (isStrict) {
                        topTagName = (String)tagNameStack.pop();
                        tagName = BraceMatchingUtil.getTagName(matcher, fileText, iterator2);
                    }
                    if (!BraceMatchingUtil.isPairBraces(topTokenType, tokenType, fileType) || isStrict && !Comparing.equal(topTagName, tagName, isCaseSensitive)) {
                        return false;
                    }
                }
            }
            iterator2.retreat();
        }
        return false;
    }

    public static boolean isStructuralBraceToken(@NotNull FileType fileType, @NotNull HighlighterIterator iterator2, @NotNull CharSequence text2) {
        if (fileType == null) {
            BraceMatchingUtil.$$$reportNull$$$0(18);
        }
        if (iterator2 == null) {
            BraceMatchingUtil.$$$reportNull$$$0(19);
        }
        if (text2 == null) {
            BraceMatchingUtil.$$$reportNull$$$0(20);
        }
        BraceMatcher matcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator2);
        return matcher.isStructuralBrace(iterator2, text2, fileType);
    }

    public static boolean isLBraceToken(@NotNull HighlighterIterator iterator2, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        if (iterator2 == null) {
            BraceMatchingUtil.$$$reportNull$$$0(21);
        }
        if (fileText == null) {
            BraceMatchingUtil.$$$reportNull$$$0(22);
        }
        if (fileType == null) {
            BraceMatchingUtil.$$$reportNull$$$0(23);
        }
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator2);
        return braceMatcher.isLBraceToken(iterator2, fileText, fileType);
    }

    public static boolean isRBraceToken(@NotNull HighlighterIterator iterator2, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        if (iterator2 == null) {
            BraceMatchingUtil.$$$reportNull$$$0(24);
        }
        if (fileText == null) {
            BraceMatchingUtil.$$$reportNull$$$0(25);
        }
        if (fileType == null) {
            BraceMatchingUtil.$$$reportNull$$$0(26);
        }
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator2);
        return braceMatcher.isRBraceToken(iterator2, fileText, fileType);
    }

    public static boolean isPairBraces(@NotNull IElementType tokenType1, @NotNull IElementType tokenType2, @NotNull FileType fileType) {
        if (tokenType1 == null) {
            BraceMatchingUtil.$$$reportNull$$$0(27);
        }
        if (tokenType2 == null) {
            BraceMatchingUtil.$$$reportNull$$$0(28);
        }
        if (fileType == null) {
            BraceMatchingUtil.$$$reportNull$$$0(29);
        }
        BraceMatcher matcher = BraceMatchingUtil.getBraceMatcher(fileType, tokenType1);
        return matcher.isPairBraces(tokenType1, tokenType2);
    }

    private static int getTokenGroup(@Nullable IElementType tokenType, FileType fileType) {
        return tokenType == null ? -1 : BraceMatchingUtil.getBraceMatcher(fileType, tokenType).getBraceTokenGroupId(tokenType);
    }

    public static int findLeftmostLParen(@NotNull HighlighterIterator iterator2, @NotNull IElementType lparenTokenType, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        if (iterator2 == null) {
            BraceMatchingUtil.$$$reportNull$$$0(30);
        }
        if (lparenTokenType == null) {
            BraceMatchingUtil.$$$reportNull$$$0(31);
        }
        if (fileText == null) {
            BraceMatchingUtil.$$$reportNull$$$0(32);
        }
        if (fileType == null) {
            BraceMatchingUtil.$$$reportNull$$$0(33);
        }
        return BraceMatchingUtil.findLeftOrRightParenth(iterator2, lparenTokenType, fileText, fileType, false, false);
    }

    public static int findLeftLParen(@NotNull HighlighterIterator iterator2, @NotNull IElementType lparenTokenType, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        if (iterator2 == null) {
            BraceMatchingUtil.$$$reportNull$$$0(34);
        }
        if (lparenTokenType == null) {
            BraceMatchingUtil.$$$reportNull$$$0(35);
        }
        if (fileText == null) {
            BraceMatchingUtil.$$$reportNull$$$0(36);
        }
        if (fileType == null) {
            BraceMatchingUtil.$$$reportNull$$$0(37);
        }
        return BraceMatchingUtil.findLeftOrRightParenth(iterator2, lparenTokenType, fileText, fileType, false, true);
    }

    public static int findRightmostRParen(@NotNull HighlighterIterator iterator2, @NotNull IElementType rparenTokenType, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        if (iterator2 == null) {
            BraceMatchingUtil.$$$reportNull$$$0(38);
        }
        if (rparenTokenType == null) {
            BraceMatchingUtil.$$$reportNull$$$0(39);
        }
        if (fileText == null) {
            BraceMatchingUtil.$$$reportNull$$$0(40);
        }
        if (fileType == null) {
            BraceMatchingUtil.$$$reportNull$$$0(41);
        }
        return BraceMatchingUtil.findLeftOrRightParenth(iterator2, rparenTokenType, fileText, fileType, true, false);
    }

    private static int findLeftOrRightParenth(@NotNull HighlighterIterator iterator2, @NotNull IElementType targetParenTokenType, @NotNull CharSequence fileText, @NotNull FileType fileType, boolean searchingForRight, boolean stopOnFirstFinishedGroup) {
        if (iterator2 == null) {
            BraceMatchingUtil.$$$reportNull$$$0(42);
        }
        if (targetParenTokenType == null) {
            BraceMatchingUtil.$$$reportNull$$$0(43);
        }
        if (fileText == null) {
            BraceMatchingUtil.$$$reportNull$$$0(44);
        }
        if (fileType == null) {
            BraceMatchingUtil.$$$reportNull$$$0(45);
        }
        int lastBraceOffset = -1;
        Stack<IElementType> braceStack = new Stack<IElementType>();
        while (!iterator2.atEnd()) {
            IElementType tokenType = iterator2.getTokenType();
            if (BraceMatchingUtil.isBraceToken(iterator2, fileText, fileType, searchingForRight)) {
                if (braceStack.isEmpty()) {
                    if (tokenType != targetParenTokenType) break;
                    lastBraceOffset = iterator2.getStart();
                    if (stopOnFirstFinishedGroup) {
                        break;
                    }
                } else {
                    IElementType topToken = (IElementType)braceStack.pop();
                    if (!BraceMatchingUtil.isPairBraces(tokenType, topToken, fileType)) {
                        break;
                    }
                }
            } else if (BraceMatchingUtil.isBraceToken(iterator2, fileText, fileType, !searchingForRight)) {
                braceStack.push(iterator2.getTokenType());
            }
            BraceMatchingUtil.advance(iterator2, searchingForRight);
        }
        return lastBraceOffset;
    }

    private static boolean isBraceToken(@NotNull HighlighterIterator iterator2, @NotNull CharSequence fileText, @NotNull FileType fileType, boolean searchingForRight) {
        if (iterator2 == null) {
            BraceMatchingUtil.$$$reportNull$$$0(46);
        }
        if (fileText == null) {
            BraceMatchingUtil.$$$reportNull$$$0(47);
        }
        if (fileType == null) {
            BraceMatchingUtil.$$$reportNull$$$0(48);
        }
        return searchingForRight ? BraceMatchingUtil.isRBraceToken(iterator2, fileText, fileType) : BraceMatchingUtil.isLBraceToken(iterator2, fileText, fileType);
    }

    private static void advance(@NotNull HighlighterIterator iterator2, boolean forward) {
        if (iterator2 == null) {
            BraceMatchingUtil.$$$reportNull$$$0(49);
        }
        if (forward) {
            iterator2.advance();
        } else {
            iterator2.retreat();
        }
    }

    @NotNull
    public static BraceMatcher getBraceMatcher(@NotNull FileType fileType, @NotNull HighlighterIterator iterator2) {
        IElementType tokenType;
        if (fileType == null) {
            BraceMatchingUtil.$$$reportNull$$$0(50);
        }
        if (iterator2 == null) {
            BraceMatchingUtil.$$$reportNull$$$0(51);
        }
        return (tokenType = iterator2.getTokenType()) == null ? BraceMatcherHolder.ourDefaultBraceMatcher : BraceMatchingUtil.getBraceMatcher(fileType, tokenType);
    }

    @NotNull
    public static BraceMatcher getBraceMatcher(@NotNull FileType fileType, @NotNull IElementType type) {
        if (fileType == null) {
            BraceMatchingUtil.$$$reportNull$$$0(52);
        }
        if (type == null) {
            BraceMatchingUtil.$$$reportNull$$$0(53);
        }
        return BraceMatchingUtil.getBraceMatcher(fileType, type.getLanguage());
    }

    @NotNull
    public static BraceMatcher getBraceMatcher(@NotNull FileType fileType, @NotNull Language lang2) {
        Language language2;
        PairedBraceMatcher matcher;
        if (fileType == null) {
            BraceMatchingUtil.$$$reportNull$$$0(54);
        }
        if (lang2 == null) {
            BraceMatchingUtil.$$$reportNull$$$0(55);
        }
        if ((matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(lang2)) != null) {
            if (matcher instanceof XmlAwareBraceMatcher) {
                XmlAwareBraceMatcher xmlAwareBraceMatcher = (XmlAwareBraceMatcher)((Object)matcher);
                if (xmlAwareBraceMatcher == null) {
                    BraceMatchingUtil.$$$reportNull$$$0(56);
                }
                return xmlAwareBraceMatcher;
            }
            if (matcher instanceof PairedBraceMatcherAdapter) {
                BraceMatcher braceMatcher = (BraceMatcher)((Object)matcher);
                if (braceMatcher == null) {
                    BraceMatchingUtil.$$$reportNull$$$0(57);
                }
                return braceMatcher;
            }
            return new PairedBraceMatcherAdapter(matcher, lang2);
        }
        BraceMatcher byFileType = BraceMatchingUtil.getBraceMatcherByFileType(fileType);
        if (byFileType != null) {
            BraceMatcher braceMatcher = byFileType;
            if (braceMatcher == null) {
                BraceMatchingUtil.$$$reportNull$$$0(58);
            }
            return braceMatcher;
        }
        if (fileType instanceof LanguageFileType && lang2 != (language2 = ((LanguageFileType)fileType).getLanguage())) {
            BraceMatcher braceMatcher;
            LanguageFileType type1 = lang2.getAssociatedFileType();
            if (type1 != null && (braceMatcher = BraceMatchingUtil.getBraceMatcherByFileType(type1)) != null) {
                BraceMatcher braceMatcher2 = braceMatcher;
                if (braceMatcher2 == null) {
                    BraceMatchingUtil.$$$reportNull$$$0(59);
                }
                return braceMatcher2;
            }
            matcher = (PairedBraceMatcher)LanguageBraceMatching.INSTANCE.forLanguage(language2);
            if (matcher != null) {
                return new PairedBraceMatcherAdapter(matcher, language2);
            }
        }
        BraceMatcher braceMatcher = BraceMatcherHolder.ourDefaultBraceMatcher;
        if (braceMatcher == null) {
            BraceMatchingUtil.$$$reportNull$$$0(60);
        }
        return braceMatcher;
    }

    @Nullable
    private static BraceMatcher getBraceMatcherByFileType(@NotNull FileType fileType) {
        SyntaxTable table;
        BraceMatcher matcher;
        if (fileType == null) {
            BraceMatchingUtil.$$$reportNull$$$0(61);
        }
        if ((matcher = (BraceMatcher)FileTypeBraceMather.getInstance().forFileType(fileType)) != null) {
            return matcher;
        }
        if (fileType instanceof AbstractFileType && ((table = ((AbstractFileType)fileType).getSyntaxTable()).isHasBraces() || table.isHasBrackets() || table.isHasParens())) {
            return CustomFileTypeBraceMatcher.INSTANCE;
        }
        return null;
    }

    private static boolean isStrictTagMatching(@NotNull BraceMatcher matcher, @NotNull FileType fileType, int group) {
        if (matcher == null) {
            BraceMatchingUtil.$$$reportNull$$$0(62);
        }
        if (fileType == null) {
            BraceMatchingUtil.$$$reportNull$$$0(63);
        }
        return matcher instanceof XmlAwareBraceMatcher && ((XmlAwareBraceMatcher)matcher).isStrictTagMatching(fileType, group);
    }

    private static boolean areTagsCaseSensitive(@NotNull BraceMatcher matcher, @NotNull FileType fileType, int tokenGroup) {
        if (matcher == null) {
            BraceMatchingUtil.$$$reportNull$$$0(64);
        }
        if (fileType == null) {
            BraceMatchingUtil.$$$reportNull$$$0(65);
        }
        return matcher instanceof XmlAwareBraceMatcher && ((XmlAwareBraceMatcher)matcher).areTagsCaseSensitive(fileType, tokenGroup);
    }

    @Nullable
    private static String getTagName(@NotNull BraceMatcher matcher, @NotNull CharSequence fileText, @NotNull HighlighterIterator iterator2) {
        if (matcher == null) {
            BraceMatchingUtil.$$$reportNull$$$0(66);
        }
        if (fileText == null) {
            BraceMatchingUtil.$$$reportNull$$$0(67);
        }
        if (iterator2 == null) {
            BraceMatchingUtil.$$$reportNull$$$0(68);
        }
        if (matcher instanceof XmlAwareBraceMatcher) {
            return ((XmlAwareBraceMatcher)matcher).getTagName(fileText, iterator2);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lbraceType";
                break;
            }
            case 1: 
            case 10: 
            case 13: 
            case 15: 
            case 18: 
            case 23: 
            case 26: 
            case 29: 
            case 33: 
            case 37: 
            case 41: 
            case 45: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 61: 
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/BraceMatchingUtil";
                break;
            }
            case 9: 
            case 12: 
            case 17: 
            case 22: 
            case 25: 
            case 32: 
            case 36: 
            case 40: 
            case 44: 
            case 47: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 11: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 24: 
            case 30: 
            case 34: 
            case 38: 
            case 42: 
            case 46: 
            case 49: 
            case 51: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType1";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType2";
                break;
            }
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lparenTokenType";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rparenTokenType";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetParenTokenType";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 62: 
            case 64: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/BraceMatchingUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getBraceMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isPairedBracesAllowedBeforeTypeInFileType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMatchedBraceOffset";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computeHighlightingAndNavigationContext";
                break;
            }
            case 8: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "matchBrace";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findStructuralLeftBrace";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isStructuralBraceToken";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isLBraceToken";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isRBraceToken";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isPairBraces";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findLeftmostLParen";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findLeftLParen";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findRightmostRParen";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "findLeftOrRightParenth";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isBraceToken";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "advance";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getBraceMatcher";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getBraceMatcherByFileType";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isStrictTagMatching";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "areTagsCaseSensitive";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getTagName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class BraceHighlightingAndNavigationContext {
        public final int currentBraceOffset;
        public final int navigationOffset;

        public BraceHighlightingAndNavigationContext(int currentBraceOffset, int navigationOffset) {
            this.currentBraceOffset = currentBraceOffset;
            this.navigationOffset = navigationOffset;
        }
    }

    private static class DefaultBraceMatcher
    implements BraceMatcher {
        private DefaultBraceMatcher() {
        }

        @Override
        public int getBraceTokenGroupId(IElementType tokenType) {
            return -1;
        }

        @Override
        public boolean isLBraceToken(HighlighterIterator iterator2, CharSequence fileText, FileType fileType) {
            return false;
        }

        @Override
        public boolean isRBraceToken(HighlighterIterator iterator2, CharSequence fileText, FileType fileType) {
            return false;
        }

        @Override
        public boolean isPairBraces(IElementType tokenType, IElementType tokenType2) {
            return false;
        }

        @Override
        public boolean isStructuralBrace(HighlighterIterator iterator2, CharSequence text2, FileType fileType) {
            return false;
        }

        @Override
        public IElementType getOppositeBraceTokenType(@NotNull IElementType type) {
            if (type == null) {
                DefaultBraceMatcher.$$$reportNull$$$0(0);
            }
            return null;
        }

        @Override
        public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
            if (lbraceType == null) {
                DefaultBraceMatcher.$$$reportNull$$$0(1);
            }
            return true;
        }

        @Override
        public int getCodeConstructStart(PsiFile file2, int openingBraceOffset) {
            return openingBraceOffset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lbraceType";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/highlighting/BraceMatchingUtil$DefaultBraceMatcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getOppositeBraceTokenType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isPairedBracesAllowedBeforeType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BraceMatcherHolder {
        private static final BraceMatcher ourDefaultBraceMatcher = new DefaultBraceMatcher();
        private static final BraceMatcher nullBraceMatcher = new DefaultBraceMatcher();

        private BraceMatcherHolder() {
        }
    }

    private static class MatchBraceContext {
        private final CharSequence fileText;
        private final FileType fileType;
        private final HighlighterIterator iterator;
        private final boolean forward;
        private final IElementType brace1Token;
        private final int group;
        private final String brace1TagName;
        private final boolean isStrict;
        private final boolean isCaseSensitive;
        @NotNull
        private final BraceMatcher myMatcher;
        private final Stack<IElementType> myBraceStack;
        private final Stack<String> myTagNameStack;

        MatchBraceContext(@NotNull CharSequence fileText, @NotNull FileType fileType, @NotNull HighlighterIterator iterator2, boolean forward) {
            if (fileText == null) {
                MatchBraceContext.$$$reportNull$$$0(0);
            }
            if (fileType == null) {
                MatchBraceContext.$$$reportNull$$$0(1);
            }
            if (iterator2 == null) {
                MatchBraceContext.$$$reportNull$$$0(2);
            }
            this(fileText, fileType, iterator2, forward, BraceMatchingUtil.isStrictTagMatching(BraceMatchingUtil.getBraceMatcher(fileType, iterator2), fileType, BraceMatchingUtil.getTokenGroup(iterator2.getTokenType(), fileType)));
        }

        MatchBraceContext(@NotNull CharSequence fileText, @NotNull FileType fileType, @NotNull HighlighterIterator iterator2, boolean forward, boolean strict) {
            if (fileText == null) {
                MatchBraceContext.$$$reportNull$$$0(3);
            }
            if (fileType == null) {
                MatchBraceContext.$$$reportNull$$$0(4);
            }
            if (iterator2 == null) {
                MatchBraceContext.$$$reportNull$$$0(5);
            }
            this.myBraceStack = new Stack();
            this.myTagNameStack = new Stack();
            this.fileText = fileText;
            this.fileType = fileType;
            this.iterator = iterator2;
            this.forward = forward;
            this.myMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator2);
            this.brace1Token = this.iterator.getTokenType();
            this.group = BraceMatchingUtil.getTokenGroup(this.brace1Token, this.fileType);
            this.brace1TagName = BraceMatchingUtil.getTagName(this.myMatcher, this.fileText, this.iterator);
            this.isCaseSensitive = BraceMatchingUtil.areTagsCaseSensitive(this.myMatcher, this.fileType, this.group);
            this.isStrict = strict;
        }

        boolean doBraceMatch() {
            boolean matched;
            block10: {
                this.myBraceStack.clear();
                this.myTagNameStack.clear();
                this.myBraceStack.push(this.brace1Token);
                if (this.isStrict) {
                    this.myTagNameStack.push(this.brace1TagName);
                }
                matched = false;
                while (true) {
                    BraceMatchingUtil.advance(this.iterator, this.forward);
                    if (this.iterator.atEnd()) break block10;
                    IElementType tokenType = this.iterator.getTokenType();
                    if (BraceMatchingUtil.getTokenGroup(tokenType, this.fileType) != this.group) continue;
                    String tagName = BraceMatchingUtil.getTagName(this.myMatcher, this.fileText, this.iterator);
                    if (!this.isStrict && !Comparing.equal(this.brace1TagName, tagName, this.isCaseSensitive)) continue;
                    if (BraceMatchingUtil.isBraceToken(this.iterator, this.fileText, this.fileType, !this.forward)) {
                        this.myBraceStack.push(tokenType);
                        if (!this.isStrict) continue;
                        this.myTagNameStack.push(tagName);
                        continue;
                    }
                    if (!BraceMatchingUtil.isBraceToken(this.iterator, this.fileText, this.fileType, this.forward)) continue;
                    IElementType topTokenType = this.myBraceStack.pop();
                    String topTagName = null;
                    if (this.isStrict) {
                        topTagName = this.myTagNameStack.pop();
                    }
                    if (!this.isStrict) {
                        IElementType baseType = this.myMatcher.getOppositeBraceTokenType(tokenType);
                        if (this.myBraceStack.contains(baseType)) {
                            while (!BraceMatchingUtil.isPairBraces(topTokenType, tokenType, this.fileType) && !this.myBraceStack.empty()) {
                                topTokenType = this.myBraceStack.pop();
                            }
                        } else if (!(this.brace1TagName != null && this.brace1TagName.equals(tagName) || BraceMatchingUtil.isPairBraces(topTokenType, tokenType, this.fileType))) {
                            this.myBraceStack.push(topTokenType);
                            continue;
                        }
                    }
                    if (!BraceMatchingUtil.isPairBraces(topTokenType, tokenType, this.fileType) || this.isStrict && !Comparing.equal(topTagName, tagName, this.isCaseSensitive)) {
                        matched = false;
                        break block10;
                    }
                    if (this.myBraceStack.isEmpty()) break;
                }
                matched = true;
            }
            return matched;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileText";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileType";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "iterator";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/highlighting/BraceMatchingUtil$MatchBraceContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

