/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class ChooseOneOrAllRunnable<T extends PsiElement>
implements Runnable {
    private final T[] myClasses;
    private final Editor myEditor;
    private final String myTitle;

    public ChooseOneOrAllRunnable(List<T> classes, Editor editor, String title, Class<T> type) {
        this.myClasses = (PsiElement[])ArrayUtil.toObjectArray(classes, type);
        this.myEditor = editor;
        this.myTitle = title;
    }

    protected abstract void selected(T ... var1);

    @Override
    public void run() {
        if (this.myClasses.length == 1) {
            this.selected((PsiElement[])ArrayUtil.toObjectArray(this.myClasses[0].getClass(), this.myClasses[0]));
        } else if (this.myClasses.length > 0) {
            PsiElementListCellRenderer<T> renderer = this.createRenderer();
            Arrays.sort(this.myClasses, renderer.getComparator());
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.selected((PsiElement[])this.myClasses);
                return;
            }
            ArrayList<T> model = new ArrayList<T>(Arrays.asList(this.myClasses));
            String selectAll = CodeInsightBundle.message("highlight.thrown.exceptions.chooser.all.entry", new Object[0]);
            model.add(0, selectAll);
            IPopupChooserBuilder<Object> builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(model).setSelectionMode(0).setRenderer(renderer).setSelectionMode(0).setItemChosenCallback(selectedValue -> {
                if (selectedValue.equals(selectAll)) {
                    this.selected((PsiElement[])this.myClasses);
                } else {
                    this.selected((PsiElement[])ArrayUtil.toObjectArray(selectedValue.getClass(), selectedValue));
                }
            }).setTitle(this.myTitle);
            renderer.installSpeedSearch(builder2);
            ApplicationManager.getApplication().invokeLater(() -> builder2.createPopup().showInBestPositionFor(this.myEditor));
        }
    }

    protected abstract PsiElementListCellRenderer<T> createRenderer();
}

