/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.ide.IdeBundle;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public class HyperlinkAnnotator
implements Annotator {
    private static final Key<String> messageKey = Key.create("hyperlink.message");

    @Override
    public void annotate(@NotNull PsiElement element2, @NotNull AnnotationHolder holder) {
        if (element2 == null) {
            HyperlinkAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            HyperlinkAnnotator.$$$reportNull$$$0(1);
        }
        if (holder.isBatchMode()) {
            return;
        }
        for (PsiReference reference2 : element2.getReferences()) {
            if (!(reference2 instanceof WebReference)) continue;
            String message = holder.getCurrentAnnotationSession().getUserData(messageKey);
            if (message == null) {
                message = HyperlinkAnnotator.getMessage();
                holder.getCurrentAnnotationSession().putUserData(messageKey, message);
            }
            TextRange range2 = reference2.getRangeInElement().shiftRight(element2.getTextRange().getStartOffset());
            holder.newAnnotation(HighlightSeverity.INFORMATION, message).range(range2).textAttributes(CodeInsightColors.INACTIVE_HYPERLINK_ATTRIBUTES).create();
        }
    }

    @NotNull
    private static String getMessage() {
        Shortcut keyboardShortcut;
        String message = IdeBundle.message("open.url.in.browser.tooltip", new Object[0]);
        Shortcut[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts("GotoDeclaration");
        String shortcutText = "";
        Shortcut mouseShortcut = ContainerUtil.find(shortcuts, shortcut -> !shortcut.isKeyboard());
        if (mouseShortcut != null) {
            shortcutText = shortcutText + KeymapUtil.getShortcutText(mouseShortcut);
            shortcutText = shortcutText.replace("Button1 ", "");
        }
        if ((keyboardShortcut = ContainerUtil.find(shortcuts, shortcut -> shortcut.isKeyboard())) != null) {
            if (!shortcutText.isEmpty()) {
                shortcutText = shortcutText + ", ";
            }
            shortcutText = shortcutText + KeymapUtil.getShortcutText(keyboardShortcut);
        }
        if (!shortcutText.isEmpty()) {
            message = message + " (" + shortcutText + ")";
        }
        String string = message;
        if (string == null) {
            HyperlinkAnnotator.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/highlighting/HyperlinkAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/highlighting/HyperlinkAnnotator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

