/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.ColoredSideBorder;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.Html;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.HyperlinkListener;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HintUtil {
    @Deprecated
    public static final Color INFORMATION_COLOR = new JBColor(0xF7F7F7, 0x4B4D4D);
    public static final Color INFORMATION_BORDER_COLOR = JBColor.namedColor("InformationHint.borderColor", new JBColor(0xE0E0E0, 6053473));
    @Deprecated
    public static final Color ERROR_COLOR = new JBColor(0xFFDCDC, 7870258);
    public static final ColorKey INFORMATION_COLOR_KEY = ColorKey.createColorKey("INFORMATION_HINT", INFORMATION_COLOR);
    public static final ColorKey QUESTION_COLOR_KEY = ColorKey.createColorKey("QUESTION_HINT", new JBColor(11915515, 3632265));
    public static final ColorKey ERROR_COLOR_KEY = ColorKey.createColorKey("ERROR_HINT", ERROR_COLOR);
    public static final Color QUESTION_UNDERSCORE_COLOR = JBColor.foreground();
    public static final ColorKey RECENT_LOCATIONS_SELECTION_KEY = ColorKey.createColorKey("RECENT_LOCATIONS_SELECTION", new JBColor(15331061, 0x383838));
    public static final ColorKey PROMOTION_PANE_KEY = ColorKey.createColorKey("PROMOTION_PANE", new JBColor(15134199, 3886167));

    private HintUtil() {
    }

    @NotNull
    public static Color getInformationColor() {
        Color color = ObjectUtils.notNull(EditorColorsUtil.getGlobalOrDefaultColor(INFORMATION_COLOR_KEY), INFORMATION_COLOR_KEY.getDefaultColor());
        if (color == null) {
            HintUtil.$$$reportNull$$$0(0);
        }
        return color;
    }

    @NotNull
    public static Color getQuestionColor() {
        Color color = ObjectUtils.notNull(EditorColorsUtil.getGlobalOrDefaultColor(QUESTION_COLOR_KEY), QUESTION_COLOR_KEY.getDefaultColor());
        if (color == null) {
            HintUtil.$$$reportNull$$$0(1);
        }
        return color;
    }

    @NotNull
    public static Color getErrorColor() {
        Color color = ObjectUtils.notNull(EditorColorsUtil.getGlobalOrDefaultColor(ERROR_COLOR_KEY), ERROR_COLOR_KEY.getDefaultColor());
        if (color == null) {
            HintUtil.$$$reportNull$$$0(2);
        }
        return color;
    }

    @NotNull
    public static Color getRecentLocationsSelectionColor(EditorColorsScheme colorsScheme) {
        Color color = ObjectUtils.notNull(colorsScheme.getColor(RECENT_LOCATIONS_SELECTION_KEY), RECENT_LOCATIONS_SELECTION_KEY.getDefaultColor());
        if (color == null) {
            HintUtil.$$$reportNull$$$0(3);
        }
        return color;
    }

    public static JComponent createInformationLabel(@NotNull String text2) {
        if (text2 == null) {
            HintUtil.$$$reportNull$$$0(4);
        }
        return HintUtil.createInformationLabel(text2, null, null, null);
    }

    public static JComponent createInformationLabel(@NotNull String text2, @Nullable HyperlinkListener hyperlinkListener, @Nullable MouseListener mouseListener, @Nullable Ref<? super Consumer<? super String>> updatedTextConsumer) {
        if (text2 == null) {
            HintUtil.$$$reportNull$$$0(5);
        }
        HintHint hintHint = HintUtil.getInformationHint();
        HintLabel label2 = HintUtil.createLabel(text2, null, hintHint.getTextBackground(), hintHint);
        HintUtil.configureLabel(label2, hyperlinkListener, mouseListener, updatedTextConsumer);
        return label2;
    }

    @NotNull
    public static HintHint getInformationHint() {
        HintHint hintHint = new HintHint().setBorderColor(INFORMATION_BORDER_COLOR).setTextBg(HintUtil.getInformationColor()).setTextFg(StartupUiUtil.isUnderDarcula() ? UIUtil.getLabelForeground() : Color.black).setFont(HintUtil.getBoldFont()).setAwtTooltip(true);
        if (hintHint == null) {
            HintUtil.$$$reportNull$$$0(6);
        }
        return hintHint;
    }

    public static CompoundBorder createHintBorder() {
        return BorderFactory.createCompoundBorder(new ColoredSideBorder(Color.white, Color.white, Color.gray, Color.gray, 1), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    }

    @NotNull
    public static JComponent createInformationLabel(SimpleColoredText text2) {
        return HintUtil.createInformationLabel(text2, null);
    }

    public static JComponent createQuestionLabel(String text2) {
        Icon icon2 = AllIcons.General.ContextHelp;
        return HintUtil.createQuestionLabel(text2, icon2);
    }

    public static JComponent createQuestionLabel(String text2, Icon icon2) {
        Color bg = HintUtil.getQuestionColor();
        HintHint hintHint = new HintHint().setTextBg(bg).setTextFg(JBColor.foreground()).setFont(HintUtil.getBoldFont()).setAwtTooltip(true);
        return HintUtil.createLabel(text2, icon2, bg, hintHint);
    }

    @Nullable
    public static String getHintLabel(JComponent hintComponent) {
        if (hintComponent instanceof HintLabel) {
            return ((HintLabel)hintComponent).getText();
        }
        return null;
    }

    @Nullable
    public static Icon getHintIcon(JComponent hintComponent) {
        if (hintComponent instanceof HintLabel) {
            return ((HintLabel)hintComponent).getIcon();
        }
        return null;
    }

    @NotNull
    public static SimpleColoredComponent createInformationComponent() {
        SimpleColoredComponent component2 = new SimpleColoredComponent();
        component2.setBackground(HintUtil.getInformationColor());
        component2.setForeground(JBColor.foreground());
        component2.setFont(HintUtil.getBoldFont());
        SimpleColoredComponent simpleColoredComponent = component2;
        if (simpleColoredComponent == null) {
            HintUtil.$$$reportNull$$$0(7);
        }
        return simpleColoredComponent;
    }

    @NotNull
    public static JComponent createInformationLabel(@NotNull SimpleColoredText text2, @Nullable Icon icon2) {
        if (text2 == null) {
            HintUtil.$$$reportNull$$$0(8);
        }
        SimpleColoredComponent component2 = HintUtil.createInformationComponent();
        component2.setIcon(icon2);
        text2.appendToComponent((ColoredTextContainer)component2);
        return new HintLabel(component2);
    }

    public static JComponent createErrorLabel(@NotNull String text2, @Nullable HyperlinkListener hyperlinkListener, @Nullable MouseListener mouseListener, @Nullable Ref<? super Consumer<? super String>> updatedTextConsumer) {
        if (text2 == null) {
            HintUtil.$$$reportNull$$$0(9);
        }
        Color bg = HintUtil.getErrorColor();
        HintHint hintHint = new HintHint().setTextBg(bg).setTextFg(JBColor.foreground()).setFont(HintUtil.getBoldFont()).setAwtTooltip(true);
        HintLabel label2 = HintUtil.createLabel(text2, null, bg, hintHint);
        HintUtil.configureLabel(label2, hyperlinkListener, mouseListener, updatedTextConsumer);
        return label2;
    }

    @NotNull
    public static JComponent createErrorLabel(@NotNull String text2) {
        if (text2 == null) {
            HintUtil.$$$reportNull$$$0(10);
        }
        JComponent jComponent = HintUtil.createErrorLabel(text2, null, null, null);
        if (jComponent == null) {
            HintUtil.$$$reportNull$$$0(11);
        }
        return jComponent;
    }

    @NotNull
    private static HintLabel createLabel(String text2, @Nullable Icon icon2, @NotNull Color color, @NotNull HintHint hintHint) {
        if (color == null) {
            HintUtil.$$$reportNull$$$0(12);
        }
        if (hintHint == null) {
            HintUtil.$$$reportNull$$$0(13);
        }
        HintLabel label2 = new HintLabel();
        label2.setText(text2, hintHint);
        label2.setIcon(icon2);
        if (!hintHint.isAwtTooltip()) {
            label2.setBorder(HintUtil.createHintBorder());
            label2.setForeground(JBColor.foreground());
            label2.setFont(HintUtil.getBoldFont());
            label2.setBackground(color);
            label2.setOpaque(true);
        }
        HintLabel hintLabel = label2;
        if (hintLabel == null) {
            HintUtil.$$$reportNull$$$0(14);
        }
        return hintLabel;
    }

    private static Font getBoldFont() {
        return StartupUiUtil.getLabelFont().deriveFont(1);
    }

    @NotNull
    public static JLabel createAdComponent(String bottomText, Border border, @JdkConstants.HorizontalAlignment int alignment) {
        JLabel label2 = new JLabel();
        label2.setText(bottomText);
        label2.setHorizontalAlignment(alignment);
        label2.setForeground(JBUI.CurrentTheme.Advertiser.foreground());
        label2.setBackground(JBUI.CurrentTheme.Advertiser.background());
        label2.setOpaque(true);
        label2.setFont(label2.getFont().deriveFont((float)(label2.getFont().getSize() - 2)));
        if (bottomText != null) {
            label2.setBorder(border);
        }
        JLabel jLabel = label2;
        if (jLabel == null) {
            HintUtil.$$$reportNull$$$0(15);
        }
        return jLabel;
    }

    @NotNull
    public static String prepareHintText(@NotNull String text2, @NotNull HintHint hintHint) {
        if (text2 == null) {
            HintUtil.$$$reportNull$$$0(16);
        }
        if (hintHint == null) {
            HintUtil.$$$reportNull$$$0(17);
        }
        String string = HintUtil.prepareHintText(new Html(text2), hintHint);
        if (string == null) {
            HintUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    public static String prepareHintText(@NotNull Html text2, @NotNull HintHint hintHint) {
        if (text2 == null) {
            HintUtil.$$$reportNull$$$0(19);
        }
        if (hintHint == null) {
            HintUtil.$$$reportNull$$$0(20);
        }
        String htmlBody = UIUtil.getHtmlBody(text2);
        return String.format("<html><head>%s</head><body>%s</body></html>", UIUtil.getCssFontDeclaration(hintHint.getTextFont(), hintHint.getTextForeground(), hintHint.getLinkForeground(), hintHint.getUlImg()), htmlBody);
    }

    private static void configureLabel(@NotNull HintLabel label2, @Nullable HyperlinkListener hyperlinkListener, @Nullable MouseListener mouseListener, @Nullable Ref<? super Consumer<? super String>> updatedTextConsumer) {
        if (label2 == null) {
            HintUtil.$$$reportNull$$$0(21);
        }
        if (hyperlinkListener != null) {
            label2.myPane.addHyperlinkListener(hyperlinkListener);
        }
        if (mouseListener != null) {
            label2.myPane.addMouseListener(mouseListener);
        }
        if (updatedTextConsumer != null) {
            Consumer<String> consumer = s -> {
                label2.myPane.setText((String)s);
                label2.setPreferredSize(null);
                label2.myPane.setPreferredSize(null);
            };
            updatedTextConsumer.set(consumer);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/hint/HintUtil";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 13: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hintHint";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInformationColor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuestionColor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorColor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentLocationsSelectionColor";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/hint/HintUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInformationHint";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createInformationComponent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorLabel";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabel";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdComponent";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareHintText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createInformationLabel";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createErrorLabel";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createLabel";
                break;
            }
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "prepareHintText";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "configureLabel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HintLabel
    extends JPanel {
        private JEditorPane myPane;
        private SimpleColoredComponent myColored;
        private JLabel myIcon;

        private HintLabel() {
            this.setLayout(new BorderLayout());
        }

        private HintLabel(@NotNull SimpleColoredComponent component2) {
            if (component2 == null) {
                HintLabel.$$$reportNull$$$0(0);
            }
            this();
            this.setText(component2);
        }

        @Override
        public boolean requestFocusInWindow() {
            if (this.myPane != null) {
                return this.myPane.requestFocusInWindow();
            }
            if (this.myColored != null) {
                return this.myColored.requestFocusInWindow();
            }
            if (this.myIcon != null) {
                return this.myIcon.requestFocusInWindow();
            }
            return super.requestFocusInWindow();
        }

        public void setText(@NotNull SimpleColoredComponent colored) {
            if (colored == null) {
                HintLabel.$$$reportNull$$$0(1);
            }
            this.clearText();
            this.myColored = colored;
            this.add((Component)this.myColored, "Center");
            this.setOpaque(true);
            this.setBackground(colored.getBackground());
            this.revalidate();
            this.repaint();
        }

        public void setText(String s, HintHint hintHint) {
            this.clearText();
            if (s != null) {
                this.myPane = IdeTooltipManager.initPane(s, hintHint, null);
                this.add((Component)this.myPane, "Center");
            }
            this.setOpaque(true);
            this.setBackground(hintHint.getTextBackground());
            this.revalidate();
            this.repaint();
        }

        private void clearText() {
            if (this.myPane != null) {
                this.remove(this.myPane);
                this.myPane = null;
            }
            if (this.myColored != null) {
                this.remove(this.myColored);
                this.myColored = null;
            }
        }

        public void setIcon(Icon icon2) {
            if (this.myIcon != null) {
                this.remove(this.myIcon);
            }
            this.myIcon = new JLabel(icon2, 0);
            this.myIcon.setVerticalAlignment(1);
            this.add((Component)this.myIcon, "West");
            this.revalidate();
            this.repaint();
        }

        @Override
        public String toString() {
            return "Hint: text='" + this.getText() + "'";
        }

        public String getText() {
            return this.myPane != null ? this.myPane.getText() : "";
        }

        @Nullable
        public Icon getIcon() {
            return this.myIcon != null ? this.myIcon.getIcon() : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colored";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/hint/HintUtil$HintLabel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

