/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.highlighting.TooltipLinkHandler;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class NavigationLinkHandler
extends TooltipLinkHandler {
    private static final Logger LOG = Logger.getInstance(NavigationLinkHandler.class);

    @Override
    public boolean handleLink(@NotNull String refSuffix, @NotNull Editor editor) {
        int offset;
        int pos;
        if (refSuffix == null) {
            NavigationLinkHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            NavigationLinkHandler.$$$reportNull$$$0(1);
        }
        if ((pos = refSuffix.lastIndexOf(58)) <= 0 || pos == refSuffix.length() - 1) {
            LOG.info("Malformed suffix: " + refSuffix);
            return true;
        }
        String path2 = refSuffix.substring(0, pos);
        VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(path2);
        if (vFile == null) {
            LOG.info("Unknown file: " + path2);
            return true;
        }
        try {
            offset = Integer.parseInt(refSuffix.substring(pos + 1));
        }
        catch (NumberFormatException e) {
            LOG.info("Malformed suffix: " + refSuffix);
            return true;
        }
        Project project2 = editor.getProject();
        if (project2 == null) {
            LOG.info("No project");
            return true;
        }
        PsiNavigationSupport.getInstance().createNavigatable(project2, vFile, offset).navigate(true);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "refSuffix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/hint/NavigationLinkHandler";
        objectArray[2] = "handleLink";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

