/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.CancelProgressOnScrolling;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtScheduledExecutorService;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.Objects;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

class ParameterInfoTaskRunnerUtil {
    public static final int DEFAULT_PROGRESS_POPUP_DELAY_MS = 1000;

    ParameterInfoTaskRunnerUtil() {
    }

    static <T> void runTask(Project project2, NonBlockingReadAction<T> nonBlockingReadAction, Consumer<T> continuationConsumer, @Nullable String progressTitle, Editor editor) {
        AtomicReference cancellablePromiseRef = new AtomicReference();
        Consumer<Boolean> stopAction = ParameterInfoTaskRunnerUtil.startProgressAndCreateStopAction(editor.getProject(), progressTitle, cancellablePromiseRef, editor);
        CancelProgressOnScrolling visibleAreaListener = new CancelProgressOnScrolling(cancellablePromiseRef);
        editor.getScrollingModel().addVisibleAreaListener(visibleAreaListener);
        Component focusOwner = ParameterInfoTaskRunnerUtil.getFocusOwner(project2);
        cancellablePromiseRef.set((CancellablePromise<?>)nonBlockingReadAction.finishOnUiThread(ModalityState.defaultModalityState(), continuation -> {
            CancellablePromise promise2 = (CancellablePromise)cancellablePromiseRef.get();
            if (promise2 != null && promise2.isSucceeded() && Objects.equals(focusOwner, ParameterInfoTaskRunnerUtil.getFocusOwner(project2))) {
                continuationConsumer.accept(continuation);
            }
        }).expireWith(editor instanceof EditorImpl ? ((EditorImpl)editor).getDisposable() : project2).submit(AppExecutorUtil.getAppExecutorService()).onProcessed(ignore -> {
            stopAction.accept(false);
            editor.getScrollingModel().removeVisibleAreaListener(visibleAreaListener);
        }));
    }

    private static Component getFocusOwner(Project project2) {
        return IdeFocusManager.getInstance(project2).getFocusOwner();
    }

    @NotNull
    private static Consumer<Boolean> startProgressAndCreateStopAction(Project project2, String progressTitle, AtomicReference<CancellablePromise<?>> promiseRef, Editor editor) {
        AtomicReference<Consumer<Boolean>> stopActionRef = new AtomicReference<Consumer<Boolean>>();
        Consumer<Boolean> originalStopAction = cancel -> {
            CancellablePromise promise2;
            stopActionRef.set(null);
            if (cancel.booleanValue() && (promise2 = (CancellablePromise)promiseRef.get()) != null) {
                promise2.cancel();
            }
        };
        if (progressTitle == null) {
            stopActionRef.set(originalStopAction);
        } else {
            Disposable disposable2 = Disposer.newDisposable();
            Disposer.register(project2, disposable2);
            JBLoadingPanel loadingPanel = new JBLoadingPanel(null, panel2 -> new LoadingDecorator((JComponent)panel2, disposable2, 0, false, new AsyncProcessIcon("ShowParameterInfo")){

                @Override
                protected NonOpaquePanel customizeLoadingLayer(JPanel parent, JLabel text2, AsyncProcessIcon icon2) {
                    parent.setLayout(new FlowLayout(0));
                    NonOpaquePanel result2 = new NonOpaquePanel();
                    result2.add(icon2);
                    parent.add(result2);
                    return result2;
                }
            });
            loadingPanel.add(new JBLabel(EmptyIcon.ICON_18));
            loadingPanel.add(new JBLabel(progressTitle));
            ComponentPopupBuilder builder2 = JBPopupFactory.getInstance().createComponentPopupBuilder(loadingPanel, null).setProject(project2).setCancelCallback(() -> {
                Consumer stopAction = (Consumer)stopActionRef.get();
                if (stopAction != null) {
                    stopAction.accept(true);
                }
                return true;
            });
            JBPopup popup2 = builder2.createPopup();
            Disposer.register(disposable2, popup2);
            ScheduledFuture showPopupFuture = EdtScheduledExecutorService.getInstance().schedule(() -> {
                if (!(popup2.isDisposed() || popup2.isVisible() || editor.isDisposed())) {
                    RelativePoint popupPosition = JBPopupFactory.getInstance().guessBestPopupLocation(editor);
                    loadingPanel.startLoading();
                    popup2.show(popupPosition);
                }
            }, ModalityState.defaultModalityState(), 1000L, TimeUnit.MILLISECONDS);
            stopActionRef.set(cancel -> {
                try {
                    loadingPanel.stopLoading();
                    originalStopAction.accept((Boolean)cancel);
                }
                finally {
                    showPopupFuture.cancel(false);
                    UIUtil.invokeLaterIfNeeded(() -> {
                        if (popup2.isVisible()) {
                            popup2.setUiVisible(false);
                        }
                        Disposer.dispose(disposable2);
                    });
                }
            });
        }
        Consumer consumer = (Consumer)stopActionRef.get();
        if (consumer == null) {
            ParameterInfoTaskRunnerUtil.$$$reportNull$$$0(0);
        }
        return consumer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/ParameterInfoTaskRunnerUtil", "startProgressAndCreateStopAction"));
    }
}

