/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.ParameterInfoComponent;
import com.intellij.codeInsight.hint.ParameterInfoController;
import com.intellij.codeInsight.hint.ParameterInfoTaskRunnerUtil;
import com.intellij.codeInsight.hint.ShowParameterInfoContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.lang.Language;
import com.intellij.lang.parameterInfo.LanguageParameterInfo;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.LightweightHint;
import com.intellij.util.ObjectUtils;
import java.awt.Point;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowParameterInfoHandler
implements CodeInsightActionHandler {
    private static final ParameterInfoHandler[] EMPTY_HANDLERS = new ParameterInfoHandler[0];
    private final boolean myRequestFocus;

    public ShowParameterInfoHandler() {
        this(false);
    }

    public ShowParameterInfoHandler(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
    }

    @Override
    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            ShowParameterInfoHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ShowParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            ShowParameterInfoHandler.$$$reportNull$$$0(2);
        }
        ShowParameterInfoHandler.invoke(project2, editor, file2, -1, null, this.myRequestFocus);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Deprecated
    public static void invoke(Project project2, Editor editor, PsiFile file2, int lbraceOffset, PsiElement highlightedElement) {
        ShowParameterInfoHandler.invoke(project2, editor, file2, lbraceOffset, highlightedElement, false);
    }

    public static void invoke(Project project2, Editor editor, PsiFile file2, int lbraceOffset, PsiElement highlightedElement, boolean requestFocus) {
        ShowParameterInfoHandler.invoke(project2, editor, file2, lbraceOffset, highlightedElement, requestFocus, false, CodeInsightBundle.message("parameter.info.progress.title", new Object[0]), e -> DumbService.getInstance(project2).showDumbModeNotification(CodeInsightBundle.message("parameter.info.indexing.mode.not.supported", new Object[0])));
    }

    public static void invoke(Project project2, Editor editor, PsiFile file2, int lbraceOffset, PsiElement highlightedElement, boolean requestFocus, boolean singleParameterHint, @Nullable String progressTitle, Consumer<IndexNotReadyException> indexNotReadyExceptionConsumer) {
        DumbService dumbService = DumbService.getInstance(project2);
        int initialOffset = editor.getCaretModel().getOffset();
        LookupEx lookup2 = LookupManager.getInstance(project2).getActiveLookup();
        LookupElement lookupElement = lookup2 != null ? lookup2.getCurrentItem() : null;
        ParameterInfoTaskRunnerUtil.runTask(project2, ReadAction.nonBlocking(() -> {
            int offset = editor.getCaretModel().getOffset();
            int fileLength = file2.getTextLength();
            if (fileLength == 0) {
                return null;
            }
            int offsetForLangDetection = offset > 0 && offset == fileLength ? offset - 1 : offset;
            Language language2 = PsiUtilCore.getLanguageAtOffset(file2, offsetForLangDetection);
            ShowParameterInfoContext context = new ShowParameterInfoContext(editor, project2, file2, offset, lbraceOffset, requestFocus, singleParameterHint);
            context.setHighlightedElement(highlightedElement);
            context.setRequestFocus(requestFocus);
            ParameterInfoHandler[] handlers = ObjectUtils.notNull(ShowParameterInfoHandler.getHandlers(project2, language2, file2.getViewProvider().getBaseLanguage()), EMPTY_HANDLERS);
            if (lookup2 != null) {
                if (lookupElement != null) {
                    for (ParameterInfoHandler handler2 : handlers) {
                        if (!handler2.couldShowInLookup()) continue;
                        Object[] items = handler2.getParametersForLookup(lookupElement, context);
                        if (items != null && items.length > 0) {
                            return () -> ShowParameterInfoHandler.showLookupEditorHint(items, editor, handler2, requestFocus);
                        }
                        return null;
                    }
                }
                return null;
            }
            return dumbService.computeWithAlternativeResolveEnabled(() -> {
                try {
                    for (int i = 0; i < handlers.length; ++i) {
                        ParameterInfoHandler handler2 = handlers[i];
                        PsiElement element2 = (PsiElement)handler2.findElementForParameterInfo(context);
                        if (element2 == null) continue;
                        return () -> {
                            if (element2.isValid()) {
                                handler2.showParameterInfo(element2, context);
                            }
                        };
                    }
                }
                catch (IndexNotReadyException e) {
                    indexNotReadyExceptionConsumer.accept(e);
                }
                return null;
            });
        }).withDocumentsCommitted(project2).expireWhen(() -> editor.getCaretModel().getOffset() != initialOffset).coalesceBy(ShowParameterInfoHandler.class, editor), continuation -> {
            if (continuation != null) {
                continuation.run();
            }
        }, progressTitle, editor);
    }

    private static void showLookupEditorHint(Object[] descriptors, Editor editor, ParameterInfoHandler handler2, boolean requestFocus) {
        ParameterInfoComponent component2 = new ParameterInfoComponent(descriptors, editor, handler2, requestFocus, false);
        component2.update(false);
        LightweightHint hint = new LightweightHint(component2);
        hint.setSelectingHint(true);
        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        Pair<Point, Short> pos = ParameterInfoController.chooseBestHintPosition(editor, null, hint, (short)6, true);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!editor.getComponent().isShowing()) {
                return;
            }
            hintManager.showEditorHint(hint, editor, (Point)pos.getFirst(), 134, 0, false, (Short)pos.getSecond());
        });
    }

    @Nullable
    public static ParameterInfoHandler[] getHandlers(Project project2, Language ... languages) {
        LinkedHashSet handlers = new LinkedHashSet();
        DumbService dumbService = DumbService.getInstance(project2);
        for (Language language2 : languages) {
            handlers.addAll(dumbService.filterByDumbAwareness(LanguageParameterInfo.INSTANCE.allForLanguage(language2)));
        }
        if (handlers.isEmpty()) {
            return null;
        }
        return handlers.toArray(new ParameterInfoHandler[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/hint/ShowParameterInfoHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

