/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.HintUtilsKt;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.PopupActionsKt;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016J!\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/codeInsight/hints/EnableCustomHintsOption;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/codeInsight/intention/HighPriorityAction;", "()V", "lastOptionName", "", "getDisabledOptionInfoAtCaretOffset", "Lcom/intellij/codeInsight/hints/HintInfo$OptionInfo;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "isAvailable", "", "startInWriteAction", "Companion", "intellij.platform.lang.impl"})
public final class EnableCustomHintsOption
implements IntentionAction,
HighPriorityAction {
    private String lastOptionName = "";
    private static final String presentableFamilyName;
    public static final Companion Companion;

    @Override
    @NotNull
    public String getText() {
        if (StringsKt.startsWith((String)this.lastOptionName, (String)"show", (boolean)true)) {
            return PopupActionsKt.access$capitalizeFirstLetter(this.lastOptionName);
        }
        String string = CodeInsightBundle.message("inlay.hints.enable.custom.option", this.lastOptionName);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CodeInsightBundle.messag\u2026.option\", lastOptionName)");
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return presentableFamilyName;
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Language language2 = file2.getLanguage();
        Intrinsics.checkExpressionValueIsNotNull((Object)language2, (String)"file.language");
        Language language3 = language2;
        if (!HintUtilsKt.isParameterHintsEnabledForLanguage(language3)) {
            return false;
        }
        if (!(editor instanceof EditorImpl)) {
            return false;
        }
        if ((InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(file2.getLanguage()) == null) {
            return false;
        }
        HintInfo.OptionInfo optionInfo = this.getDisabledOptionInfoAtCaretOffset(editor, file2);
        if (optionInfo == null) {
            return false;
        }
        HintInfo.OptionInfo option2 = optionInfo;
        this.lastOptionName = option2.getOptionName();
        return true;
    }

    private final HintInfo.OptionInfo getDisabledOptionInfoAtCaretOffset(Editor editor, PsiFile file2) {
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        int offset = caretModel.getOffset();
        PsiElement psiElement = file2.findElementAt(offset);
        if (psiElement == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"file.findElementAt(offset) ?: return null");
        PsiElement element2 = psiElement;
        InlayParameterHintsProvider inlayParameterHintsProvider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(file2.getLanguage());
        if (inlayParameterHintsProvider == null) {
            return null;
        }
        InlayParameterHintsProvider provider = inlayParameterHintsProvider;
        PsiElement target2 = PsiTreeUtil.findFirstParent(element2, (Condition<? super PsiElement>)new Condition<PsiElement>(provider, file2){
            final /* synthetic */ InlayParameterHintsProvider $provider;
            final /* synthetic */ PsiFile $file;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean value(PsiElement it) {
                if (it instanceof PsiFile) return true;
                PsiElement psiElement = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"it");
                if (!PopupActionsKt.access$hasDisabledOptionHintInfo(this.$provider, psiElement, this.$file)) return false;
                return true;
            }
            {
                this.$provider = inlayParameterHintsProvider;
                this.$file = psiFile;
            }
        });
        if (target2 == null || target2 instanceof PsiFile) {
            return null;
        }
        HintInfo hintInfo = provider.getHintInfo(target2, file2);
        if (!(hintInfo instanceof HintInfo.OptionInfo)) {
            hintInfo = null;
        }
        return (HintInfo.OptionInfo)hintInfo;
    }

    @Override
    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        HintInfo.OptionInfo optionInfo = this.getDisabledOptionInfoAtCaretOffset(editor, file2);
        if (optionInfo == null) {
            return;
        }
        HintInfo.OptionInfo option2 = optionInfo;
        option2.enable();
        PopupActionsKt.access$refreshAllOpenEditors();
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    static {
        Companion = new Companion(null);
        String string = CodeInsightBundle.message("inlay.hints.intention.family.name", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CodeInsightBundle.messag\u2026s.intention.family.name\")");
        presentableFamilyName = string;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/codeInsight/hints/EnableCustomHintsOption$Companion;", "", "()V", "presentableFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

