/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.hints.CollectorWithSettings;
import com.intellij.codeInsight.hints.HintUtils;
import com.intellij.codeInsight.hints.InlayHintsPass;
import com.intellij.codeInsight.hints.InlayHintsSettings;
import com.intellij.codeInsight.hints.InlayHintsUtilsKt;
import com.intellij.codeInsight.hints.ProviderWithSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/codeInsight/hints/InlayHintsPassFactory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactoryRegistrar;", "()V", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "registerHighlightingPassFactory", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.platform.lang.impl"})
public final class InlayHintsPassFactory
implements TextEditorHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar {
    private static final Key<Long> PSI_MODIFICATION_STAMP;
    public static final Companion Companion;

    @Override
    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)registrar, (String)"registrar");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, -1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        if (editor.isOneLineMode()) {
            return null;
        }
        Long savedStamp = editor.getUserData(PSI_MODIFICATION_STAMP);
        long currentStamp = InlayHintsPassFactory.Companion.getCurrentModificationStamp(file2);
        if (savedStamp != null && savedStamp == currentStamp) {
            return null;
        }
        InlayHintsSettings settings = InlayHintsSettings.Companion.instance();
        Language language2 = file2.getLanguage();
        Intrinsics.checkExpressionValueIsNotNull((Object)language2, (String)"file.language");
        Language language3 = language2;
        Project project2 = file2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"file.project");
        Iterable $this$mapNotNull$iv = HintUtils.INSTANCE.getHintProvidersForLanguage(language3, project2);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            CollectorWithSettings collectorWithSettings;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ProviderWithSettings it = (ProviderWithSettings)element$iv$iv;
            boolean bl2 = false;
            if (InlayHintsUtilsKt.getCollectorWrapperFor(it, file2, editor, language3) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            CollectorWithSettings it$iv$iv = collectorWithSettings;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CollectorWithSettings it = (CollectorWithSettings)element$iv$iv;
            boolean bl = false;
            if (!settings.hintsShouldBeShown(it.getKey(), language3)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List collectors = (List)destination$iv$iv;
        return new InlayHintsPass(file2, collectors, editor);
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create("inlay.psi.modification.stamp");
        Intrinsics.checkExpressionValueIsNotNull(key, (String)"Key.create<Long>(\"inlay.psi.modification.stamp\")");
        PSI_MODIFICATION_STAMP = key;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rR)\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u00078\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/codeInsight/hints/InlayHintsPassFactory$Companion;", "", "()V", "PSI_MODIFICATION_STAMP", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "PSI_MODIFICATION_STAMP$annotations", "forceHintsUpdateOnNextPass", "", "getCurrentModificationStamp", "file", "Lcom/intellij/psi/PsiFile;", "putCurrentModificationStamp", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.lang.impl"})
    public static final class Companion {
        public final void forceHintsUpdateOnNextPass() {
            EditorFactory editorFactory = EditorFactory.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)editorFactory, (String)"EditorFactory.getInstance()");
            for (Editor editor : editorFactory.getAllEditors()) {
                editor.putUserData(PSI_MODIFICATION_STAMP, null);
            }
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectManager, (String)"ProjectManager.getInstance()");
            Project[] projectArray = projectManager.getOpenProjects();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectArray, (String)"ProjectManager.getInstance().openProjects");
            Project[] $this$forEach$iv = projectArray;
            boolean $i$f$forEach = false;
            UserDataHolder[] userDataHolderArray = $this$forEach$iv;
            int n = userDataHolderArray.length;
            for (int i = 0; i < n; ++i) {
                UserDataHolder element$iv;
                UserDataHolder project2 = element$iv = userDataHolderArray[i];
                boolean bl = false;
                DaemonCodeAnalyzer.getInstance((Project)project2).restart();
            }
        }

        @JvmStatic
        private static /* synthetic */ void PSI_MODIFICATION_STAMP$annotations() {
        }

        public final void putCurrentModificationStamp(@NotNull Editor editor, @NotNull PsiFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            editor.putUserData(PSI_MODIFICATION_STAMP, this.getCurrentModificationStamp(file2));
        }

        private final long getCurrentModificationStamp(PsiFile file2) {
            PsiManager psiManager = file2.getManager();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"file.manager");
            PsiModificationTracker psiModificationTracker = psiManager.getModificationTracker();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiModificationTracker, (String)"file.manager.modificationTracker");
            return psiModificationTracker.getModificationCount();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

