/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.hints.ImmediateConfigurable;
import com.intellij.codeInsight.hints.InlayHintsSettings;
import com.intellij.codeInsight.hints.settings.InlayProviderSettingsModel;
import com.intellij.codeInsight.hints.settings.InlaySettingsProvider;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/codeInsight/hints/InlayProviderUsageCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "addModelEvents", "", "model", "Lcom/intellij/codeInsight/hints/settings/InlayProviderSettingsModel;", "language", "Lcom/intellij/lang/Language;", "metrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "getGroupId", "", "getMetrics", "project", "Lcom/intellij/openapi/project/Project;", "getVersion", "", "intellij.platform.lang.impl"})
public final class InlayProviderUsageCollector
extends ProjectUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "inlay.configuration";
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        InlaySettingsProvider[] settingsProviders = InlaySettingsProvider.EP.INSTANCE.getExtensions();
        boolean bl = false;
        Set metricEvents = new LinkedHashSet();
        InlayHintsSettings settings = InlayHintsSettings.Companion.instance();
        metricEvents.add(new MetricEvent("global.inlays.settings", new FeatureUsageData().addData("enabled_globally", settings.hintsEnabledGlobally())));
        for (InlaySettingsProvider settingsProvider : settingsProviders) {
            Collection<Language> languages = settingsProvider.getSupportedLanguages(project2);
            for (Language language2 : languages) {
                List<InlayProviderSettingsModel> models = settingsProvider.createModels(project2, language2);
                for (InlayProviderSettingsModel model : models) {
                    this.addModelEvents(model, language2, metricEvents);
                }
                metricEvents.add(new MetricEvent("language.inlays.settings", new FeatureUsageData().addData("enabled", settings.hintsEnabled(language2)).addLanguage(language2)));
            }
        }
        return metricEvents;
    }

    private final void addModelEvents(InlayProviderSettingsModel model, Language language2, Set<MetricEvent> metrics) {
        for (ImmediateConfigurable.Case case_ : model.getCases()) {
            FeatureUsageData usageData = new FeatureUsageData().addData("model", model.getId()).addData("option_id", case_.getId()).addData("option_value", case_.getValue()).addLanguage(language2).addData("enabled", model.isEnabled());
            metrics.add(new MetricEvent("model.options", usageData));
        }
    }

    public int getVersion() {
        return 3;
    }
}

