/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.HintInfoFilter;
import com.intellij.codeInsight.hints.HintUtilsKt;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.filtering.Matcher;
import com.intellij.codeInsight.hints.filtering.MatcherConstructor;
import com.intellij.codeInsight.hints.settings.Diff;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.lang.Language;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class MethodInfoBlacklistFilter
implements HintInfoFilter {
    private final List<Matcher> myMatchers;

    public MethodInfoBlacklistFilter(Set<String> list2) {
        this.myMatchers = list2.stream().map(item -> MatcherConstructor.INSTANCE.createMatcher((String)item)).filter(e -> e != null).collect(Collectors.toList());
    }

    @NotNull
    public static MethodInfoBlacklistFilter forLanguage(@NotNull Language language2) {
        if (language2 == null) {
            MethodInfoBlacklistFilter.$$$reportNull$$$0(0);
        }
        Set<String> list2 = MethodInfoBlacklistFilter.fullBlacklist(language2);
        return new MethodInfoBlacklistFilter(list2);
    }

    @Override
    public boolean showHint(@NotNull HintInfo info) {
        if (info == null) {
            MethodInfoBlacklistFilter.$$$reportNull$$$0(1);
        }
        if (info instanceof HintInfo.MethodInfo) {
            HintInfo.MethodInfo methodInfo = (HintInfo.MethodInfo)info;
            return this.myMatchers.stream().noneMatch(e -> e.isMatching(methodInfo.getFullyQualifiedName(), methodInfo.getParamNames()));
        }
        return false;
    }

    @NotNull
    private static Set<String> fullBlacklist(Language language2) {
        InlayParameterHintsProvider provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language2);
        if (provider == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                MethodInfoBlacklistFilter.$$$reportNull$$$0(2);
            }
            return set;
        }
        Set<String> blackList = MethodInfoBlacklistFilter.blacklist(language2);
        Language dependentLanguage = provider.getBlackListDependencyLanguage();
        if (dependentLanguage != null) {
            blackList = ContainerUtil.union(blackList, MethodInfoBlacklistFilter.blacklist(dependentLanguage));
        }
        Set<String> set = blackList;
        if (set == null) {
            MethodInfoBlacklistFilter.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    private static Set<String> blacklist(@NotNull Language language2) {
        InlayParameterHintsProvider provider;
        if (language2 == null) {
            MethodInfoBlacklistFilter.$$$reportNull$$$0(4);
        }
        if ((provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language2)) != null) {
            ParameterNameHintsSettings settings = ParameterNameHintsSettings.getInstance();
            Diff diff = settings.getBlackListDiff(HintUtilsKt.getLanguageForSettingKey(language2));
            Set<String> set = diff.applyOn(provider.getDefaultBlackList());
            if (set == null) {
                MethodInfoBlacklistFilter.$$$reportNull$$$0(5);
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            MethodInfoBlacklistFilter.$$$reportNull$$$0(6);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/hints/MethodInfoBlacklistFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/hints/MethodInfoBlacklistFilter";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fullBlacklist";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "blacklist";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "blacklist";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

