/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.MethodInfoBlacklistFilter;
import com.intellij.codeInsight.hints.ParameterHintsPass;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterHintsPassFactory
implements TextEditorHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar {
    protected static final Key<Long> PSI_MODIFICATION_STAMP = Key.create("psi.modification.stamp");

    @Override
    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project2) {
        if (registrar == null) {
            ParameterHintsPassFactory.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            ParameterHintsPassFactory.$$$reportNull$$$0(1);
        }
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, -1);
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        if (file2 == null) {
            ParameterHintsPassFactory.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            ParameterHintsPassFactory.$$$reportNull$$$0(3);
        }
        if (editor.isOneLineMode()) {
            return null;
        }
        long currentStamp = ParameterHintsPassFactory.getCurrentModificationStamp(file2);
        Long savedStamp = editor.getUserData(PSI_MODIFICATION_STAMP);
        if (savedStamp != null && savedStamp == currentStamp) {
            return null;
        }
        Language language2 = file2.getLanguage();
        InlayParameterHintsProvider provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language2);
        if (provider == null) {
            return null;
        }
        return new ParameterHintsPass(file2, editor, MethodInfoBlacklistFilter.forLanguage(language2), false);
    }

    public static long getCurrentModificationStamp(@NotNull PsiFile file2) {
        if (file2 == null) {
            ParameterHintsPassFactory.$$$reportNull$$$0(4);
        }
        return file2.getManager().getModificationTracker().getModificationCount();
    }

    public static void forceHintsUpdateOnNextPass() {
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            ParameterHintsPassFactory.forceHintsUpdateOnNextPass(editor);
        }
    }

    public static void forceHintsUpdateOnNextPass(@NotNull Editor editor) {
        if (editor == null) {
            ParameterHintsPassFactory.$$$reportNull$$$0(5);
        }
        editor.putUserData(PSI_MODIFICATION_STAMP, null);
    }

    protected static void putCurrentPsiModificationStamp(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            ParameterHintsPassFactory.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            ParameterHintsPassFactory.$$$reportNull$$$0(7);
        }
        editor.putUserData(PSI_MODIFICATION_STAMP, ParameterHintsPassFactory.getCurrentModificationStamp(file2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/hints/ParameterHintsPassFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerHighlightingPassFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightingPass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCurrentModificationStamp";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "forceHintsUpdateOnNextPass";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "putCurrentPsiModificationStamp";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

