/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hints.HintUtilsKt;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.PopupActionsKt;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/codeInsight/hints/ToggleInlineHintsAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Companion", "intellij.platform.lang.impl"})
public final class ToggleInlineHintsAction
extends AnAction {
    private static final String disableText;
    private static final String enableText;
    public static final Companion Companion;

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        if (!InlayParameterHintsExtension.INSTANCE.hasAnyExtensions()) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
        PsiFile psiFile = CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        if (psiFile == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"CommonDataKeys.PSI_FILE.\u2026(e.dataContext) ?: return");
        PsiFile file2 = psiFile;
        Language language2 = file2.getLanguage();
        Intrinsics.checkExpressionValueIsNotNull((Object)language2, (String)"file.language");
        boolean isHintsShownNow = HintUtilsKt.isParameterHintsEnabledForLanguage(language2);
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setText(isHintsShownNow ? disableText : enableText);
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"e.presentation");
        presentation2.setEnabledAndVisible(true);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        PsiFile psiFile = CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        if (psiFile == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"CommonDataKeys.PSI_FILE.\u2026(e.dataContext) ?: return");
        PsiFile file2 = psiFile;
        Language language2 = file2.getLanguage();
        Intrinsics.checkExpressionValueIsNotNull((Object)language2, (String)"file.language");
        Language language3 = language2;
        boolean before = HintUtilsKt.isParameterHintsEnabledForLanguage(language3);
        HintUtilsKt.setShowParameterHintsForLanguage(!before, language3);
        PopupActionsKt.access$refreshAllOpenEditors();
    }

    static {
        Companion = new Companion(null);
        String string = CodeInsightBundle.message("inlay.hints.disable.action.text", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CodeInsightBundle.messag\u2026nts.disable.action.text\")");
        disableText = PopupActionsKt.access$capitalize(string);
        String string2 = CodeInsightBundle.message("inlay.hints.enable.action.text", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"CodeInsightBundle.messag\u2026ints.enable.action.text\")");
        enableText = PopupActionsKt.access$capitalize(string2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/codeInsight/hints/ToggleInlineHintsAction$Companion;", "", "()V", "disableText", "", "Lorg/jetbrains/annotations/NotNull;", "enableText", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

