/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.presentation;

import com.intellij.codeInsight.hints.presentation.BasePresentation;
import com.intellij.codeInsight.hints.presentation.TextInlayPresentation$WhenMappings;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.paint.EffectPainter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u0006H\u0016R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0004\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0011\"\u0004\b\u001b\u0010\u0013R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0011\"\u0004\b!\u0010\u0013R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/codeInsight/hints/presentation/TextInlayPresentation;", "Lcom/intellij/codeInsight/hints/presentation/BasePresentation;", "width", "", "height", "text", "", "yBaseline", "lineHeight", "ascent", "descent", "fontProvider", "Lkotlin/Function1;", "Lcom/intellij/openapi/editor/colors/EditorFontType;", "Ljava/awt/Font;", "(IILjava/lang/String;IIIILkotlin/jvm/functions/Function1;)V", "getAscent", "()I", "setAscent", "(I)V", "getDescent", "setDescent", "getFontProvider", "()Lkotlin/jvm/functions/Function1;", "getHeight", "setHeight", "getLineHeight", "setLineHeight", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "getWidth", "setWidth", "paint", "", "g", "Ljava/awt/Graphics2D;", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "toString", "intellij.platform.lang.impl"})
public final class TextInlayPresentation
extends BasePresentation {
    private int width;
    private int height;
    @NotNull
    private String text;
    private int yBaseline;
    private int lineHeight;
    private int ascent;
    private int descent;
    @NotNull
    private final Function1<EditorFontType, Font> fontProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void paint(@NotNull Graphics2D g, @NotNull TextAttributes attributes) {
        Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
        Object savedHint = g.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
        try {
            EditorFontType editorFontType;
            Color foreground = attributes.getForegroundColor();
            if (foreground == null) return;
            switch (attributes.getFontType()) {
                case 1: {
                    editorFontType = EditorFontType.BOLD;
                    break;
                }
                case 2: {
                    editorFontType = EditorFontType.ITALIC;
                    break;
                }
                default: {
                    editorFontType = EditorFontType.PLAIN;
                }
            }
            EditorFontType fontType = editorFontType;
            Font font = (Font)this.fontProvider.invoke((Object)fontType);
            g.setFont(font);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AntialiasingType.getKeyForCurrentScope(false));
            g.setColor(foreground);
            g.drawString(this.text, 0, this.yBaseline);
            Color effectColor = attributes.getEffectColor();
            if (effectColor == null) return;
            g.setColor(effectColor);
            EffectType effectType = attributes.getEffectType();
            if (effectType == null) {
                return;
            }
            switch (TextInlayPresentation$WhenMappings.$EnumSwitchMapping$0[effectType.ordinal()]) {
                case 1: {
                    EffectPainter.LINE_UNDERSCORE.paint(g, 0, this.ascent, this.getWidth(), this.descent, font);
                    return;
                }
                case 2: {
                    EffectPainter.BOLD_LINE_UNDERSCORE.paint(g, 0, this.ascent, this.getWidth(), this.descent, font);
                    return;
                }
                case 3: {
                    EffectPainter.STRIKE_THROUGH.paint(g, 0, this.ascent, this.getWidth(), this.getHeight(), font);
                    return;
                }
                case 4: {
                    EffectPainter.WAVE_UNDERSCORE.paint(g, 0, this.ascent, this.getWidth(), this.descent, font);
                    return;
                }
                case 5: {
                    EffectPainter.BOLD_DOTTED_UNDERSCORE.paint(g, 0, this.ascent, this.getWidth(), this.descent, font);
                    return;
                }
            }
            return;
        }
        finally {
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedHint);
        }
    }

    @Override
    @NotNull
    public String toString() {
        return this.text;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final void setText(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.text = string;
    }

    public final int getLineHeight() {
        return this.lineHeight;
    }

    public final void setLineHeight(int n) {
        this.lineHeight = n;
    }

    public final int getAscent() {
        return this.ascent;
    }

    public final void setAscent(int n) {
        this.ascent = n;
    }

    public final int getDescent() {
        return this.descent;
    }

    public final void setDescent(int n) {
        this.descent = n;
    }

    @NotNull
    public final Function1<EditorFontType, Font> getFontProvider() {
        return this.fontProvider;
    }

    public TextInlayPresentation(int width, int height, @NotNull String text2, int yBaseline, int lineHeight, int ascent, int descent, @NotNull Function1<? super EditorFontType, ? extends Font> fontProvider) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        Intrinsics.checkParameterIsNotNull(fontProvider, (String)"fontProvider");
        this.width = width;
        this.height = height;
        this.text = text2;
        this.yBaseline = yBaseline;
        this.lineHeight = lineHeight;
        this.ascent = ascent;
        this.descent = descent;
        this.fontProvider = fontProvider;
    }
}

