/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.presentation.listeners;

import com.intellij.codeInsight.hints.PresentationContainerRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/codeInsight/hints/presentation/listeners/InlayEditorMouseMotionListener;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionListener;", "()V", "activeContainer", "Lcom/intellij/codeInsight/hints/PresentationContainerRenderer;", "mouseMoved", "", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "intellij.platform.lang.impl"})
public final class InlayEditorMouseMotionListener
implements EditorMouseMotionListener {
    private PresentationContainerRenderer<?> activeContainer;

    @Override
    public void mouseMoved(@NotNull EditorMouseEvent e) {
        PresentationContainerRenderer container2;
        Inlay<PresentationContainerRenderer> inlay;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        if (e.isConsumed()) {
            return;
        }
        Editor editor = e.getEditor();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"e.editor");
        Editor editor2 = editor;
        MouseEvent mouseEvent = e.getMouseEvent();
        Intrinsics.checkExpressionValueIsNotNull((Object)mouseEvent, (String)"e.mouseEvent");
        MouseEvent event = mouseEvent;
        if (Intrinsics.areEqual((Object)editor2.getMouseEventArea(event), (Object)EditorMouseEventArea.EDITING_AREA) ^ true) {
            PresentationContainerRenderer<?> presentationContainerRenderer = this.activeContainer;
            if (presentationContainerRenderer != null) {
                presentationContainerRenderer.mouseExited();
            }
            this.activeContainer = null;
            return;
        }
        Inlay<PresentationContainerRenderer> inlay2 = inlay = editor2.getInlayModel().getElementAt(event.getPoint(), PresentationContainerRenderer.class);
        PresentationContainerRenderer presentationContainerRenderer = container2 = inlay2 != null ? inlay2.getRenderer() : null;
        if (Intrinsics.areEqual(this.activeContainer, (Object)container2) ^ true) {
            PresentationContainerRenderer<?> presentationContainerRenderer2 = this.activeContainer;
            if (presentationContainerRenderer2 != null) {
                presentationContainerRenderer2.mouseExited();
            }
            this.activeContainer = container2;
        }
        if (container2 == null) {
            return;
        }
        Rectangle rectangle = inlay.getBounds();
        if (rectangle == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)rectangle, (String)"inlay.bounds ?: return");
        Rectangle bounds2 = rectangle;
        Point inlayPoint = new Point(bounds2.x, bounds2.y);
        Point translated = new Point(event.getX() - inlayPoint.x, event.getY() - inlayPoint.y);
        container2.mouseMoved(event, translated);
    }
}

